/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.sdh.sdhconfig.dao;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.db.CommonDaoService;
import com.huawei.nglct.nemgr.sdh.sdhconfig.TESNCPSingleXC;
import com.huawei.nglct.nemgr.sdh.sdhconfig.po.TESDHSingleXC;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class TESDHSingleXCDao {
    private static final int WORK_XC = 1;

    private TESDHSingleXCDao() {
    }

    public static void deleteSDHXC(int neid, int xcId) {
        String hql = "delete TESDHSingleXC where cLogicNeId=:cLogicNeId and cSDHXCID=:cSDHXCID";
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("cLogicNeId", neid);
        map.put("cSDHXCID", xcId);
        try {
            CommonDaoService.deleteByHql((String)hql, map);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TESDHSingleXCDao.deleteSDHXC() fail!", (Throwable)e);
        }
    }

    public static TESDHSingleXC getXCById(int neid, int singleXCId) {
        String hql = "from TESDHSingleXC where cLogicNeId=:cLogicNeId and cSDHXCID=:cSDHXCID";
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("cLogicNeId", neid);
        map.put("cSDHXCID", singleXCId);
        try {
            List xcList = CommonDaoService.getListByHql((String)hql, map);
            if (!xcList.isEmpty()) {
                return (TESDHSingleXC)xcList.get(0);
            }
            return null;
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TESDHSingleXCDao.getXCById() fail!", (Throwable)e);
            return null;
        }
    }

    public static TESNCPSingleXC getSNCPById(int neid, int pgno) {
        TESNCPSingleXC singleSncp = null;
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("cLogicNeId", neid);
        map.put("cPGNo", pgno);
        return singleSncp;
    }

    public static List getAllXC(int neid) {
        List xcList = new ArrayList();
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        String hql = " from TESDHSingleXC where cLogicNeId =:clogicNeId";
        params.put("clogicNeId", neid);
        try {
            xcList = CommonDaoService.getListByHql((String)hql, params);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Get SDHXC Fail!" + e.getMessage());
        }
        return xcList;
    }

    public static List getAllSNCPIdListByNeId(int neid) {
        List sncpIdList = new ArrayList();
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        String hql = "select cPGNo from TESDHSingleXC where cLogicNeId =:clogicNeId";
        params.put("clogicNeId", neid);
        try {
            sncpIdList = CommonDaoService.getListByHql((String)hql, params);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Get SNCPIdList Failed!", (Throwable)e);
        }
        return sncpIdList;
    }

    public static List getAllXCIdListByNeId(int neid, List xcList) {
        ArrayList<Integer> xcIdList = new ArrayList<Integer>();
        xcList.clear();
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        String hql = " from TESDHSingleXC where cLogicNeId =:clogicNeId";
        params.put("clogicNeId", neid);
        try {
            List XCsList = CommonDaoService.getListByHql((String)hql, params);
            xcList.addAll(XCsList);
            int size = XCsList.size();
            for (int i = 0; i < size; ++i) {
                xcIdList.add(((TESDHSingleXC)XCsList.get(i)).getSdhxcid());
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Get SDHXCIdList Fail!", (Throwable)e);
        }
        return xcIdList;
    }

    public static List getAllSNCP(int neid) {
        ArrayList sncpList = new ArrayList();
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("clogicNeId", neid);
        try {
            HashMap tempSncpMap = new HashMap();
            Iterator iter = tempSncpMap.values().iterator();
            while (iter.hasNext()) {
                sncpList.add(iter.next());
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Get SDHXC Fail!", (Throwable)e);
        }
        return sncpList;
    }

    public static void addSNCPs(List sncpList) {
        if (null == sncpList || sncpList.isEmpty()) {
            return;
        }
    }

    public static void addXCs(List xcList) {
        if (null == xcList || xcList.isEmpty()) {
            return;
        }
        int size = xcList.size();
        for (int i = 0; i < size; ++i) {
            TESDHSingleXCDao.addXC((TESDHSingleXC)xcList.get(i));
        }
    }

    public static void addXC(TESDHSingleXC xc) {
        try {
            CommonDaoService.save((Object)xc);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Save LineMSP Fail!", (Throwable)e);
        }
    }

    public static void delXCs(int neid, List xcList) {
        if (null == xcList || xcList.isEmpty()) {
            return;
        }
        int size = xcList.size();
        for (int i = 0; i < size; ++i) {
            TESDHSingleXCDao.delXC(neid, (TESDHSingleXC)xcList.get(i));
        }
    }

    public static void delXC(int neid, TESDHSingleXC xc) {
        String hql = "";
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("cLogicNeId", neid);
        if (xc.pgno != 0) {
            hql = "delete TESDHSingleXC where cLogicNeId=:cLogicNeId and cPGNo=:cPGNo and cXCFlag=:cXCFlag";
            map.put("cPGNo", xc.pgno);
            map.put("cXCFlag", xc.xcflag);
        } else {
            hql = "delete TESDHSingleXC where cLogicNeId=:cLogicNeId and cSDHXCID=:cSDHXCID";
            map.put("cSDHXCID", xc.sdhxcid);
        }
        try {
            CommonDaoService.deleteByHql((String)hql, map);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Delete SDHXC Fail!", (Throwable)e);
        }
    }

    public static void updateXCPara(TESDHSingleXC xc) {
        try {
            CommonDaoService.update((Object)xc);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Update SDHXC Fail!", (Throwable)e);
        }
    }

    public static void updateXCsPara(List xcList) {
        if (null == xcList || xcList.isEmpty()) {
            return;
        }
        int size = xcList.size();
        for (int i = 0; i < size; ++i) {
            TESDHSingleXCDao.updateXCPara((TESDHSingleXC)xcList.get(i));
        }
    }

    public static void updateSNCPsPara(List sncpList) {
        if (null == sncpList || sncpList.isEmpty()) {
            return;
        }
    }

    public static void clearXCs(int neID) {
        String hql = "delete TESDHSingleXC where cLogicNeId=:cLogicNeId";
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("cLogicNeId", neID);
        try {
            CommonDaoService.deleteByHql((String)hql, map);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Delete SDHXC Fail!", (Throwable)e);
        }
    }
}

