/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.sdh.sdhconfig;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nemgr.sdh.sdhconfig.TESNCPSingleXC;
import com.huawei.nglct.nemgr.sdh.sdhconfig.TESNCPayloadCache;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.util.ArrayList;

public class TESNCSwitchStatusQuerySuperBean
extends TENEExplorerBean {
    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.neid = neid;
            this.subfunc = subFunc;
            this.inputData = inputData;
            this.outputData = new Datainterface();
            this.operationList = this.getOperation(neid, subFunc, inputData, memeryData);
            int result = this.sendMessage(neid);
            if (result == 0) {
                this.handleMessage(neid, this.operationList, subFunc, this.getFilterErrorCodeList());
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
            }
            if (this.isNeedOperationlog()) {
                this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
            return null;
        }
        return this.outputData;
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        int errorCode;
        super.handleMessage(neid, operationList, subfunc);
        if (this.outputData != null && (errorCode = Integer.parseInt(this.outputData.getErrorMessage().getErrorcode())) == 0) {
            int ksize = this.outputData.getBussinessParams().getRowParamsCount();
            for (int k = 0; k < ksize; ++k) {
                Param[] params = this.outputData.getBussinessParams().getRowParams(k).getParam();
                int switchState = 0;
                int currentWorkPath = 0;
                int mainPathState = 0;
                int backupPathState = 0;
                int pgNo = 0;
                int isize = params.length;
                for (int i = 0; i < isize; ++i) {
                    String nameParam = params[i].getName();
                    String valueParam = params[i].getValue();
                    if (nameParam.equalsIgnoreCase("pgno")) {
                        pgNo = Integer.parseInt(valueParam);
                        continue;
                    }
                    if (nameParam.equalsIgnoreCase("currentWorkPath")) {
                        currentWorkPath = Integer.parseInt(valueParam);
                        continue;
                    }
                    if (nameParam.equalsIgnoreCase("switchRequest")) {
                        switchState = Integer.parseInt(valueParam);
                        continue;
                    }
                    if (nameParam.equalsIgnoreCase("mainPathStatus")) {
                        mainPathState = Integer.parseInt(valueParam);
                        continue;
                    }
                    if (!nameParam.equalsIgnoreCase("backupPathStatus")) continue;
                    backupPathState = Integer.parseInt(valueParam);
                }
                TESNCPayloadCache sncpCache = TESNCPayloadCache.getInstance();
                if (sncpCache.isEmpty(this.neid)) continue;
                ArrayList sncpxcList = sncpCache.getCache(this.neid);
                int kisize = sncpxcList.size();
                for (int ki = 0; ki < kisize; ++ki) {
                    TESNCPSingleXC sncpSinglexc = (TESNCPSingleXC)sncpxcList.get(ki);
                    if (sncpSinglexc.pgNo != pgNo) continue;
                    sncpSinglexc.mainPathState = mainPathState;
                    sncpSinglexc.backupPathState = backupPathState;
                    sncpSinglexc.switchState = switchState;
                    sncpSinglexc.currentWorkPath = currentWorkPath;
                }
            }
        }
    }
}

