/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.sdh.sdhconfig;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.log.TELogInfo;
import com.huawei.nglct.cbb.log.TELogMgr;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import java.io.File;
import java.util.ArrayList;

public class TESNCSwitchCMDBean
extends TENEExplorerBean {
    private String[] pgNoArray = null;
    private String[] srcBoardNameArray = null;
    private String[] snkBoardNameArray = null;
    private String[] swtTypeArray = null;
    private String[] swtDirectionArray = null;
    private int convertSize = 0;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.neid = neid;
            this.subfunc = subFunc;
            this.inputData = inputData;
            this.outputData = new Datainterface();
            RowParams[] rParams = inputData.getBussinessParams().getRowParams();
            this.pgNoArray = new String[rParams.length];
            this.srcBoardNameArray = new String[rParams.length];
            this.snkBoardNameArray = new String[rParams.length];
            this.swtTypeArray = new String[rParams.length];
            this.swtDirectionArray = new String[rParams.length];
            int len = rParams.length;
            for (int i = 0; i < len; ++i) {
                this.pgNoArray[i] = rParams[i].getParam("pgno").getValue();
                this.srcBoardNameArray[i] = rParams[i].getParam("srcBoardName").getValue();
                this.snkBoardNameArray[i] = rParams[i].getParam("snkBoardName").getValue();
                this.swtTypeArray[i] = rParams[i].getParam("switchType").getValue();
                this.swtDirectionArray[i] = rParams[i].getParam("switchDirect").getValue();
                ++this.convertSize;
            }
            this.operationList = this.getOperation(neid, subFunc, inputData, memeryData);
            int result = this.sendMessage(neid);
            if (result == 0) {
                this.handleMessage(neid, this.operationList, subFunc);
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
            }
            if (this.isNeedOperationlog()) {
                this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
            return null;
        }
        return this.outputData;
    }

    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        try {
            int i;
            int errorCode2 = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
            if (errorCode2 == 1090646019) {
                return;
            }
            ArrayList<TELogInfo> loginfoList2 = new ArrayList<TELogInfo>();
            TELogInfo loginfo2 = null;
            int userID = 0;
            if (TESysManagerConstants.SYS_SINGLE_STATUS != TESysManagerBean.getInstance().getSysStauts()) {
                try {
                    userID = Integer.parseInt(user);
                }
                catch (Exception e) {
                    userID = 0;
                }
            }
            TENE neObj = TENEListMgr.getInstance().getNE(neid);
            String operObj = "";
            operObj = null == neObj ? String.valueOf(neid) : neObj.getNEName();
            if (errorCode2 == 0) {
                loginfo2 = new TELogInfo();
                loginfo2.setResult(0);
                loginfo2.setErrCode(0);
                loginfo2.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode2));
                loginfoList2.add(loginfo2);
            } else if (errorCode2 == 2 || errorCode2 == 1) {
                int len = outputData.getBussinessParams().getRowParamsCount();
                for (i = 0; i < len; ++i) {
                    RowErrors[] rowErrors = outputData.getBussinessParams().getRowParams(i).getRowErrors();
                    int size = rowErrors.length;
                    for (int j = 0; j < size; ++j) {
                        loginfo2 = new TELogInfo();
                        loginfo2.setResult(2);
                        loginfo2.setErrCode(Integer.parseInt(rowErrors[j].getErrorMessage().getErrorcode()));
                        loginfo2.setErrInfo(rowErrors[j].getErrorMessage().getErrorinfo());
                        loginfoList2.add(loginfo2);
                    }
                }
            } else {
                loginfo2 = new TELogInfo();
                loginfo2.setResult(2);
                loginfo2.setErrCode(errorCode2);
                loginfo2.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode2));
                loginfoList2.add(loginfo2);
            }
            if (this.convertSize > 0 && errorCode2 == 0) {
                for (int ik = 0; ik < this.convertSize; ++ik) {
                    int size = loginfoList2.size();
                    for (int i2 = 0; i2 < size; ++i2) {
                        loginfo2 = (TELogInfo)loginfoList2.get(i2);
                        loginfo2.setCmdID(subfunc.getCode());
                        loginfo2.setLocation(ipAddress);
                        loginfo2.setUserID(userID);
                        loginfo2.setUserName(TESysManagerBean.getInstance().getSysUser());
                        loginfo2.setOperateName(subfunc.getSubFuncDes(neid));
                        loginfo2.setOperateObject(operObj);
                        loginfo2.setOperateDesc(this.operationDescribtion(ik));
                        TELogMgr.writeLog((TELogInfo)((TELogInfo)loginfoList2.get(i2)));
                    }
                }
            } else {
                int size = loginfoList2.size();
                for (i = 0; i < size; ++i) {
                    loginfo2 = (TELogInfo)loginfoList2.get(i);
                    loginfo2.setCmdID(subfunc.getCode());
                    loginfo2.setLocation(ipAddress);
                    loginfo2.setUserID(userID);
                    loginfo2.setUserName(TESysManagerBean.getInstance().getSysUser());
                    loginfo2.setOperateName(subfunc.getSubFuncDes(neid));
                    loginfo2.setOperateObject(operObj);
                    loginfo2.setOperateDesc("");
                    TELogMgr.writeLog((TELogInfo)((TELogInfo)loginfoList2.get(i)));
                }
            }
        }
        catch (NumberFormatException e) {
            TELogFactory.getNormalLogger().error("Writer Log Fault:\n", (Throwable)e);
            return;
        }
        catch (IndexOutOfBoundsException e) {
            TELogFactory.getNormalLogger().error("Writer Log Fault:\n", (Throwable)e);
            return;
        }
    }

    private String operationDescribtion(int index) {
        StringBuffer operDesc = new StringBuffer();
        StringBuffer filePath = new StringBuffer();
        filePath.append("sdh").append(File.separator).append(TEPathManager.RESOURCE_PROFILE_PATH).append("sdhconfig").append(File.separator).append("sdhconfig_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        TEResourceUtil res = TEGetFilePath.getResource((int)this.neid, (StringBuffer)filePath);
        operDesc.append(res.getString("pgNo")).append(":").append(this.pgNoArray[index]);
        operDesc.append(",");
        operDesc.append(res.getString("srcBoardName")).append(":").append(this.srcBoardNameArray[index]);
        operDesc.append(",");
        operDesc.append(res.getString("snkBoardName")).append(":").append(this.snkBoardNameArray[index]);
        operDesc.append(",");
        operDesc.append(res.getString("swtDirection")).append(":");
        operDesc.append(res.getString("swtDirection" + this.swtDirectionArray[index]));
        operDesc.append(",");
        operDesc.append(res.getString("swtType")).append(":");
        operDesc.append(res.getString("swtType" + this.swtTypeArray[index]));
        operDesc.append(" ");
        return operDesc.toString();
    }
}

