/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.sdh.sdhconfig;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.log.TELogInfo;
import com.huawei.nglct.cbb.log.TELogMgr;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import java.io.File;
import java.util.ArrayList;

public class TESNCSetParameterSuperBean
extends TENEExplorerBean {
    private static final int UNKNOWN_REVERTMODE = 2;
    private static final int UNKNOWN_REVERT = 0;
    private String[] pgNoArray = null;
    private String[] srcBoardNameArray = null;
    private String[] snkBoardNameArray = null;
    private String[] xcFlagArray = null;
    private String[] revertModeArray = null;
    private String[] wtrTimeArray = null;
    private String[] delayTimeArray = null;
    private String[] sncpTypeArray = null;
    private int convertSize = 0;

    public Datainterface performBussinessProcess(int neID, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.neid = neID;
            this.subfunc = subFunc;
            this.inputData = inputData;
            this.outputData = new Datainterface();
            RowParams[] rParams = inputData.getBussinessParams().getRowParams();
            this.pgNoArray = new String[rParams.length];
            this.srcBoardNameArray = new String[rParams.length];
            this.snkBoardNameArray = new String[rParams.length];
            this.xcFlagArray = new String[rParams.length];
            this.revertModeArray = new String[rParams.length];
            this.wtrTimeArray = new String[rParams.length];
            this.delayTimeArray = new String[rParams.length];
            this.sncpTypeArray = new String[rParams.length];
            int len = rParams.length;
            for (int i = 0; i < len; ++i) {
                this.pgNoArray[i] = rParams[i].getParam("pgno").getValue();
                this.srcBoardNameArray[i] = rParams[i].getParam("srcBoardName").getValue();
                this.snkBoardNameArray[i] = rParams[i].getParam("snkBoardName").getValue();
                this.xcFlagArray[i] = rParams[i].getParam("xcFlag").getValue();
                Param para = rParams[i].getParam("revertMode");
                this.revertModeArray[i] = para == null ? String.valueOf(2) : rParams[i].getParam("revertMode").getValue();
                para = rParams[i].getParam("wtrTime");
                this.wtrTimeArray[i] = para == null ? String.valueOf(0) : rParams[i].getParam("wtrTime").getValue();
                para = rParams[i].getParam("delayTime");
                if (para == null) {
                    this.wtrTimeArray[i] = String.valueOf(0);
                } else {
                    this.delayTimeArray[i] = rParams[i].getParam("delayTime").getValue();
                }
                this.sncpTypeArray[i] = rParams[i].getParam("sncpType").getValue();
                ++this.convertSize;
            }
            this.operationList = this.getOperation(this.neid, subFunc, inputData, memeryData);
            int result = this.sendMessage(this.neid);
            if (result == 0) {
                this.handleMessage(this.neid, this.operationList, subFunc, this.getFilterErrorCodeList());
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
            }
            if (this.isNeedOperationlog()) {
                this.writeLog(this.neid, this.subfunc, inputData, user, ipAddress, this.outputData);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
            return null;
        }
        return this.outputData;
    }

    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        try {
            int i;
            int errorCodeSncParam = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
            if (1090646019 == errorCodeSncParam) {
                return;
            }
            ArrayList<TELogInfo> loginfoList = new ArrayList<TELogInfo>();
            TELogInfo loginfoSncParam = null;
            int userIDSncParam = 0;
            if (TESysManagerConstants.SYS_SINGLE_STATUS != TESysManagerBean.getInstance().getSysStauts()) {
                try {
                    userIDSncParam = Integer.parseInt(user);
                }
                catch (Exception e) {
                    userIDSncParam = 0;
                }
            }
            TENE neObj = TENEListMgr.getInstance().getNE(neid);
            String operObjSncParam = "";
            operObjSncParam = null == neObj ? String.valueOf(neid) : neObj.getNEName();
            if (errorCodeSncParam == 0) {
                loginfoSncParam = new TELogInfo();
                loginfoSncParam.setResult(0);
                loginfoSncParam.setErrCode(0);
                loginfoSncParam.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCodeSncParam));
                loginfoList.add(loginfoSncParam);
            } else if (errorCodeSncParam == 2 || errorCodeSncParam == 1) {
                int len = outputData.getBussinessParams().getRowParamsCount();
                for (i = 0; i < len; ++i) {
                    RowErrors[] rowErrors = outputData.getBussinessParams().getRowParams(i).getRowErrors();
                    int size = rowErrors.length;
                    for (int j = 0; j < size; ++j) {
                        loginfoSncParam = new TELogInfo();
                        loginfoSncParam.setResult(2);
                        loginfoSncParam.setErrCode(Integer.parseInt(rowErrors[j].getErrorMessage().getErrorcode()));
                        loginfoSncParam.setErrInfo(rowErrors[j].getErrorMessage().getErrorinfo());
                        loginfoList.add(loginfoSncParam);
                    }
                }
            } else {
                loginfoSncParam = new TELogInfo();
                loginfoSncParam.setResult(2);
                loginfoSncParam.setErrCode(errorCodeSncParam);
                loginfoSncParam.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCodeSncParam));
                loginfoList.add(loginfoSncParam);
            }
            if (this.convertSize > 0 && errorCodeSncParam == 0) {
                for (int ik = 0; ik < this.convertSize; ++ik) {
                    int size = loginfoList.size();
                    for (int i2 = 0; i2 < size; ++i2) {
                        loginfoSncParam = (TELogInfo)loginfoList.get(i2);
                        loginfoSncParam.setCmdID(subfunc.getCode());
                        loginfoSncParam.setLocation(ipAddress);
                        loginfoSncParam.setUserID(userIDSncParam);
                        loginfoSncParam.setUserName(TESysManagerBean.getInstance().getSysUser());
                        loginfoSncParam.setOperateName(subfunc.getSubFuncDes(neid));
                        loginfoSncParam.setOperateObject(operObjSncParam);
                        loginfoSncParam.setOperateDesc(this.operationDescribtion(ik));
                        TELogMgr.writeLog((TELogInfo)((TELogInfo)loginfoList.get(i2)));
                    }
                }
            } else {
                int size = loginfoList.size();
                for (i = 0; i < size; ++i) {
                    loginfoSncParam = (TELogInfo)loginfoList.get(i);
                    loginfoSncParam.setCmdID(subfunc.getCode());
                    loginfoSncParam.setLocation(ipAddress);
                    loginfoSncParam.setUserID(userIDSncParam);
                    loginfoSncParam.setUserName(TESysManagerBean.getInstance().getSysUser());
                    loginfoSncParam.setOperateName(subfunc.getSubFuncDes(neid));
                    loginfoSncParam.setOperateObject(operObjSncParam);
                    loginfoSncParam.setOperateDesc("");
                    TELogMgr.writeLog((TELogInfo)((TELogInfo)loginfoList.get(i)));
                }
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Writer Log Fault:\n", (Throwable)e);
            return;
        }
    }

    private String operationDescribtion(int index) {
        StringBuffer operDesc = new StringBuffer(46);
        StringBuffer filePath = new StringBuffer(26);
        filePath.append("sdh").append(File.separator).append(TEPathManager.RESOURCE_PROFILE_PATH).append("sdhconfig").append(File.separator).append("sdhconfig_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        TEResourceUtil res = TEGetFilePath.getResource((int)this.neid, (StringBuffer)filePath);
        operDesc.append(res.getString("pgNo")).append(':').append(this.pgNoArray[index]);
        operDesc.append(',');
        operDesc.append(res.getString("srcBoardName")).append(':').append(this.srcBoardNameArray[index]);
        operDesc.append(',');
        operDesc.append(res.getString("snkBoardName")).append(':').append(this.snkBoardNameArray[index]);
        operDesc.append(',');
        operDesc.append(res.getString("xcFlag")).append(':');
        operDesc.append(res.getString("xcFlag" + String.valueOf(this.xcFlagArray[index])));
        operDesc.append(',');
        operDesc.append(res.getString("revertMode")).append(':');
        operDesc.append(res.getString("revertMode" + String.valueOf(this.revertModeArray[index])));
        operDesc.append(',');
        operDesc.append(res.getString("wtrTime")).append(':').append(this.wtrTimeArray[index]);
        operDesc.append(',');
        operDesc.append(res.getString("delayTime")).append(':').append(this.delayTimeArray[index]);
        operDesc.append(',');
        operDesc.append(res.getString("watchCondition")).append(':');
        operDesc.append(res.getString("watchCondition" + String.valueOf(this.sncpTypeArray[index])));
        operDesc.append(' ');
        return operDesc.toString();
    }
}

