/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.sdh.sdhconfig;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.sdh.sdhconfig.TESDHIF1ABBoard;
import com.huawei.nglct.nemgr.sdh.sdhconfig.TESDHQueryDataCache;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import java.util.ArrayList;

public class TESNCPSingleXC
implements Cloneable {
    public int pgNo = 0;
    public int xcLevel = 0;
    public int srcTTpType = 0;
    public int srcBoardType = 0;
    public int srcSlotID = 0;
    public int srcPortID = 0;
    public int srcVC4ID = 0;
    public int srcPathID = 0;
    public int srcNO = 0;
    public int srcTug3 = 0;
    public int srcTug2 = 0;
    public int srcTu12 = 0;
    public int psrcTTpType = 0;
    public int psrcBoardType = 0;
    public int psrcSlotID = 0;
    public int psrcPortID = 0;
    public int psrcVC4ID = 0;
    public int psrcPathID = 0;
    public int psrcNO = 0;
    public int psrcTug3 = 0;
    public int psrcTug2 = 0;
    public int psrcTu12 = 0;
    public int snkTTpType = 0;
    public int snkBoardType = 0;
    public int snkSlotID = 0;
    public int snkPortID = 0;
    public int snkVC4ID = 0;
    public int snkPathID = 0;
    public int snkNO = 0;
    public int snkTug3 = 0;
    public int snkTug2 = 0;
    public int snkTu12 = 0;
    public String srcBoard = null;
    public String snkBoard = null;
    public String psrcBoard = null;
    public int wtrTime = 600;
    public int revertMode = -1;
    public int neID = -1;
    public int currentWorkPath = -1;
    public int mainPathState = -1;
    public int backupPathState = -1;
    public int switchState = -1;
    public int delayTime = -1;
    public int pdelayTime = -1;
    public int sncpType = 1;
    public int watchConditions = 0;
    public int pwatchConditions = 0;
    private static final int VC12 = 6;
    private static final int VC4 = 1;
    private static final int VC4_4C = 2;
    private static final int VC4_8C = 3;
    private static final int VC4_16C = 4;
    private static final int VC4_64C = 5;

    public TESNCPSingleXC(int _neID) {
        this.neID = _neID;
    }

    public TESNCPSingleXC() {
    }

    public String getBoardName(int neid, int slotid, int port) {
        int subrackid = TEBoardUtil.getSubrackIDFromSlot((int)neid, (int)slotid);
        int boardtype = TEConfigurationDataMgr.getInstance().getBoardType(neid, slotid);
        String boardname = TEConfigurationDataMgr.getInstance().getBoardTypeName(neid, boardtype);
        String portname = TEConfigurationDataMgr.getInstance().getPortName(neid, slotid, boardtype, port);
        String name = "";
        name = subrackid < 0 ? slotid + "-" + boardname : TEBoardUtil.getSubrackNameFromSlot((int)neid, (int)slotid) + "-" + TEBoardUtil.getSlotIDFromSlot((int)neid, (int)slotid) + "-" + boardname;
        if (boardtype != 1030 && boardtype != 1031) {
            name = name + "-" + portname;
        }
        return name;
    }

    public Object clone() {
        try {
            TESNCPSingleXC result = (TESNCPSingleXC)super.clone();
            result.pgNo = this.pgNo;
            result.xcLevel = this.xcLevel;
            result.backupPathState = this.backupPathState;
            result.currentWorkPath = this.currentWorkPath;
            result.mainPathState = this.mainPathState;
            result.revertMode = this.revertMode;
            result.wtrTime = this.wtrTime;
            result.switchState = this.switchState;
            result.delayTime = this.delayTime;
            result.pdelayTime = this.pdelayTime;
            result.sncpType = this.sncpType;
            result.watchConditions = this.watchConditions;
            result.srcNO = this.srcNO;
            result.srcSlotID = this.srcSlotID;
            result.srcBoardType = this.srcBoardType;
            result.srcTTpType = this.srcTTpType;
            result.srcPortID = this.srcPortID;
            result.srcVC4ID = this.srcVC4ID;
            result.srcTug3 = this.srcTug3;
            result.srcTug2 = this.srcTug2;
            result.srcTu12 = this.srcTu12;
            result.srcPathID = this.srcPathID;
            result.psrcNO = this.psrcNO;
            result.psrcSlotID = this.psrcSlotID;
            result.psrcBoardType = this.psrcBoardType;
            result.psrcTTpType = this.psrcTTpType;
            result.psrcPortID = this.psrcPortID;
            result.psrcVC4ID = this.psrcVC4ID;
            result.psrcTug3 = this.psrcTug3;
            result.psrcTug2 = this.psrcTug2;
            result.psrcTu12 = this.psrcTu12;
            result.psrcPathID = this.psrcPathID;
            result.snkNO = this.snkNO;
            result.snkSlotID = this.snkSlotID;
            result.snkBoardType = this.snkBoardType;
            result.snkTTpType = this.snkTTpType;
            result.snkPortID = this.snkPortID;
            result.snkVC4ID = this.snkVC4ID;
            result.snkTug3 = this.snkTug3;
            result.snkTug2 = this.snkTug2;
            result.snkTu12 = this.snkTu12;
            result.snkPathID = this.snkPathID;
            return result;
        }
        catch (CloneNotSupportedException ex) {
            TELogFactory.getNormalLogger().error("TESNCPSingleXC.clone() fail!", (Throwable)ex);
            throw new InternalError();
        }
    }

    public String getSrcVC12Name() {
        int boardtype = TEConfigurationDataMgr.getInstance().getBoardType(this.neID, this.srcSlotID);
        if (TEConfigurationDataMgr.getInstance().isBranchBoard(this.neID, this.srcSlotID) && boardtype != 1622) {
            return String.valueOf(this.srcPortID);
        }
        if (this.xcLevel == 1) {
            return "VC4:" + this.srcVC4ID;
        }
        if (this.xcLevel == 6) {
            TESDHQueryDataCache xcCacheInstance = TESDHQueryDataCache.getInstance();
            ArrayList IF1BoardList = xcCacheInstance.getIF1ABList(this.neID);
            if (IF1BoardList != null) {
                int isize = IF1BoardList.size();
                for (int i = 0; i < isize; ++i) {
                    TESDHIF1ABBoard if1board = (TESDHIF1ABBoard)IF1BoardList.get(i);
                    if (this.srcSlotID != if1board.boardSlotID) continue;
                    return "VC4:" + this.srcVC4ID + ":" + this.srcPathID;
                }
                return "VC4:" + this.srcVC4ID + ":" + this.srcPathID;
            }
            return "VC4:" + this.srcVC4ID + ":" + this.srcPathID;
        }
        if (this.xcLevel == 2 || this.xcLevel == 3 || this.xcLevel == 4 || this.xcLevel == 5) {
            return this.getLevelStr(this.xcLevel) + this.srcVC4ID;
        }
        String tmp = "VC4:" + this.srcVC4ID;
        if (this.srcPathID > 0) {
            tmp = tmp + ":" + this.srcPathID;
        }
        return tmp;
    }

    public String getpSrcVC12Name() {
        int boardtype = TEConfigurationDataMgr.getInstance().getBoardType(this.neID, this.psrcSlotID);
        if (TEConfigurationDataMgr.getInstance().isBranchBoard(this.neID, this.psrcSlotID) && boardtype != 1622) {
            return String.valueOf(this.psrcPortID);
        }
        if (this.xcLevel == 1) {
            return "VC4:" + this.psrcVC4ID;
        }
        if (this.xcLevel == 6) {
            TESDHQueryDataCache xcCacheInstance = TESDHQueryDataCache.getInstance();
            ArrayList IF1BoardList = xcCacheInstance.getIF1ABList(this.neID);
            if (IF1BoardList != null) {
                int isize = IF1BoardList.size();
                for (int i = 0; i < isize; ++i) {
                    TESDHIF1ABBoard if1board = (TESDHIF1ABBoard)IF1BoardList.get(i);
                    if (this.psrcSlotID != if1board.boardSlotID) continue;
                    return "VC4:" + this.psrcVC4ID + ":" + this.psrcPathID;
                }
                return "VC4:" + this.psrcVC4ID + ":" + this.psrcPathID;
            }
            return "VC4:" + this.psrcVC4ID + ":" + this.psrcPathID;
        }
        if (this.xcLevel == 2 || this.xcLevel == 3 || this.xcLevel == 4 || this.xcLevel == 5) {
            return this.getLevelStr(this.xcLevel) + this.srcVC4ID;
        }
        String tmp = "VC4:" + this.psrcVC4ID;
        if (this.snkPathID > 0) {
            tmp = tmp + ":" + this.psrcPathID;
        }
        return tmp;
    }

    public String getSnkVC12Name() {
        int boardtype = TEConfigurationDataMgr.getInstance().getBoardType(this.neID, this.snkSlotID);
        if (TEConfigurationDataMgr.getInstance().isBranchBoard(this.neID, this.snkSlotID) && boardtype != 1622) {
            return String.valueOf(this.snkPortID);
        }
        if (this.xcLevel == 1) {
            return "VC4:" + this.snkVC4ID;
        }
        if (this.xcLevel == 6) {
            TESDHQueryDataCache xcCacheInstance = TESDHQueryDataCache.getInstance();
            ArrayList IF1BoardList = xcCacheInstance.getIF1ABList(this.neID);
            if (IF1BoardList != null) {
                int isize = IF1BoardList.size();
                for (int i = 0; i < isize; ++i) {
                    TESDHIF1ABBoard if1board = (TESDHIF1ABBoard)IF1BoardList.get(i);
                    if (this.snkSlotID != if1board.boardSlotID) continue;
                    return "VC4:" + this.snkVC4ID + ":" + this.snkPathID;
                }
                return "VC4:" + this.snkVC4ID + ":" + this.snkPathID;
            }
            return "VC4:" + this.snkVC4ID + ":" + this.snkPathID;
        }
        if (this.xcLevel == 2 || this.xcLevel == 3 || this.xcLevel == 4 || this.xcLevel == 5) {
            return this.getLevelStr(this.xcLevel) + this.srcVC4ID;
        }
        String tmp = "VC4:" + this.snkVC4ID;
        if (this.snkPathID > 0) {
            tmp = tmp + ":" + this.snkPathID;
        }
        return tmp;
    }

    void makeSrcTUG(int ucNo) {
        switch (this.xcLevel) {
            case 4097: {
                this.srcTug3 = (ucNo - 1) / 21 + 1;
                this.srcTug2 = (ucNo - 1) % 21 / 3 + 1;
                this.srcTu12 = (ucNo - 1) % 3 + 1;
                break;
            }
            case 4099: {
                this.srcTu12 = 0;
                this.srcTug2 = 0;
                this.srcTug3 = ucNo;
                break;
            }
            case 4864: 
            case 4865: 
            case 4868: 
            case 4872: 
            case 4880: 
            case 4928: {
                this.srcTu12 = 0;
                this.srcTug2 = 0;
                this.srcTug3 = 0;
                this.srcVC4ID = ucNo;
                break;
            }
        }
    }

    void makeSnkTUG(int ucNo) {
        switch (this.xcLevel) {
            case 4097: {
                this.snkTug3 = (ucNo - 1) / 21 + 1;
                this.snkTug2 = (ucNo - 1) % 21 / 3 + 1;
                this.snkTu12 = (ucNo - 1) % 3 + 1;
                break;
            }
            case 4099: {
                this.snkTu12 = 0;
                this.snkTug2 = 0;
                this.snkTug3 = ucNo;
                break;
            }
            case 4864: 
            case 4865: 
            case 4868: 
            case 4872: 
            case 4880: 
            case 4928: {
                this.snkTu12 = 0;
                this.snkTug2 = 0;
                this.snkTug3 = 0;
                this.snkVC4ID = ucNo;
                break;
            }
        }
    }

    public int getPayloadType() {
        if (TEConfigurationDataMgr.getInstance().isBranchBoard(this.neID, this.srcSlotID)) {
            if (TEConfigurationDataMgr.getInstance().isBranchBoard(this.neID, this.snkSlotID)) {
                return 6;
            }
            return 1;
        }
        if (TEConfigurationDataMgr.getInstance().isBranchBoard(this.neID, this.snkSlotID)) {
            return 0;
        }
        if (this.srcSlotID == this.snkSlotID && this.srcPortID == this.snkPortID && this.srcVC4ID == this.snkVC4ID) {
            return 5;
        }
        return 3;
    }

    public String getSrcBoardName() {
        return this.srcBoard;
    }

    public String getSnkBoardName() {
        return this.snkBoard;
    }

    public void setSrcBoardName(String srcBoard) {
        this.srcBoard = srcBoard;
    }

    public void setSnkBoardName(String snkBoard) {
        this.snkBoard = snkBoard;
    }

    public int getWTRTime() {
        return this.wtrTime;
    }

    public void setWTRTime(int wtrTime) {
        this.wtrTime = wtrTime;
    }

    public int getSwitchState() {
        return this.switchState;
    }

    public void setSwitchState(int switchState) {
        this.switchState = switchState;
    }

    public int getCurrentWorkPath() {
        return this.currentWorkPath;
    }

    public void setCurrentWorkPath(int currentWorkPath) {
        this.currentWorkPath = currentWorkPath;
    }

    public int getMainPathState() {
        return this.mainPathState;
    }

    public void setMainPathState(int mainPathState) {
        this.mainPathState = mainPathState;
    }

    public int getBackupPathState() {
        return this.backupPathState;
    }

    public void setBackupPathState(int backupPathState) {
        this.backupPathState = backupPathState;
    }

    public int getxcLevel() {
        return this.xcLevel;
    }

    public void setxcLeve(int xcLevel) {
        this.xcLevel = xcLevel;
    }

    public int getNeID() {
        return this.neID;
    }

    public void setNeID(int neID) {
        this.neID = neID;
    }

    private String getLevelStr(int level) {
        String str = "VC4:";
        switch (level) {
            case 2: {
                str = "VC4-4C:";
                break;
            }
            case 3: {
                str = "VC4-8C:";
                break;
            }
            case 4: {
                str = "VC4-16C:";
                break;
            }
            case 5: {
                str = "VC4-64C:";
                break;
            }
        }
        return str;
    }
}

