/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.sdh.sdhconfig;

import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import com.huawei.nglct.nemgr.sdh.sdhconfig.TESDHCreateBean;
import com.huawei.nglct.nemgr.sdh.sdhconfig.TESDHIF1ABBoard;
import com.huawei.nglct.nemgr.sdh.sdhconfig_v2r8c01.TESDHQueryDataCache;
import com.huawei.nglct.util.convertor.TETimeSlotConvertUtil;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class TESDHUtil {
    private static final int TIME_OUT = 30;
    private static final int E1PRI_ENABLE = 1;
    public static final int VC4 = 1;
    public static final int VC12 = 6;
    public static final int VC3 = 7;
    public static final int HUAWEIMODE = 0;
    public static final int LUCENTMODE = 1;
    private static final int TUG_COMMON_FLAG = 21;

    public static ArrayList convertPathData(String pathStr) {
        ArrayList<Integer> pathList = new ArrayList<Integer>();
        for (String s : pathStr.split(",")) {
            String[] arr1 = s.split("-");
            int start = Integer.parseInt(arr1[0]);
            int end = Integer.parseInt(arr1[arr1.length - 1]);
            for (int j = start; j <= end; ++j) {
                pathList.add(new Integer(j));
            }
        }
        return pathList;
    }

    public static int getPathMode(Datainterface inputData) {
        for (RowParams rowParams : inputData.getBussinessParams().getRowParams()) {
            Param param = rowParams.getParam("pathMode");
            if (null == param) continue;
            return Integer.valueOf(param.getValue());
        }
        return 0;
    }

    public static void resetOperation(int neid, ArrayList operationList, int pathMode) {
        int m = operationList.size();
        for (int i = 0; i < m; ++i) {
            int xcLevel;
            Operation oper = (Operation)operationList.get(i);
            if (!"NSCMD_CFG_DEL_XC_NEW".equals(oper.getName()) && !"NSCMD_CFG_SET_E1SRVPRIORITY_WBID".equals(oper.getName()) || (xcLevel = Integer.valueOf(oper.getInput().getPartValue("xcLevel")).intValue()) != 6 || pathMode != 1) continue;
            TESDHUtil.convertLucentToHuawei(neid, oper.getInput());
        }
    }

    private static void convertLucentToHuawei(int neid, Input input) {
        TEConfigurationDataMgr cfgMgr = TEConfigurationDataMgr.getInstance();
        int slotId = Integer.valueOf(input.getPartValue("srcSlotID"));
        int boardType = cfgMgr.getBoardType(neid, slotId);
        int pathId = Integer.valueOf(input.getPartValue("srcPathID"));
        if (TESDHCreateBean.boardTypeConvertedList.contains(String.valueOf(boardType))) {
            pathId = TETimeSlotConvertUtil.convertLangxunToHuaweiMode((int)pathId);
            input.setPartValue("srcPathID", String.valueOf(pathId));
        }
        slotId = Integer.valueOf(input.getPartValue("snkSlotID"));
        boardType = cfgMgr.getBoardType(neid, slotId);
        pathId = Integer.valueOf(input.getPartValue("snkPathID"));
        if (TESDHCreateBean.boardTypeConvertedList.contains(String.valueOf(boardType))) {
            pathId = TETimeSlotConvertUtil.convertLangxunToHuaweiMode((int)pathId);
            input.setPartValue("snkPathID", String.valueOf(pathId));
        }
    }

    public static Set<String> queryIFE1Enable(int neid) {
        OperationResult result;
        TEConfigurationDataMgr cfgMgr = TEConfigurationDataMgr.getInstance();
        List boardList = cfgMgr.getBoardList(neid, 2080);
        boardList.addAll(cfgMgr.getBoardList(neid, 2079));
        boardList.addAll(cfgMgr.getBoardList(neid, 2266));
        boardList.addAll(cfgMgr.getBoardList(neid, 2267));
        boardList.addAll(cfgMgr.getBoardList(neid, 2474));
        boardList.addAll(cfgMgr.getBoardList(neid, 2475));
        boardList.addAll(cfgMgr.getBoardList(neid, 2468));
        List boards = TESpecialAttrMgr.getInstance().getSupportCPList(neid, "TE_FUNC_RTN_CFG_IFINTERFACE", "TE_ATTR_RTN_IFINTERFACE_E1PRIENABLE");
        for (Integer integer : boards) {
            boardList.addAll(cfgMgr.getBoardList(neid, integer.intValue()));
        }
        Operation oper = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_CFG_GET_E1PRIENABLE");
        Input input = oper.getInput();
        ArrayList<Object> operList = new ArrayList<Object>();
        int m = boardList.size();
        for (int i = 0; i < m; ++i) {
            TEBoard board = (TEBoard)boardList.get(i);
            input.setPartValue("slotid", String.valueOf(board.getSlotID()));
            List portList = cfgMgr.getPortListFromPortType(neid, board.getBoardType(), 1802);
            int n = portList.size();
            for (int j = 0; j < n; ++j) {
                input.setPartValue("portid", String.valueOf((Integer)portList.get(j)));
                operList.add(oper.clone());
            }
        }
        HashSet<String> e1PriPortSet = new HashSet<String>();
        if (operList.size() > 0 && null != (result = TENECommMgr.getInstance().sendCommand(neid, operList, 30)) && 0 == result.retCode) {
            int errCode = 0;
            int mn = operList.size();
            for (int k = 0; k < mn; ++k) {
                int e1PriEn;
                oper = (Operation)operList.get(k);
                Output output = oper.getOutput(0);
                errCode = Integer.valueOf(output.getFault(0).getCode());
                if (0 != errCode || 1 != (e1PriEn = Integer.valueOf(output.getPartValue("e1enable")).intValue())) continue;
                StringBuilder sb = new StringBuilder();
                sb.append(output.getPartValue("slotid")).append("-");
                sb.append(output.getPartValue("portid"));
                e1PriPortSet.add(sb.toString());
            }
        }
        return e1PriPortSet;
    }

    public static boolean isPDHMode(int neid, int slotID) {
        TESDHQueryDataCache sdhcache = TESDHQueryDataCache.getInstance();
        ArrayList iflist = sdhcache.getIF1ABList(neid);
        if (iflist != null && !iflist.isEmpty()) {
            int isize = iflist.size();
            for (int i = 0; i < isize; ++i) {
                TESDHIF1ABBoard if1board = (TESDHIF1ABBoard)iflist.get(i);
                if (if1board.getBoardSlotID() != slotID) continue;
                return if1board.getCurrentMode() != 7;
            }
            return false;
        }
        return false;
    }

    public static int convertPathID(int pathID, int sourceMode, int destMode) {
        if (sourceMode == destMode) {
            return pathID;
        }
        int newpathID = pathID;
        switch (sourceMode) {
            case 1: {
                int Tug3 = (pathID - 1) / 21 + 1;
                int Tug2 = (pathID - 1) % 21 / 3 + 1;
                int Tu12 = (pathID - 1) % 3 + 1;
                newpathID = Tug3 + (Tug2 - 1) * 3 + (Tu12 - 1) * 21;
                break;
            }
        }
        return newpathID;
    }
}

