/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.sdh.sdhconfig;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.sdh.sdhconfig.TESDHIF1ABBoard;
import com.huawei.nglct.nemgr.sdh.sdhconfig.TESDHPayloadComparator;
import com.huawei.nglct.nemgr.sdh.sdhconfig.TESDHQueryDataCache;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import java.util.ArrayList;
import java.util.Comparator;

public class TESDHSingleXC
implements Cloneable {
    public int sdhXCID = 0;
    public int srcSlotID = 0;
    public int srcBoardType = 0;
    public int srcPort = 0;
    public int srcVC4 = 0;
    public int srcPathID = 0;
    public int srcNO = 0;
    public int srcTug3 = 0;
    public int srcTug2 = 0;
    public int srcTu12 = 0;
    public int srcTTpType = 0;
    public int snkSlotID = 0;
    public int snkBoardType = 0;
    public int snkPort = 0;
    public int snkVC4 = 0;
    public int snkPathID = 0;
    public int snkNO = 0;
    public int snkTug3 = 0;
    public int snkTug2 = 0;
    public int snkTu12 = 0;
    public int snkTTpType = 0;
    public int xcLevel = 0;
    public int pgNo = 0;
    public int xcFlag = 0;
    public String snkBoardCellView = null;
    public String srcBoardCellView = null;
    public boolean isE1Pri = false;
    public int e1Pri = -1;
    public int serviceOrigin = 0;
    private Comparator payloadcomparator = new TESDHPayloadComparator();
    private int wtrTime = 600;
    private int revertMode = -1;
    private int initCriteria = 0;
    private int holdoffTime = 0;
    private String circuitName;
    private static final int VC4 = 1;
    private static final int VC4_4C = 2;
    private static final int VC4_8C = 3;
    private static final int VC4_16C = 4;
    private static final int VC4_64C = 5;
    private static final int VC12 = 6;
    private static final int VC3 = 7;
    private boolean isPumap = false;
    private static final int TUG_COMMON_FLAG = 21;
    private int neID;

    public TESDHSingleXC(int _neID) {
        this.neID = _neID;
    }

    public TESDHSingleXC() {
    }

    public String getBoardViewName(int neid, int slotid, int port) {
        int boardtype = TEConfigurationDataMgr.getInstance().getBoardType(neid, slotid);
        String boardname = TEConfigurationDataMgr.getInstance().getBoardTypeName(neid, boardtype);
        String portname = TEConfigurationDataMgr.getInstance().getPortName(neid, slotid, boardtype, port, 61001);
        portname = portname.equals("") ? TEConfigurationDataMgr.getInstance().getPortName(neid, slotid, boardtype, port) : port + "(" + portname + ")";
        int subrackid = TEBoardUtil.getSubrackIDFromSlot((int)neid, (int)slotid);
        if (TEConfigurationDataMgr.getInstance().isBranchBoard(neid, slotid) && boardtype != 1622) {
            if (subrackid >= 0) {
                return TEBoardUtil.getSubrackNameFromSlot((int)neid, (int)slotid) + "-" + TEBoardUtil.getSlotIDFromSlot((int)neid, (int)slotid) + "-" + boardname;
            }
            return slotid + "-" + boardname;
        }
        if (subrackid >= 0) {
            return TEBoardUtil.getSubrackNameFromSlot((int)neid, (int)slotid) + "-" + TEBoardUtil.getSlotIDFromSlot((int)neid, (int)slotid) + "-" + boardname + "-" + portname;
        }
        return slotid + "-" + boardname + "-" + portname;
    }

    public boolean equals(Object obj) {
        return this.payloadcomparator.compare(this, obj) == 0;
    }

    public int hashCode() {
        int result = 37;
        result += this.sdhXCID;
        result += this.srcSlotID;
        result += this.srcBoardType;
        result += this.srcPort;
        result += this.srcVC4;
        result += this.srcNO;
        result += this.srcTug3;
        result += this.srcTug2;
        result += this.srcTu12;
        result += this.srcTTpType;
        result += this.snkSlotID;
        result += this.snkBoardType;
        result += this.snkPort;
        result += this.snkVC4;
        result += this.snkNO;
        result += this.snkTug3;
        result += this.snkTug2;
        result += this.snkTu12;
        result += this.snkTTpType;
        result += this.xcLevel;
        result += this.pgNo;
        result += this.xcFlag;
        return result += this.neID;
    }

    public Object clone() {
        try {
            TESDHSingleXC result = (TESDHSingleXC)super.clone();
            result.holdoffTime = this.holdoffTime;
            result.initCriteria = this.initCriteria;
            result.pgNo = this.pgNo;
            result.revertMode = this.revertMode;
            result.sdhXCID = this.sdhXCID;
            result.snkNO = this.snkNO;
            result.snkSlotID = this.snkSlotID;
            result.snkBoardType = this.snkBoardType;
            result.snkTTpType = this.snkTTpType;
            result.snkPort = this.snkPort;
            result.snkVC4 = this.snkVC4;
            result.snkTug3 = this.snkTug3;
            result.snkTug2 = this.snkTug2;
            result.snkTu12 = this.snkTu12;
            result.snkPathID = this.snkPathID;
            result.srcNO = this.srcNO;
            result.srcSlotID = this.srcSlotID;
            result.srcBoardType = this.srcBoardType;
            result.srcTTpType = this.srcTTpType;
            result.srcPort = this.srcPort;
            result.srcVC4 = this.srcVC4;
            result.srcTug3 = this.srcTug3;
            result.srcTug2 = this.srcTug2;
            result.srcTu12 = this.srcTu12;
            result.srcPathID = this.srcPathID;
            result.wtrTime = this.wtrTime;
            result.xcFlag = this.xcFlag;
            result.xcLevel = this.xcLevel;
            return result;
        }
        catch (CloneNotSupportedException ex) {
            TELogFactory.getNormalLogger().error("TESDHSingleXC.clone() fail!", (Throwable)ex);
            throw new InternalError();
        }
    }

    public String getSrcVC12Name() {
        int boardtype = TEConfigurationDataMgr.getInstance().getBoardType(this.getNeID(), this.getSrcSlotID());
        if (TEConfigurationDataMgr.getInstance().isBranchBoard(this.neID, this.srcSlotID) && boardtype != 1176 && boardtype != 1177 && boardtype != 1622) {
            return String.valueOf(this.srcPort);
        }
        TESDHQueryDataCache xcCacheInstance = TESDHQueryDataCache.getInstance();
        ArrayList ifboardList = xcCacheInstance.getIF1ABList(this.neID);
        boolean IF1InPDHMode = false;
        if (ifboardList != null) {
            int isize = ifboardList.size();
            for (int i = 0; i < isize; ++i) {
                TESDHIF1ABBoard ifboard = (TESDHIF1ABBoard)ifboardList.get(i);
                if (!ifboard.isPDHMode(this.srcSlotID)) continue;
                IF1InPDHMode = true;
                break;
            }
        }
        if (IF1InPDHMode) {
            return String.valueOf(this.srcPathID);
        }
        if (this.xcLevel == 1) {
            return "VC4:" + this.srcVC4;
        }
        if (this.xcLevel == 2) {
            return "VC4:" + this.srcVC4 + "-" + (this.srcVC4 + 3);
        }
        if (this.xcLevel == 3) {
            return "VC4:" + this.srcVC4 + "-" + (this.srcVC4 + 7);
        }
        if (this.xcLevel == 4) {
            return "VC4:" + this.srcVC4 + "-" + (this.srcVC4 + 15);
        }
        if (this.xcLevel == 5) {
            return "VC4:" + this.srcVC4 + "-" + (this.srcVC4 + 63);
        }
        if (this.xcLevel == 7) {
            return "VC4:" + this.srcVC4 + ":" + this.srcPathID;
        }
        return "VC4:" + this.srcVC4 + ":" + this.srcPathID;
    }

    public String getSnkVC12Name() {
        int boardtype = TEConfigurationDataMgr.getInstance().getBoardType(this.getNeID(), this.getSnkSlotID());
        if (TEConfigurationDataMgr.getInstance().isBranchBoard(this.neID, this.snkSlotID) && boardtype != 1176 && boardtype != 1177 && boardtype != 1622) {
            return String.valueOf(this.snkPort);
        }
        TESDHQueryDataCache xcCacheInstance = TESDHQueryDataCache.getInstance();
        ArrayList ifboardList = xcCacheInstance.getIF1ABList(this.neID);
        boolean IF1InPDHMode = false;
        if (ifboardList != null) {
            int isize = ifboardList.size();
            for (int i = 0; i < isize; ++i) {
                TESDHIF1ABBoard ifboard = (TESDHIF1ABBoard)ifboardList.get(i);
                if (!ifboard.isPDHMode(this.snkSlotID)) continue;
                IF1InPDHMode = true;
                break;
            }
        }
        if (IF1InPDHMode) {
            return String.valueOf(this.snkPathID);
        }
        if (this.xcLevel == 1) {
            return "VC4:" + this.snkVC4;
        }
        if (this.xcLevel == 2) {
            return "VC4:" + this.snkVC4 + "-" + (this.snkVC4 + 3);
        }
        if (this.xcLevel == 3) {
            return "VC4:" + this.snkVC4 + "-" + (this.snkVC4 + 7);
        }
        if (this.xcLevel == 4) {
            return "VC4:" + this.snkVC4 + "-" + (this.snkVC4 + 15);
        }
        if (this.xcLevel == 5) {
            return "VC4:" + this.snkVC4 + "-" + (this.snkVC4 + 63);
        }
        if (this.xcLevel == 7) {
            return "VC4:" + this.snkVC4 + ":" + this.snkPathID;
        }
        return "VC4:" + this.snkVC4 + ":" + this.snkPathID;
    }

    public static boolean isCanAdjoin(TESDHSingleXC xc1, TESDHSingleXC xc2) {
        return TESDHSingleXC.isCanAdjoinSingleDirection(xc1, xc2) || TESDHSingleXC.isCanAdjoinSingleDirection(xc2, xc1);
    }

    private static boolean isCanAdjoinSingleDirection(TESDHSingleXC xc1, TESDHSingleXC xc2) {
        if (xc1.xcLevel != xc2.xcLevel) {
            return false;
        }
        switch (xc1.xcLevel) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                boolean result = false;
                boolean result1 = false;
                if (xc1.srcSlotID == xc2.srcSlotID && xc1.snkSlotID == xc2.snkSlotID) {
                    if (TEConfigurationDataMgr.getInstance().isBranchBoard(xc1.neID, xc1.srcSlotID)) {
                        if (xc1.srcPort == xc2.srcPort - 1) {
                            result = true;
                        }
                    } else if (xc1.srcPort == xc2.srcPort && xc1.srcVC4 == xc2.srcVC4 - 1) {
                        result = true;
                    }
                    if (result) {
                        if (TEConfigurationDataMgr.getInstance().isBranchBoard(xc1.neID, xc1.snkSlotID)) {
                            if (xc1.snkPort == xc2.snkPort - 1) {
                                result1 = true;
                            }
                        } else if (xc1.snkPort == xc2.snkPort && xc1.snkVC4 == xc2.snkVC4 - 1) {
                            result1 = true;
                        }
                    }
                }
                return result && result1;
            }
            case 6: {
                boolean[] results = TESDHSingleXC.getResults(xc1, xc2);
                boolean result2 = false;
                if (xc1.srcSlotID == xc2.srcSlotID && xc1.snkSlotID == xc2.snkSlotID && results[1] && xc1.isE1Pri == xc2.isE1Pri && xc1.e1Pri == xc2.e1Pri) {
                    result2 = true;
                }
                return results[0] && results[1] && result2;
            }
            case 7: {
                boolean[] results = TESDHSingleXC.getResults(xc1, xc2);
                return results[0] && results[1];
            }
        }
        TELogFactory.getNormalLogger().info("TESDHSingleXC.isCanAdjoinSingleDirection() xc1.xcLevel:" + xc1.xcLevel + " not in case!");
        return false;
    }

    private static boolean[] getResults(TESDHSingleXC xc1, TESDHSingleXC xc2) {
        boolean result = false;
        boolean result1 = false;
        if (xc1.srcSlotID == xc2.srcSlotID && xc1.snkSlotID == xc2.snkSlotID) {
            if (TEConfigurationDataMgr.getInstance().isBranchBoard(xc1.neID, xc1.srcSlotID)) {
                if (xc1.srcPort == xc2.srcPort - 1) {
                    result = true;
                }
            } else if (xc1.srcPort == xc2.srcPort && xc1.srcVC4 == xc2.srcVC4 && xc1.srcPathID == xc2.srcPathID - 1) {
                result = true;
            }
            if (result) {
                if (TEConfigurationDataMgr.getInstance().isBranchBoard(xc1.neID, xc1.snkSlotID)) {
                    if (xc1.snkPort == xc2.snkPort - 1) {
                        result1 = true;
                    }
                } else if (xc1.snkPort == xc2.snkPort && xc1.snkVC4 == xc2.snkVC4 && xc1.snkPathID == xc2.snkPathID - 1) {
                    result1 = true;
                }
            }
        }
        return new boolean[]{result, result1};
    }

    boolean isSameSrc(TESDHSingleXC data) {
        return this.srcSlotID == data.srcSlotID && this.srcBoardType == data.srcBoardType && this.srcPort == data.srcPort;
    }

    void setData() {
        this.srcNO = this.xcLevel == 6 ? 1 : (this.xcLevel == 7 ? 2 : 3);
        this.makeSrcTUG(this.srcNO);
    }

    public int getPayloadType() {
        int boardtype = TEConfigurationDataMgr.getInstance().getBoardType(this.neID, this.srcSlotID);
        if (boardtype == 1622) {
            if (this.srcPort >= 5 && this.srcPort <= 25 && this.snkPort >= 5 && this.snkPort <= 25) {
                return 6;
            }
            if ((this.srcPort < 5 || this.srcPort > 25) && this.snkPort >= 5 && this.snkPort <= 25) {
                if (this.pgNo != 0) {
                    return 0;
                }
                return 0;
            }
            if (this.srcPort >= 5 && this.srcPort <= 25 && (this.snkPort < 5 || this.snkPort > 25)) {
                return 1;
            }
        }
        if (TEConfigurationDataMgr.getInstance().isSDHLineBoard(this.neID, this.srcSlotID)) {
            if (TEConfigurationDataMgr.getInstance().isSDHLineBoard(this.neID, this.snkSlotID)) {
                if (this.srcSlotID == this.snkSlotID && this.srcPort == this.snkPort && this.srcVC4 == this.snkVC4) {
                    return 5;
                }
                return 3;
            }
            return 0;
        }
        if (TEConfigurationDataMgr.getInstance().isSDHLineBoard(this.neID, this.snkSlotID)) {
            return 1;
        }
        return 6;
    }

    public int getRevertMode() {
        return this.revertMode;
    }

    void makeSrcTUG(int ucNo) {
        switch (this.xcLevel) {
            case 6: {
                this.srcTug3 = (ucNo - 1) / 21 + 1;
                this.srcTug2 = (ucNo - 1) % 21 / 3 + 1;
                this.srcTu12 = (ucNo - 1) % 3 + 1;
                break;
            }
            case 7: {
                this.srcTu12 = 0;
                this.srcTug2 = 0;
                this.srcTug3 = ucNo;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                this.srcTu12 = 0;
                this.srcTug2 = 0;
                this.srcTug3 = 0;
                this.srcVC4 = ucNo;
                break;
            }
        }
    }

    void makeSnkTUG(int ucNo) {
        switch (this.xcLevel) {
            case 6: {
                this.snkTug3 = (ucNo - 1) / 21 + 1;
                this.snkTug2 = (ucNo - 1) % 21 / 3 + 1;
                this.snkTu12 = (ucNo - 1) % 3 + 1;
                break;
            }
            case 7: {
                this.snkTu12 = 0;
                this.snkTug2 = 0;
                this.snkTug3 = ucNo;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                this.snkTu12 = 0;
                this.snkTug2 = 0;
                this.snkTug3 = 0;
                this.snkVC4 = ucNo;
                break;
            }
        }
    }

    void makeSlotNo() {
        if (this.srcTTpType == 1) {
            this.srcNO = this.srcPort & 0xFF;
        } else {
            switch (this.xcLevel) {
                case 4097: {
                    this.srcNO = (this.srcTu12 - 1) * 21 + (this.srcTug2 - 1) * 3 + this.srcTug3;
                    break;
                }
                case 4099: {
                    this.srcNO = this.srcTug3;
                    break;
                }
                default: {
                    this.srcNO = 0;
                }
            }
        }
        if (this.snkTTpType == 1) {
            this.snkNO = this.snkPort & 0xFF;
        } else {
            switch (this.xcLevel) {
                case 4097: {
                    this.snkNO = (this.snkTu12 - 1) * 21 + (this.snkTug2 - 1) * 3 + this.snkTug3;
                    break;
                }
                case 4099: {
                    this.snkNO = this.snkTug3;
                    break;
                }
                default: {
                    this.snkNO = 0;
                }
            }
        }
    }

    public void setSrcBoardCellView(String srcBoardCellView) {
        this.srcBoardCellView = srcBoardCellView;
    }

    public String getSrcBoardCellView() {
        return this.srcBoardCellView;
    }

    public void setSnkBoardCellView(String snkBoardCellView) {
        this.snkBoardCellView = snkBoardCellView;
    }

    public String getSnkBoardCellView() {
        return this.srcBoardCellView;
    }

    public int getHoldoffTime() {
        return this.holdoffTime;
    }

    public void setHoldoffTime(int holdoffTime) {
        this.holdoffTime = holdoffTime;
    }

    public int getIRevertMode() {
        return this.revertMode;
    }

    public void setRevertMode(int iRevertMode) {
        this.revertMode = iRevertMode;
        this.initCriteria = 0;
        this.holdoffTime = 0;
    }

    public int getWTRTime() {
        return this.wtrTime;
    }

    public void setWTRTime(int time) {
        this.wtrTime = time;
    }

    public int getPgNo() {
        return this.pgNo;
    }

    public void setPgNo(int pgNo) {
        this.pgNo = pgNo;
    }

    public int getSdhXCID() {
        return this.sdhXCID;
    }

    public void setSdhXCID(int sdhXCID) {
        this.sdhXCID = sdhXCID;
    }

    public int getSnkBoardType() {
        return this.snkBoardType;
    }

    public void setSnkBoardType(int snkBoardType) {
        this.snkBoardType = snkBoardType;
    }

    public int getSnkNO() {
        return this.snkNO;
    }

    public void setSnkNO(int snkNO) {
        this.snkNO = snkNO;
    }

    public int getSnkPort() {
        return this.snkPort;
    }

    public void setSnkPort(int snkPort) {
        this.snkPort = snkPort;
    }

    public int getSnkSlotID() {
        return this.snkSlotID;
    }

    public void setSnkSlotID(int snkSlotID) {
        this.snkSlotID = snkSlotID;
    }

    public int getSnkTu12() {
        return this.snkTu12;
    }

    public void setSnkTu12(int snkTu12) {
        this.snkTu12 = snkTu12;
    }

    public int getSnkTug2() {
        return this.snkTug2;
    }

    public void setSnkTug2(int snkTug2) {
        this.snkTug2 = snkTug2;
    }

    public int getSnkTug3() {
        return this.snkTug3;
    }

    public void setSnkTug3(int snkTug3) {
        this.snkTug3 = snkTug3;
    }

    public int getSnkVC4() {
        return this.snkVC4;
    }

    public void setSnkVC4(int snkVC4) {
        this.snkVC4 = snkVC4;
    }

    public int getSrcBoardType() {
        return this.srcBoardType;
    }

    public void setSrcBoardType(int srcBoardType) {
        this.srcBoardType = srcBoardType;
    }

    public int getSrcNO() {
        return this.srcNO;
    }

    public void setSrcNO(int srcNO) {
        this.srcNO = srcNO;
    }

    public int getSrcPort() {
        return this.srcPort;
    }

    public void setSrcPort(int srcPort) {
        this.srcPort = srcPort;
    }

    public int getSrcSlotID() {
        return this.srcSlotID;
    }

    public void setSrcSlotID(int srcSlotID) {
        this.srcSlotID = srcSlotID;
    }

    public int getSrcTu12() {
        return this.srcTu12;
    }

    public void setSrcTu12(int srcTu12) {
        this.srcTu12 = srcTu12;
    }

    public int getSrcTug2() {
        return this.srcTug2;
    }

    public void setSrcTug2(int srcTug2) {
        this.srcTug2 = srcTug2;
    }

    public int getSrcTug3() {
        return this.srcTug3;
    }

    public void setSrcTug3(int srcTug3) {
        this.srcTug3 = srcTug3;
    }

    public int getSrcVC4() {
        return this.srcVC4;
    }

    public void setSrcVC4(int srcVC4) {
        this.srcVC4 = srcVC4;
    }

    public int getXcFlag() {
        return this.xcFlag;
    }

    public void setXcFlag(int xcFlag) {
        this.xcFlag = xcFlag;
    }

    public int getXcLevel() {
        return this.xcLevel;
    }

    public void setXcLevel(int xcLevel) {
        this.xcLevel = xcLevel;
    }

    public int getSlotTypeMode() {
        return -1;
    }

    public void setPayloadcomparator(Comparator payloadcomparator) {
        this.payloadcomparator = payloadcomparator;
    }

    public int getNeID() {
        return this.neID;
    }

    public void setNeID(int neID) {
        this.neID = neID;
    }

    public String getCircuitName() {
        return this.circuitName;
    }

    public void setCircuitName(String circuitName) {
        this.circuitName = circuitName;
    }

    public int getSrcLineNo() {
        return TESDHSingleXC.getLineNo(this.srcTug3, this.srcTug2, this.srcTu12);
    }

    public int getSnkLineNo() {
        return TESDHSingleXC.getLineNo(this.snkTug3, this.snkTug2, this.snkTu12);
    }

    public static int getLineNo(int tug3, int tug2, int tug12) {
        return (tug3 - 1) * 21 + (tug2 - 1) * 3 + tug12;
    }

    public boolean isPumap() {
        return this.isPumap;
    }

    public void setPumap(boolean isPumap) {
        this.isPumap = isPumap;
    }
}

