/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.sdh.sdhconfig;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.db.CommonDaoService;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.model.TESDHTTPUsedInfoMgr;
import com.huawei.nglct.nelist.model.TESDHTs;
import com.huawei.nglct.nelist.model.TESDHXCTTp;
import com.huawei.nglct.nemgr.sdh.sdhconfig.po.TESDHSingleXC;
import com.huawei.nglct.po.TECircuitPack;
import com.huawei.nglct.po.TEPortPO;
import com.huawei.nglct.util.device.port.TEPortUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class TESDHPayloadMgr {
    private static int XCFLAGBIT_PGXC_PROTECT = 1;
    private static int XCFLAGBIT_SNCMPXC = 2;
    private static int XCFLAGBIT_SNCXC_PP = 3;
    private static int XCFLAGBIT_EXTRA_SUPPORT = 4;
    private static int IL_SDH_VC4 = 4865;

    public static int checkTTPValid(int neID, TESDHXCTTp xcTTp) {
        int slotID = xcTTp.getSlotID();
        int portID = xcTTp.getPortID();
        TECircuitPack pCP = new TECircuitPack(neID, slotID);
        if ((pCP = (TECircuitPack)CommonDaoService.getById(TECircuitPack.class, (Serializable)pCP)) == null) {
            return 1090594139;
        }
        TEPortPO pPort = new TEPortPO(neID, slotID, portID);
        if ((pPort = (TEPortPO)CommonDaoService.getById(TEPortPO.class, (Serializable)pPort)) == null) {
            return 1090596477;
        }
        if (TEPortUtil.isLinePort((TEPortPO)pPort) && (xcTTp.getTs().m_usVC4 > pPort.getFBCount(43) || xcTTp.getTs().m_usVC4 <= 0)) {
            return 1090596478;
        }
        return 0;
    }

    public static int isXcFullProtectedByMsp(TENE pNE, TESDHXCTTp sdhTTP) {
        int errCode = 0;
        return errCode;
    }

    public static int ifHaveExtraXC(TENE pNE, TESDHSingleXC singleXC) {
        if (singleXC.getXcflag() == XCFLAGBIT_PGXC_PROTECT || singleXC.getXcflag() == XCFLAGBIT_EXTRA_SUPPORT) {
            return 0;
        }
        int errCode = 0;
        return errCode;
    }

    public static int isDisconflictEx(TESDHSingleXC originXC, TESDHSingleXC singleXC) {
        int errCode = 0;
        TESDHXCTTp originSnkTTp = originXC.getSnkTTp();
        TESDHXCTTp singleSnkTTp = singleXC.getSnkTTp();
        if (originSnkTTp.getLevel() > IL_SDH_VC4) {
            int bgnTTPVC4No;
            ArrayList<Integer> originVcNoList = new ArrayList<Integer>();
            int endTTpVC4No = bgnTTPVC4No + (originSnkTTp.getLevel() - IL_SDH_VC4);
            for (bgnTTPVC4No = originSnkTTp.getTs().m_usVC4; bgnTTPVC4No <= endTTpVC4No; ++bgnTTPVC4No) {
                originVcNoList.add(bgnTTPVC4No);
            }
            endTTpVC4No = bgnTTPVC4No + (singleSnkTTp.getLevel() - IL_SDH_VC4);
            for (bgnTTPVC4No = singleSnkTTp.getTs().m_usVC4; bgnTTPVC4No <= endTTpVC4No; ++bgnTTPVC4No) {
                if (!originVcNoList.contains(bgnTTPVC4No)) continue;
                return 1090594069;
            }
        } else {
            TESDHTs originSnkTs = originSnkTTp.getTs();
            TESDHTs singleSnkTs = singleSnkTTp.getTs();
            if (originSnkTs.m_usVC4 == singleSnkTs.m_usVC4) {
                if (0 == originSnkTs.m_ucTug3 && 0 == singleSnkTs.m_ucTug3 || 0 == originSnkTs.m_ucTug3 && singleSnkTs.m_ucTug3 != 0) {
                    return 1090594069;
                }
                if (0 != originSnkTs.m_ucTug3 && originSnkTs.m_ucTug3 == singleSnkTs.m_ucTug3 && 0 == originSnkTs.m_ucTug2 && singleSnkTs.m_ucTug2 != 0) {
                    return 1090594069;
                }
            }
        }
        return errCode;
    }

    public static void updateSDHXCTTPInfo(int neID, List<TESDHSingleXC> xcList, boolean isAdd) {
        ArrayList<TESDHXCTTp> srcPPITTPList = new ArrayList<TESDHXCTTp>();
        ArrayList<TESDHXCTTp> snkPPITTPList = new ArrayList<TESDHXCTTp>();
        ArrayList<TESDHXCTTp> srcSPITTPList = new ArrayList<TESDHXCTTp>();
        ArrayList<TESDHXCTTp> snkSPITTPList = new ArrayList<TESDHXCTTp>();
        TESDHTTPUsedInfoMgr mgrInstance = TESDHTTPUsedInfoMgr.getInstance();
        try {
            int size = xcList.size();
            for (int index = 0; index < size; ++index) {
                int i;
                int srcVC4;
                TESDHXCTTp tmpTTP;
                int vc4Num;
                TESDHSingleXC sdhXC = xcList.get(index);
                TESDHXCTTp sdhXCTTP = sdhXC.getSrcTTp();
                if (1 == sdhXC.srcTtpType) {
                    srcPPITTPList.add(sdhXCTTP);
                } else {
                    vc4Num = mgrInstance.getUsedVC4Number(sdhXCTTP.m_TTpLevel);
                    if (vc4Num > 1) {
                        tmpTTP = sdhXCTTP;
                        tmpTTP.m_TTpLevel = 4865;
                        srcVC4 = tmpTTP.m_Ts.m_usVC4;
                        for (i = 0; i < vc4Num; ++i) {
                            tmpTTP.m_Ts.m_usVC4 = srcVC4 + i;
                            srcSPITTPList.add(tmpTTP);
                        }
                    } else {
                        srcSPITTPList.add(sdhXCTTP);
                    }
                }
                sdhXCTTP = sdhXC.getSnkTTp();
                if (1 == sdhXC.srcTtpType) {
                    snkPPITTPList.add(sdhXCTTP);
                    continue;
                }
                vc4Num = mgrInstance.getUsedVC4Number(sdhXCTTP.m_TTpLevel);
                if (vc4Num > 1) {
                    tmpTTP = sdhXCTTP;
                    tmpTTP.m_TTpLevel = 4865;
                    srcVC4 = tmpTTP.m_Ts.m_usVC4;
                    for (i = 0; i < vc4Num; ++i) {
                        tmpTTP.m_Ts.m_usVC4 = srcVC4 + i;
                        snkSPITTPList.add(tmpTTP);
                    }
                    continue;
                }
                snkSPITTPList.add(sdhXCTTP);
            }
            mgrInstance.updatePPIUsedInfo(neID, srcPPITTPList, true, isAdd);
            mgrInstance.updatePPIUsedInfo(neID, snkPPITTPList, false, isAdd);
            mgrInstance.updateVC4TTPUsedInfo(neID, srcSPITTPList, true, isAdd);
            mgrInstance.updateVC4TTPUsedInfo(neID, snkSPITTPList, false, isAdd);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TESDHPayloadMgr.updateSDHXCTTPInfo() fail!", (Throwable)e);
        }
    }
}

