/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.sdh.sdhconfig;

import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TESDHXCTTp;
import com.huawei.nglct.nemgr.sdh.sdhconfig.TESDHFabricIF;
import com.huawei.nglct.nemgr.sdh.sdhconfig.TESDHPayloadMgr;
import com.huawei.nglct.nemgr.sdh.sdhconfig.dao.TESDHSingleXCDao;
import com.huawei.nglct.nemgr.sdh.sdhconfig.po.TESDHSingleXC;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TESDHModifyXCBean {
    private static final int STSDHXC_ACTIVATE = 2;
    private static final int STSDHXC_DEACTIVATE = 4;
    private static final int STSDHXC_BIND = 8;
    private static final int STSDHXC_UNBIND = 16;
    private static final int XCAS_ACTIVATED = 1;
    private static final int XCAS_DEACTIVATED = 0;
    private static final int IL_SDH_VC4_AU3 = 4864;
    private static final int IL_SDH_VC4 = 4865;
    private static final int IL_SDH_4C = 4868;
    private static final int IL_SDH_8C = 4872;
    private static final int IL_SDH_16C = 4880;
    private static final int IL_SDH_64C = 4928;
    private static final int IL_SDH_256C = 5120;
    private static final int Qx5_1A1MSPXCPG_BEGINID = 0x10000000;
    private static final int QX5_SNCMP_PG_BEGINID = 0x20000000;
    private static final int XCFLAGBIT_SNCPXC_PROTECT = 0;
    private static final Map<Integer, Integer> LEVEL_MAP = new HashMap<Integer, Integer>();
    private int neid = -1;
    private List<TESDHSingleXC> m_SDHXCList = null;

    public int modifySDHXCs(int neID, List<Integer> modifyXCIDList, List<TESDHSingleXC> singleXCList, boolean bActivateNow, List<TESDHSingleXC> protectXCList, Map<TESDHSingleXC, Integer> mapFailXC) {
        this.neid = neID;
        int errCode = 0;
        if (modifyXCIDList.isEmpty() || singleXCList.isEmpty()) {
            return errCode;
        }
        ArrayList<TESDHSingleXC> modifyAllXCList = new ArrayList<TESDHSingleXC>();
        ArrayList<TESDHSingleXC> modifiedXCList = new ArrayList<TESDHSingleXC>();
        modifiedXCList.addAll(singleXCList);
        if (modifyXCIDList.size() != modifiedXCList.size()) {
            return 1090594362;
        }
        this.m_SDHXCList = TESDHSingleXCDao.getAllXC(this.neid);
        ArrayList<Integer> allModifyXCIDList = new ArrayList<Integer>();
        this.getXCIDsInSamePG(modifyXCIDList, allModifyXCIDList, false);
        errCode = this.isXCsInState(allModifyXCIDList, 4);
        if (0 != errCode) {
            return errCode;
        }
        this.getXCsFromID(allModifyXCIDList, modifyAllXCList);
        TENE pNE = TEConfigurationDataMgr.getInstance().getNE(neID);
        ArrayList relaXCList = new ArrayList();
        ArrayList<TESDHSingleXC> modifiedAllXCList = new ArrayList<TESDHSingleXC>();
        modifiedAllXCList.addAll(modifiedXCList);
        errCode = this.getCopyXCFromXCNp(pNE, modifiedAllXCList, relaXCList);
        errCode = this.validate(pNE, modifiedAllXCList);
        if (errCode != 0) {
            return errCode;
        }
        int xcSize = modifiedAllXCList.size();
        for (int i = 0; i < xcSize; ++i) {
            for (int j = i + 1; j < xcSize; ++j) {
                errCode = this.isDisconflict((TESDHSingleXC)modifiedAllXCList.get(i), (TESDHSingleXC)modifiedAllXCList.get(j));
                if (0 == errCode) continue;
                return errCode;
            }
        }
        ArrayList<TESDHSingleXC> unconflictModifiedXCList = new ArrayList<TESDHSingleXC>();
        ArrayList<TESDHSingleXC> conflictModifiedXCList = new ArrayList<TESDHSingleXC>();
        this.divideConflictXC(modifiedAllXCList, modifyAllXCList, conflictModifiedXCList, unconflictModifiedXCList);
        TESDHFabricIF pFabric = new TESDHFabricIF(neID);
        if (!unconflictModifiedXCList.isEmpty() && 0 != (errCode = pFabric.checkPayload(unconflictModifiedXCList))) {
            return errCode;
        }
        errCode = this.delXCs(modifyAllXCList);
        if (0 != errCode) {
            return errCode;
        }
        TESDHPayloadMgr.updateSDHXCTTPInfo(neID, modifyAllXCList, false);
        pFabric.connect(this.m_SDHXCList);
        ArrayList<TESDHSingleXC> modifyNpXCList = new ArrayList<TESDHSingleXC>();
        ArrayList<TESDHSingleXC> modifyWorkXCList = new ArrayList<TESDHSingleXC>();
        ArrayList<TESDHSingleXC> modifyProtectXCList = new ArrayList<TESDHSingleXC>();
        this.divideToSncXC(modifyAllXCList, modifyNpXCList, modifyWorkXCList, modifyProtectXCList);
        modifyWorkXCList.addAll(modifyNpXCList);
        errCode = this.createSDHXCs(neID, singleXCList, bActivateNow, protectXCList, mapFailXC);
        return errCode;
    }

    private int getXCIDsInSamePG(List<Integer> xcIDList, List<Integer> allXCIDList, boolean bNeedCheck) {
        ArrayList<TESDHSingleXC> allXCList = new ArrayList<TESDHSingleXC>();
        allXCIDList.clear();
        allXCList.clear();
        ArrayList<Integer> xcPGIDList = new ArrayList<Integer>();
        int size = xcIDList.size();
        for (int i = 0; i < size; ++i) {
            int xcID = xcIDList.get(i);
            TESDHSingleXC xc = null;
            int jSize = this.m_SDHXCList.size();
            for (int j = 0; j < jSize && (xc = this.m_SDHXCList.get(j)).getSdhxcid() != xcID; ++j) {
            }
            if (xc != null) {
                if (xc.getPgno() != 0) {
                    xcPGIDList.add(xc.getPgno());
                    continue;
                }
                allXCIDList.add(xcID);
                allXCList.add(xc);
                continue;
            }
            if (!bNeedCheck) continue;
            return 1090594049;
        }
        if (xcPGIDList.isEmpty()) {
            return 0;
        }
        List m_SNCPList = TESDHSingleXCDao.getAllSNCP(this.neid);
        if (m_SNCPList.isEmpty() && bNeedCheck) {
            return 1090594049;
        }
        return 0;
    }

    private int isXCsInState(List<Integer> xcidList, int StateType) {
        List<Integer> stateXCIDList = xcidList;
        int xcCount = 0;
        int iSize = stateXCIDList.size();
        for (int i = 0; i < iSize; ++i) {
            int xcID = stateXCIDList.get(i);
            TESDHSingleXC xc = null;
            int jSize = this.m_SDHXCList.size();
            for (int j = 0; j < jSize && xcID != (xc = this.m_SDHXCList.get(j)).getSdhxcid(); ++j) {
            }
            if (xc == null) continue;
            ++xcCount;
            if ((StateType & 2) != 0 && xc.getActivateState() != 1) {
                return 1090594053;
            }
            if ((StateType & 4) != 0 && xc.getActivateState() != 0) {
                return 1090594052;
            }
            if ((StateType & 8) != 0 && xc.getBindGroupNo() == 0) {
                return 1090594055;
            }
            if ((StateType & 0x10) == 0 || xc.getBindGroupNo() == 0) continue;
            return 1090594054;
        }
        return xcCount == stateXCIDList.size() ? 0 : 1090594049;
    }

    private int getXCsFromID(List<Integer> xcidList, List<TESDHSingleXC> sdhSingleXCList) {
        sdhSingleXCList.clear();
        int iSize = xcidList.size();
        block0: for (int i = 0; i < iSize; ++i) {
            int xcID = xcidList.get(i);
            int jSize = this.m_SDHXCList.size();
            for (int j = 0; j < jSize; ++j) {
                if (this.m_SDHXCList.get(j).getSdhxcid() != xcID) continue;
                sdhSingleXCList.add(this.m_SDHXCList.get(j));
                continue block0;
            }
        }
        return 0;
    }

    private int getCopyXCFromXCNp(TENE pNE, List singleXCList, List modifyXCList) {
        int errCode = 0;
        return errCode;
    }

    private int validate(TENE pNE, List<TESDHSingleXC> singleXCList) {
        int errCode = 0;
        int size = singleXCList.size();
        for (int i = 0; i < size; ++i) {
            errCode = this.validate(pNE, singleXCList.get(i));
            if (errCode == 0) continue;
            return errCode;
        }
        return errCode;
    }

    private int validate(TENE pNE, TESDHSingleXC singleXC) {
        int errCode = 0;
        int xcLevel = singleXC.getLevel();
        int uUsedVC4 = 0;
        if (this.isXCHighLevel(xcLevel) && ((uUsedVC4 = this.getUsedVC4Number(xcLevel)) == 0 || (singleXC.getSrcVc4() - 1) % uUsedVC4 != 0 || (singleXC.getSnkVc4() - 1) % uUsedVC4 != 0)) {
            return 1090594064;
        }
        errCode = singleXC.validate();
        if (0 != errCode) {
            return errCode;
        }
        errCode = TESDHPayloadMgr.checkTTPValid(pNE.getNEID(), singleXC.getSrcTTp());
        if (errCode != 0) {
            return errCode;
        }
        errCode = TESDHPayloadMgr.checkTTPValid(pNE.getNEID(), singleXC.getSnkTTp());
        if (0 != errCode) {
            return errCode;
        }
        if (singleXC.getLevel() > 4865) {
            TESDHXCTTp srcTTP = singleXC.getSrcTTp();
            TESDHXCTTp snkTTP = singleXC.getSnkTTp();
            errCode = TESDHPayloadMgr.isXcFullProtectedByMsp(pNE, srcTTP);
            if (0 != errCode) {
                return errCode;
            }
            errCode = TESDHPayloadMgr.isXcFullProtectedByMsp(pNE, snkTTP);
            if (0 != errCode) {
                return errCode;
            }
        }
        if (errCode == 0) {
            errCode = TESDHPayloadMgr.ifHaveExtraXC(pNE, singleXC);
        }
        return errCode;
    }

    private void divideConflictXC(List<TESDHSingleXC> nmXCList, List<TESDHSingleXC> neXCList, List<TESDHSingleXC> conflictNMXCList, List<TESDHSingleXC> unconflictNMXCList) {
        int errCode = 0;
        List<TESDHSingleXC> tempModifyNEXCList = neXCList;
        List<TESDHSingleXC> tempModifyNMXCList = nmXCList;
        ArrayList<Integer> conflictPGNoModifyVec = new ArrayList<Integer>();
        TESDHSingleXC nmXC = null;
        TESDHSingleXC neXC = null;
        int iSize = tempModifyNMXCList.size();
        for (int i = 0; i < iSize; ++i) {
            nmXC = tempModifyNMXCList.get(i);
            if (0 != nmXC.getPgno() && conflictPGNoModifyVec.contains(nmXC.getPgno())) {
                conflictNMXCList.add(nmXC);
                continue;
            }
            int jSize = tempModifyNEXCList.size();
            for (int j = 0; j < jSize; ++j) {
                neXC = tempModifyNEXCList.get(j);
                errCode = this.isDisconflict(nmXC, neXC);
                if (0 == errCode) continue;
                if (0 != nmXC.getPgno()) {
                    conflictPGNoModifyVec.add(nmXC.getPgno());
                }
                conflictNMXCList.add(nmXC);
                break;
            }
            if (errCode != 0) continue;
            unconflictNMXCList.add(nmXC);
        }
        TESDHSingleXC unconflictNMXCModify = null;
        int len = unconflictNMXCList.size();
        for (int i = 0; i < len; ++i) {
            unconflictNMXCModify = unconflictNMXCList.get(i);
            if (0 == unconflictNMXCModify.getPgno() || !conflictPGNoModifyVec.contains(unconflictNMXCModify.getPgno())) continue;
            conflictNMXCList.add(unconflictNMXCModify);
            unconflictNMXCList.remove(unconflictNMXCModify);
        }
    }

    private int isDisconflict(TESDHSingleXC originXC, TESDHSingleXC singleXC) {
        int errCode = 0;
        TESDHXCTTp originSnkTTpModify = originXC.getSnkTTp();
        TESDHXCTTp singleSnkTTpModify = singleXC.getSnkTTp();
        if (originSnkTTpModify.getSlotID() == singleSnkTTpModify.getSlotID() && originSnkTTpModify.getPortID() == singleSnkTTpModify.getPortID() && originSnkTTpModify.getTTpType() == singleSnkTTpModify.getTTpType()) {
            if (originSnkTTpModify.getLevel() == singleSnkTTpModify.getLevel()) {
                if (originSnkTTpModify.getTs().equals((Object)singleSnkTTpModify.getTs())) {
                    return 1090594069;
                }
            } else if (originSnkTTpModify.getLevel() > singleSnkTTpModify.getLevel() ? 0 != (errCode = TESDHPayloadMgr.isDisconflictEx(originXC, singleXC)) : originSnkTTpModify.getLevel() < singleSnkTTpModify.getLevel() && 0 != (errCode = TESDHPayloadMgr.isDisconflictEx(singleXC, originXC))) {
                return errCode;
            }
        }
        return errCode;
    }

    private int delXCs(List<TESDHSingleXC> xcList) {
        Datainterface resultData = new Datainterface();
        int errorCode = Integer.parseInt(resultData.getErrorMessage().getErrorcode());
        return errorCode;
    }

    private void divideToSncXC(List<TESDHSingleXC> singleXCList, List<TESDHSingleXC> npXCList, List<TESDHSingleXC> sncpWorkXCList, List<TESDHSingleXC> sncpProtectXCList) {
        npXCList.clear();
        sncpWorkXCList.clear();
        sncpProtectXCList.clear();
        TESDHSingleXC singleXCModify = null;
        int size = singleXCList.size();
        for (int i = 0; i < size; ++i) {
            singleXCModify = singleXCList.get(i);
            int pgNO = singleXCModify.getPgno();
            if (pgNO == 0 || pgNO >= 0x10000000 && pgNO < 0x20000000) {
                npXCList.add(singleXCModify);
                continue;
            }
            if (singleXCModify.getXCFlagBits(0)) {
                sncpProtectXCList.add(singleXCModify);
                continue;
            }
            sncpWorkXCList.add(singleXCModify);
        }
    }

    private int getUsedVC4Number(int level) {
        if (!this.isXCHighLevel(level)) {
            return 1;
        }
        return LEVEL_MAP.get(level);
    }

    private boolean isXCHighLevel(int xcLevel) {
        return xcLevel >= 4864;
    }

    private int createSDHXCs(int neID, List<TESDHSingleXC> singleXCList, boolean bActivateNow, List<TESDHSingleXC> protectXCList, Map<TESDHSingleXC, Integer> mapFailXC) {
        int errorCode = 0;
        if (protectXCList == null) {
            int size = singleXCList.size();
            for (int i = 0; i < size; ++i) {
                Datainterface result = new Datainterface();
                int tempErrorCode = Integer.valueOf(result.getErrorMessage().getErrorcode());
                if (tempErrorCode == 0) continue;
                mapFailXC.put(singleXCList.get(i), tempErrorCode);
            }
        }
        errorCode = mapFailXC.isEmpty() ? 0 : (mapFailXC.size() == singleXCList.size() ? 2 : 1);
        return errorCode;
    }

    static {
        LEVEL_MAP.put(4864, 1);
        LEVEL_MAP.put(4865, 1);
        LEVEL_MAP.put(4868, 4);
        LEVEL_MAP.put(4872, 8);
        LEVEL_MAP.put(4880, 16);
        LEVEL_MAP.put(4928, 64);
        LEVEL_MAP.put(5120, 256);
    }
}

