/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.sdh.sdhconfig;

import com.huawei.nglct.nemgr.sdh.sdhconfig.TECrossConnection;
import com.huawei.nglct.nemgr.sdh.sdhconfig.TEDSetTSData;
import com.huawei.nglct.nemgr.sdh.sdhconfig.TEMainBoardBus;
import com.huawei.nglct.nemgr.sdh.sdhconfig.po.TESDHSingleXC;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TESDHFabricIF {
    private static final int IL_PDH_E1 = 4097;
    private static final int IL_PDH_E3 = 4099;
    private static final int IL_SDH_VC4_AU3 = 4864;
    private static final int IL_SDH_VC4 = 4865;
    private static final int IL_SDH_4C = 4868;
    private static final int IL_SDH_8C = 4872;
    private static final int IL_SDH_16C = 4880;
    private static final int IL_SDH_64C = 4928;
    private static final int XCFLAGBIT_PGXC_PROTECT = 1;
    private List<TEDSetTSData> m_listTS = new ArrayList<TEDSetTSData>();
    private TECrossConnection m_pCrossConnect = new TECrossConnection();
    private TEMainBoardBus m_pMainBoardBus = new TEMainBoardBus();
    private Map<Integer, BitSet> m_BusCapacity = new HashMap<Integer, BitSet>();

    public TESDHFabricIF(int neID) {
    }

    public int checkPayload(List<TESDHSingleXC> sdhXCList) {
        int i;
        int retCode = 0;
        int size = sdhXCList.size();
        for (i = 0; i < size && 0 == (retCode = this.checkPayload(sdhXCList.get(i))); ++i) {
            this.connect(sdhXCList.get(i), true);
        }
        for (int j = 0; j < i; ++j) {
            this.connect(sdhXCList.get(j), false);
        }
        return retCode;
    }

    public void getAvailableTS(boolean IsSrc, int slot, int port, Map<Integer, BitSet> vc4TsMap) {
    }

    public void connect(List<TESDHSingleXC> allXCList) {
    }

    public void disConnect(List<TESDHSingleXC> sdhXCList) {
    }

    public void reInstall() {
    }

    public int connect(TESDHSingleXC sdhXC, boolean isAdd) {
        int level = sdhXC.getLevel();
        switch (level) {
            case 4097: 
            case 4099: 
            case 4864: 
            case 4865: {
                break;
            }
            case 4868: {
                TESDHSingleXC temp = sdhXC;
                for (int i = 0; i < 4; ++i) {
                    temp.setSrcVc4(sdhXC.getSrcVc4() + i);
                    temp.setSnkVc4(sdhXC.getSnkVc4() + i);
                    temp.setLevel(4865);
                    this.connect(temp, isAdd);
                }
                return 0;
            }
            case 4872: {
                TESDHSingleXC temp = sdhXC;
                for (int i = 0; i < 8; ++i) {
                    temp.setSrcVc4(sdhXC.getSrcVc4() + i);
                    temp.setSnkVc4(sdhXC.getSnkVc4() + i);
                    temp.setLevel(4865);
                    this.connect(temp, isAdd);
                }
                return 0;
            }
            case 4880: {
                TESDHSingleXC temp = sdhXC;
                for (int i = 0; i < 16; ++i) {
                    temp.setSrcVc4(sdhXC.getSrcVc4() + i);
                    temp.setSnkVc4(sdhXC.getSnkVc4() + i);
                    temp.setLevel(4865);
                    this.connect(temp, isAdd);
                }
                return 0;
            }
            case 4928: {
                TESDHSingleXC temp = sdhXC;
                for (int i = 0; i < 64; ++i) {
                    temp.setSrcVc4(sdhXC.getSrcVc4() + i);
                    temp.setSnkVc4(sdhXC.getSnkVc4() + i);
                    temp.setLevel(4865);
                    this.connect(temp, isAdd);
                }
                return 0;
            }
        }
        int nDstBrdID = sdhXC.getSnkSlotId();
        int nDstVC4 = sdhXC.getSnkVc4();
        int nDstTUG = sdhXC.getSnkTug();
        int nDstPordID = sdhXC.getSnkPortId();
        TEDSetTSData temp = new TEDSetTSData();
        temp.setNDstBrdID(nDstBrdID);
        temp.setNDstVC4(nDstVC4);
        temp.setNDstPortID(nDstPordID);
        temp.setNDstTUG(nDstTUG);
        if ((sdhXC.getXcflag() & 2) == 0) {
            if (isAdd) {
                this.m_listTS.add(temp);
            } else if (this.m_listTS.contains(temp)) {
                this.m_listTS.remove(temp);
            }
        }
        return this.commonConnect(sdhXC, isAdd);
    }

    public int commonConnect(TESDHSingleXC sdhXC, boolean isAdd) {
        int nSrcBrdID = sdhXC.getSrcSlotId();
        int nSrcVC4 = sdhXC.getSrcVc4();
        int nSrcTUG = sdhXC.getSrcTug();
        int nSrcPordID = sdhXC.getSrcPortId();
        int nDstBrdID = sdhXC.getSnkSlotId();
        int nDstVC4 = sdhXC.getSnkVc4();
        int nDstTUG = sdhXC.getSnkTug();
        int nDstPordID = sdhXC.getSnkPortId();
        int nSrcBus = 0;
        int nDstBus = 0;
        this.m_pMainBoardBus.getBusFromSlot(nSrcBus, nSrcBrdID, nSrcPordID, nSrcVC4, true);
        this.m_pMainBoardBus.getBusFromSlot(nDstBus, nDstBrdID, nDstPordID, nDstVC4, false);
        this.commonConnect(nSrcBus, nSrcTUG, isAdd, true);
        if ((sdhXC.getXcflag() & 2) == 0) {
            this.commonConnect(nDstBus, nDstTUG, isAdd, false);
        }
        this.m_pCrossConnect.setCap(nSrcBus, nSrcBrdID, nSrcPordID, nSrcVC4, nSrcTUG, nDstBus, nDstBrdID, nDstPordID, nDstVC4, nDstTUG, isAdd);
        return 0;
    }

    public void commonConnect(int nBus, int nTugs, boolean isAdd, boolean isSrc) {
        BitSet bitXC = this.m_BusCapacity.get(nBus);
        if (nTugs == 1) {
            return;
        }
        int tempTugs = nTugs >> 1;
        int cuTu12 = tempTugs & 3;
        int cuTug2 = tempTugs >> 2 & 7;
        int cuTug3 = tempTugs >> 5 & 3;
        for (int i = 0; i < 3; ++i) {
            if (cuTug3 != 0 && i + 1 != cuTug3) continue;
            for (int j = 0; j < 7; ++j) {
                if (cuTug2 != 0 && j + 1 != cuTug2) continue;
                for (int k = 0; k < 3; ++k) {
                    if (cuTu12 != 0 && k + 1 != cuTu12) continue;
                    int nTime = k * 21 + j * 3 + i + 1;
                    bitXC.set(nTime - 1, isAdd);
                }
            }
        }
    }

    public int checkPayload(TESDHSingleXC sdhXC) {
        int retCode = 0;
        int level = sdhXC.getLevel();
        switch (level) {
            case 4097: 
            case 4099: 
            case 4864: 
            case 4865: {
                break;
            }
            case 4868: {
                TESDHSingleXC temp = sdhXC;
                for (int i = 0; i < 4; ++i) {
                    temp.setSrcVc4(sdhXC.getSrcVc4() + i);
                    temp.setSnkVc4(sdhXC.getSnkVc4() + i);
                    temp.setLevel(4865);
                    retCode = this.checkPayload(temp);
                    if (0 != retCode) break;
                }
                return retCode;
            }
            case 4872: {
                TESDHSingleXC temp = sdhXC;
                for (int i = 0; i < 8; ++i) {
                    temp.setSrcVc4(sdhXC.getSrcVc4() + i);
                    temp.setSnkVc4(sdhXC.getSnkVc4() + i);
                    temp.setLevel(4865);
                    retCode = this.checkPayload(temp);
                    if (0 != retCode) break;
                }
                return retCode;
            }
            case 4880: {
                TESDHSingleXC temp = sdhXC;
                for (int i = 0; i < 16; ++i) {
                    temp.setSrcVc4(sdhXC.getSrcVc4() + i);
                    temp.setSnkVc4(sdhXC.getSnkVc4() + i);
                    temp.setLevel(4865);
                    retCode = this.checkPayload(temp);
                    if (0 != retCode) break;
                }
                return retCode;
            }
            case 4928: {
                TESDHSingleXC temp = sdhXC;
                for (int i = 0; i < 64; ++i) {
                    temp.setSrcVc4(sdhXC.getSrcVc4() + i);
                    temp.setSnkVc4(sdhXC.getSnkVc4() + i);
                    temp.setLevel(4865);
                    retCode = this.checkPayload(temp);
                    if (0 != retCode) break;
                }
                return retCode;
            }
            default: {
                return 1090594119;
            }
        }
        int nSrcBrdID = sdhXC.getSrcSlotId();
        int nSrcVC4 = sdhXC.getSrcVc4();
        int nSrcPortID = sdhXC.getSrcPortId();
        int nSrcTUG = sdhXC.getSrcTug();
        int nDstBrdID = sdhXC.getSnkSlotId();
        int nDstVC4 = sdhXC.getSnkVc4();
        int nDstPortID = sdhXC.getSnkPortId();
        int nDstTUG = sdhXC.getSnkTug();
        retCode = this.checkBoardIsOk(nSrcBrdID, nSrcPortID, nSrcVC4, nSrcTUG);
        if (0 != retCode) {
            return retCode;
        }
        if (sdhXC.getXcflag() == 1) {
            return 0;
        }
        retCode = this.checkBoardIsOk(nDstBrdID, nDstPortID, nDstVC4, nDstTUG);
        if (0 != retCode) {
            return retCode;
        }
        TEDSetTSData temp = new TEDSetTSData();
        temp.setNDstBrdID(nDstBrdID);
        temp.setNDstVC4(nDstVC4);
        temp.setNDstPortID(nDstPortID);
        temp.setNDstTUG(nDstTUG);
        int size = this.m_listTS.size();
        for (int i = 0; i < size; ++i) {
            TEDSetTSData tempTs = this.m_listTS.get(i);
            if (!tempTs.isConflict(temp)) continue;
            return 1090594069;
        }
        return this.checkPayload(sdhXC);
    }

    private int checkBoardIsOk(int nBrdId, int nPortId, int nVC4, int nTS) {
        return 0;
    }
}

