/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.sdh.sdhconfig;

import com.huawei.nglct.cbb.log.TECommonWriteLogBean;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.sdh.sdhconfig.TESDHCreateBean;
import com.huawei.nglct.nemgr.sdh.sdhconfig.TESDHUtil;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.convertor.TETimeSlotConvertUtil;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import java.io.File;
import java.util.ArrayList;

public class TESDHDeleteBean
extends TECommonWriteLogBean {
    private static final int BASE_NUM = 50;
    private static final int VC12 = 6;
    private static final int HUAWEIMODE = 0;
    private static final int LUCENTMODE = 1;
    private TEConfigurationDataMgr cfgMgr = TEConfigurationDataMgr.getInstance();

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.neid = neid;
            this.subfunc = subFunc;
            this.inputData = inputData;
            int pathMode = this.getPathMode();
            this.outputData = new Datainterface();
            this.operationList = this.getOperation(neid, subFunc, inputData, memeryData);
            if (null == this.operationList || this.operationList.size() == 0) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
                return this.outputData;
            }
            TESDHUtil.resetOperation(neid, this.operationList, pathMode);
            this.TIME_OUT = 60;
            int result = -1;
            ArrayList tmpList = this.operationList;
            boolean flg = false;
            int m = 50;
            int n = tmpList.size();
            for (int i = 0; i < n; i += m) {
                this.operationList = new ArrayList();
                if (i + m > n) {
                    this.operationList.addAll(tmpList.subList(i, n));
                } else {
                    this.operationList.addAll(tmpList.subList(i, i + m));
                }
                if (!subFunc.getTransSupport()) {
                    Operation verifyOper = null;
                    verifyOper = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_CFG_VERIFY");
                    this.operationList.add(verifyOper);
                }
                result = this.sendMessage(neid);
                Thread.sleep(100L);
                if (result == 0) continue;
                if (!flg) {
                    flg = true;
                    continue;
                }
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
                if (this.isNeedOperationlog()) {
                    this.writeLog(neid, subFunc, inputData, user, ipAddress, this.outputData);
                }
                return this.outputData;
            }
            this.handleMessage(neid, this.operationList, subFunc);
            Param isLogFlagParam = inputData.getBussinessParams().getRowParams(0).getParam("isLogFlag");
            if (isLogFlagParam != null && isLogFlagParam.getValue().equals("0")) {
                this.isLogFlag = false;
            }
            if (this.isLogFlag && this.isNeedOperationlog()) {
                this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
            return null;
        }
        this.setNeIdParams();
        return this.outputData;
    }

    private int getPathMode() {
        for (RowParams rowParams : this.inputData.getBussinessParams().getRowParams()) {
            Param param = rowParams.getParam("pathMode");
            if (null == param) continue;
            return Integer.valueOf(param.getValue());
        }
        return 0;
    }

    private void resetOperation(int pathMode) {
        int m = this.operationList.size();
        for (int i = 0; i < m; ++i) {
            int xcLevel;
            Operation oper = (Operation)this.operationList.get(i);
            if (!"NSCMD_CFG_DEL_XC_NEW".equals(oper.getName()) || (xcLevel = Integer.valueOf(oper.getInput().getPartValue("xcLevel")).intValue()) != 6 || pathMode != 1) continue;
            this.convertLucentToHuawei(oper.getInput());
        }
    }

    private void convertLucentToHuawei(Input input) {
        int slotId = Integer.valueOf(input.getPartValue("srcSlotID"));
        int boardType = this.cfgMgr.getBoardType(this.neid, slotId);
        int pathId = Integer.valueOf(input.getPartValue("srcPathID"));
        if (TESDHCreateBean.boardTypeConvertedList.contains(String.valueOf(boardType))) {
            pathId = TETimeSlotConvertUtil.convertLangxunToHuaweiMode((int)pathId);
            input.setPartValue("srcPathID", String.valueOf(pathId));
        }
        slotId = Integer.valueOf(input.getPartValue("snkSlotID"));
        boardType = this.cfgMgr.getBoardType(this.neid, slotId);
        pathId = Integer.valueOf(input.getPartValue("snkPathID"));
        if (TESDHCreateBean.boardTypeConvertedList.contains(String.valueOf(boardType))) {
            pathId = TETimeSlotConvertUtil.convertLangxunToHuaweiMode((int)pathId);
            input.setPartValue("snkPathID", String.valueOf(pathId));
        }
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> errList = new ArrayList<Integer>();
        errList.add(32414);
        errList.add(38701);
        return errList;
    }

    protected boolean isSingletonLog() {
        return true;
    }

    public String getDetailInfo(RowParams[] rParams) {
        String xcNoString = "";
        String pgNoString = "";
        int isize = rParams.length;
        for (int i = 0; i < isize; ++i) {
            int pgNo;
            int sdhXCID;
            Param tmp = rParams[i].getParam("sdhXCID");
            if (tmp != null && (sdhXCID = Integer.parseInt(rParams[i].getParam("sdhXCID").getValue())) > 0) {
                xcNoString = xcNoString.equals("") ? String.valueOf(sdhXCID) : xcNoString + "," + sdhXCID;
            }
            if ((tmp = rParams[i].getParam("pgno")) == null || (pgNo = Integer.parseInt(rParams[i].getParam("pgno").getValue())) <= 0) continue;
            pgNoString = pgNoString.equals("") ? String.valueOf(pgNo) : pgNoString + "," + pgNo;
        }
        StringBuffer strBuf = new StringBuffer();
        StringBuffer filePath = new StringBuffer(29);
        filePath.append("sdh").append(File.separator).append("res").append(File.separator).append("sdhconfig").append(File.separator).append("sdhconfig_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        TEResourceUtil res = TEGetFilePath.getResource((int)this.neid, (StringBuffer)filePath);
        strBuf.append(TEConfigurationDataMgr.getInstance().getNE(this.neid).getNEName()).append(':');
        if (!pgNoString.equals("")) {
            strBuf.append(res.getString("pgNo")).append(':').append(pgNoString);
        }
        if (!xcNoString.equals("")) {
            strBuf.append(res.getString("xcNo")).append(':').append(xcNoString);
        }
        return strBuf.toString();
    }
}

