/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.sdh.sdhconfig;

import com.huawei.nglct.cbb.log.TECommonWriteLogBean;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Fault;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.io.File;
import java.util.ArrayList;

public class TESDHConvertSNCPToNormalBean
extends TECommonWriteLogBean {
    private int rtnCode = 0;
    private String[] pgNoList;
    private Datainterface inputParam = null;
    private int xcFlag = 0;
    private static final int sdhXCID = 0;
    private static final int HUAWEIMODE = 0;
    private int m_currServiceMode = 0;
    private TEConfigurationDataMgr mgr = TEConfigurationDataMgr.getInstance();
    private TEResourceUtil res = null;

    public Datainterface performBussinessProcess(int neID, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        RowParams rParams = inputData.getBussinessParams().getRowParams()[0];
        this.inputParam = inputData;
        this.subfunc = subFunc;
        this.neid = neID;
        this.pgNoList = rParams.getParam("pgNo").getValue().trim().split(",");
        this.xcFlag = Integer.parseInt(rParams.getParam("xcFlag").getValue().trim());
        this.m_currServiceMode = Integer.parseInt(rParams.getParam("serviceMode").getValue().trim());
        Integer.parseInt(rParams.getParam("xcFlag").getValue().trim());
        int pgsize = this.pgNoList.length;
        for (int i = 0; i < pgsize; ++i) {
            int pctGroupID = Integer.parseInt(this.pgNoList[i].trim());
            this.rtnCode = pctGroupID < 1 ? 39298 : this.doConvert(neID, pctGroupID);
        }
        if (this.outputData == null) {
            this.outputData = new Datainterface();
        }
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.rtnCode));
        if (this.isNeedOperationlog()) {
            this.writeLog(this.neid, this.subfunc, inputData, user, ipAddress, this.outputData);
        }
        return this.outputData;
    }

    public int doConvert(int neID, int pctGroupID) {
        ArrayList<Object> operList = new ArrayList<Object>();
        try {
            Operation oper = TECreateObjectFactory.getOperation((int)neID, (String)this.subfunc.getQxMapping(0).getContent());
            Input input = oper.getInput();
            input.setPartValue("pgNo", new Integer(pctGroupID).toString());
            input.setPartValue("xcFlag", new Integer(this.xcFlag).toString());
            input.setPartValue("sdhXCID", new Integer(0).toString());
            operList.add(oper.clone());
            OperationResult result = null;
            if (TESpecialAttrMgr.getInstance().isNESupport(neID, "TE_FUNC_CFG_SDH_PAYLOAD", "SDH_ATTR_SUPPORT_SNCP_CONVERT_TRANS")) {
                result = TENECommMgr.getInstance().sendCommand(neID, operList, null, 20, true);
                return result.retCode;
            }
            result = TENECommMgr.getInstance().sendCommand(neID, operList, 10);
            if (result.retCode != 0) {
                return result.retCode;
            }
            Operation oper2 = TECreateObjectFactory.getOperation((int)neID, (String)this.subfunc.getQxMapping(1).getContent());
            if (oper2 != null) {
                operList.clear();
                operList.add(oper2.clone());
                result = TENECommMgr.getInstance().sendCommand(neID, operList, 10);
                if (result.retCode != 0) {
                    return result.retCode;
                }
            }
            Operation tmpOper = (Operation)operList.get(0);
            Output output = tmpOper.getOutput()[0];
            Fault fault = output.getFault()[0];
            return Integer.parseInt(fault.getCode());
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TESDHConvertSNCPToNormalBean.doConvert() fail!", (Throwable)e);
            return 1090646019;
        }
    }

    protected boolean isSingletonLog() {
        return true;
    }

    public String getDetailInfo(RowParams[] rParamsArr) {
        StringBuffer strBuf = new StringBuffer();
        Param[] params = rParamsArr[0].getParam();
        int neId = Integer.parseInt(Datainterface.getParam((Param[])params, (String)"neId").getValue());
        String neName = this.mgr.getNE(neId).getNEName();
        StringBuffer filePath = new StringBuffer();
        filePath.append("sdh").append(File.separator).append("res").append(File.separator).append("sdhconfig").append(File.separator).append("sdhconfig_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        this.res = TEGetFilePath.getResource((int)this.neid, (StringBuffer)filePath);
        strBuf.append(neName).append(":");
        if (this.inputParam != null) {
            String xcFlag = rParamsArr[0].getParam("xcFlag").getValue();
            String pgNo = rParamsArr[0].getParam("pgNo").getValue();
            if ("1".equals(xcFlag)) {
                strBuf.append(this.res.getString("convertSNCPToWSDH"));
            } else {
                strBuf.append(this.res.getString("convertSNCPToPSDH"));
            }
            strBuf.append(":").append(xcFlag).append(",");
            strBuf.append(this.res.getString("pgNo")).append(":").append(pgNo);
            strBuf.append(",");
            if (this.m_currServiceMode == 0) {
                strBuf.append(this.res.getString("currMode")).append(":").append(this.res.getString("huaweiMode")).append(" ");
            } else {
                strBuf.append(this.res.getString("currMode")).append(":").append(this.res.getString("lucentMode")).append(" ");
            }
        }
        return strBuf.toString();
    }
}

