/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.sdh.sdhconfig;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Option;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.neinterface.neadapter.TECommuNEMgr;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TECircuitPackDescription;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEQueryLogicPort;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgDataMgr;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgModel;
import com.huawei.nglct.nemgr.sdh.sdhconfig.TESDHBoardResource;
import com.huawei.nglct.nemgr.sdh.sdhconfig.TESDHLevelResource;
import com.huawei.nglct.nemgr.sdh.sdhconfig.TESDHUseableReource;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Fault;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.slf4j.Logger;

public class TEGetAvaliableSDHXCBoard
extends TENEExplorerBean {
    private Datainterface output;
    private ArrayList usableResourceList = new ArrayList();
    private ArrayList sdhLevelList = null;
    private Logger log = TELogFactory.getNormalLogger();
    private static final int IF1MODE1 = 1;
    private static final int IF1MODE2 = 2;
    private static final int IF1MODE3 = 3;
    private static final int IF1MODE4 = 4;
    private static final int IF1MODE5 = 5;
    private static final int IF1MODE6 = 6;
    private static final int IF1MODE7 = 7;
    private static final int IF1MODE8 = 8;
    private static final int IF1MODE9 = 9;
    private static final int IF1MODE10 = 10;
    private static final int IF1MODE11 = 11;
    private static final int IF1MODE12 = 12;
    private static final int IF1MODE13 = 13;
    private static final int IF1MODE14 = 14;
    private static final int IF1MODE15 = 15;
    private static final int IF1MODE16 = 16;
    private static final int IF1MODE17 = 17;
    private static final int IF1MODE18 = 18;
    private static final int IF1MODE19 = 19;
    private static final int IF1MODE20 = 20;
    private static final int XCLEVEL_VC4 = 1;
    private static final int XCLEVEL_VC3 = 7;
    private static final int XCLEVEL_VC12 = 6;
    private static final int IF1MAX0 = 0;
    private static final int IF1MAX1 = 1;
    private static final int IF1MAX2 = 3;
    private static final int IF1MAX6 = 63;
    private static final int LMS_TYPE_1BN = 1;
    private TEConfigurationDataMgr mgr = TEConfigurationDataMgr.getInstance();
    private static final List<Integer> CES_BOARDS = new ArrayList<Integer>();
    private boolean isConvertSNCP = false;
    private static final int ALL_GROUP = 0;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.inputData = inputData;
        this.output = new Datainterface();
        this.operationList = new ArrayList();
        this.TIME_OUT = 60;
        RowParams rParams = inputData.getBussinessParams().getRowParams()[0];
        Param[] paramArr = rParams.getParam();
        if (paramArr.length <= 0) {
            this.output.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
            return this.output;
        }
        Param isconvertsncp = rParams.getParam("isconvertsncp");
        if (null != isconvertsncp) {
            this.isConvertSNCP = true;
        }
        try {
            this.sdhLevelList = new ArrayList();
            TESDHLevelResource sdhResource = null;
            HashMap usedSlotID = new HashMap();
            Vector boardList = TENEListMgr.getInstance().getNE(neid).getBoardList();
            int len = paramArr.length;
            for (int i = 0; i < len; ++i) {
                String sdhname = paramArr[i].getName();
                int sdhvalue = Integer.parseInt(paramArr[i].getValue());
                if (!sdhname.equalsIgnoreCase("sdhlevel")) continue;
                ArrayList usableBoardList = new ArrayList();
                int size = boardList.size();
                for (int j = 0; j < size; ++j) {
                    TEGenCfgModel cfgModel;
                    TEBoard board = (TEBoard)boardList.get(j);
                    if (!this.isBoradSupportLevel(sdhvalue, board)) continue;
                    int bdType = board.getBoardType();
                    int slotID = board.getSlotID();
                    if (this.mgr.isIFboard(bdType) && null != (cfgModel = TEGenCfgDataMgr.getGenCfgMode((int)bdType)) && null != cfgModel.getAttrFromId("W32PORT_ATTR_RADIOWORKMODE")) continue;
                    if (this.mgr.isSDHLineBoard(this.neid, slotID)) {
                        this.getSDHLineBoardResource(sdhvalue, board, usableBoardList, usedSlotID);
                        continue;
                    }
                    if (!this.mgr.isBranchBoard(this.neid, slotID)) continue;
                    this.getBranchBoardResource(sdhvalue, board, usableBoardList);
                }
                sdhResource = new TESDHLevelResource(sdhvalue, sdhname, usableBoardList);
                this.sdhLevelList.add(sdhResource);
            }
            List<Integer> iF1board = this.getIF1BoardList(boardList);
            this.getIF1BoardRes(iF1board, sdhResource);
            this.fliter1Plus1Port(this.sdhLevelList);
            this.output = this.constructsdhBoardList(this.sdhLevelList);
            this.output.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
        }
        catch (Exception e) {
            this.log.error("Get Avaliable SDH XC Board Fail!\n", (Throwable)e);
            this.output.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090646019));
        }
        return this.output;
    }

    public Datainterface constructsdhBoardList(ArrayList BoardList) {
        Datainterface data = new Datainterface();
        BussinessParams bParams = new BussinessParams();
        int size = BoardList.size();
        for (int i = 0; i < size; ++i) {
            TESDHLevelResource sdhLevel = (TESDHLevelResource)BoardList.get(i);
            ArrayList boardList = sdhLevel.getusableList();
            Collections.sort(boardList);
            int bdsize = boardList.size();
            for (int j = 0; j < bdsize; ++j) {
                TESDHBoardResource board = (TESDHBoardResource)boardList.get(j);
                RowParams rParams = new RowParams();
                Param param = null;
                param = new Param("sdhName", sdhLevel.getsdhName());
                rParams.addParam(param);
                param = new Param("sdhLevel", String.valueOf(sdhLevel.getsdhLevel()));
                rParams.addParam(param);
                int slotid = board.getSlotID();
                param = new Param("slotID", String.valueOf(slotid));
                rParams.addParam(param);
                param = new Param("subrackid", String.valueOf(TEBoardUtil.getSubrackIDFromSlot((int)this.neid, (int)slotid)));
                rParams.addParam(param);
                param = new Param("subrackname", TEBoardUtil.getSubrackNameFromSlot((int)this.neid, (int)slotid));
                rParams.addParam(param);
                param = new Param("showslotid", String.valueOf(TEBoardUtil.getSlotIDFromSlot((int)this.neid, (int)slotid)));
                rParams.addParam(param);
                param = new Param("bdType", String.valueOf(board.getBoardType()));
                rParams.addParam(param);
                param = new Param("bdName", board.getBoardName());
                rParams.addParam(param);
                param = "".equals(board.getVC4String()) ? new Param("bdVC4", String.valueOf(board.getVC4num())) : new Param("bdVC4", board.getVC4String());
                rParams.addParam(param);
                param = new Param("bdPort", board.getPortString());
                rParams.addParam(param);
                param = new Param("bdPath", String.valueOf(board.getPathNumber()));
                rParams.addParam(param);
                param = new Param("isPDHBoard", String.valueOf(board.isBranchBoard()));
                rParams.addParam(param);
                bParams.addRowParams(rParams);
            }
        }
        data.setBussinessParams(bParams);
        data.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neid, (int)0));
        return data;
    }

    public Datainterface constructRtnData() {
        Datainterface data = new Datainterface();
        BussinessParams bParams = new BussinessParams();
        int size = this.usableResourceList.size();
        for (int i = 0; i < size; ++i) {
            TESDHUseableReource res = (TESDHUseableReource)this.usableResourceList.get(i);
            RowParams rParams = new RowParams();
            Param param = null;
            param = new Param("sdhLevel", String.valueOf(res.getSDHLevel()));
            rParams.addParam(param);
            int slotid = res.getSlotID();
            param = new Param("slotID", String.valueOf(slotid));
            rParams.addParam(param);
            param = new Param("subrackid", String.valueOf(TEBoardUtil.getSubrackIDFromSlot((int)this.neid, (int)slotid)));
            rParams.addParam(param);
            param = new Param("subrackname", TEBoardUtil.getSubrackNameFromSlot((int)this.neid, (int)slotid));
            rParams.addParam(param);
            param = new Param("showslotid", String.valueOf(TEBoardUtil.getSlotIDFromSlot((int)this.neid, (int)slotid)));
            rParams.addParam(param);
            param = new Param("bdType", String.valueOf(res.getBoardType()));
            rParams.addParam(param);
            param = new Param("bdName", res.getBoardName());
            rParams.addParam(param);
            param = new Param("port", (String)res.getPorts().get(0));
            int size1 = res.getPorts().size();
            for (int j = 1; j < size1; ++j) {
                Option option = new Option((String)res.getPorts().get(j));
                param.addOption(option);
            }
            rParams.addParam(param);
            bParams.addRowParams(rParams);
        }
        data.setBussinessParams(bParams);
        return data;
    }

    private List<Integer> getIF1BoardList(List<TEBoard> boardList) {
        ArrayList<Integer> IF1board = new ArrayList<Integer>();
        int size = boardList.size();
        for (int j = 0; j < size; ++j) {
            TEGenCfgModel cfgModel;
            TEBoard board = boardList.get(j);
            int bdType = board.getBoardType();
            int slotID = board.getSlotID();
            if (!this.mgr.isIFboard(bdType) || null == (cfgModel = TEGenCfgDataMgr.getGenCfgMode((int)bdType)) || null == cfgModel.getAttrFromId("W32PORT_ATTR_RADIOWORKMODE")) continue;
            IF1board.add(slotID);
        }
        return IF1board;
    }

    private void getSDHLineBoardResource(int sdhvalue, TEBoard board, ArrayList usableBoardList, Map usedSlotID) {
        TESDHBoardResource bdResource = null;
        int bdType = board.getBoardType();
        int slotID = board.getSlotID();
        String bdName = board.getBoardName();
        boolean isSdhPort = true;
        ArrayList portList = (ArrayList)usedSlotID.get(slotID);
        if (null == portList) {
            portList = TEQueryLogicPort.getLogicPortList((int)this.neid, (int)slotID, (int)bdType, (boolean)isSdhPort);
            usedSlotID.put(slotID, portList);
        }
        Collections.sort(portList);
        String portString = "";
        String vc4String = "";
        int ksize = portList.size();
        for (int k = 0; k < ksize; ++k) {
            String iportVcStr = (String)portList.get(k);
            String[] iportVc = iportVcStr.split("-");
            if (portString.equals("")) {
                portString = iportVc[0];
                vc4String = iportVc[1];
                continue;
            }
            portString = portString + "," + iportVc[0];
            vc4String = vc4String + "," + iportVc[1];
        }
        if (portString.equalsIgnoreCase("")) {
            return;
        }
        switch (sdhvalue) {
            case 1: {
                boolean isNotVC4 = TESpecialAttrMgr.getInstance().isCPNotSupportByType(bdType, "TE_FUNC_CFG_SDH_PAYLOAD", "SDH_ATTR_NOTSUPPORT_SDHXC_VC4");
                if (1210 == bdType || 2423 == bdType || 1548 == bdType || 2079 == bdType || 2080 == bdType || 2102 == bdType || 2469 == bdType || isNotVC4) break;
                bdResource = new TESDHBoardResource(slotID, bdType, portString, vc4String, 1, bdName, sdhvalue);
                usableBoardList.add(bdResource);
                break;
            }
            case 7: {
                boolean isNotVC3 = TESpecialAttrMgr.getInstance().isCPNotSupportByType(bdType, "TE_FUNC_CFG_SDH_PAYLOAD", "SDH_ATTR_NOTSUPPORT_SDHXC_VC3");
                if (bdType == 1548 || 2079 == bdType || 2080 == bdType || 2102 == bdType || 2469 == bdType || isNotVC3) break;
                bdResource = new TESDHBoardResource(slotID, bdType, portString, vc4String, 3, bdName, sdhvalue);
                usableBoardList.add(bdResource);
                break;
            }
            case 6: {
                int e1num = 63;
                if (bdType == 2473) {
                    e1num = 46;
                }
                boolean isNotVC12 = TESpecialAttrMgr.getInstance().isCPNotSupportByType(bdType, "TE_FUNC_CFG_SDH_PAYLOAD", "SDH_ATTR_NOTSUPPORT_SDHXC_VC12");
                if (bdType == 2469 || isNotVC12) break;
                bdResource = new TESDHBoardResource(slotID, bdType, portString, vc4String, e1num, bdName, sdhvalue);
                usableBoardList.add(bdResource);
                break;
            }
        }
    }

    private void getBranchBoardResource(int sdhvalue, TEBoard board, ArrayList usableBoardList) {
        TESDHBoardResource bdResource = null;
        int bdType = board.getBoardType();
        int slotID = board.getSlotID();
        String bdName = board.getBoardName();
        int boardtype = this.mgr.getBoardType(this.neid, slotID);
        int portNum = this.mgr.getBoardPortNum(this.neid, bdType);
        int iLevel = this.mgr.getPortIterfaceLevel(this.neid, boardtype, 1);
        String portString = "";
        for (int k = 0; k < portNum; ++k) {
            portString = portString.equals("") ? String.valueOf(k + 1) : portString + "," + (k + 1);
        }
        switch (sdhvalue) {
            case 6: {
                boolean isNotCES = TESpecialAttrMgr.getInstance().isCPNotSupportByType(bdType, "TE_FUNC_CFG_SDH_PAYLOAD", "SDH_ATTR_NOTSUPPORT_SDHXC_CESBD");
                if (this.isConvertSNCP && bdType == 2269 || CES_BOARDS.contains(bdType) || isNotCES) break;
                bdResource = new TESDHBoardResource(slotID, bdType, portString, 0, portNum, bdName, sdhvalue);
                bdResource.setBranchBoard(true);
                usableBoardList.add(bdResource);
                break;
            }
            case 7: {
                if (iLevel != 4099) break;
                bdResource = new TESDHBoardResource(slotID, bdType, portString, 0, portNum, bdName, sdhvalue);
                bdResource.setBranchBoard(true);
                usableBoardList.add(bdResource);
                break;
            }
        }
    }

    private void getIF1BoardRes(List<Integer> if1board, TESDHLevelResource sdhResource) {
        TESDHBoardResource bdResource = null;
        if (!if1board.isEmpty()) {
            int ksize = if1board.size();
            for (int k = 0; k < ksize; ++k) {
                int slotid = if1board.get(k);
                Operation operation0 = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_GET_RADIO_IFMODE");
                operation0.getInput().setPartValue("slotid", String.valueOf(slotid));
                operation0.getInput().setPartValue("port", String.valueOf(1));
                this.operationList.add(operation0);
            }
            int result = super.sendMessage(this.neid);
            if (result == 0) {
                int ksize2 = this.operationList.size();
                for (int k = 0; k < ksize2; ++k) {
                    Operation optemp = (Operation)this.operationList.get(k);
                    Output[] output = optemp.getOutput();
                    int kisize = output.length;
                    block10: for (int ki = 0; ki < kisize; ++ki) {
                        Fault[] faultArr = output[ki].getFault();
                        int code = -1;
                        for (Fault fault : faultArr) {
                            code = Integer.parseInt(fault.getCode());
                        }
                        if (code != 0) continue;
                        int slotid = Integer.parseInt(output[ki].getPartValue("slotid"));
                        int portid = Integer.parseInt(output[ki].getPartValue("port"));
                        int if1Mode = Integer.parseInt(output[ki].getPartValue("W32PORT_ATTR_RADIOWORKMODE"));
                        switch (if1Mode) {
                            case 1: 
                            case 2: {
                                int i;
                                int bdtype = this.mgr.getBoardType(this.neid, slotid);
                                String bdname = this.mgr.getBoardTypeName(this.neid, bdtype);
                                int isize = this.sdhLevelList.size();
                                for (i = 0; i < isize; ++i) {
                                    TESDHLevelResource sdhResrc = (TESDHLevelResource)this.sdhLevelList.get(i);
                                    if (sdhResrc.getsdhLevel() != 6) continue;
                                    ArrayList usableBoardList = sdhResrc.getusableList();
                                    bdResource = new TESDHBoardResource(slotid, bdtype, String.valueOf(portid), 1, 63, bdname, sdhResrc.getsdhLevel());
                                    usableBoardList.add(bdResource);
                                    continue block10;
                                }
                                continue block10;
                            }
                            case 3: 
                            case 4: {
                                ArrayList usableBoardList;
                                int i;
                                int bdtype = this.mgr.getBoardType(this.neid, slotid);
                                String bdname = this.mgr.getBoardTypeName(this.neid, bdtype);
                                int isize = this.sdhLevelList.size();
                                for (i = 0; i < isize; ++i) {
                                    sdhResource = (TESDHLevelResource)this.sdhLevelList.get(i);
                                    if (sdhResource.getsdhLevel() != 6) continue;
                                    usableBoardList = sdhResource.getusableList();
                                    bdResource = new TESDHBoardResource(slotid, bdtype, String.valueOf(portid), 1, 63, bdname, sdhResource.getsdhLevel());
                                    usableBoardList.add(bdResource);
                                    continue block10;
                                }
                                continue block10;
                            }
                            case 5: 
                            case 6: {
                                ArrayList usableBoardList;
                                int i;
                                int bdtype = this.mgr.getBoardType(this.neid, slotid);
                                String bdname = this.mgr.getBoardTypeName(this.neid, bdtype);
                                int isize = this.sdhLevelList.size();
                                for (i = 0; i < isize; ++i) {
                                    sdhResource = (TESDHLevelResource)this.sdhLevelList.get(i);
                                    if (sdhResource.getsdhLevel() != 6) continue;
                                    usableBoardList = sdhResource.getusableList();
                                    bdResource = new TESDHBoardResource(slotid, bdtype, String.valueOf(portid), 1, 63, bdname, sdhResource.getsdhLevel());
                                    usableBoardList.add(bdResource);
                                    continue block10;
                                }
                                continue block10;
                            }
                            case 10: 
                            case 11: 
                            case 12: 
                            case 13: 
                            case 14: 
                            case 15: 
                            case 16: 
                            case 17: 
                            case 18: 
                            case 19: 
                            case 20: {
                                ArrayList usableBoardList;
                                int i;
                                int bdtype = this.mgr.getBoardType(this.neid, slotid);
                                String bdname = this.mgr.getBoardTypeName(this.neid, bdtype);
                                int isize = this.sdhLevelList.size();
                                for (i = 0; i < isize; ++i) {
                                    sdhResource = (TESDHLevelResource)this.sdhLevelList.get(i);
                                    if (sdhResource.getsdhLevel() != 6) continue;
                                    usableBoardList = sdhResource.getusableList();
                                    bdResource = new TESDHBoardResource(slotid, bdtype, String.valueOf(portid), 1, 63, bdname, sdhResource.getsdhLevel());
                                    usableBoardList.add(bdResource);
                                    continue block10;
                                }
                                continue block10;
                            }
                            case 8: 
                            case 9: {
                                ArrayList usableBoardList;
                                int i;
                                int bdtype = this.mgr.getBoardType(this.neid, slotid);
                                String bdname = this.mgr.getBoardTypeName(this.neid, bdtype);
                                int isize = this.sdhLevelList.size();
                                for (i = 0; i < isize; ++i) {
                                    sdhResource = (TESDHLevelResource)this.sdhLevelList.get(i);
                                    if (sdhResource.getsdhLevel() != 7) continue;
                                    usableBoardList = sdhResource.getusableList();
                                    bdResource = new TESDHBoardResource(slotid, bdtype, String.valueOf(portid), 1, 1, bdname, sdhResource.getsdhLevel());
                                    usableBoardList.add(bdResource);
                                    continue block10;
                                }
                                continue block10;
                            }
                            case 7: {
                                ArrayList usableBoardList;
                                int i;
                                int bdtype = this.mgr.getBoardType(this.neid, slotid);
                                String bdname = this.mgr.getBoardTypeName(this.neid, bdtype);
                                int isize = this.sdhLevelList.size();
                                for (i = 0; i < isize; ++i) {
                                    sdhResource = (TESDHLevelResource)this.sdhLevelList.get(i);
                                    if (sdhResource.getsdhLevel() == 6) {
                                        usableBoardList = sdhResource.getusableList();
                                        bdResource = new TESDHBoardResource(slotid, bdtype, String.valueOf(portid), 1, 63, bdname, sdhResource.getsdhLevel());
                                        usableBoardList.add(bdResource);
                                    }
                                    if (sdhResource.getsdhLevel() == 1) {
                                        usableBoardList = sdhResource.getusableList();
                                        bdResource = new TESDHBoardResource(slotid, bdtype, String.valueOf(portid), 1, 1, bdname, sdhResource.getsdhLevel());
                                        usableBoardList.add(bdResource);
                                    }
                                    if (sdhResource.getsdhLevel() != 7) continue;
                                    usableBoardList = sdhResource.getusableList();
                                    bdResource = new TESDHBoardResource(slotid, bdtype, String.valueOf(portid), 1, 3, bdname, sdhResource.getsdhLevel());
                                    usableBoardList.add(bdResource);
                                }
                                continue block10;
                            }
                        }
                    }
                }
            }
        }
    }

    private boolean isBoradSupportLevel(int sdhvalue, TEBoard board) {
        ArrayList supportLevel = TECircuitPackDescription.getInstance().getCPPortSupXCList(board.getBoardType(), 0);
        boolean hasLevel = true;
        if (null != supportLevel && 0 < supportLevel.size()) {
            int sdhlevel = 0;
            hasLevel = false;
            switch (sdhvalue) {
                case 7: {
                    sdhlevel = 4099;
                    break;
                }
                case 6: {
                    sdhlevel = 4097;
                    break;
                }
                default: {
                    TELogFactory.getNormalLogger().info("TEGetAvaliableSDHXCBoard.performBussinessProcess() sdhvalue:" + sdhvalue + " not in case!");
                }
            }
            int listlen = supportLevel.size();
            for (int k = 0; k < listlen; ++k) {
                if (sdhlevel != (Integer)supportLevel.get(k)) continue;
                hasLevel = true;
                break;
            }
        }
        return hasLevel;
    }

    public void fliter1Plus1Port(ArrayList sdhLevelList) {
        Map<Integer, List<String>> if1Plus1UsedPortMap = this.get1Plus1PGRes();
        Map<Integer, List<String>> linearMSUsedResMap = this.getLineaMSPGRes();
        int size = sdhLevelList.size();
        for (int i = 0; i < size; ++i) {
            TESDHLevelResource sdhLevel = (TESDHLevelResource)sdhLevelList.get(i);
            ArrayList boardList = sdhLevel.getusableList();
            Iterator iter = boardList.iterator();
            while (iter.hasNext()) {
                TESDHBoardResource board = (TESDHBoardResource)iter.next();
                int bdType = board.getBoardType();
                if (this.mgr.isIFboard(bdType) && this.is1Plus1BoradPort(board, if1Plus1UsedPortMap)) {
                    iter.remove();
                    continue;
                }
                if (!this.isLinearMSBoradPort(board, linearMSUsedResMap)) continue;
                iter.remove();
            }
        }
    }

    public boolean is1Plus1BoradPort(TESDHBoardResource board, Map<Integer, List<String>> if1Plus1UsedPortMap) {
        int soltID = board.getSlotID();
        return if1Plus1UsedPortMap.containsKey(soltID);
    }

    public boolean isLinearMSBoradPort(TESDHBoardResource board, Map<Integer, List<String>> linearUsedPortMap) {
        int soltID = board.getSlotID();
        return linearUsedPortMap.containsKey(soltID);
    }

    private Map<Integer, List<String>> get1Plus1PGRes() {
        HashMap<Integer, List<String>> if1Plus1UsedPortMap = new HashMap<Integer, List<String>>();
        ArrayList<Operation> operations = new ArrayList<Operation>();
        Operation operation = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_GET_RADIO_1J1PG");
        operation.getInput().setPartValue("groupId", String.valueOf(0));
        operations.add(operation);
        int result = super.sendMessage(this.neid, operations);
        if (result == 0) {
            Operation optemp = (Operation)operations.get(0);
            for (Output output : optemp.getOutput()) {
                Fault[] faultArr = output.getFault();
                int code = -1;
                for (Fault fault : faultArr) {
                    code = Integer.parseInt(fault.getCode());
                }
                if (code != 0) continue;
                int protectionSlotId = Integer.parseInt(output.getPartValue("protectionSlotId"));
                String protectionport = output.getPartValue("protectionport");
                this.addIF1Plus1ProtectSlot(if1Plus1UsedPortMap, protectionSlotId, protectionport);
            }
        }
        return if1Plus1UsedPortMap;
    }

    private void addIF1Plus1ProtectSlot(Map<Integer, List<String>> IF1puls1PGSlotID, int soltID, String port) {
        List<String> portList = IF1puls1PGSlotID.get(soltID);
        if (null == portList) {
            portList = new ArrayList<String>();
            portList.add(port);
            IF1puls1PGSlotID.put(soltID, portList);
        } else if (!this.containsPort(portList, port)) {
            portList.add(port);
        }
    }

    public Map<Integer, List<String>> getLineaMSPGRes() {
        HashMap<Integer, List<String>> linearMSResMap = new HashMap<Integer, List<String>>();
        ArrayList<Operation> operationsList = new ArrayList<Operation>();
        Operation operation1 = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_GET_LMS_PUMAP_NEW");
        Operation operation2 = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_GET_LMS_PG");
        if (operation1 == null || operation2 == null) {
            return linearMSResMap;
        }
        operation1.getInput().setPartValue("groupID", String.valueOf("0"));
        operationsList.add(operation1);
        operation2.getInput().setPartValue("groupID", String.valueOf("0"));
        operationsList.add(operation2);
        int timeout = TESysManagerBean.getInstance().getExplorerBeanTimeout();
        int result = TECommuNEMgr.getInstance().sendCommand((int)this.neid, operationsList, (int)timeout, null).retCode;
        if (result != 0) {
            return linearMSResMap;
        }
        Map<Integer, Integer> lmsGroupType = this.parseLMSGroupType(operationsList);
        for (int j = 0; j < operationsList.size(); ++j) {
            Operation oper = (Operation)operationsList.get(j);
            if (!oper.getName().equalsIgnoreCase("NSCMD_CFG_GET_LMS_PUMAP_NEW")) continue;
            Output[] outputArray = oper.getOutput();
            for (int i = 0; i < outputArray.length; ++i) {
                int code = Integer.parseInt(outputArray[i].getFault(0).getCode());
                if (code != 0) continue;
                int slotid = Integer.parseInt(outputArray[i].getPartValue("slotid"));
                String portid = outputArray[i].getPartValue("port");
                String protectUnit = outputArray[i].getPartValue("protectUnit");
                String groupID = outputArray[i].getPartValue("groupID");
                if (!"0".equals(protectUnit) || groupID != null && lmsGroupType.containsKey(Integer.parseInt(groupID)) && lmsGroupType.get(Integer.parseInt(groupID)) == 1) continue;
                ArrayList<String> portList = (ArrayList<String>)linearMSResMap.get(slotid);
                if (linearMSResMap.get(slotid) == null) {
                    portList = new ArrayList<String>();
                }
                if (!portList.contains(portid)) {
                    portList.add(portid);
                }
                linearMSResMap.put(slotid, portList);
            }
        }
        return linearMSResMap;
    }

    private Map<Integer, Integer> parseLMSGroupType(ArrayList operationsList) {
        HashMap<Integer, Integer> lmsGroupType = new HashMap<Integer, Integer>();
        for (int j = 0; j < operationsList.size(); ++j) {
            Operation oper = (Operation)operationsList.get(j);
            if (!oper.getName().equalsIgnoreCase("NSCMD_CFG_GET_LMS_PG")) continue;
            Output[] outputArray = oper.getOutput();
            for (int i = 0; i < outputArray.length; ++i) {
                String groupID;
                Output output = outputArray[i];
                int code = Integer.parseInt(output.getFault(0).getCode());
                if (code != 0 || (groupID = output.getPartValue("groupID")) == null || groupID.isEmpty()) continue;
                lmsGroupType.put(Integer.parseInt(groupID), Integer.parseInt(output.getPartValue("protectionType")));
            }
        }
        return lmsGroupType;
    }

    public boolean containsPort(List<String> portList, String port) {
        if (portList == null) {
            return false;
        }
        return portList.contains(port);
    }

    public boolean isNeedOperationlog() {
        return false;
    }

    static {
        CES_BOARDS.add(2274);
        CES_BOARDS.add(2273);
    }
}

