/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.sdh.ringmsp_v2r8c01;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TENEMgrInterface;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import com.huawei.nglct.nemgr.sdh.TESDHResourceCaseUtil;
import com.huawei.nglct.nemgr.sdh.ringmsp_v2r8c01.TERingMspQuery;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.device.port.TEVirtualPortUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Vector;
import org.slf4j.Logger;

public class TEAvailabeResQueryBean
implements TENEMgrInterface {
    private int neid;
    private Datainterface output;
    private Logger log = TELogFactory.getNormalLogger();

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.output = new Datainterface();
        TENE neObj_ringmsp = TENEListMgr.getInstance().getNE(neid);
        try {
            if (null != neObj_ringmsp) {
                this.getAvaliableBoardForRingMsp();
            } else {
                this.output.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090596385));
            }
        }
        catch (Exception e) {
            this.log.error("Get Avaliable IPA Board Fail!\n", (Throwable)e);
            this.output.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090646019));
        }
        return this.output;
    }

    private void getAvaliableBoardForRingMsp() {
        this.output.setBussinessParams(new BussinessParams());
        RowParams rowparams_ringmsp = null;
        TEBoard board = null;
        int bdType = 0;
        int slotID = 0;
        int port = 0;
        String bdName = "";
        Vector boardList_ringmsp = TENEListMgr.getInstance().getNE(this.neid).getClonedBoardList();
        Collections.sort(boardList_ringmsp);
        int size = boardList_ringmsp.size();
        for (int j = 0; j < size; ++j) {
            ArrayList portList;
            board = (TEBoard)boardList_ringmsp.get(j);
            bdType = board.getBoardType();
            slotID = board.getSlotID();
            bdName = board.getBoardName();
            boolean isSupportBD = TESpecialAttrMgr.getInstance().isCPSupportByType(bdType, "TE_FUNC_CFG_RINGMSP", "SDH_ATTR_SUPPORT_RINGMSP_SUPPORTBD");
            if (!TESDHResourceCaseUtil.Supported_BoardList.contains(bdType + "") && !isSupportBD || !TEConfigurationDataMgr.getInstance().isSDHLineBoard(this.neid, slotID) || null == (portList = TEConfigurationDataMgr.getInstance().getLogicPortList(this.neid, slotID))) continue;
            Collections.sort(portList);
            int portLen = portList.size();
            for (int portIndex = 0; portIndex < portLen; ++portIndex) {
                port = (Integer)portList.get(portIndex);
                if (TEVirtualPortUtil.isMSOTNBoard((int)bdType) && !TEVirtualPortUtil.getExistVPortsByDomain((int)this.neid, (int)slotID, (int)1).contains(port) || TERingMspQuery.usedPortMap.containsKey(slotID + "-" + port)) continue;
                rowparams_ringmsp = new RowParams();
                rowparams_ringmsp.addParam("neid", String.valueOf(this.neid));
                rowparams_ringmsp.addParam("subrackid", String.valueOf(TEBoardUtil.getSubrackIDFromSlot((int)this.neid, (int)slotID)));
                rowparams_ringmsp.addParam("subrackname", TEBoardUtil.getSubrackNameFromSlot((int)this.neid, (int)slotID));
                rowparams_ringmsp.addParam("slotid", String.valueOf(slotID));
                rowparams_ringmsp.addParam("showslotid", String.valueOf(TEBoardUtil.getSlotIDFromSlot((int)this.neid, (int)slotID)));
                rowparams_ringmsp.addParam("boardname", bdName);
                rowparams_ringmsp.addParam("port", String.valueOf(port));
                if (0 == port) continue;
                rowparams_ringmsp.addParam("portname", TEConfigurationDataMgr.getInstance().getPortName(this.neid, slotID, bdType, port));
                int portType = TEConfigurationDataMgr.getInstance().getPortType(this.neid, bdType, port);
                String rate = TEConfigurationDataMgr.getInstance().getBoardPortSpeed(this.neid, bdType, portType) + "";
                if (bdType == 1577) {
                    rate = this.getLogicalPortSpeed(slotID, port) + "";
                    if ("2".equals(rate)) {
                        rowparams_ringmsp.addParam("rate", "4");
                    } else {
                        rowparams_ringmsp.addParam("rate", rate);
                    }
                } else if (TEVirtualPortUtil.isMSOTNBoard((int)bdType)) {
                    rowparams_ringmsp.addParam("rate", String.valueOf(TEVirtualPortUtil.getVC4NumByVSDHPortLevel((int)this.neid, (int)slotID, (int)port)));
                } else if (!"-1".equals(rate)) {
                    rowparams_ringmsp.addParam("rate", Integer.valueOf(rate.substring(2, 4)) + "");
                }
                this.output.getBussinessParams().addRowParams(rowparams_ringmsp);
            }
        }
        this.output.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
    }

    public boolean isNeedOperationlog() {
        return false;
    }

    private int getLogicalPortSpeed(int slotid, int portNo) {
        try {
            Operation oper_ringmsp = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_GET_PORT");
            Input input = oper_ringmsp.getInput();
            Part part = input.getPart("slotID");
            part.setValue(String.valueOf(slotid));
            part = input.getPart("portID");
            part.setValue(String.valueOf(portNo));
            ArrayList<Operation> operationList = new ArrayList<Operation>();
            operationList.add(oper_ringmsp);
            int resualt = TENECommMgr.getInstance().sendCommand((int)this.neid, operationList, (int)10).retCode;
            if (resualt == 0 && oper_ringmsp.getOutput()[0].getFault()[0].getCode().equals(String.valueOf(0))) {
                int speedLevel = Integer.parseInt(oper_ringmsp.getOutput()[0].getPartValue("speedLevel"));
                return speedLevel;
            }
        }
        catch (Exception e) {
            this.log.error("Parse Qx description file fail!", (Throwable)e);
            return -1;
        }
        return -1;
    }
}

