/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.sdh.ringmsp;

import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.ArrayList;

public class TERingMspUtils {
    public static final String WEST_UNIT = "0";
    public static final String WEST_UNIT1 = "1";
    public static final String EAST_UNIT1 = "3";
    public static final int ACTIVE_FLAG = 3;
    private static final int PROTOCOLSTATE_UNKNOWN = 4;
    private static final int PROTOCOLSTATE_STARTED = 1;
    private static final int PROTOCOLSTATE_STARTING = 2;
    private static final int PROTOCOLSTATE_STOP = 0;
    private static final int PROTOCOLSTATE_PARTSTARTED = 3;
    private static final int STA_LOCK_PROTECT_SPAN = 36;
    private static final int STA_PROTOCOL_STARTING = 2;
    private static final int STA_PROTOCOL_UNSTART = 0;
    private static final int STA_IDLE = 28;
    private static final int STA_FS_S = 14;
    private static final int STA_FS_R = 15;
    private static final int STA_MS_S = 16;
    private static final int STA_MS_R = 17;
    private static final int STA_SF_S = 20;
    private static final int STA_SF_R = 21;
    private static final int STA_SD_S = 24;
    private static final int STA_SD_R = 25;
    private static final int STA_EXER_S = 18;
    private static final int STA_EXER_R = 19;
    private static final int STA_SFPS = 37;
    private static final int STA_SD_P = 23;
    private static final int STA_RRS = 39;
    private static final int STA_RRR = 40;
    private static final int STA_PASS_THROUGH = 29;
    private static final int STA_WTR = 26;
    private static final int STA_LOCK_WORKSPAN = 256;
    private static final int STA_LOCK_RING = 512;
    private static final int STA_LOCK_WS_WR = 768;
    private static final int STA_LOCK_RINGALL = 1024;
    private static final int STA_LOCK_WS_RA = 1280;
    private static final int STA_LOCK_WR_RA = 1536;
    private static final int STA_LOCK_WS_WR_RA = 1792;

    private TERingMspUtils() {
    }

    public static int getSwitchStatus(int convertstatus, int converttype) {
        int swState;
        int lockState;
        switch (converttype << 8 | convertstatus) {
            case 63492: {
                return 36;
            }
            case 65280: {
                return 2;
            }
            case 255: {
                return 2;
            }
            case 0: {
                return 0;
            }
            case 1: {
                return 28;
            }
            case 57348: {
                return 14;
            }
            case 53252: {
                return 15;
            }
            case 28676: {
                return 16;
            }
            case 24580: {
                return 17;
            }
            case 49156: {
                return 20;
            }
            case 45060: {
                return 21;
            }
            case 36868: {
                return 24;
            }
            case 32772: {
                return 25;
            }
            case 16388: {
                return 18;
            }
            case 12292: {
                return 19;
            }
            case 61444: {
                return 37;
            }
            case 40964: {
                return 23;
            }
            case 8196: {
                return 39;
            }
            case 4100: {
                return 40;
            }
            case 6: {
                return 29;
            }
            case 20484: {
                return 26;
            }
        }
        switch (converttype & 7) {
            case 1: {
                lockState = 256;
                break;
            }
            case 2: {
                lockState = 512;
                break;
            }
            case 3: {
                lockState = 768;
                break;
            }
            case 4: {
                lockState = 1024;
                break;
            }
            case 5: {
                lockState = 1280;
                break;
            }
            case 6: {
                lockState = 1536;
                break;
            }
            case 7: {
                lockState = 1792;
                break;
            }
            default: {
                lockState = 0;
            }
        }
        switch (converttype & 0xF8) {
            case 240: {
                swState = 37;
                break;
            }
            case 248: {
                swState = 36;
                break;
            }
            case 224: {
                swState = 14;
                break;
            }
            case 208: {
                swState = 15;
                break;
            }
            case 192: {
                swState = 20;
                break;
            }
            case 176: {
                swState = 21;
                break;
            }
            case 144: {
                swState = 24;
                break;
            }
            case 128: {
                swState = 25;
                break;
            }
            case 112: {
                swState = 16;
                break;
            }
            case 96: {
                swState = 17;
                break;
            }
            case 80: {
                swState = 26;
                break;
            }
            case 64: {
                swState = 18;
                break;
            }
            case 48: {
                swState = 19;
                break;
            }
            case 32: {
                swState = 39;
                break;
            }
            case 16: {
                swState = 40;
                break;
            }
            default: {
                swState = 0;
            }
        }
        return lockState | swState;
    }

    public static void handleRMSSWState(Operation swstaOper, ArrayList operationList) {
        Output output = null;
        int len = swstaOper.getOutputCount();
        for (int i = 0; i < len; ++i) {
            output = swstaOper.getOutput(i);
            if (0 != Integer.parseInt(output.getFault(0).getCode())) {
                Part tmpPart = new Part();
                tmpPart.setName("protocolstate");
                tmpPart.setValue("4");
                output.addPart(tmpPart);
                continue;
            }
            int wconvertstatus = Integer.parseInt(output.getPartValue("Wconvertstatus"));
            int econvertstatus = Integer.parseInt(output.getPartValue("Econvertstatus"));
            int protocolStatus = 0;
            if (wconvertstatus > 0 && wconvertstatus < 255 || econvertstatus > 0 && econvertstatus < 255) {
                protocolStatus = 3;
            }
            if (wconvertstatus > 0 && wconvertstatus < 255 && econvertstatus > 0 && econvertstatus < 255) {
                protocolStatus = 1;
            }
            if (wconvertstatus == 0 && econvertstatus == 0) {
                protocolStatus = 0;
            }
            if (wconvertstatus == 255 || econvertstatus == 255) {
                protocolStatus = 2;
            }
            Part tmpPart = new Part();
            tmpPart.setName("protocolstate");
            tmpPart.setValue(protocolStatus + "");
            output.addPart(tmpPart);
        }
    }
}

