/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.sdh.reportform;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import com.huawei.nglct.util.io.IOStreamConvertor;
import com.huawei.nglct.util.io.TEFileUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.xml.TERWCfgFile;
import com.huawei.nglct.util.xml.TEResourceManager;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import gnu.trove.TIntArrayList;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;

public class TEExportCeaseInfo
extends TENEExplorerBean {
    private static final int TIME_OUT = 300;
    private static final String EXPORT_CEASE_FILEPATH = TERWCfgFile.getBundleRWCfgFilePath(TEResourceManager.class, (String)("report" + File.separator + "ceas" + File.separator));

    public ArrayList getOperation(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData) {
        ArrayList<Operation> opertionList = new ArrayList<Operation>();
        opertionList.add(TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_CFG_GET_NECFGINFO"));
        return opertionList;
    }

    public int sendMessage(int neid) {
        int retCode = 0;
        OperationResult result = TENECommMgr.getInstance().sendCommand(neid, (List)this.operationList, this.getTimeOut());
        if (null != result) {
            retCode = result.retCode;
        }
        if (retCode != 0) {
            return retCode;
        }
        this.getQuueryBDCfgInfo();
        return retCode;
    }

    protected void getQuueryBDCfgInfo() {
        ArrayList<Operation> sendOperList = new ArrayList<Operation>();
        OperationResult result = null;
        TENE neObj = TENEListMgr.getInstance().getNE(this.neid);
        Vector phyBDList = neObj.getClonedPhyBoardList();
        Collections.sort(phyBDList);
        Operation tmpBDCfgOper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_GET_BDCFGINFO");
        Operation tmpODUOper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_GET_ODU_FACTORYINFO");
        Operation tmpBdInfoOper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_GET_BDINFO");
        Operation bdCfgInfoOper = null;
        Operation oduOper = null;
        Operation bdInfoOper = null;
        int slotid = 0;
        int boardType = 0;
        TIntArrayList bdTypeList = this.getFilterBoardTypeList();
        int len = phyBDList.size();
        for (int i = 0; i < len; ++i) {
            sendOperList.clear();
            slotid = ((TEBoard)phyBDList.get(i)).getSlotID();
            boardType = ((TEBoard)phyBDList.get(i)).getBoardType();
            if (null != tmpBDCfgOper) {
                bdCfgInfoOper = (Operation)tmpBDCfgOper.clone();
                bdCfgInfoOper.getInput().getPart(0).setValue("" + slotid);
                sendOperList.add(bdCfgInfoOper);
            }
            boolean isODUBD = TESpecialAttrMgr.getInstance().isCPSupportByType(boardType, "TE_FUNC_CFG_BOARDINFO_REPORT", "SDH_ATTR_SUPPORT_BOARDINFO_ODUSP");
            if (boardType == 1035 || boardType == 1220 || boardType == 1405 || isODUBD) {
                oduOper = (Operation)tmpODUOper.clone();
                oduOper.getInput().getPart(0).setValue("" + slotid);
                sendOperList.add(oduOper);
            }
            boolean isIFBD = TESpecialAttrMgr.getInstance().isCPNotSupportByType(boardType, "TE_FUNC_CFG_BOARDINFO_REPORT", "SDH_ATTR_NOTSUPPORT_BOARDINFO_CEASBD_OLD");
            if (!bdTypeList.contains(boardType) && !isIFBD) {
                bdInfoOper = (Operation)tmpBdInfoOper.clone();
                bdInfoOper.getInput().getPart(0).setValue("" + slotid);
                bdInfoOper.getInput().getPart(1).setValue("0");
                sendOperList.add(bdInfoOper);
            }
            result = TENECommMgr.getInstance().sendCommand(this.neid, sendOperList, this.getTimeOut());
            int retCode = 0;
            if (null != result) {
                retCode = result.retCode;
            }
            if (0 != retCode) continue;
            this.operationList.addAll(sendOperList);
            if (bdTypeList.contains(boardType) || isIFBD) continue;
            this.handleQueryBDInfo((Operation)sendOperList.get(sendOperList.size() - 1));
        }
    }

    protected void handleQueryBDInfo(Operation firstOper) {
        ArrayList<Operation> queryBDInfoList = new ArrayList<Operation>();
        Operation operation = null;
        if (!firstOper.getOutput(0).getFault(0).getCode().equals("0")) {
            return;
        }
        int bagTotal = Integer.parseInt(firstOper.getOutput(0).getPart(1).getValue());
        for (int j = 1; j < bagTotal; ++j) {
            operation = (Operation)firstOper.clone();
            operation.getInput().getPart(1).setValue("" + j);
            queryBDInfoList.add(operation);
        }
        if (null != queryBDInfoList && queryBDInfoList.size() > 0) {
            OperationResult result = TENECommMgr.getInstance().sendCommand(this.neid, queryBDInfoList, this.getTimeOut());
            int retCode = 0;
            if (null != result) {
                retCode = result.retCode;
            }
            if (0 == retCode) {
                this.operationList.addAll(queryBDInfoList);
            }
        }
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        StringBuffer detailInfo = new StringBuffer();
        Operation tmpOper = null;
        StringBuffer fileName = new StringBuffer();
        TENE neObj = TENEListMgr.getInstance().getNE(neid);
        fileName.append("NEData_").append(neObj.getNEName()).append(".txt");
        String filePath = EXPORT_CEASE_FILEPATH + fileName.toString();
        String lineSep = System.getProperty("line.separator");
        int bagIndex = 0;
        int dataLength = 0;
        int len = operationList.size();
        for (int i = 0; i < len; ++i) {
            tmpOper = (Operation)operationList.get(i);
            if (tmpOper.getOutput(0).getFault(0).getCode().equals("0")) {
                String returnValue;
                if (tmpOper.getName().equals("NSCMD_CFG_GET_BDINFO")) {
                    bagIndex = Integer.parseInt(tmpOper.getOutput(0).getPart(2).getValue());
                    dataLength = Integer.parseInt(tmpOper.getOutput(0).getPart(3).getValue());
                    byte[] infoByteArr = tmpOper.getOutput(0).getPart(4).getValue().getBytes();
                    returnValue = IOStreamConvertor.replaceSpecialStr((String)new String(infoByteArr, 0, dataLength));
                    if (bagIndex == 0) {
                        detailInfo.append(lineSep);
                    }
                } else {
                    detailInfo.append(lineSep);
                    returnValue = IOStreamConvertor.replaceSpecialStr((String)tmpOper.getOutput(0).getPart(1).getValue());
                }
                String convertValue = returnValue.replaceAll("\n", lineSep);
                detailInfo.append(convertValue);
                continue;
            }
            TELogFactory.getNormalLogger().debug("Send Command<" + tmpOper.getName() + "> is Fail!The errorCode is :" + tmpOper.getOutput(0).getFault(0).getCode());
        }
        if (detailInfo.length() > 0) {
            detailInfo.append("*/");
        }
        int result = this.saveTxt(fileName.toString(), detailInfo.toString());
        this.outputData = new Datainterface();
        this.outputData.setBussinessParams(new BussinessParams());
        RowParams rowParams = new RowParams();
        rowParams.addParam(new Param("filePath", filePath));
        this.outputData.getBussinessParams().addRowParams(rowParams);
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
    }

    public int getTimeOut() {
        return 300;
    }

    public boolean isNeedOperationlog() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int saveTxt(String fileName, String content) {
        String basePath = EXPORT_CEASE_FILEPATH;
        if (!TEFileUtil.makedir((String)basePath)) {
            return 1090646024;
        }
        int result = 0;
        String filePath = basePath + fileName;
        File file = new File(filePath);
        if (file.exists()) {
            file.delete();
        }
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new FileWriter(filePath));
            out.write(content);
            out.flush();
            this.safeCloseileStream(out);
        }
        catch (IOException e) {
            try {
                result = 1090646024;
                TELogFactory.getNormalLogger().error("Export CEASE File Faile," + filePath, (Throwable)e);
                this.safeCloseileStream(out);
            }
            catch (Throwable throwable) {
                this.safeCloseileStream(out);
                throw throwable;
            }
        }
        return result;
    }

    private void safeCloseileStream(BufferedWriter fileStream) {
        if (fileStream != null) {
            try {
                fileStream.close();
            }
            catch (IOException ex) {
                TELogFactory.getNormalLogger().info("close file stream failed!", (Throwable)ex);
            }
        }
    }

    protected TIntArrayList getFilterBoardTypeList() {
        TIntArrayList bdTypeList = new TIntArrayList();
        bdTypeList.add(1035);
        bdTypeList.add(1220);
        bdTypeList.add(1405);
        return bdTypeList;
    }
}

