/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.sdh.regconfig;

import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;

public class TEREGConfigQueryBean
extends TENEExplorerBean {
    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        this.neid = neid;
        this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList, (ArrayList)filterErrorCodeList);
        Operation tmpOper = (Operation)operationList.get(0);
        Output output = tmpOper.getOutput(0);
        int faultCode = Integer.parseInt(output.getFault(0).getCode());
        if (faultCode == 0 && this.outputData.getBussinessParams().getRowParams().length > 0) {
            this.handleREGMap(this.outputData);
        }
    }

    private void handleREGMap(Datainterface outputData) {
        RowParams[] rowData = outputData.getBussinessParams().getRowParams();
        int len = rowData.length;
        for (int i = 0; i < len; ++i) {
            String boardName;
            int id;
            Param param = rowData[i].getParam("eastslotid");
            if (param != null && !"".equals(param.getValue())) {
                id = Integer.parseInt(param.getValue());
                boardName = this.getBoardName(id);
                String eastMap = rowData[i].getParam("eastslotid").getValue() + "-" + boardName + "-" + rowData[i].getParam("eastportid").getValue();
                rowData[i].addParam("eastmap", eastMap);
            }
            if ((param = rowData[i].getParam("westslotid")) == null || "".equals(param.getValue())) continue;
            id = Integer.parseInt(param.getValue());
            boardName = this.getBoardName(id);
            String westMap = rowData[i].getParam("westslotid").getValue() + "-" + boardName + "-" + rowData[i].getParam("westportid").getValue();
            rowData[i].addParam("westmap", westMap);
        }
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(new Integer(38662));
        list.add(new Integer(41674));
        return list;
    }

    private String getBoardName(int soltid) {
        TEBoard board = TEConfigurationDataMgr.getInstance().getBoard(this.neid, soltid);
        if (board == null) {
            return "";
        }
        String boardName = TEConfigurationDataMgr.getInstance().getBoardTypeName(this.neid, board.getBoardType());
        return boardName;
    }
}

