/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.sdh.regconfig;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEQueryLogicPort;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Vector;
import org.slf4j.Logger;

public class TEAvailabeBoardInfoQueryBean
extends TENEExplorerBean {
    private int neid;
    private Datainterface output;
    private Logger log = TELogFactory.getNormalLogger();

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = 0 + neid;
        this.output = new Datainterface();
        TENE neObj = TENEListMgr.getInstance().getNE(neid);
        try {
            if (null != neObj) {
                this.getAvaliableBoard();
            } else {
                this.output.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090596385));
            }
        }
        catch (Exception e) {
            this.log.error("Get Avaliable IPA Board Fail!!!!\n", (Throwable)e);
            this.output.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090646019));
        }
        return this.output;
    }

    private void getAvaliableBoard() {
        this.output.setBussinessParams(new BussinessParams());
        RowParams rowparams_rtn99 = null;
        TEBoard board = null;
        int bdType = 0;
        int slotID = 0;
        int port = 0;
        String bdName = "";
        Vector boardList_rtn99 = TENEListMgr.getInstance().getNE(this.neid).getClonedBoardList();
        int size = boardList_rtn99.size();
        for (int j = 0; j < size; ++j) {
            ArrayList portList;
            board = (TEBoard)boardList_rtn99.get(j);
            bdType = board.getBoardType();
            slotID = board.getSlotID();
            bdName = TEConfigurationDataMgr.getInstance().getBoardTypeName(this.neid, bdType);
            boolean isIFBD = TESpecialAttrMgr.getInstance().isCPSupportByType(bdType, "REG_CONFIG", "SDH_ATTR_SUPPORT_REGCONF_IFBD");
            if (bdType == 1176 || bdType == 1177 || isIFBD) continue;
            boolean isNotSPBD = TESpecialAttrMgr.getInstance().isCPNotSupportByType(bdType, "REG_CONFIG", "SDH_ATTR_SUPPORT_REGCONF_NOTSUPPORTBD");
            if (bdType == 1548 || bdType == 2057 || bdType == 2423 || isNotSPBD || !TEConfigurationDataMgr.getInstance().isSDHLineBoard(this.neid, slotID) || null == (portList = TEQueryLogicPort.getLogicPortList((int)this.neid, (int)slotID, (int)bdType))) continue;
            Collections.sort(portList);
            int portLen = portList.size();
            for (int portIndex = 0; portIndex < portLen; ++portIndex) {
                port = (Integer)portList.get(portIndex);
                rowparams_rtn99 = new RowParams();
                rowparams_rtn99.addParam("neid", String.valueOf(this.neid));
                rowparams_rtn99.addParam("slotid", String.valueOf(slotID));
                rowparams_rtn99.addParam("portid", String.valueOf(port));
                String bdmap = slotID + "-" + bdName + "-" + port;
                rowparams_rtn99.addParam("boardmap", bdmap);
                this.output.getBussinessParams().addRowParams(rowparams_rtn99);
            }
        }
        this.output.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
    }

    public boolean isNeedOperationlog() {
        return false;
    }
}

