/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.sdh.orderwire;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TENEMgrInterface;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEQueryLogicPort;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import org.slf4j.Logger;

public class TEAvailabePortQueryBean
implements TENEMgrInterface {
    private int neid;
    private Datainterface output;
    private Logger log = TELogFactory.getNormalLogger();

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.output = new Datainterface();
        TENE neObj = TENEListMgr.getInstance().getNE(neid);
        try {
            if (null != neObj) {
                this.getAvaliableBoard();
            } else {
                this.output.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090596385));
            }
        }
        catch (Exception e) {
            this.log.error("Get Avaliable IPA Board Fail!\n", (Throwable)e);
            this.output.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090646019));
        }
        return this.output;
    }

    private void getAvaliableBoard() {
        this.output.setBussinessParams(new BussinessParams());
        RowParams rowparams = null;
        TEBoard board = null;
        int bdType = 0;
        int slotID = 0;
        int port = 0;
        String bdName = "";
        TEConfigurationDataMgr cfgDataMgr = TEConfigurationDataMgr.getInstance();
        Vector boardList = TENEListMgr.getInstance().getNE(this.neid).getClonedBoardList();
        Collections.sort(boardList, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                TEBoard board1 = (TEBoard)arg0;
                TEBoard board2 = (TEBoard)arg1;
                if (board1.getSlotID() >= board2.getSlotID()) {
                    return 1;
                }
                return 0;
            }
        });
        int size = boardList.size();
        for (int j = 0; j < size; ++j) {
            ArrayList portList;
            board = (TEBoard)boardList.get(j);
            bdType = board.getBoardType();
            slotID = board.getSlotID();
            bdName = cfgDataMgr.getBoardTypeName(this.neid, bdType);
            ArrayList<String> portList0 = new ArrayList<String>();
            if (cfgDataMgr.isIFboard(bdType) && this.filterNotSupport(bdType)) {
                port = 1;
                rowparams = new RowParams();
                String availableport = slotID + "-" + bdName + "-" + port;
                rowparams.addParam("availableport", availableport);
                this.output.getBussinessParams().addRowParams(rowparams);
                portList0.add(availableport);
                continue;
            }
            if (!(bdType != 2077 && bdType != 2078 && bdType != 2090 && bdType != 2091 && bdType != 2092 && bdType != 2089 && bdType != 2263 && bdType != 2546 || slotID != 7 && slotID != 1 && slotID != 15)) {
                port = 1;
                rowparams = new RowParams();
                String availableport = slotID + "-" + bdName + "-" + port;
                rowparams.addParam("availableport", availableport);
                this.output.getBussinessParams().addRowParams(rowparams);
                portList0.add(availableport);
                continue;
            }
            boolean isNotSupport = TESpecialAttrMgr.getInstance().isCPNotSupportByType(bdType, "TE_FUNC_WEBLCT_ORDERWIRE", "SDH_ATTR_NOTSUPPORT_ORDERWIRE_F1_LINEBD");
            if (!cfgDataMgr.isSDHLineBoard(this.neid, slotID) || bdType == 2102 || bdType == 2423 || bdType == 2469 || isNotSupport || null == (portList = TEQueryLogicPort.getLogicPortList((int)this.neid, (int)slotID, (int)bdType))) continue;
            Collections.sort(portList);
            int portLen = portList.size();
            for (int portIndex = 0; portIndex < portLen; ++portIndex) {
                boolean continueFlag = false;
                port = (Integer)portList.get(portIndex);
                String availableport = slotID + "-" + bdName + "-" + port;
                for (int index = portList0.size() - 1; index >= 0; --index) {
                    if (!availableport.equalsIgnoreCase((String)portList0.get(index))) continue;
                    portList0.remove(index);
                    continueFlag = true;
                    break;
                }
                if (continueFlag) continue;
                rowparams = new RowParams();
                rowparams.addParam("availableport", availableport);
                this.output.getBussinessParams().addRowParams(rowparams);
            }
        }
        this.output.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
    }

    private boolean filterNotSupport(int boardType) {
        boolean flag = false;
        boolean isNotSpflag = TESpecialAttrMgr.getInstance().isCPNotSupportByType(boardType, "TE_FUNC_WEBLCT_ORDERWIRE", "SDH_ATTR_NOTSUPPORT_ORDERWIRE_F1_HARDBD");
        if (boardType != 1032 && boardType != 1033 && boardType != 1175 && !isNotSpflag) {
            flag = true;
        }
        return flag;
    }

    public boolean isNeedOperationlog() {
        return false;
    }
}

