/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.sdh.ohpbytemgr;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.log.TELogInfo;
import com.huawei.nglct.cbb.log.TELogMgr;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.gencfg.TEGenCfgDataConvertor;
import com.huawei.nglct.gencfg.TEGenCfgFunAttr;
import com.huawei.nglct.gencfg.TEGenCfgFunCmd;
import com.huawei.nglct.gencfg.TEGenCfgQueryBean;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgAttribute;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgDataMgr;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgModel;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgPortAttribute;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.util.io.IOStreamConvertor;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.util.ArrayList;

public class TEQueryVc4OhpbyteBean
extends TEGenCfgQueryBean {
    private static final String NOTSUPPORTBOARD = "38664";
    private static final String PATHPASS = "39171";
    private TEGenCfgModel genCfgModel = null;
    private static final String ATTR_STJ1_1BYTEMODE = "ATTR_STJ1_1BYTEMODE";
    private static final String ATTR_STJ1_16BYTEMODE = "ATTR_STJ1_16BYTEMODE";
    private static final String ATTR_STJ1_62BYTEMODE = "ATTR_STJ1_62BYTEMODE";
    private static final String ATTR_STJ1_64BYTEMODE = "ATTR_STJ1_64BYTEMODE";
    private static final String ATTR_SRJ1_1BYTEMODE = "ATTR_SRJ1_1BYTEMODE";
    private static final String ATTR_SRJ1_16BYTEMODE = "ATTR_SRJ1_16BYTEMODE";
    private static final String ATTR_SRJ1_62BYTEMODE = "ATTR_SRJ1_62BYTEMODE";
    private static final String ATTR_RJ1_1BYTEMODE = "ATTR_RJ1_1BYTEMODE";
    private static final String ATTR_SRJ1_64BYTEMODE = "ATTR_SRJ1_64BYTEMODE";
    private static final String ATTR_RJ1_16BYTEMODE = "ATTR_RJ1_16BYTEMODE";
    private static final String ATTR_STJ1_FORBIDMODE = "ATTR_STJ1_FORBIDMODE";
    private static final String ATTR_SRJ1_DISABLE_MODE = "ATTR_SRJ1_DISABLE_MODE";
    private static final String ATTR_SRJ0_FORBIDMODE = "ATTR_SRJ0_FORBIDMODE";
    private static final String SDHVC4_ATTR_STJ1BYTEMODE = "SDHVC4_ATTR_STJ1BYTEMODE";
    private static final String SDHVC4_ATTR_STJ1 = "SDHVC4_ATTR_STJ1";
    private static final String SDHVC4_ATTR_SRJ1BYTEMODE = "SDHVC4_ATTR_SRJ1BYTEMODE";
    private static final String SDHVC4_ATTR_SRJ1 = "SDHVC4_ATTR_SRJ1";
    private static final String ETHVC4_ATTR_SRJ1BYTEMODE = "ETHVC4_ATTR_SRJ1BYTEMODE";
    private static final String ETHVC4_ATTR_SRJ1 = "ETHVC4_ATTR_SRJ1";
    private static final String W32PORT_ATTR_RJ1BYTEMODE = "SDHVC4_ATTR_RJ1BYTEMODE";
    private static final String W32PORT_ATTR_RJ1 = "SDHVC4_ATTR_RJ1";
    private static final String SUPPORT = "1";
    private static final String NOTSUPPORT = "0";
    private static final String J0MODESINGLE = "3";
    private static final String J0MODE16 = "1";
    private static final String J0MODE64 = "2";
    private static final String INVAILABLEVALUE = "-1";

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        TEBoard boardObj;
        TENE neObj = TENEListMgr.getInstance().getNE(neid);
        String slotid = inputData.getBussinessParams().getRowParams(0).getParam("slotid").getValue();
        if (null != neObj && null != (boardObj = neObj.getBoard(Integer.parseInt(slotid)))) {
            this.genCfgModel = TEGenCfgDataMgr.getGenCfgMode((int)boardObj.getBoardType());
        }
        return super.performBussinessProcess(neid, subFunc, inputData, memeryData, user, ipAddress);
    }

    public void handleMessage(int neid, SubFunc subfunc, ArrayList operationList, ArrayList filterErrorCodeList) {
        this.outputData = TEGenCfgDataConvertor.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList, (ArrayList)filterErrorCodeList);
        if (null == this.outputData || null == this.outputData.getBussinessParams()) {
            return;
        }
        if (this.outputData.getBussinessParams().getRowParamsCount() == 0) {
            return;
        }
        RowParams rowparams = null;
        String portid = null;
        int len = this.outputData.getBussinessParams().getRowParamsCount();
        for (int i = 0; i < len; ++i) {
            rowparams = this.outputData.getBussinessParams().getRowParams(i);
            if (rowparams.getParamCount() == 0) continue;
            if (null != rowparams.getParam(SDHVC4_ATTR_STJ1BYTEMODE)) {
                this.processByte(rowparams, SDHVC4_ATTR_STJ1BYTEMODE, SDHVC4_ATTR_STJ1);
            }
            if (null != rowparams.getParam("ETHVC4_ATTR_STJ1BYTEMODE")) {
                this.processByte(rowparams, "ETHVC4_ATTR_STJ1BYTEMODE", "ETHVC4_ATTR_STJ1");
            }
            if (null != rowparams.getParam(SDHVC4_ATTR_SRJ1BYTEMODE)) {
                this.processByte(rowparams, SDHVC4_ATTR_SRJ1BYTEMODE, SDHVC4_ATTR_SRJ1);
            }
            if (null != rowparams.getParam(ETHVC4_ATTR_SRJ1BYTEMODE)) {
                this.processByte(rowparams, ETHVC4_ATTR_SRJ1BYTEMODE, ETHVC4_ATTR_SRJ1);
            }
            if (null != rowparams.getParam(W32PORT_ATTR_RJ1BYTEMODE)) {
                this.processByte(rowparams, W32PORT_ATTR_RJ1BYTEMODE, W32PORT_ATTR_RJ1);
            }
            if (null != rowparams.getParam("ETHVC4_ATTR_RJ1BYTEMODE")) {
                this.processByte(rowparams, "ETHVC4_ATTR_RJ1BYTEMODE", "ETHVC4_ATTR_RJ1");
            }
            if (rowparams.getParam("port") != null) {
                portid = rowparams.getParam("port").getValue();
            } else {
                portid = "1";
                Param portNameParam = new Param("portname", "1(SDH-1)");
                rowparams.addParam(portNameParam);
            }
            if (this.isSupportByte(Integer.parseInt(portid), ATTR_STJ1_1BYTEMODE)) {
                rowparams.addParam(ATTR_STJ1_1BYTEMODE, "1");
            } else {
                rowparams.addParam(ATTR_STJ1_1BYTEMODE, NOTSUPPORT);
            }
            if (this.isSupportByte(Integer.parseInt(portid), ATTR_STJ1_16BYTEMODE)) {
                rowparams.addParam(ATTR_STJ1_16BYTEMODE, "1");
            } else {
                rowparams.addParam(ATTR_STJ1_16BYTEMODE, NOTSUPPORT);
            }
            if (this.isSupportByte(Integer.parseInt(portid), ATTR_STJ1_62BYTEMODE)) {
                rowparams.addParam(ATTR_STJ1_62BYTEMODE, "1");
            } else {
                rowparams.addParam(ATTR_STJ1_62BYTEMODE, NOTSUPPORT);
            }
            if (this.isSupportByte(Integer.parseInt(portid), ATTR_STJ1_64BYTEMODE)) {
                rowparams.addParam(ATTR_STJ1_64BYTEMODE, "1");
            } else {
                rowparams.addParam(ATTR_STJ1_64BYTEMODE, NOTSUPPORT);
            }
            if (this.isSupportByte(Integer.parseInt(portid), ATTR_SRJ1_1BYTEMODE)) {
                rowparams.addParam(ATTR_SRJ1_1BYTEMODE, "1");
            } else {
                rowparams.addParam(ATTR_SRJ1_1BYTEMODE, NOTSUPPORT);
            }
            if (this.isSupportByte(Integer.parseInt(portid), ATTR_SRJ1_16BYTEMODE)) {
                rowparams.addParam(ATTR_SRJ1_16BYTEMODE, "1");
            } else {
                rowparams.addParam(ATTR_SRJ1_16BYTEMODE, NOTSUPPORT);
            }
            if (this.isSupportByte(Integer.parseInt(portid), ATTR_SRJ1_62BYTEMODE)) {
                rowparams.addParam(ATTR_SRJ1_62BYTEMODE, "1");
            } else {
                rowparams.addParam(ATTR_SRJ1_62BYTEMODE, NOTSUPPORT);
            }
            if (this.isSupportByte(Integer.parseInt(portid), ATTR_SRJ1_64BYTEMODE)) {
                rowparams.addParam(ATTR_SRJ1_64BYTEMODE, "1");
            } else {
                rowparams.addParam(ATTR_SRJ1_64BYTEMODE, NOTSUPPORT);
            }
            if (this.isSupportByte(Integer.parseInt(portid), ATTR_RJ1_1BYTEMODE)) {
                rowparams.addParam(ATTR_RJ1_1BYTEMODE, "1");
            } else {
                rowparams.addParam(ATTR_RJ1_1BYTEMODE, NOTSUPPORT);
            }
            if (this.isSupportByte(Integer.parseInt(portid), ATTR_RJ1_16BYTEMODE)) {
                rowparams.addParam(ATTR_RJ1_16BYTEMODE, "1");
            } else {
                rowparams.addParam(ATTR_RJ1_16BYTEMODE, NOTSUPPORT);
            }
            if (this.isSupportByte(Integer.parseInt(portid), ATTR_SRJ1_DISABLE_MODE)) {
                rowparams.addParam(ATTR_SRJ1_DISABLE_MODE, "1");
            } else {
                rowparams.addParam(ATTR_SRJ1_DISABLE_MODE, NOTSUPPORT);
            }
            if (this.isSupportByte(Integer.parseInt(portid), ATTR_STJ1_FORBIDMODE)) {
                rowparams.addParam(ATTR_STJ1_FORBIDMODE, "1");
            } else {
                rowparams.addParam(ATTR_STJ1_FORBIDMODE, NOTSUPPORT);
            }
            if (this.isSupportByte(Integer.parseInt(portid), ATTR_SRJ0_FORBIDMODE)) {
                rowparams.addParam(ATTR_SRJ0_FORBIDMODE, "1");
                continue;
            }
            rowparams.addParam(ATTR_SRJ0_FORBIDMODE, NOTSUPPORT);
        }
    }

    private void processByte(RowParams rowparams, String key1, String key2) {
        String temp = "";
        String J0byteMode = rowparams.getParam(key1).getValue();
        if (INVAILABLEVALUE.equals(J0byteMode) || J0byteMode.equalsIgnoreCase("/")) {
            return;
        }
        String value = IOStreamConvertor.replaceSpecialPrototype((String)rowparams.getParam(key2).getValue());
        if (J0byteMode.equals("1")) {
            int offset = value.length() < 32 ? value.length() : 32;
            temp = value.substring(2, offset);
        } else if (J0byteMode.equals(J0MODE64)) {
            int offset = value.length() < 124 ? value.length() : 124;
            temp = value.substring(0, offset);
        } else if (J0byteMode.equals(J0MODESINGLE)) {
            temp = rowparams.getParam(key2).getValue().substring(0, 2);
        } else {
            int offset = value.length() < 32 ? value.length() : 32;
            temp = value.substring(0, offset);
        }
        rowparams.getParam(key2).setValue(temp);
    }

    private boolean isSupportByte(int portid, String byteMode) {
        TEGenCfgAttribute genCfgAttri = this.genCfgModel.getAttrFromId(byteMode);
        if (null == genCfgAttri) {
            return false;
        }
        ArrayList portList = genCfgAttri.getPortList();
        TEGenCfgPortAttribute port = null;
        int len = portList.size();
        for (int i = 0; i < len; ++i) {
            port = (TEGenCfgPortAttribute)portList.get(i);
            if (portid != port.getPort()) continue;
            return true;
        }
        return false;
    }

    public boolean isNeedExpandOperObj(String attrId) {
        return attrId.equals(SDHVC4_ATTR_STJ1) || attrId.equals(SDHVC4_ATTR_STJ1BYTEMODE) || attrId.equals(SDHVC4_ATTR_SRJ1) || attrId.equals(SDHVC4_ATTR_SRJ1BYTEMODE) || attrId.equals(W32PORT_ATTR_RJ1) || attrId.equals(W32PORT_ATTR_RJ1BYTEMODE) || attrId.equals("SDHVC4_ATTR_STC2") || attrId.equals("SDHVC4_ATTR_SRC2") || attrId.equals("SDHVC4_ATTR_RC2") || attrId.equals("ETHVC4_ATTR_STC2") || attrId.equals("ETHVC4_ATTR_SRC2") || attrId.equals("ETHVC4_ATTR_RC2") || attrId.equals("SDHVC4_ATTR_VC4OHOVER");
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> codeList = new ArrayList<Integer>();
        codeList.add(38662);
        codeList.add(Integer.valueOf(NOTSUPPORTBOARD));
        codeList.add(38759);
        codeList.add(38737);
        codeList.add(40004);
        codeList.add(41730);
        codeList.add(38779);
        codeList.add(38671);
        codeList.add(38684);
        codeList.add(38671);
        codeList.add(38684);
        codeList.add(38777);
        codeList.add(Integer.valueOf(PATHPASS));
        return codeList;
    }

    public ArrayList getQueryOperationList(TEGenCfgFunCmd funCmd, Datainterface inputData) {
        ArrayList operationList = new ArrayList();
        for (int rowIndex = 0; rowIndex < inputData.getBussinessParams().getRowParamsCount(); ++rowIndex) {
            RowParams rowparams = inputData.getBussinessParams().getRowParams(rowIndex);
            ArrayList attrList = this.getQueryAttrList(rowparams);
            String attrId = "";
            String groupAttr = "";
            for (int i = attrList.size() - 1; i >= 0; --i) {
                attrId = (String)attrList.get(i);
                TEGenCfgFunAttr funAttr = funCmd.getGenCfgFunAttr(attrId, "query");
                if (null == funAttr) continue;
                this.getQueryAttrOperationList(funAttr, operationList, attrId, inputData);
                int len = funAttr.getGroupAttrList().size();
                for (int index = 0; index < len; ++index) {
                    groupAttr = (String)funAttr.getGroupAttrList().get(index);
                    if (groupAttr.equalsIgnoreCase(attrId) || !attrList.remove(groupAttr)) continue;
                    if (groupAttr.equalsIgnoreCase(W32PORT_ATTR_RJ1) || groupAttr.equalsIgnoreCase(SDHVC4_ATTR_SRJ1) || groupAttr.equalsIgnoreCase(SDHVC4_ATTR_STJ1) || groupAttr.equalsIgnoreCase(SDHVC4_ATTR_STJ1BYTEMODE) || groupAttr.equalsIgnoreCase(SDHVC4_ATTR_SRJ1BYTEMODE) || groupAttr.equalsIgnoreCase(W32PORT_ATTR_RJ1BYTEMODE)) {
                        --i;
                        continue;
                    }
                    this.queryAttrListBuff.append(",").append(this.res.getString(groupAttr));
                    --i;
                }
            }
        }
        return operationList;
    }

    public void getQueryAttrOperationList(TEGenCfgFunAttr funAttr, ArrayList operationList, String attrId, Datainterface inputData) {
        if (null == funAttr) {
            return;
        }
        String operationName = funAttr.getPtcode();
        ArrayList<String> operationNameList = new ArrayList<String>();
        operationNameList.add(operationName);
        String additioncmd = funAttr.getAdditionCmd();
        if (null != additioncmd && !"".equals(additioncmd.trim())) {
            operationNameList.add(additioncmd);
        }
        Datainterface convertData = inputData;
        if (this.isNeedExpandOperObj(attrId) && null == (convertData = this.performExpandOperObj(attrId, funAttr, inputData))) {
            return;
        }
        ArrayList subOperationList = TEGenCfgDataConvertor.convertToOperation((TEGenCfgFunAttr)funAttr, (Datainterface)convertData, (int)this.neid, operationNameList);
        if (null != subOperationList && 0 != subOperationList.size()) {
            if (attrId.equalsIgnoreCase("SDHVC4_ATTR_STC2") || attrId.equalsIgnoreCase("SDHVC4_ATTR_SRC2") || attrId.equalsIgnoreCase("SDHVC4_ATTR_RC2") || attrId.equalsIgnoreCase("SDHVC4_ATTR_VC4OHOVER") || attrId.equalsIgnoreCase("ETHVC4_ATTR_STC2") || attrId.equalsIgnoreCase("ETHVC4_ATTR_SRC2") || attrId.equalsIgnoreCase("ETHVC4_ATTR_RC2")) {
                this.queryAttrListBuff.append(",").append(this.res.getString(attrId));
            }
            operationList.addAll(subOperationList);
        }
    }

    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        try {
            int i;
            int errorCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
            ArrayList<TELogInfo> loginfoList = new ArrayList<TELogInfo>();
            TELogInfo loginfo = null;
            int userID = 0;
            if (TESysManagerConstants.SYS_SINGLE_STATUS != TESysManagerBean.getInstance().getSysStauts()) {
                try {
                    userID = Integer.parseInt(user);
                }
                catch (Exception e) {
                    userID = 0;
                }
            }
            TENE neObj = TENEListMgr.getInstance().getNE(neid);
            String operObj = "";
            operObj = null == neObj ? String.valueOf(neid) : neObj.getNEName();
            if (errorCode == 0) {
                loginfo = new TELogInfo();
                loginfo.setResult(0);
                loginfo.setErrCode(0);
                loginfo.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode));
                loginfoList.add(loginfo);
            } else if (errorCode == 2 || errorCode == 1) {
                int len = outputData.getBussinessParams().getRowParamsCount();
                for (i = 0; i < len; ++i) {
                    int j = 0;
                    RowErrors[] rowErrors = outputData.getBussinessParams().getRowParams(i).getRowErrors();
                    int size = rowErrors.length;
                    if (j >= size) continue;
                    loginfo = new TELogInfo();
                    loginfo.setResult(errorCode);
                    loginfo.setErrCode(Integer.parseInt(rowErrors[j].getErrorMessage().getErrorcode()));
                    loginfo.setErrInfo(rowErrors[j].getErrorMessage().getErrorinfo());
                    loginfoList.add(loginfo);
                }
            } else {
                loginfo = new TELogInfo();
                loginfo.setResult(2);
                loginfo.setErrCode(errorCode);
                loginfo.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode));
                loginfoList.add(loginfo);
            }
            int size = loginfoList.size();
            for (i = 0; i < size; ++i) {
                boolean isNull;
                loginfo = (TELogInfo)loginfoList.get(i);
                loginfo.setCmdID(subfunc.getCode());
                loginfo.setLocation(ipAddress);
                loginfo.setUserID(userID);
                loginfo.setUserName(TESysManagerBean.getInstance().getSysUser());
                loginfo.setOperateName(subfunc.getSubFuncDes(neid));
                loginfo.setOperateObject(operObj);
                String detailDes = operObj;
                String detailRes = "";
                if (null != inputData.getBussinessParams().getRowParams(0).getParam("slotid")) {
                    int slotid = Integer.parseInt(inputData.getBussinessParams().getRowParams(0).getParam("slotid").getValue());
                    int boardtype = TEConfigurationDataMgr.getInstance().getBoardType(neid, slotid);
                    detailDes = detailDes + "-" + slotid + "-" + TEConfigurationDataMgr.getInstance().getBoardTypeName(neid, boardtype);
                }
                if (!(isNull = this.queryAttrListBuff.toString().equals(""))) {
                    String queryAttrList = this.queryAttrListBuff.toString();
                    if (0 == queryAttrList.indexOf(",")) {
                        detailRes = queryAttrList.substring(1);
                    }
                } else {
                    detailRes = this.res.getString("SDHVC4_ATTR_J1BYTE_LOG") + "," + this.res.getString("SDHVC4_ATTR_J1MODE_LOG");
                }
                detailDes = detailDes + ": " + detailRes;
                loginfo.setOperateDesc(detailDes);
                TELogMgr.writeLog((TELogInfo)((TELogInfo)loginfoList.get(i)));
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Writer Log Fault:\n", (Throwable)e);
            return;
        }
    }
}

