/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.sdh.ohpbytemgr;

import com.huawei.nglct.cbb.log.TELogInfo;
import com.huawei.nglct.cbb.log.TELogMgr;
import com.huawei.nglct.common.TEParseXMLFile;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.gencfg.TEGenCfgDataConvertor;
import com.huawei.nglct.gencfg.TEGenCfgQueryBean;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgAttribute;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgDataMgr;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgModel;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgPortAttribute;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.xml.TEResourceManager;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.io.File;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TEQueryRegOhpbyteBean
extends TEGenCfgQueryBean {
    private static final String CFGGETISNULL = "38662";
    private static final String NOTSUPPORTBOARD = "38664";
    private static final String NOTSUPPORTCOMMAND = "38737";
    private static final String PORTISNOTIN = "40004";
    private static final String ERROR_NOTSUPPORTED_WHEN_J0_DISABLED = "41729";
    private int slotid;
    private static final String LANGUAGE = TESysManagerBean.getInstance().getlanguage();
    private static final String FILEPATH = "nemgr" + File.separator + "sdh" + File.separator + "res" + File.separator + "ohpbytemgr" + File.separator + "overheadres_" + LANGUAGE + ".xml";
    private TEGenCfgModel genCfgModel = null;
    private static final String ATTR_STJ0_1BYTEMODE = "ATTR_STJ0_1BYTEMODE";
    private static final String ATTR_STJ0_16BYTEMODE = "ATTR_STJ0_16BYTEMODE";
    private static final String ATTR_SRJ0_1BYTEMODE = "ATTR_SRJ0_1BYTEMODE";
    private static final String ATTR_SRJ0_16BYTEMODE = "ATTR_SRJ0_16BYTEMODE";
    private static final String ATTR_RJ0_1BYTEMODE = "ATTR_RJ0_1BYTEMODE";
    private static final String ATTR_RJ0_16BYTEMODE = "ATTR_RJ0_16BYTEMODE";
    private static final String W32PORT_ATTR_STJ0BYTEMODE = "W32PORT_ATTR_STJ0BYTEMODE";
    private static final String W32PORT_ATTR_STJ0 = "W32PORT_ATTR_STJ0";
    private static final String W32PORT_ATTR_SRJ0BYTEMODE = "W32PORT_ATTR_SRJ0BYTEMODE";
    private static final String W32PORT_ATTR_SRJ0 = "W32PORT_ATTR_SRJ0";
    private static final String W32PORT_ATTR_RJ0BYTEMODE = "W32PORT_ATTR_RJ0BYTEMODE";
    private static final String W32PORT_ATTR_RJ0 = "W32PORT_ATTR_RJ0";
    private static final String SUPPORT = "1";
    private static final String NOTSUPPORT = "0";
    private static final String J0MODESINGLE = "3";
    private static final String J0MODE16 = "1";
    private static final String J0MODE64 = "2";
    private static final String INVAILABLEVALUE = "-1";

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        TEBoard boardObj;
        TENE neObj = TENEListMgr.getInstance().getNE(neid);
        String slotid = inputData.getBussinessParams().getRowParams(0).getParam("slotid").getValue();
        this.slotid = Integer.parseInt(slotid);
        if (null != neObj && null != (boardObj = neObj.getBoard(Integer.parseInt(slotid)))) {
            this.genCfgModel = TEGenCfgDataMgr.getGenCfgMode((int)boardObj.getBoardType());
        }
        return super.performBussinessProcess(neid, subFunc, inputData, memeryData, user, ipAddress);
    }

    public void handleMessage(int neid, SubFunc subfunc, ArrayList operationList, ArrayList filterErrorCodeList) {
        this.outputData = TEGenCfgDataConvertor.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList, (ArrayList)filterErrorCodeList);
        if (null == this.outputData || null == this.outputData.getBussinessParams()) {
            return;
        }
        if (0 == this.outputData.getBussinessParams().getRowParamsCount()) {
            return;
        }
        RowParams rowparams = null;
        String portid = null;
        int len = this.outputData.getBussinessParams().getRowParamsCount();
        for (int i = 0; i < len; ++i) {
            rowparams = this.outputData.getBussinessParams().getRowParams(i);
            if (0 == rowparams.getParamCount()) continue;
            if (null != rowparams.getParam(W32PORT_ATTR_STJ0BYTEMODE)) {
                this.processByte(rowparams, W32PORT_ATTR_STJ0BYTEMODE, W32PORT_ATTR_STJ0);
            }
            if (null != rowparams.getParam(W32PORT_ATTR_SRJ0BYTEMODE)) {
                this.processByte(rowparams, W32PORT_ATTR_SRJ0BYTEMODE, W32PORT_ATTR_SRJ0);
            }
            if (null != rowparams.getParam(W32PORT_ATTR_RJ0BYTEMODE)) {
                this.processByte(rowparams, W32PORT_ATTR_RJ0BYTEMODE, W32PORT_ATTR_RJ0);
            }
            if (this.isSupportByte(Integer.parseInt(portid = rowparams.getParam("port").getValue()), ATTR_STJ0_1BYTEMODE)) {
                rowparams.addParam(ATTR_STJ0_1BYTEMODE, "1");
            } else {
                rowparams.addParam(ATTR_STJ0_1BYTEMODE, NOTSUPPORT);
            }
            if (this.isSupportByte(Integer.parseInt(portid), ATTR_STJ0_16BYTEMODE)) {
                rowparams.addParam(ATTR_STJ0_16BYTEMODE, "1");
            } else {
                rowparams.addParam(ATTR_STJ0_16BYTEMODE, NOTSUPPORT);
            }
            if (this.isSupportByte(Integer.parseInt(portid), ATTR_SRJ0_1BYTEMODE)) {
                rowparams.addParam(ATTR_SRJ0_1BYTEMODE, "1");
            } else {
                rowparams.addParam(ATTR_SRJ0_1BYTEMODE, NOTSUPPORT);
            }
            if (this.isSupportByte(Integer.parseInt(portid), ATTR_SRJ0_16BYTEMODE)) {
                rowparams.addParam(ATTR_SRJ0_16BYTEMODE, "1");
            } else {
                rowparams.addParam(ATTR_SRJ0_16BYTEMODE, NOTSUPPORT);
            }
            if (this.isSupportByte(Integer.parseInt(portid), ATTR_RJ0_1BYTEMODE)) {
                rowparams.addParam(ATTR_RJ0_1BYTEMODE, "1");
            } else {
                rowparams.addParam(ATTR_RJ0_1BYTEMODE, NOTSUPPORT);
            }
            if (this.isSupportByte(Integer.parseInt(portid), ATTR_RJ0_16BYTEMODE)) {
                rowparams.addParam(ATTR_RJ0_16BYTEMODE, "1");
                continue;
            }
            rowparams.addParam(ATTR_RJ0_16BYTEMODE, NOTSUPPORT);
        }
    }

    private void processByte(RowParams rowparams, String key1, String key2) {
        String temp = "";
        String J0byteMode = rowparams.getParam(key1).getValue();
        if (INVAILABLEVALUE.equals(J0byteMode) || J0byteMode.equalsIgnoreCase("/")) {
            return;
        }
        temp = J0byteMode.equals("1") ? rowparams.getParam(key2).getValue().substring(2, 32) : (J0byteMode.equals(J0MODE64) ? rowparams.getParam(key2).getValue().substring(0, 124) : (J0byteMode.equals(J0MODESINGLE) ? rowparams.getParam(key2).getValue().substring(0, 2) : rowparams.getParam(key2).getValue().substring(0, 32)));
        rowparams.getParam(key2).setValue(temp);
    }

    private boolean isSupportByte(int portid, String byteMode) {
        TEGenCfgAttribute genCfgAttri = this.genCfgModel.getAttrFromId(byteMode);
        if (null == genCfgAttri) {
            return false;
        }
        ArrayList portList = genCfgAttri.getPortList();
        TEGenCfgPortAttribute port = null;
        int len = portList.size();
        for (int i = 0; i < len; ++i) {
            port = (TEGenCfgPortAttribute)portList.get(i);
            if (portid != port.getPort()) continue;
            return true;
        }
        return false;
    }

    public boolean isNeedExpandOperObj(String attrId) {
        return attrId.equals(W32PORT_ATTR_STJ0) || attrId.equals(W32PORT_ATTR_STJ0BYTEMODE) || attrId.equals(W32PORT_ATTR_SRJ0) || attrId.equals(W32PORT_ATTR_SRJ0BYTEMODE) || attrId.equals(W32PORT_ATTR_RJ0) || attrId.equals(W32PORT_ATTR_RJ0BYTEMODE) || attrId.equals("SDHVC4_ATTR_STJ1") || attrId.equals("SDHVC4_ATTR_STJ1BYTEMODE") || attrId.equals("SDHVC4_ATTR_SRJ1") || attrId.equals("SDHVC4_ATTR_SRJ1BYTEMODE") || attrId.equals("SDHVC4_ATTR_RJ1") || attrId.equals("SDHVC4_ATTR_RJ1BYTEMODE");
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> codeList = new ArrayList<Integer>();
        codeList.add(new Integer(CFGGETISNULL));
        codeList.add(new Integer(NOTSUPPORTBOARD));
        codeList.add(new Integer(NOTSUPPORTCOMMAND));
        codeList.add(new Integer(PORTISNOTIN));
        codeList.add(new Integer(ERROR_NOTSUPPORTED_WHEN_J0_DISABLED));
        codeList.add(new Integer(38671));
        return codeList;
    }

    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        Document doc = TEParseXMLFile.parseFile((String)(TEResourceManager.getPath() + FILEPATH));
        Element element = null;
        if (null == this.operationList || this.operationList.isEmpty()) {
            return;
        }
        Operation operation = null;
        Output output = null;
        TELogInfo loginfo = new TELogInfo();
        String operationName = subfunc.getDes();
        element = (Element)doc.getElementsByTagName(operationName).item(0);
        loginfo.setOperateName(element.getAttribute("value"));
        loginfo.setCmdID(subfunc.getCode());
        loginfo.setLocation("");
        loginfo.setUserID(0);
        loginfo.setUserName(TESysManagerBean.getInstance().getSysUser());
        TENE neObj = TENEListMgr.getInstance().getNE(neid);
        String operObj = "";
        operObj = null == neObj ? String.valueOf(neid) : neObj.getNEName();
        loginfo.setOperateObject(operObj);
        int errorCode = 0;
        StringBuffer des = new StringBuffer();
        int boardType = TEConfigurationDataMgr.getInstance().getBoardType(neid, this.slotid);
        String boardName = TEConfigurationDataMgr.getInstance().getBoardTypeName(neid, boardType);
        ArrayList filterErrorCodeList = this.getFilterErrorCodeList();
        String port = "";
        int userID = 0;
        if (TESysManagerConstants.SYS_SINGLE_STATUS != TESysManagerBean.getInstance().getSysStauts()) {
            try {
                userID = Integer.parseInt(user);
            }
            catch (Exception e) {
                userID = 0;
            }
        }
        int len = this.operationList.size();
        for (int i = 0; i < len; ++i) {
            operation = (Operation)this.operationList.get(i);
            int size = operation.getOutputCount();
            for (int j = 0; j < size; ++j) {
                loginfo.setUserID(userID);
                loginfo.setUserName(TESysManagerBean.getInstance().getSysUser());
                loginfo.setLocation(ipAddress);
                int allErrorCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
                output = operation.getOutput(j);
                String code = output.getFault(0).getCode();
                if (!code.equals("")) {
                    errorCode = Integer.parseInt(output.getFault(0).getCode());
                    if (filterErrorCodeList.contains(Integer.valueOf(output.getFault(0).getCode()))) continue;
                }
                loginfo.setResult(allErrorCode);
                loginfo.setErrCode(errorCode);
                loginfo.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode));
                des.append(this.slotid).append("-").append(boardName).append(":");
                port = output.getPart("port").getValue();
                if (null == port) continue;
                if (null != output.getPartValue(W32PORT_ATTR_STJ0)) {
                    element = (Element)doc.getElementsByTagName(W32PORT_ATTR_STJ0).item(0);
                    des.append(element.getAttribute("value"));
                }
                if (null != output.getPartValue(W32PORT_ATTR_SRJ0)) {
                    element = (Element)doc.getElementsByTagName(W32PORT_ATTR_SRJ0).item(0);
                    des.append(",").append(element.getAttribute("value"));
                }
                if (null != output.getPartValue(W32PORT_ATTR_RJ0)) {
                    element = (Element)doc.getElementsByTagName(W32PORT_ATTR_RJ0).item(0);
                    des.append(",").append(element.getAttribute("value"));
                }
                if (null != output.getPartValue(W32PORT_ATTR_STJ0BYTEMODE)) {
                    element = (Element)doc.getElementsByTagName(W32PORT_ATTR_STJ0BYTEMODE).item(0);
                    des.append(",").append(element.getAttribute("value"));
                }
                if (null != output.getPartValue(W32PORT_ATTR_SRJ0BYTEMODE)) {
                    element = (Element)doc.getElementsByTagName(W32PORT_ATTR_SRJ0BYTEMODE).item(0);
                    des.append(",").append(element.getAttribute("value"));
                }
                if (null != output.getPartValue(W32PORT_ATTR_RJ0BYTEMODE)) {
                    element = (Element)doc.getElementsByTagName(W32PORT_ATTR_RJ0BYTEMODE).item(0);
                    des.append(",").append(element.getAttribute("value"));
                }
                loginfo.setOperateDesc(des.toString());
                des.delete(0, des.length());
                TELogMgr.writeLog((TELogInfo)loginfo);
            }
        }
    }
}

