/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.sdh.msprotect.linemsp;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.nemgr.sdh.msprotect.TEDirSwitchState;
import com.huawei.nglct.nemgr.sdh.msprotect.TESwitchStateInfo;
import com.huawei.nglct.nemgr.sdh.msprotect.po.TELineMspBoardMap;
import com.huawei.nglct.nemgr.sdh.msprotect.po.TELineMspPG;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.List;

public class TELineMspQxImpl {
    private static final int ACTIVE_FLAG = 3;

    public static int createLineMspCmd(int neid, TELineMspPG linemsp) {
        int errCode = 0;
        try {
            TELineMspBoardMap lineMspBoardMap;
            Operation cmdSetPUMap;
            ArrayList<Operation> operationList = new ArrayList<Operation>();
            List workBoardMapList = linemsp.getBoardMapList(1);
            Operation cmdAddPG = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_CFG_ADD_LMS_PG");
            cmdAddPG.getInput().getPart("groupID").setValue("" + linemsp.getLineMsgPGKey().getLineMspId());
            cmdAddPG.getInput().getPart("protectionType").setValue("" + linemsp.getProtectType());
            cmdAddPG.getInput().getPart("wordPathNum").setValue("" + workBoardMapList.size());
            cmdAddPG.getInput().getPart("revertiveMode").setValue("" + linemsp.getRecoverMode());
            cmdAddPG.getInput().getPart("switchMode").setValue("" + linemsp.getSwitchMode());
            operationList.add(cmdAddPG);
            int size = workBoardMapList.size();
            for (int index = 0; index < size; ++index) {
                cmdSetPUMap = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_CFG_SET_LMS_PUMAP_NEW");
                cmdSetPUMap.getInput().getPart("groupID").setValue("" + linemsp.getLineMsgPGKey().getLineMspId());
                lineMspBoardMap = (TELineMspBoardMap)workBoardMapList.get(index);
                cmdSetPUMap.getInput().getPart("protectUnit").setValue("" + lineMspBoardMap.getBoardMapType());
                cmdSetPUMap.getInput().getPart("slotid").setValue("" + lineMspBoardMap.getWestSlotID());
                cmdSetPUMap.getInput().getPart("port").setValue("" + lineMspBoardMap.getWestPortID());
                operationList.add(cmdSetPUMap);
            }
            List protectBoardMapList = linemsp.getBoardMapList(0);
            int size2 = protectBoardMapList.size();
            for (int index = 0; index < size2; ++index) {
                cmdSetPUMap = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_CFG_SET_LMS_PUMAP_NEW");
                cmdSetPUMap.getInput().getPart("groupID").setValue("" + linemsp.getLineMsgPGKey().getLineMspId());
                lineMspBoardMap = (TELineMspBoardMap)protectBoardMapList.get(index);
                cmdSetPUMap.getInput().getPart("protectUnit").setValue("" + lineMspBoardMap.getBoardMapType());
                cmdSetPUMap.getInput().getPart("slotid").setValue("" + lineMspBoardMap.getWestSlotID());
                cmdSetPUMap.getInput().getPart("port").setValue("" + lineMspBoardMap.getWestPortID());
                operationList.add(cmdSetPUMap);
            }
            operationList.add(TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_CFG_VERIFY"));
            OperationResult result = TENECommMgr.getInstance().sendCommand(neid, operationList, 20);
            errCode = result.retCode;
            if (0 == errCode) {
                errCode = TELineMspQxImpl.getResult(operationList);
            }
            if (0 != errCode) {
                return errCode;
            }
            TObjectIntHashMap attrMap = new TObjectIntHashMap();
            attrMap.put((Object)"switchIndication", linemsp.getSwitchIndication());
            attrMap.put((Object)"revertiveTime", linemsp.getWrtTime());
            attrMap.put((Object)"sdEnable", linemsp.getSdflag());
            attrMap.put((Object)"switchTag", linemsp.getSdsfSWFlag());
            errCode = TELineMspQxImpl.setLineMspParaCmd(neid, linemsp.getLineMsgPGKey().getLineMspId(), attrMap);
            if (0 != errCode) {
                TELineMspQxImpl.delLineMspCmd(neid, linemsp.getLineMsgPGKey().getLineMspId());
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TELineMspQxImpl.createLineMspCmd() fail!", (Throwable)e);
        }
        return errCode;
    }

    public static int setLineMspParaCmd(int neid, int lineMspID, TObjectIntHashMap attrMap) {
        int errCode = 0;
        if (null == attrMap || attrMap.isEmpty()) {
            return errCode;
        }
        try {
            ArrayList<Operation> operationList = new ArrayList<Operation>();
            if (attrMap.containsKey((Object)"switchIndication")) {
                Operation cmdSetswmode = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_CFG_SET_LMS_K2SWMODE");
                cmdSetswmode.getInput().getPart("groupID").setValue("" + lineMspID);
                cmdSetswmode.getInput().getPart("switchIndication").setValue("" + attrMap.get((Object)"switchIndication"));
                operationList.add(cmdSetswmode);
            }
            if (attrMap.containsKey((Object)"revertiveMode")) {
                Operation cmdRevMode = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_CFG_SET_LMS_RESTOREMODE");
                cmdRevMode.getInput().getPart("groupID").setValue("" + lineMspID);
                cmdRevMode.getInput().getPart("revertiveMode").setValue("" + attrMap.get((Object)"revertiveMode"));
                operationList.add(cmdRevMode);
            }
            if (attrMap.containsKey((Object)"revertiveTime")) {
                Operation cmdSetWRTTime = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_CFG_SET_LMS_WTRTIME");
                cmdSetWRTTime.getInput().getPart("groupID").setValue("" + lineMspID);
                cmdSetWRTTime.getInput().getPart("revertiveTime").setValue("" + attrMap.get((Object)"revertiveTime"));
                operationList.add(cmdSetWRTTime);
            }
            if (attrMap.containsKey((Object)"sdEnable")) {
                Operation cmdSetSDFlag = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_CFG_SET_LMS_SDFLAG");
                cmdSetSDFlag.getInput().getPart("groupID").setValue("" + lineMspID);
                cmdSetSDFlag.getInput().getPart("sdEnable").setValue("" + attrMap.get((Object)"sdEnable"));
                operationList.add(cmdSetSDFlag);
            }
            if (attrMap.containsKey((Object)"protocolType")) {
                Operation cmdsetprotype = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_CFG_SET_LMS_PROTYPE");
                cmdsetprotype.getInput().getPart("groupID").setValue("" + lineMspID);
                cmdsetprotype.getInput().getPart("protocolType").setValue("" + attrMap.get((Object)"protocolType"));
                operationList.add(cmdsetprotype);
            }
            if (attrMap.containsKey((Object)"switchTag")) {
                Operation cmdSetSFSDLevel = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_CFG_SET_LMS_SFSD_LEVEL");
                cmdSetSFSDLevel.getInput().getPart("groupID").setValue("" + lineMspID);
                cmdSetSFSDLevel.getInput().getPart("switchTag").setValue("" + attrMap.get((Object)"switchTag"));
                operationList.add(cmdSetSFSDLevel);
            }
            if (attrMap.containsKey((Object)"switchMode")) {
                Operation cmdSetSWMode = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_CFG_SET_LMS_SWITCHMODE");
                cmdSetSWMode.getInput().getPart("groupID").setValue("" + lineMspID);
                cmdSetSWMode.getInput().getPart("switchMode").setValue("" + attrMap.get((Object)"switchMode"));
                operationList.add(cmdSetSWMode);
            }
            OperationResult result = TENECommMgr.getInstance().sendCommand(neid, operationList, 20);
            errCode = result.retCode;
            if (0 == errCode) {
                errCode = TELineMspQxImpl.getResult(operationList);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TELineMspQxImpl.setLineMspParaCmd() fail!", (Throwable)e);
        }
        return errCode;
    }

    public static int delLineMspCmd(int neid, int pgID) {
        int errCode = 0;
        try {
            ArrayList<Operation> operationList = new ArrayList<Operation>();
            Operation cmdDelLmsPG = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_CFG_DEL_LMS_PG");
            cmdDelLmsPG.getInput().getPart("groupID").setValue("" + pgID);
            operationList.add(cmdDelLmsPG);
            operationList.add(TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_CFG_VERIFY"));
            OperationResult result = TENECommMgr.getInstance().sendCommand(neid, operationList, 20);
            errCode = result.retCode;
            if (0 == errCode && (errCode = TELineMspQxImpl.getResult(operationList)) == 38688) {
                errCode = 0;
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TELineMspQxImpl.delLineMspCmd() fail!", (Throwable)e);
        }
        return errCode;
    }

    public static int queryLineMspCmd(int neid, List linemspList) {
        int errCode = 0;
        linemspList.clear();
        try {
            ArrayList<Operation> queryPGList = new ArrayList<Operation>();
            Operation cmdGetLmsPG = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_CFG_GET_LMS_PG");
            queryPGList.add(cmdGetLmsPG);
            OperationResult result = TENECommMgr.getInstance().sendCommand(neid, queryPGList, 20);
            errCode = result.retCode;
            if (0 == errCode) {
                errCode = TELineMspQxImpl.getResult(queryPGList);
            }
            if (0 != errCode) {
                return errCode;
            }
            for (int i = cmdGetLmsPG.getOutputCount() - 1; i >= 0; --i) {
                if (0 == Integer.parseInt(cmdGetLmsPG.getOutput(i).getFault(0).getCode()) && 3 == Integer.parseInt(cmdGetLmsPG.getOutput(i).getPartValue("activeFlag"))) continue;
                cmdGetLmsPG.removeOutput(i);
            }
            TELineMspQxImpl.pgBaseInfoQx2O(neid, cmdGetLmsPG, linemspList);
            ArrayList queryPGAttrQxList = new ArrayList();
            errCode = TELineMspQxImpl.queryLineMspParaCmd(neid, linemspList);
            if (0 != errCode) {
                return errCode;
            }
            TELineMspQxImpl.pgParaInfoQx2O(queryPGAttrQxList, linemspList);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TELineMspQxImpl.queryLineMspCmd() fail!", (Throwable)e);
        }
        return errCode;
    }

    public static int queryLineMspParaCmd(int neid, List linemspList) {
        int errCode = 0;
        if (null == linemspList || linemspList.isEmpty()) {
            return errCode;
        }
        try {
            ArrayList<Operation> queryPGAttrQxList = new ArrayList<Operation>();
            ArrayList<Operation> queryPGAttList = new ArrayList<Operation>();
            queryPGAttList.add(TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_CFG_GET_LMS_WTRTIME"));
            queryPGAttList.add(TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_CFG_GET_LMS_SDFLAG"));
            queryPGAttList.add(TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_CFG_GET_LMS_PUMAP_NEW"));
            queryPGAttList.add(TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_CFG_GET_LMS_PROTOCOL"));
            queryPGAttList.add(TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_CFG_GET_LMS_SFSD_LEVEL"));
            queryPGAttList.add(TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_CFG_GET_LMS_K2SWMODE"));
            Operation tempOper = null;
            int len = linemspList.size();
            for (int i = 0; i < len; ++i) {
                int size = queryPGAttList.size();
                for (int j = 0; j < size; ++j) {
                    tempOper = (Operation)queryPGAttList.get(j);
                    tempOper.getInput().getPart(0).setValue("" + ((TELineMspPG)linemspList.get(i)).getLineMsgPGKey().getLineMspId());
                    queryPGAttrQxList.add((Operation)tempOper.clone());
                }
            }
            if (!queryPGAttrQxList.isEmpty()) {
                OperationResult result = TENECommMgr.getInstance().sendCommand(neid, queryPGAttrQxList, 20);
                errCode = result.retCode;
            }
            if (0 == errCode) {
                TELineMspQxImpl.pgParaInfoQx2O(queryPGAttrQxList, linemspList);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TELineMspQxImpl.queryLineMspParaCmd() fail!", (Throwable)e);
        }
        return errCode;
    }

    public static int setLineMspSwitchCmd(int neid, int pgID, int swDir, int eAction) {
        int errCode = 0;
        try {
            Operation cmdExtSW = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_CFG_LMS_EXT_SWCMD");
            cmdExtSW.getInput().getPart("groupid").setValue("" + pgID);
            cmdExtSW.getInput().getPart("protectUnit").setValue("" + swDir);
            cmdExtSW.getInput().getPart("switchType").setValue("" + eAction);
            ArrayList<Operation> operationList = new ArrayList<Operation>();
            operationList.add(cmdExtSW);
            OperationResult result = TENECommMgr.getInstance().sendCommand(neid, operationList, 10);
            errCode = result.retCode;
            if (0 == errCode) {
                errCode = TELineMspQxImpl.getResult(operationList);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TELineMspQxImpl.setLineMspSwitchCmd() fail!", (Throwable)e);
        }
        return errCode;
    }

    public static int setDealLineMspProtocolCmd(int neid, int pgID, int flag) {
        int errCode = 0;
        try {
            Operation cmdDealProtocol = flag == 1 ? TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_CFG_START_LMS_PROTOCOL") : TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_CFG_STOP_LMS_PROTOCOL");
            cmdDealProtocol.getInput().getPart("groupid").setValue("" + pgID);
            ArrayList<Operation> operationList = new ArrayList<Operation>();
            operationList.add(cmdDealProtocol);
            OperationResult result = TENECommMgr.getInstance().sendCommand(neid, operationList, 10);
            errCode = result.retCode;
            if (0 == errCode) {
                errCode = TELineMspQxImpl.getResult(operationList);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TELineMspQxImpl.setDealLineMspProtocolCmd() fail!", (Throwable)e);
        }
        return errCode;
    }

    public static int queryLineMspSWStateCmd(int neid, int pgID, TELineMspPG linemsp, TESwitchStateInfo swInfo, boolean isNeedConvert) {
        int errCode = 0;
        try {
            Operation cmdQuerySWState = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_CFG_GET_LMS_SWSTA_02");
            cmdQuerySWState.getInput().getPart("groupID").setValue("" + pgID);
            ArrayList<Operation> operationList = new ArrayList<Operation>();
            operationList.add(cmdQuerySWState);
            OperationResult result = TENECommMgr.getInstance().sendCommand(neid, operationList, 10);
            errCode = result.retCode;
            if (0 == errCode) {
                errCode = TELineMspQxImpl.getResult(operationList);
            }
            if (0 != errCode) {
                return errCode;
            }
            swInfo.setNeId(neid);
            swInfo.setPgId(pgID);
            TELineMspQxImpl.switchStateQx2O(linemsp, ((Operation)operationList.get(0)).getOutput(), swInfo, isNeedConvert);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TELineMspQxImpl.queryLineMspSWStateCmd() fail!", (Throwable)e);
        }
        return errCode;
    }

    private static void pgBaseInfoQx2O(int neid, Operation operation, List lineMspList) {
        if (null == operation) {
            return;
        }
        int size = operation.getOutputCount();
        for (int i = 0; i < size; ++i) {
            TELineMspPG linemsp = new TELineMspPG();
            Output output = operation.getOutput(i);
            linemsp.setLineMsgPGKey(neid, Integer.parseInt(output.getPartValue("groupID")));
            linemsp.setProtectType(Integer.parseInt(output.getPartValue("protectionType")));
            linemsp.setRecoverMode(Integer.parseInt(output.getPartValue("revertiveMode")));
            linemsp.setSwitchMode(Integer.parseInt(output.getPartValue("switchMode")));
            lineMspList.add(linemsp);
        }
    }

    private static void pgParaInfoQx2O(ArrayList operationList, List lineMspList) {
        if (null == operationList || null == lineMspList) {
            return;
        }
        int size = lineMspList.size();
        for (int index = 0; index < size; ++index) {
            TELineMspPG linemsp = (TELineMspPG)lineMspList.get(index);
            for (int i = operationList.size() - 1; i >= 0; --i) {
                Operation operation = (Operation)operationList.get(i);
                int pgID = Integer.parseInt(operation.getOutput(0).getPartValue("groupID"));
                if (pgID != linemsp.getLineMsgPGKey().getLineMspId()) continue;
                if ("NSCMD_CFG_GET_LMS_PUMAP_NEW".equals(operation.getName())) {
                    TELineMspQxImpl.pgBoardMapQx2O(operation, linemsp);
                }
                if ("NSCMD_CFG_GET_LMS_WTRTIME".equals(operation.getName())) {
                    linemsp.setWrtTime(Integer.parseInt(operation.getOutput(0).getPartValue("revertiveTime")));
                }
                if ("NSCMD_CFG_GET_LMS_PROTOCOL".equals(operation.getName())) {
                    linemsp.setProtocolType(Integer.parseInt(operation.getOutput(0).getPartValue("protocolType")));
                }
                if ("NSCMD_CFG_GET_LMS_SDFLAG".equals(operation.getName())) {
                    linemsp.setSdflag(Integer.parseInt(operation.getOutput(0).getPartValue("sdEnable")));
                }
                if ("NSCMD_CFG_GET_LMS_K2SWMODE".equals(operation.getName())) {
                    linemsp.setSwitchIndication(Integer.parseInt(operation.getOutput(0).getPartValue("switchIndication")));
                }
                if ("NSCMD_CFG_GET_LMS_SFSD_LEVEL".equals(operation.getName())) {
                    linemsp.setSdsfSWFlag(Integer.parseInt(operation.getOutput(0).getPartValue("switchTag")));
                }
                operationList.remove(i);
            }
        }
    }

    private static void pgBoardMapQx2O(Operation operation, TELineMspPG linemsp) {
        if (null == operation || null == linemsp) {
            return;
        }
        int size = operation.getOutputCount();
        for (int i = 0; i < size; ++i) {
            TELineMspBoardMap boardMap = new TELineMspBoardMap();
            Output output = operation.getOutput(i);
            int boardMapType = Integer.parseInt(output.getPartValue("protectUnit"));
            boardMap.setBoardMapType(boardMapType);
            boardMap.setWestSlotID(Integer.parseInt(output.getPartValue("slotid")));
            boardMap.setWestPortID(Integer.parseInt(output.getPartValue("port")));
            boardMap.setClogicNeId(linemsp.getLineMsgPGKey().getClogicNeId());
            boardMap.setLineMspID(linemsp.getLineMsgPGKey().getLineMspId());
            linemsp.getLineMspBoardMap().add(boardMap);
        }
    }

    private static void switchStateQx2O(TELineMspPG pLineMsp, Output[] outputs, TESwitchStateInfo swInfo, boolean isNeedConvert) {
        List allBoardMapList = pLineMsp.getBoardMapList(2);
        Output output2 = outputs[0];
        int tempState = TELineMspQxImpl.getSWStateReal(pLineMsp, output2);
        if (0 == tempState || 2 == tempState) {
            swInfo.setProtocolState(tempState);
            int len = allBoardMapList.size();
            for (int k = 0; k < len; ++k) {
                TELineMspBoardMap boardMap = (TELineMspBoardMap)allBoardMapList.get(k);
                TEDirSwitchState state = new TEDirSwitchState();
                state.setSlotId(boardMap.getWestSlotID());
                state.setPortId(boardMap.getWestPortID());
                state.setM_protectedUnit(255);
                state.setM_lrIndication(0);
                state.setLockState(33);
                state.setSWState(33);
                state.setStatePriority(0);
                state.setBoardMapDirection(k);
                swInfo.getListDirSwitchState().add(state);
                swInfo.getListNeSwitchState().add(state);
            }
            return;
        }
        swInfo.setProtocolState(1);
        for (Output output2 : outputs) {
            TEDirSwitchState state = new TEDirSwitchState();
            state.setSWState(33);
            state.setLockState(33);
            state.setBoardMapDirection(Integer.parseInt(output2.getPartValue("protectUnit")));
            TELineMspBoardMap boardMap = (TELineMspBoardMap)allBoardMapList.get(state.getBoardMapDirection());
            state.setSlotId(boardMap.getWestSlotID());
            state.setPortId(boardMap.getWestPortID());
            state.setM_protectedUnit(Integer.parseInt(output2.getPartValue("protectedUnit")));
            state.setChannel(state.getM_protectedUnit());
            state.setM_lrIndication(Integer.parseInt(output2.getPartValue("endIndication")));
            if (isNeedConvert) {
                state.setLockState(TELineMspQxImpl.getSWStateReal(pLineMsp, output2));
            } else {
                state.setLockState(Integer.parseInt(output2.getPart("switchStatue").getValue()));
            }
            state.setSWState(state.getLockState());
            state.setStatePriority(TELineMspQxImpl.getSWStatePri(state.getSWState()));
            swInfo.getListDirSwitchState().add(state);
            swInfo.getListNeSwitchState().add(state);
        }
    }

    private static int getSWStateReal(TELineMspPG pLineMsp, Output output) {
        int retState = 33;
        int tempState = TELineMspQxImpl.convertSwState(Integer.parseInt(output.getPart("protocolStatus").getValue()), Integer.parseInt(output.getPart("switchStatue").getValue()));
        if (null == pLineMsp) {
            retState = 33;
            return retState;
        }
        if (Integer.parseInt(output.getPart("protectedUnit").getValue()) == 0 && 0 == pLineMsp.getRecoverMode()) {
            switch (tempState) {
                case 4: {
                    retState = 12;
                    break;
                }
                case 5: {
                    retState = 13;
                    break;
                }
                case 8: {
                    retState = 22;
                    break;
                }
                case 7: {
                    retState = 23;
                    break;
                }
                default: {
                    retState = tempState;
                    break;
                }
            }
        } else {
            retState = tempState;
        }
        return retState;
    }

    private static int convertSwState(int swState, int swReq) {
        if (swState == 0) {
            return 0;
        }
        if (swState == 255) {
            return 2;
        }
        if (swState == 1) {
            return 28;
        }
        if (swState == 4) {
            switch (swReq) {
                case 240: {
                    return 31;
                }
                case 224: {
                    return 4;
                }
                case 208: {
                    return 8;
                }
                case 176: {
                    return 7;
                }
                case 128: {
                    return 5;
                }
                case 96: {
                    return 26;
                }
                case 64: {
                    return 6;
                }
                case 16: {
                    return 9;
                }
            }
            return 28;
        }
        return 33;
    }

    private static int getSWStatePri(int swState) {
        int Priority = 0;
        switch (swState) {
            case 4: {
                Priority = 13;
                break;
            }
            case 12: {
                Priority = 14;
                break;
            }
            case 5: {
                Priority = 7;
                break;
            }
            case 13: {
                Priority = 8;
                break;
            }
            case 6: {
                Priority = 3;
                break;
            }
            case 31: {
                Priority = 15;
                break;
            }
            case 10: {
                Priority = 15;
                break;
            }
            case 32: {
                Priority = 15;
                break;
            }
            case 26: {
                Priority = 4;
                break;
            }
            case 22: {
                Priority = 15;
                break;
            }
            case 23: {
                Priority = 12;
                break;
            }
            case 7: {
                Priority = 10;
                break;
            }
            case 8: {
                Priority = 12;
                break;
            }
            case 9: {
                Priority = 1;
                break;
            }
            default: {
                Priority = 0;
            }
        }
        return Priority;
    }

    private static int getResult(ArrayList operationList) {
        int errCode = 0;
        if (null == operationList || operationList.isEmpty()) {
            return errCode;
        }
        int size = operationList.size();
        for (int index = 0; index < size; ++index) {
            Operation operation = (Operation)operationList.get(index);
            errCode = Integer.parseInt(operation.getOutput(0).getFault(0).getCode());
            if (0 == errCode || 38662 == errCode) continue;
            return errCode;
        }
        return 0;
    }
}

