/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.sdh.msprotect.linemsp;

import com.huawei.nglct.core.event.Event;
import com.huawei.nglct.core.event.EventManager;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.sdh.msprotect.TEEventMspSwitch;
import com.huawei.nglct.nemgr.sdh.msprotect.TESwitchStateInfo;
import com.huawei.nglct.nemgr.sdh.msprotect.linemsp.TELineMspDBMgr;
import com.huawei.nglct.nemgr.sdh.msprotect.linemsp.TELineMspQxImpl;
import com.huawei.nglct.nemgr.sdh.msprotect.po.TELineMspBoardMap;
import com.huawei.nglct.nemgr.sdh.msprotect.po.TELineMspPG;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntIntHashMap;
import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class TELineMspMgrImpl {
    public static int createLineMspPG(int neid, TELineMspPG linemsp) {
        int errCode = 0;
        TENE ne = TENEListMgr.getInstance().getNE(neid);
        errCode = TELineMspMgrImpl.allocLineMspID(ne, linemsp);
        if (0 != errCode) {
            return errCode;
        }
        errCode = TELineMspQxImpl.createLineMspCmd(neid, linemsp);
        if (0 != errCode) {
            return errCode;
        }
        TELineMspDBMgr.addLineMsp(linemsp);
        EventManager.getInstance().postEvent(new Event(79, (Object)linemsp));
        return errCode;
    }

    public static int delLineMspPGs(int neid, TIntArrayList delPGIDList, TIntIntHashMap failPGMap) {
        int errCode = 0;
        failPGMap.clear();
        if (null == delPGIDList || delPGIDList.isEmpty()) {
            return errCode;
        }
        int size = delPGIDList.size();
        for (int i = 0; i < size; ++i) {
            int tmpPGID = delPGIDList.get(i);
            errCode = TELineMspMgrImpl.delLineMspPG(neid, tmpPGID);
            if (0 == errCode) continue;
            failPGMap.put(tmpPGID, errCode);
        }
        if (delPGIDList.size() == failPGMap.size()) {
            return 2;
        }
        return 0;
    }

    public static int delLineMspPG(int neid, int pgID) {
        int errCode = TELineMspQxImpl.delLineMspCmd(neid, pgID);
        if (0 != errCode) {
            return errCode;
        }
        TELineMspPG linemsp = TELineMspDBMgr.getLineMsp(neid, pgID);
        TELineMspDBMgr.delLineMspPG(neid, pgID);
        if (null != linemsp) {
            EventManager.getInstance().postEvent(new Event(80, (Object)linemsp));
        }
        return errCode;
    }

    public static int queryLineMspPG(int neid, List linemspList) {
        int i;
        int errCode = 0;
        linemspList.clear();
        errCode = TELineMspQxImpl.queryLineMspCmd(neid, linemspList);
        if (0 != errCode) {
            return errCode;
        }
        ArrayList delLineMspPGList = new ArrayList();
        ArrayList addLineMspPGList = new ArrayList();
        errCode = TELineMspMgrImpl.updateLineMsp(neid, linemspList, delLineMspPGList, addLineMspPGList);
        int size = delLineMspPGList.size();
        for (i = 0; i < size; ++i) {
            EventManager.getInstance().postEvent(new Event(80, (Object)((TELineMspPG)delLineMspPGList.get(i))));
        }
        size = addLineMspPGList.size();
        for (i = 0; i < size; ++i) {
            EventManager.getInstance().postEvent(new Event(79, (Object)((TELineMspPG)addLineMspPGList.get(i))));
        }
        return errCode;
    }

    public static int getLineMspPG(int neid, int pgID, List linemspList) {
        int errCode = 0;
        linemspList.clear();
        if (pgID != 0) {
            TELineMspPG linemsp = TELineMspDBMgr.getLineMsp(neid, pgID);
            if (null == linemsp) {
                errCode = 1090593960;
            }
            linemspList.add(linemsp);
        } else {
            linemspList.addAll(TELineMspDBMgr.getAllLineMsp(neid));
        }
        return errCode;
    }

    public static int setLineMspPGSwitch(int neid, int pgID, int swDir, int eAction) {
        int errCode = 0;
        errCode = TELineMspQxImpl.setLineMspSwitchCmd(neid, pgID, swDir, eAction);
        return errCode;
    }

    public static int setDealLineMspProtocols(int neID, TIntIntHashMap pgMap, TIntIntHashMap failPGMap) {
        int errCode = 0;
        if (null == pgMap || pgMap.isEmpty()) {
            return errCode;
        }
        int[] keys = pgMap.keys();
        failPGMap.clear();
        for (int i = 0; i < keys.length; ++i) {
            int pgID = keys[i];
            int oprType = pgMap.get(pgID);
            errCode = TELineMspMgrImpl.setDealLineMspProtocol(neID, pgID, oprType);
            if (0 == errCode) continue;
            failPGMap.put(pgID, errCode);
        }
        if (failPGMap.size() == pgMap.size()) {
            return 2;
        }
        return errCode;
    }

    public static int setDealLineMspProtocol(int neID, int pgID, int oprType) {
        if (oprType != 1 && oprType != 0) {
            return 1090593825;
        }
        return TELineMspQxImpl.setDealLineMspProtocolCmd(neID, pgID, oprType);
    }

    public static int setLineMspPGPara(int neid, int pgID, TObjectIntHashMap attrMap) {
        int errCode = 0;
        ArrayList linemspList = new ArrayList();
        errCode = TELineMspMgrImpl.queryLineMspPG(neid, linemspList);
        if (0 != errCode) {
            return errCode;
        }
        TELineMspPG linemsp = null;
        int len = linemspList.size();
        for (int i = 0; i < len && pgID != (linemsp = (TELineMspPG)linemspList.get(i)).getLineMsgPGKey().getLineMspId(); ++i) {
        }
        if (null == linemsp) {
            return 1090594023;
        }
        errCode = TELineMspQxImpl.setLineMspParaCmd(neid, pgID, attrMap);
        if (0 == errCode) {
            TELineMspPG linemspNM;
            if (attrMap.containsKey((Object)"switchIndication")) {
                linemsp.setSwitchIndication(attrMap.get((Object)"switchIndication"));
            }
            if (attrMap.containsKey((Object)"revertiveMode")) {
                linemsp.setRecoverMode(attrMap.get((Object)"revertiveMode"));
            }
            if (attrMap.containsKey((Object)"revertiveTime")) {
                linemsp.setWrtTime(attrMap.get((Object)"revertiveTime"));
            }
            if (attrMap.containsKey((Object)"sdEnable")) {
                linemsp.setSdflag(attrMap.get((Object)"sdEnable"));
            }
            if (attrMap.containsKey((Object)"protocolType")) {
                linemsp.setProtocolType(attrMap.get((Object)"protocolType"));
            }
            if (attrMap.containsKey((Object)"switchTag")) {
                linemsp.setSdsfSWFlag(attrMap.get((Object)"switchTag"));
            }
            if (attrMap.containsKey((Object)"switchMode")) {
                linemsp.setSwitchMode(attrMap.get((Object)"switchMode"));
            }
            if (null != (linemspNM = TELineMspDBMgr.getLineMsp(neid, pgID))) {
                Iterator<TELineMspBoardMap> itrNE = null;
                Iterator<TELineMspBoardMap> itrNM = null;
                for (TELineMspBoardMap boardMapNE : linemsp.getLineMspBoardMap()) {
                    for (TELineMspBoardMap boardMapNM : linemspNM.getLineMspBoardMap()) {
                        if (boardMapNE.getBoardMapType() != boardMapNM.getBoardMapType()) continue;
                        boardMapNE.setCid(boardMapNM.getCid());
                    }
                }
            }
            EventManager.getInstance().postEvent(new Event(4866, (Object)linemsp));
        }
        return errCode;
    }

    public static TELineMspPG getLineMspPGPara(int neid, int pgID, TELineMspPG linemsp) {
        int errCode = 0;
        ArrayList linemspList = new ArrayList();
        errCode = TELineMspMgrImpl.getLineMspPG(neid, pgID, linemspList);
        if (0 == errCode) {
            return (TELineMspPG)linemspList.get(0);
        }
        return null;
    }

    public static int queryLineMspPGPara(int neid, int pgID, TELineMspPG linemsp) {
        int errCode = 0;
        ArrayList<TELineMspPG> linMspList = new ArrayList<TELineMspPG>();
        linMspList.add(linemsp);
        errCode = TELineMspQxImpl.queryLineMspParaCmd(neid, linMspList);
        if (0 == errCode) {
            TELineMspDBMgr.updatePGPara(linemsp);
        }
        return errCode;
    }

    public static int queryLineMspPGSWState(int neid, int pgID, TESwitchStateInfo swInfo, boolean isNeedConvert) {
        int errCode = 0;
        ArrayList lineMspList = new ArrayList();
        TELineMspMgrImpl.getLineMspPG(neid, pgID, lineMspList);
        if (null == lineMspList || lineMspList.isEmpty()) {
            return 1090593960;
        }
        TELineMspPG linemsp = (TELineMspPG)lineMspList.get(0);
        errCode = TELineMspQxImpl.queryLineMspSWStateCmd(neid, pgID, linemsp, swInfo, isNeedConvert);
        if (0 == errCode) {
            TEEventMspSwitch eventMspSW = new TEEventMspSwitch();
            eventMspSW.setM_neID(neid);
            eventMspSW.setM_mspPG(linemsp);
            eventMspSW.setM_swInfo(swInfo);
            EventManager.getInstance().postEvent(new Event(81, (Object)eventMspSW));
        }
        return errCode;
    }

    public static int updateLineMsp(int neid, List linemspList, List delLineMspPGList, List addLineMspPGList) {
        int errCode = 0;
        delLineMspPGList.clear();
        addLineMspPGList.clear();
        ArrayList linemspLst = new ArrayList();
        linemspLst.addAll(linemspList);
        ArrayList nmLineMspList = new ArrayList();
        TELineMspMgrImpl.getLineMspPG(neid, 0, nmLineMspList);
        int nmDataSize = nmLineMspList.size();
        for (int i = 0; i < nmDataSize; ++i) {
            TELineMspPG nmLineMsp = (TELineMspPG)nmLineMspList.get(i);
            boolean bFindSamePG = false;
            for (int j = linemspLst.size() - 1; j >= 0; --j) {
                TELineMspPG neLineMsp = (TELineMspPG)linemspLst.get(j);
                if (!nmLineMsp.getLineMsgPGKey().equals(neLineMsp.getLineMsgPGKey())) continue;
                nmLineMsp.setSwitchMode(neLineMsp.getSwitchMode());
                nmLineMsp.setRecoverMode(neLineMsp.getRecoverMode());
                nmLineMsp.setWrtTime(neLineMsp.getWrtTime());
                nmLineMsp.setSdflag(neLineMsp.getSdflag());
                nmLineMsp.setProtocolType(neLineMsp.getProtocolType());
                TELineMspDBMgr.updatePGPara(nmLineMsp);
                bFindSamePG = true;
                linemspLst.remove(j);
                break;
            }
            if (bFindSamePG) continue;
            TELineMspDBMgr.delLineMspPG(nmLineMsp);
            delLineMspPGList.add(nmLineMsp);
        }
        if (!linemspLst.isEmpty()) {
            TELineMspDBMgr.addLineMsps(linemspLst);
            addLineMspPGList.addAll(linemspLst);
        }
        return errCode;
    }

    public static int allocLineMspID(TENE ne, TELineMspPG linemsp) {
        int errCode = 0;
        ArrayList allLineMsp = new ArrayList();
        TELineMspMgrImpl.getLineMspPG(ne.getNEID(), 0, allLineMsp);
        TIntArrayList pgIDs = new TIntArrayList();
        int size = allLineMsp.size();
        for (int i = 0; i < size; ++i) {
            pgIDs.add(((TELineMspPG)allLineMsp.get(i)).getLineMsgPGKey().getLineMspId());
        }
        if (linemsp.getLineMsgPGKey().getLineMspId() != 0) {
            if (pgIDs.contains(linemsp.getLineMsgPGKey().getLineMspId())) {
                return 1090593968;
            }
        } else {
            int lineMspID = 1;
            while (pgIDs.contains(lineMspID)) {
                ++lineMspID;
            }
            linemsp.getLineMsgPGKey().setLineMspId(lineMspID);
            for (TELineMspBoardMap boardMap : linemsp.getLineMspBoardMap()) {
                boardMap.setLineMspID(lineMspID);
            }
        }
        return errCode;
    }

    public static int uploadLineMspPG(int neid) {
        int errCode = 0;
        errCode = TELineMspMgrImpl.queryLineMspPG(neid, new ArrayList());
        return errCode;
    }

    public static int dataSyncLineMspPG(int neid) {
        int errCode = 0;
        return errCode;
    }

    public static int copyLineMspPG(int neid) {
        int errCode = 0;
        return errCode;
    }

    public static int synCheckLineMspPG(int neid) {
        int errCode = 0;
        ArrayList linemspListNe = new ArrayList();
        ArrayList linemspListNM = new ArrayList();
        errCode = TELineMspQxImpl.queryLineMspCmd(neid, linemspListNe);
        if (0 != errCode) {
            return errCode;
        }
        errCode = TELineMspMgrImpl.getLineMspPG(neid, 0, linemspListNM);
        if (0 != errCode) {
            return errCode;
        }
        if (linemspListNe.size() != linemspListNM.size()) {
            errCode = 1090593926;
        }
        Comparator<TELineMspPG> itemComparator = new Comparator<TELineMspPG>(){

            @Override
            public int compare(TELineMspPG mspPgA, TELineMspPG mspPGB) {
                return mspPgA.getPsnID() - mspPGB.getPsnID();
            }
        };
        Collections.sort(linemspListNe, itemComparator);
        Collections.sort(linemspListNM, itemComparator);
        if (0 == errCode) {
            for (int i = 0; i < linemspListNe.size(); ++i) {
                if (TELineMspMgrImpl.isSameLineMsp((TELineMspPG)linemspListNe.get(i), (TELineMspPG)linemspListNM.get(i))) continue;
                errCode = 1090593927;
                break;
            }
        }
        return errCode;
    }

    public static int exportLineMsp(int neid, String cmdID) {
        int errCode = 0;
        ArrayList lineMspPGList = new ArrayList();
        errCode = TELineMspMgrImpl.getLineMspPG(neid, 0, lineMspPGList);
        if (0 != errCode) {
            return errCode;
        }
        return errCode;
    }

    public static int importLineMsp(int neid, String cmdID) {
        int errCode = 0;
        return errCode;
    }

    public static boolean isSameLineMsp(TELineMspPG src, TELineMspPG snk) {
        if (!src.equals(snk)) {
            return false;
        }
        if (src.getPsnID() != snk.getPsnID()) {
            return false;
        }
        if (src.getSwitchMode() != snk.getSwitchMode()) {
            return false;
        }
        if (src.getRecoverMode() != snk.getRecoverMode()) {
            return false;
        }
        if (src.getWrtTime() != snk.getWrtTime()) {
            return false;
        }
        return src.getSdflag() == snk.getSdflag();
    }

    public static boolean isNESupportMSPFunc(int neID, int funcID) {
        return true;
    }

    public static boolean isNESupportLineMsp(int funcID, int NEID) {
        return true;
    }
}

