/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.sdh.logicsys.mooperation;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoNameValuePair;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.po.embeddednemgrmo.ptn.linemsp.TELineMspBoardMapMOPO;
import com.huawei.nglct.po.embeddednemgrmo.ptn.linemsp.TELineMspMOPO;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class TELineMspMoOperationUtil {
    public static final char PROID_E2E = '\u0bda';
    public static final int CREATE_REPORT_CMD = 11536466;
    public static final int DELETE_REPORT_CMD = 11536469;
    private static final int DEFAULT_SUBCARD_ID = 255;

    private TELineMspMoOperationUtil() {
    }

    public static TELineMspMOPO getLMspMOPO(RowParams rowParams) {
        TELineMspMOPO lineMspMOPO = null;
        if (rowParams.getRowErrorsCount() == 0) {
            lineMspMOPO = new TELineMspMOPO();
            long mspID = Long.parseLong(rowParams.getParam("groupID").getValue());
            lineMspMOPO.setLineMspID(mspID);
            short protectType = Short.parseShort(rowParams.getParam("protectionType").getValue());
            lineMspMOPO.setProtectType(protectType);
            short switchMode = Short.parseShort(rowParams.getParam("switchMode").getValue());
            lineMspMOPO.setSwitchMode(switchMode);
            short recoverMode = Short.parseShort(rowParams.getParam("revertiveMode").getValue());
            lineMspMOPO.setRecoverMode(recoverMode);
            int wrtTime = Integer.parseInt(rowParams.getParam("revertiveTime").getValue());
            lineMspMOPO.setWRTTime(wrtTime);
            short sdflag = Short.parseShort(rowParams.getParam("sdEnable").getValue());
            lineMspMOPO.setSdflag(sdflag);
            short protocolType = Short.parseShort(rowParams.getParam("protocolType").getValue());
            lineMspMOPO.setProtocolType(protocolType);
            short sdsfSWFlag = Short.parseShort(rowParams.getParam("switchTag").getValue());
            lineMspMOPO.setSDSFPriSwitchFlag(sdsfSWFlag);
            if (rowParams.getParam("switchIndication") != null && rowParams.getParam("switchIndication").getValue() != null) {
                short switchIndication = Short.parseShort(rowParams.getParam("switchIndication").getValue());
                lineMspMOPO.setSwitchModeIndication(switchIndication);
            }
            if (rowParams.getParam("activationStatus") != null && rowParams.getParam("activationStatus").getValue() != null) {
                short activationStatus = Short.parseShort(rowParams.getParam("activationStatus").getValue());
                lineMspMOPO.setActivationStatus(activationStatus);
            }
            if (rowParams.getParam("delaytime") != null && rowParams.getParam("delaytime").getValue() != null) {
                lineMspMOPO.setUserLabel(rowParams.getParam("delaytime").getValue());
            }
        }
        return lineMspMOPO;
    }

    public static TELineMspBoardMapMOPO getLMspBoardMapMOPO(int neID, RowParams rowParams, short protectUnitID, String _slotID, String _subSlotID, String _portID) {
        long slotID = Long.parseLong(rowParams.getParam(_slotID).getValue());
        long subSlotID = 255L;
        if (rowParams.getParam(_subSlotID) != null && rowParams.getParam(_subSlotID).getValue() != null) {
            subSlotID = Long.parseLong(rowParams.getParam(_subSlotID).getValue());
        }
        long portID = Long.parseLong(rowParams.getParam(_portID).getValue());
        long absolutePortID = TEConfigurationDataMgr.getAbsolutPort((int)16, (int)((int)portID));
        int boardType = TEConfigurationDataMgr.getInstance().getBoardType(neID, (int)slotID);
        TELineMspBoardMapMOPO lMspBoardMapMOPO = new TELineMspBoardMapMOPO(protectUnitID, boardType, slotID, subSlotID, absolutePortID);
        return lMspBoardMapMOPO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TEDaoOperationResult getLMSPDBData(int neID) {
        TEDaoOperationResult dbResult = null;
        try {
            dbResult = TECommonDaoService.findAll((int)neID, (int[])new int[]{neID}, TELineMspMOPO.class);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("The query LMSP from db result exception", (Throwable)e);
        }
        finally {
            if (null == dbResult) {
                TELogFactory.getNormalLogger().error("The query LMSP from db result exception");
            }
        }
        return dbResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TEDaoOperationResult getLMSPDBData(int neID, Datainterface outputData) {
        TEDaoOperationResult dbResult = null;
        try {
            dbResult = TECommonDaoService.findAll((int)neID, (int[])new int[]{neID}, TELineMspMOPO.class);
        }
        catch (Exception e) {
            try {
                TELogFactory.getNormalLogger().error("The query LMSP from db result exception", (Throwable)e);
            }
            catch (Throwable throwable) {
                TELineMspMoOperationUtil.fillDBErrors(neID, outputData, dbResult);
                throw throwable;
            }
            TELineMspMoOperationUtil.fillDBErrors(neID, outputData, dbResult);
        }
        TELineMspMoOperationUtil.fillDBErrors(neID, outputData, dbResult);
        return dbResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<TELineMspMOPO> queryTELineMspMOPOFromDB(int neID) {
        TEDaoOperationResult dbResult = null;
        ArrayList<TELineMspMOPO> result = new ArrayList<TELineMspMOPO>();
        try {
            dbResult = TECommonDaoService.findAll((int)neID, (int[])new int[]{neID}, TELineMspMOPO.class);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("The query LMSP from db result exception ", (Throwable)e);
        }
        finally {
            if (null == dbResult) {
                TELogFactory.getNormalLogger().error("The query LMSP from db result exception");
            }
        }
        if (null != dbResult && 0 == dbResult.getResult() && !dbResult.getData().isEmpty()) {
            List data = dbResult.getData();
            for (Object obj : data) {
                result.add((TELineMspMOPO)obj);
            }
        } else {
            String tipStr = "Get TELineMspMOPO fail! ";
            if (null != dbResult) {
                tipStr = tipStr + String.format("[neID:%d, retCode:%d]", neID, dbResult.getResult());
            }
            TELogFactory.getNormalLogger().error(tipStr);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TELineMspMOPO queryTELineMspMOPOFromDB(int neID, Long mspID) {
        TEDaoOperationResult dbResult = null;
        TELineMspMOPO lineMspMOPO = null;
        ArrayList<TEDaoNameValuePair> criteria = new ArrayList<TEDaoNameValuePair>();
        TEDaoNameValuePair aPair = new TEDaoNameValuePair("LineMspID", String.valueOf(mspID));
        criteria.add(aPair);
        try {
            dbResult = TECommonDaoService.findByID((int)neID, (int[])new int[]{neID}, TELineMspMOPO.class, criteria);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("The query LMSP ID from db result exception " + mspID, (Throwable)e);
        }
        finally {
            if (null == dbResult) {
                TELogFactory.getNormalLogger().error("The query LMSP from db result exception");
            }
        }
        if (null != dbResult && 0 == dbResult.getResult() && dbResult.getData().size() > 0) {
            lineMspMOPO = (TELineMspMOPO)dbResult.getData().get(0);
        }
        return lineMspMOPO;
    }

    public static Datainterface fillDBErrors(int neID, Datainterface outputData, TEDaoOperationResult dbResult) {
        if (dbResult != null) {
            if (dbResult.getResult() == 0) {
                return outputData;
            }
            TELogFactory.getNormalLogger().error("Operate DB is fail. The errorCode is " + dbResult.getResult() + " and the errorInfo is " + TEErrorResourceUtil.getErrorMessage((int)dbResult.getResult()) + "!");
        }
        int errorCode = 1090646274;
        RowErrors rowError = new RowErrors();
        Param errorparam = new Param("neid", String.valueOf(neID));
        rowError.addParam(errorparam);
        ErrorMessage errorMessage = new ErrorMessage();
        errorMessage.setErrorcode(String.valueOf(errorCode));
        errorMessage.setErrorinfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode));
        rowError.setErrorMessage(errorMessage);
        outputData.getBussinessParams().getRowParams(0).addRowErrors(rowError);
        errorMessage = outputData.getErrorMessage();
        if (0 == Integer.parseInt(errorMessage.getErrorcode())) {
            errorMessage.setErrorcode(String.valueOf(errorCode));
            errorMessage.setErrorinfo(TEErrorResourceUtil.getErrCodeResWithDot((int)neID, (int)errorCode));
        }
        return outputData;
    }

    public static Map<Long, TELineMspMOPO> getLineMspMOPOFromOutput(int neID, BussinessParams businessparams) {
        HashMap<Long, TELineMspMOPO> mspIDToObjMap = new HashMap<Long, TELineMspMOPO>();
        if (businessparams == null) {
            return mspIDToObjMap;
        }
        if (0 == businessparams.getRowParamsCount()) {
            return mspIDToObjMap;
        }
        int rowlen = businessparams.getRowParamsCount();
        for (int row = 0; row < rowlen; ++row) {
            TELineMspMOPO lineMspMOPO;
            RowParams rowparams = businessparams.getRowParams(row);
            Param param = rowparams.getParam("groupID");
            if (null == param || null == (lineMspMOPO = TELineMspMoOperationUtil.getLMspMOPO(rowparams))) continue;
            TELineMspBoardMapMOPO protectLMspBoardMapMOPO = TELineMspMoOperationUtil.getLMspBoardMapMOPO(neID, rowparams, (short)0, "slotid0", "subslotid0", "port0");
            lineMspMOPO.getProtectBoardMapList().add(protectLMspBoardMapMOPO);
            int wordPathNum = Integer.parseInt(rowparams.getParam("wordPathNum").getValue());
            for (int i = 1; i <= wordPathNum; ++i) {
                short protectUnitID = Short.parseShort(rowparams.getParam("protectUnit" + i).getValue());
                TELineMspBoardMapMOPO workLMspBoardMapMOPO = TELineMspMoOperationUtil.getLMspBoardMapMOPO(neID, rowparams, protectUnitID, "slotid" + i, "subslotid" + i, "port" + i);
                lineMspMOPO.getWorkBoardMapList().add(workLMspBoardMapMOPO);
            }
            mspIDToObjMap.put(lineMspMOPO.getLineMspID(), lineMspMOPO);
        }
        return mspIDToObjMap;
    }

    public static Map<Long, TELineMspMOPO> getPtnLineMspMOPOFromOutput(int neID, BussinessParams businessparams) {
        TELineMspBoardMapMOPO workLMspBoardMapMOPO;
        TELineMspMOPO lineMspMOPO;
        Param param;
        int row;
        HashMap<Long, TELineMspMOPO> mspIDToObjMap = new HashMap<Long, TELineMspMOPO>();
        int rowlen = businessparams.getRowParamsCount();
        for (row = 0; row < rowlen; ++row) {
            RowParams rowparams = businessparams.getRowParams(row);
            param = rowparams.getParam("groupID");
            if (null == param) continue;
            lineMspMOPO = TELineMspMoOperationUtil.getLMspMOPO(rowparams);
            TELineMspBoardMapMOPO protectLMspBoardMapMOPO = TELineMspMoOperationUtil.getLMspBoardMapMOPO(neID, rowparams, (short)0, "Pslotid", "Psubslotid", "Pport");
            lineMspMOPO.getProtectBoardMapList().add(protectLMspBoardMapMOPO);
            workLMspBoardMapMOPO = TELineMspMoOperationUtil.getLMspBoardMapMOPO(neID, rowparams, (short)1, "Wslotid", "Wsubslotid", "Wport");
            lineMspMOPO.getWorkBoardMapList().add(workLMspBoardMapMOPO);
            mspIDToObjMap.put(lineMspMOPO.getLineMspID(), lineMspMOPO);
        }
        rowlen = businessparams.getRowParamsCount();
        for (row = 1; row < rowlen; ++row) {
            RowParams rowParams = businessparams.getRowParams(row);
            param = rowParams.getParam("WgroupID");
            if (null == param || null == (lineMspMOPO = (TELineMspMOPO)mspIDToObjMap.get(Long.parseLong(param.getValue())))) continue;
            short protectUnitID = Short.parseShort(rowParams.getParam("WprotectUnit").getValue());
            workLMspBoardMapMOPO = TELineMspMoOperationUtil.getLMspBoardMapMOPO(neID, rowParams, protectUnitID, "Wslotid", "Wsubslotid", "Wport");
            lineMspMOPO.getWorkBoardMapList().add(workLMspBoardMapMOPO);
        }
        return mspIDToObjMap;
    }
}

