/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.sdh.logicsys.datacfg;

import com.huawei.nglct.cbb.datamanage.integration.model.TEDataCfgNEInfo;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TENEMgrInterface;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.sdh.logicsys.mooperation.TELineMspMoOperationUtil;
import com.huawei.nglct.po.embeddednemgrmo.ptn.linemsp.TELineMspMOPO;
import com.huawei.nglct.sysmanager.TEHandleSbiInfo;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;

public class TELineMspGeneralHandler {
    protected TEDataCfgNEInfo neInfo = null;
    protected static final Logger E2ELOGGER = TELogFactory.getNormalLogger();
    protected static final String TENEEXPLORERBEAN_CLASSNAME = "com.huawei.nglct.explorer.TENEExplorerBean";
    protected int operateFlag = -1;

    public TELineMspGeneralHandler(TEDataCfgNEInfo pPara, int flag) {
        this.operateFlag = flag;
        this.neInfo = pPara;
    }

    protected int queryLineMSPData(Map<Long, TELineMspMOPO> lineMspMOPO) {
        Datainterface allData;
        int neID = this.neInfo.getNeID();
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        if (null != ne && 1 != ne.getLogStatus()) {
            TEHandleSbiInfo.getInstance().handleSBIConnectOnInter(neID);
        }
        if (null == (allData = this.getLineMSPDataFromNe(neID, 2109646))) {
            return 0;
        }
        int errorCode = Integer.parseInt(allData.getErrorMessage().getErrorcode());
        if (0 != errorCode) {
            TELogFactory.getNormalLogger().error("Query LMSP fail and not save data to DB");
            return -1;
        }
        lineMspMOPO = TELineMspMoOperationUtil.getLineMspMOPOFromOutput(neID, allData.getBussinessParams());
        return 0;
    }

    public int performWNEMgrBussinessProcess() {
        HashMap<Long, TELineMspMOPO> mspIDToObjMap = new HashMap<Long, TELineMspMOPO>();
        int result = this.queryLineMSPData(mspIDToObjMap);
        if (result != 0) {
            return result;
        }
        if (null == mspIDToObjMap || mspIDToObjMap.isEmpty()) {
            return 0;
        }
        int neID = this.neInfo.getNeID();
        try {
            Iterator iter = mspIDToObjMap.values().iterator();
            while (iter.hasNext()) {
                TECommonDaoService.create((int)neID, (int[])new int[]{neID}, iter.next());
            }
        }
        catch (Exception e) {
            if (3 == this.operateFlag) {
                E2ELOGGER.error("Upload LMSP not save data to DB", (Throwable)e);
            } else {
                E2ELOGGER.error("Sync LMSP not save data to DB", (Throwable)e);
            }
            return -1;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Datainterface getLineMSPDataFromNe(int neID, int sfid) {
        Datainterface din = new Datainterface();
        BussinessParams bus = new BussinessParams();
        din.setBussinessParams(bus);
        RowParams rp = new RowParams();
        bus.addRowParams(rp);
        Param p = new Param("neid", String.valueOf(neID));
        rp.addParam(p);
        SubFunc subFunc = null;
        int neType = this.neInfo.getNeType();
        String neVersion = this.neInfo.getNeVersion();
        try {
            subFunc = TECreateObjectFactory.getSubFuncByVer((int)neID, (int)sfid, (int)neType, (String)neVersion);
        }
        catch (Exception e1) {
            TELogFactory.getNormalLogger().error(e1.getMessage());
        }
        if (null == subFunc) {
            TELogFactory.getNormalLogger().info("Not Find Query Lmsp subFunc!");
            return null;
        }
        Datainterface allData = null;
        String classMapping = subFunc.getClassMapping();
        TENEMgrInterface neMgrBean = null;
        try {
            neMgrBean = classMapping == null ? (TENEMgrInterface)Class.forName(TENEEXPLORERBEAN_CLASSNAME).newInstance() : (TENEMgrInterface)Class.forName(classMapping).newInstance();
        }
        catch (Exception e) {
            if (3 == this.operateFlag) {
                E2ELOGGER.error("The Upload LMSP from weblct exception " + neID, (Throwable)e);
            } else {
                E2ELOGGER.error("The Sync LMSP from weblct exception " + neID, (Throwable)e);
            }
        }
        finally {
            if (null != neMgrBean) {
                allData = neMgrBean.performBussinessProcess(neID, subFunc, din, null, null, null);
            }
        }
        return allData;
    }
}

