/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.sdh.logicsys;

import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nemgr.sdh.TEProtectSWSuper;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;

public class TEProtectSW
extends TEProtectSWSuper {
    private static final int Chain_ACT_CLEAR_ALL = 250;
    private static final int Chain_ACT_LOCK = 15;
    private static final int Chain_ACT_FS = 13;
    private static final int Chain_ACT_FS_P = 13;
    private static final int Chain_ACT_FS_W = 14;
    private static final int Chain_ACT_MS = 7;
    private static final int Chain_ACT_MS_P = 7;
    private static final int Chain_ACT_MS_W = 8;
    private static final int Chain_ACT_EXER = 3;
    private static final int Chain_STA_FS = 13;
    private static final int Chain_STA_FS_P = 14;
    private static final int Chain_STA_MS = 7;
    private static final int Chain_STA_MS_P = 8;
    private static final int Chain_STA_EXER = 3;
    private static final int Chain_STA_LOCK = 15;
    private static final int Chain_STA_SF_P = 15;
    private static final int Chain_STA_SD_P = 12;
    private static final int Chain_STA_WTR = 4;
    private static final int Chain_STA_SD = 10;
    private static final int Chain_STA_SF = 12;
    private static final int Chain_STA_DNR = 4;
    private static final int STA_FS = 224;
    private static final int STA_FS_P = 225;
    private static final int STA_MS = 128;
    private static final int STA_MS_P = 129;
    private static final int STA_SF = 208;
    private static final int STA_SF_P = 209;
    private static final int STA_SD = 176;
    private static final int STA_SD_P = 177;
    private static final int STA_WTR = 96;
    private static final int STA_EXER = 64;
    private static final int STA_LOCK = 240;
    private static final int STA_DNR = 16;
    private static final int ACT_CLEAR_ALL = 16;
    private static final int ACT_LOCK = 15;
    private static final int ACT_FS = 14;
    private static final int ACT_FS_P = 13;
    private static final int ACT_FS_W = 12;
    private static final int ACT_MS = 8;
    private static final int ACT_MS_P = 7;
    private static final int ACT_MS_W = 6;
    private static final int ACT_EXER = 4;
    private static final String NSCMD_CFG_GET_LMS_SWSTA_02 = "NSCMD_CFG_GET_LMS_SWSTA_02";
    private static final int SWITCH_OFFSET = 1000;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        int result = this.checkSwitchStatus(neid, subFunc, inputData);
        if (result != 0) {
            this.outputData = new Datainterface();
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
            this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
            return this.outputData;
        }
        return super.performBussinessProcess(neid, subFunc, inputData, memeryData, user, ipAddress);
    }

    private int checkSwitchStatus(int neid, SubFunc subFunc, Datainterface inputData) {
        ArrayList<String> operNameList = new ArrayList<String>();
        operNameList.add(NSCMD_CFG_GET_LMS_SWSTA_02);
        ArrayList operList = TEDataConverter.convertToOperation((SubFunc)subFunc, (Datainterface)inputData, (int)neid, operNameList);
        if (operList.isEmpty()) {
            return 0;
        }
        int result = this.sendMessage(neid, operList);
        if (result == 0) {
            int protectUnit = Integer.parseInt(inputData.getBussinessParams().getRowParams(0).getParam("protectUnit").getValue());
            int switchType = Integer.parseInt(inputData.getBussinessParams().getRowParams(0).getParam("switchType").getValue());
            Operation oper = (Operation)operList.get(0);
            ArrayList<LogicSysState> listState = new ArrayList<LogicSysState>();
            int len = oper.getOutputCount();
            for (int i = 0; i < len; ++i) {
                Output output = oper.getOutput(i);
                if (!output.getFault(0).getCode().equals(String.valueOf(0))) continue;
                int protectUnitTmp = Integer.parseInt(output.getPart("protectUnit").getValue());
                int switchState = Integer.parseInt(output.getPart("switchStatue").getValue());
                listState.add(new LogicSysState(protectUnitTmp, switchState));
            }
            int priority = this.getActionPriority(protectUnit, switchType);
            LogicSysState state = null;
            int groupPriority = 0;
            int len2 = listState.size();
            for (int i = 0; i < len2; ++i) {
                state = (LogicSysState)listState.get(i);
                if (state.getPriority() <= groupPriority) continue;
                groupPriority = state.getPriority();
            }
            if (priority < groupPriority) {
                result = 1090595074;
            }
        }
        return result;
    }

    private int getActionPriority(int protectUnit, int swtichType) {
        if (swtichType == 14) {
            swtichType = protectUnit == 0 ? 12 : 13;
        }
        if (swtichType == 8) {
            swtichType = protectUnit == 0 ? 6 : 7;
        }
        switch (swtichType) {
            case 16: {
                return 250;
            }
            case 15: {
                return 15;
            }
            case 14: {
                return 13;
            }
            case 13: {
                return 13;
            }
            case 12: {
                return 14;
            }
            case 8: {
                return 7;
            }
            case 7: {
                return 7;
            }
            case 6: {
                return 8;
            }
            case 4: {
                return 3;
            }
        }
        return 0;
    }

    class LogicSysState {
        private int protectUnit;
        private int switchState;
        private int priority;

        public LogicSysState(int protectUnit, int switchState) {
            this.protectUnit = protectUnit;
            this.switchState = switchState;
            if (switchState == 224 && protectUnit == 0) {
                switchState = 225;
            }
            if (switchState == 128 && protectUnit == 0) {
                switchState = 129;
            }
            if (switchState == 208 && protectUnit == 0) {
                switchState = 209;
            }
            if (switchState == 176 && protectUnit == 0) {
                switchState = 177;
            }
            this.initPriority(switchState);
        }

        private void initPriority(int switchState) {
            switch (switchState) {
                case 224: {
                    this.priority = 13;
                    break;
                }
                case 225: {
                    this.priority = 14;
                    break;
                }
                case 128: {
                    this.priority = 7;
                    break;
                }
                case 129: {
                    this.priority = 8;
                    break;
                }
                case 64: {
                    this.priority = 3;
                    break;
                }
                case 240: {
                    this.priority = 15;
                    break;
                }
                case 96: {
                    this.priority = 4;
                    break;
                }
                case 209: {
                    this.priority = 15;
                    break;
                }
                case 177: {
                    this.priority = 12;
                    break;
                }
                case 176: {
                    this.priority = 10;
                    break;
                }
                case 208: {
                    this.priority = 12;
                    break;
                }
                case 16: {
                    this.priority = 4;
                    break;
                }
                default: {
                    this.priority = 0;
                }
            }
        }

        public int getProtectUnit() {
            return this.protectUnit;
        }

        public void setProtectUnit(int protectUnit) {
            this.protectUnit = protectUnit;
        }

        public int getSwitchState() {
            return this.switchState;
        }

        public void setSwitchState(int switchState) {
            this.switchState = switchState;
        }

        public int getPriority() {
            return this.priority;
        }

        public void setPriority(int priority) {
            this.priority = priority;
        }
    }
}

