/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.sdh.logicsys;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TENEMgrInterface;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TESubBoard;
import com.huawei.nglct.nelist.model.circuitpack.TEPortProperty;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import org.slf4j.Logger;

public abstract class TEAvailabeResQuerySuperBean
implements TENEMgrInterface {
    private int neid;
    private Datainterface output;
    private Logger log = TELogFactory.getNormalLogger();
    private static final int BOARD_ASD1 = 1170;
    private static final int BDTYPE_SLD3VS2 = 3059;

    protected abstract ArrayList getLogicPortList(int var1, int var2, int var3, int var4);

    private void getAvaliableBoard() {
        this.output.setBussinessParams(new BussinessParams());
        TEConfigurationDataMgr cfgDataMgr = TEConfigurationDataMgr.getInstance();
        RowParams rowparams = null;
        TEBoard board = null;
        int bdType = 0;
        int slotId = 0;
        int port = 0;
        String bdName = "";
        Vector boardList = TENEListMgr.getInstance().getNE(this.neid).getClonedBoardList();
        int size = boardList.size();
        for (int j = 0; j < size; ++j) {
            board = (TEBoard)boardList.get(j);
            bdType = board.getBoardType();
            slotId = board.getSlotID();
            bdName = board.getBoardName();
            if (this.isPtnSuppBoard(this.neid, bdType)) {
                ArrayList portList = this.getLogicPortList(this.neid, slotId, bdType, 1798);
                if (null == portList) continue;
                Collections.sort(portList);
                int portLen = portList.size();
                for (int portIndex = 0; portIndex < portLen; ++portIndex) {
                    port = (Integer)portList.get(portIndex);
                    rowparams = new RowParams();
                    rowparams.addParam("neid", String.valueOf(this.neid));
                    rowparams.addParam("slotid", String.valueOf(slotId));
                    rowparams.addParam("boardname", bdName);
                    rowparams.addParam("subslotid", "0");
                    rowparams.addParam("subboardname", "");
                    rowparams.addParam("port", String.valueOf(port));
                    rowparams.addParam("portname", TEConfigurationDataMgr.getInstance().getPortName(this.neid, slotId, bdType, port));
                    this.output.getBussinessParams().addRowParams(rowparams);
                }
            }
            List subList = board.getSubBoardList();
            int len = subList.size();
            for (int i = 0; i < len; ++i) {
                ArrayList portList;
                TESubBoard subBoard = (TESubBoard)subList.get(i);
                int subSlot = subBoard.getSubSlotID();
                int subType = subBoard.getSubBoardType();
                String subName = cfgDataMgr.getBoardTypeName(this.neid, subType);
                if (!this.isPtnSuppBoard(this.neid, subType) || null == (portList = cfgDataMgr.getBoardPortList(this.neid, subType))) continue;
                Collections.sort(portList);
                int portLen = portList.size();
                for (int portIndex = 0; portIndex < portLen; ++portIndex) {
                    port = (Integer)portList.get(portIndex);
                    rowparams = new RowParams();
                    rowparams.addParam("neid", String.valueOf(this.neid));
                    rowparams.addParam("slotid", String.valueOf(slotId));
                    rowparams.addParam("boardname", bdName);
                    rowparams.addParam("subslotid", String.valueOf(subSlot));
                    rowparams.addParam("subboardname", subName);
                    rowparams.addParam("port", String.valueOf(port));
                    rowparams.addParam("portname", TEConfigurationDataMgr.getInstance().getPortName(this.neid, subSlot, subType, port));
                    this.output.getBussinessParams().addRowParams(rowparams);
                }
            }
        }
        this.output.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
    }

    public boolean isPtnSuppBoard(int neid, int boardType) {
        if (boardType == 1170) {
            return false;
        }
        if (boardType == 3059) {
            return false;
        }
        TEConfigurationDataMgr instance = TEConfigurationDataMgr.getInstance();
        ArrayList list = instance.getBoardPortPropertyList(neid, boardType);
        boolean ret = false;
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            int portType = ((TEPortProperty)list.get(i)).getPortType();
            if (portType != 1798 && portType != 256) continue;
            ret = true;
            break;
        }
        return ret;
    }

    public boolean isNeedOperationlog() {
        return false;
    }

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.output = new Datainterface();
        TENE neObj = TENEListMgr.getInstance().getNE(neid);
        try {
            if (null != neObj) {
                this.getAvaliableBoard();
            } else {
                this.output.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090596385));
            }
        }
        catch (Exception e) {
            this.log.error("Get Avaliable IPA Board Fail!\n", (Throwable)e);
            this.output.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090646019));
        }
        return this.output;
    }
}

