/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.sdh.logicsys;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TENEMgrInterface;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEQueryLogicPort;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Vector;
import org.slf4j.Logger;

public class TEAvailabeResQueryBean
implements TENEMgrInterface {
    private int neid;
    private Datainterface output;
    private Logger log = TELogFactory.getNormalLogger();

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.output = new Datainterface();
        TENE neObj = TENEListMgr.getInstance().getNE(neid);
        try {
            if (null != neObj) {
                this.getAvaliableBoard();
            } else {
                this.output.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090596385));
            }
        }
        catch (Exception e) {
            this.log.error("Get Avaliable IPA Board Fail!\n", (Throwable)e);
            this.output.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090646019));
        }
        return this.output;
    }

    private void getAvaliableBoard() {
        this.output.setBussinessParams(new BussinessParams());
        RowParams rowparams = null;
        TEBoard board = null;
        int bdType = 0;
        int slotID = 0;
        int port = 0;
        String bdName = "";
        Vector boardList = TENEListMgr.getInstance().getNE(this.neid).getClonedBoardList();
        int size = boardList.size();
        for (int j = 0; j < size; ++j) {
            ArrayList portList;
            board = (TEBoard)boardList.get(j);
            bdType = board.getBoardType();
            slotID = board.getSlotID();
            bdName = board.getBoardName();
            boolean isNotSupportBD = TESpecialAttrMgr.getInstance().isCPNotSupportByType(bdType, "TE_FUNC_CFG_LINEMSP", "SDH_ATTR_SUPPORT_RINGMSP_NOTSUPPORTBD_RTN");
            if (TEConfigurationDataMgr.getInstance().isIFboard(bdType) || bdType == 1066 || bdType == 1210 || bdType == 2057 || bdType == 2102 || bdType == 2439 || bdType == 2549 || bdType == 2469 || isNotSupportBD || !TEConfigurationDataMgr.getInstance().isSDHLineBoard(this.neid, slotID) || null == (portList = TEQueryLogicPort.getLogicPortList((int)this.neid, (int)slotID, (int)bdType))) continue;
            Collections.sort(portList);
            int portLen = portList.size();
            for (int portIndex = 0; portIndex < portLen; ++portIndex) {
                port = (Integer)portList.get(portIndex);
                rowparams = new RowParams();
                rowparams.addParam("neid", String.valueOf(this.neid));
                rowparams.addParam("subrackid", String.valueOf(TEBoardUtil.getSubrackIDFromSlot((int)this.neid, (int)slotID)));
                rowparams.addParam("subrackname", TEBoardUtil.getSubrackNameFromSlot((int)this.neid, (int)slotID));
                rowparams.addParam("slotid", String.valueOf(slotID));
                rowparams.addParam("showslotid", String.valueOf(TEBoardUtil.getSlotIDFromSlot((int)this.neid, (int)slotID)));
                rowparams.addParam("boardname", bdName);
                rowparams.addParam("port", String.valueOf(port));
                rowparams.addParam("portname", TEConfigurationDataMgr.getInstance().getPortName(this.neid, slotID, bdType, port));
                String level = TEConfigurationDataMgr.getInstance().getPortIterfaceLevel(this.neid, bdType, port) + "";
                if (bdType == 2264) {
                    level = this.getLogicalPortSpeed(slotID, port) + "";
                    if ("2".equals(level)) {
                        rowparams.addParam("inflevel", "4");
                    } else {
                        rowparams.addParam("inflevel", level);
                    }
                } else if (!"-1".equals(level)) {
                    rowparams.addParam("inflevel", Integer.valueOf(level.substring(2, 4)) + "");
                }
                this.output.getBussinessParams().addRowParams(rowparams);
            }
        }
        this.output.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
    }

    public boolean isNeedOperationlog() {
        return false;
    }

    private int getLogicalPortSpeed(int slotid, int portNo) {
        try {
            Operation oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_GET_PORT");
            Input input = oper.getInput();
            Part part = input.getPart("slotID");
            part.setValue(String.valueOf(slotid));
            part = input.getPart("portID");
            part.setValue(String.valueOf(portNo));
            ArrayList<Operation> operationList = new ArrayList<Operation>();
            operationList.add(oper);
            int resualt = TENECommMgr.getInstance().sendCommand((int)this.neid, operationList, (int)10).retCode;
            if (resualt == 0 && oper.getOutput()[0].getFault()[0].getCode().equals(String.valueOf(0))) {
                int speedLevel = Integer.parseInt(oper.getOutput()[0].getPartValue("speedLevel"));
                return speedLevel;
            }
        }
        catch (Exception e) {
            this.log.error("Parse Qx description file fail!", (Throwable)e);
            return -1;
        }
        return -1;
    }
}

