/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.sdh.laserautoshutdown;

import com.huawei.nglct.cbb.log.TECommonWriteLogBean;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.device.port.TEVirtualPortUtil;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.string.TEResourceUtil;
import java.io.File;
import java.util.ArrayList;

public class TEQueryALSBean
extends TECommonWriteLogBean {
    private static final String PORTISNOTIN = "40004";
    private static final String LANGUAGE = TESysManagerBean.getInstance().getlanguage();
    private static final String BASE_PATH = "sdh" + File.separator + "res" + File.separator;
    private static final String STRING_SOURCE = BASE_PATH + "laserautoshutdown" + File.separator + "laserals_" + LANGUAGE + ".ini";
    private TEResourceUtil resourceUtil = null;

    public ArrayList getOperation(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData) {
        RowParams rowParams = (RowParams)inputData.getBussinessParams().getRowParams(0).clone();
        rowParams.addParam("portID", "");
        inputData.getBussinessParams().removeRowParams(0);
        int slotId = Integer.valueOf(rowParams.getParam("slotid").getValue());
        TEConfigurationDataMgr mgr = TEConfigurationDataMgr.getInstance();
        ArrayList portList = mgr.getBoardPortList(neid, mgr.getBoardType(neid, slotId));
        if (mgr.isDynPortBoardType(neid, mgr.getBoardType(neid, slotId))) {
            portList.clear();
            portList = mgr.getLogicPortList(neid, slotId);
        }
        if (TEVirtualPortUtil.isMSOTNBoard((int)neid, (int)slotId)) {
            portList.clear();
            portList.addAll(TEVirtualPortUtil.getExistVPortsByDomain((int)neid, (int)slotId, (int)1));
        }
        int m = portList.size();
        for (int i = 0; i < m; ++i) {
            rowParams.getParam("portID").setValue(String.valueOf(portList.get(i)));
            inputData.getBussinessParams().addRowParams((RowParams)rowParams.clone());
        }
        return super.getOperation(neid, subFunc, inputData, memeryData);
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        String portname = "";
        this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList, (ArrayList)filterErrorCodeList);
        if (null == this.outputData || null == this.outputData.getBussinessParams()) {
            return;
        }
        if (this.outputData.getBussinessParams().getRowParamsCount() == 0) {
            return;
        }
        RowParams rowparams = null;
        Param param = null;
        int len = this.outputData.getBussinessParams().getRowParamsCount();
        for (int i = 0; i < len; ++i) {
            String slotID = "";
            String portid = "";
            rowparams = this.outputData.getBussinessParams().getRowParams(i);
            int len1 = rowparams.getParamCount();
            if (0 == len1) {
                return;
            }
            try {
                slotID = rowparams.getParam("slotid").getValue();
                portid = rowparams.getParam("portID").getValue();
                portname = this.getPortName(Integer.parseInt(slotID), Integer.parseInt(portid));
                param = new Param("portname", portname);
                rowparams.addParam(param);
                continue;
            }
            catch (Exception e) {
                TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
                return;
            }
        }
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> codeList = new ArrayList<Integer>();
        codeList.add(Integer.valueOf(PORTISNOTIN));
        codeList.add(38671);
        return codeList;
    }

    private String getPortName(int slotid, int portid) {
        TEBoard board = TEConfigurationDataMgr.getInstance().getBoard(this.neid, slotid);
        int boardtype = board.getBoardType();
        String portname = TEConfigurationDataMgr.getInstance().getPortName(this.neid, slotid, boardtype, portid);
        return portname;
    }

    protected boolean isSingletonLog() {
        return true;
    }

    public String getDetailInfo(RowParams[] rParamsArr) {
        this.resourceUtil = TEGetFilePath.getResource((int)this.neid, (String)STRING_SOURCE);
        String detailDes = "";
        TENE neObj = TENEListMgr.getInstance().getNE(this.neid);
        detailDes = null == neObj ? String.valueOf(this.neid) : neObj.getNEName();
        if (null != rParamsArr[0].getParam("slotid")) {
            int slotid = Integer.parseInt(rParamsArr[0].getParam("slotid").getValue());
            int boardtype = TEConfigurationDataMgr.getInstance().getBoardType(this.neid, slotid);
            String subrackName = TEBoardUtil.getSubrackNameFromSlot((int)this.neid, (int)slotid);
            detailDes = detailDes + "-";
            if (!"".equals(subrackName)) {
                detailDes = detailDes + subrackName + "-";
            }
            detailDes = detailDes + TEBoardUtil.getSlotIDFromSlot((int)this.neid, (int)slotid) + "-" + TEConfigurationDataMgr.getInstance().getBoardTypeName(this.neid, boardtype);
        }
        String qurey_res = this.resourceUtil.getString("qureyAls");
        return detailDes + ":" + qurey_res;
    }
}

