/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.sdh.fault;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

public class TEQueryUNEQInsertBean
extends TENEExplorerBean {
    private static final int TIME_OUT = 10;
    private static Logger log = TELogFactory.getNormalLogger();
    private TEResourceUtil res = null;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.neid = neid;
            this.subfunc = subFunc;
            this.inputData = inputData;
            this.operationList = this.queryUNEQ(neid, this.getSlotID());
            int result = TENECommMgr.getInstance().sendCommand((int)neid, (List)this.operationList, (int)10).retCode;
            this.outputData = new Datainterface();
            if (result == 0) {
                this.handleMessage(neid, this.operationList, subFunc);
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
            }
            if (this.isNeedOperationlog()) {
                this.writeLog(neid, subFunc, inputData, user, ipAddress, this.outputData);
            }
        }
        catch (Exception e) {
            log.error("query ne alarm property fail!", (Throwable)e);
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)2));
            return this.outputData;
        }
        return this.outputData;
    }

    private String getSlotID() {
        RowParams[] rowParams = this.inputData.getBussinessParams().getRowParams();
        if (rowParams.length >= 0) {
            return rowParams[0].getParam("slotID").getValue();
        }
        return "0";
    }

    public ArrayList queryUNEQ(int neID, String slotID) {
        int bType = 1;
        int boardtype = TEConfigurationDataMgr.getInstance().getBoardType(neID, Integer.parseInt(slotID));
        if (boardtype == 1179) {
            bType = 4;
        }
        ArrayList<Operation> operationList = new ArrayList<Operation>();
        try {
            Operation oper = TECreateObjectFactory.getOperation((int)neID, (String)"NSCMD_CFG_GET_INS_UNEQ");
            if (null == oper) {
                log.info("The operation NSCMD_CFG_GET_INS_UNEQ is not found!");
                return null;
            }
            Input input = oper.getInput();
            Part part = input.getPart("slotID");
            part.setValue(slotID);
            part = input.getPart("pathID");
            part.setValue(String.valueOf(0));
            input = oper.getInput();
            part = input.getPart("bType");
            part.setValue(bType + "");
            oper.getOutput(0).getPart("bSwitch").setName("R_TLOS");
            operationList.add(oper);
            Operation oper2 = (Operation)oper.clone();
            input = oper2.getInput();
            part = input.getPart("bType");
            part.setValue(String.valueOf(2));
            oper2.getOutput(0).getPart("R_TLOS").setName("PNOUSE");
            operationList.add(oper2);
        }
        catch (Exception e) {
            log.error("Parse Qx description file fail!", (Throwable)e);
            return null;
        }
        return operationList;
    }

    public boolean isNeedOperationlog() {
        return true;
    }

    public String getDetailStr(RowParams rowparams) {
        StringBuffer filePath = new StringBuffer();
        filePath.append("necommon").append(File.separator).append(TEPathManager.RESOURCE_PROFILE_PATH).append("fault").append(File.separator).append("stringsource_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        this.res = TEGetFilePath.getResource((int)this.neid, (StringBuffer)filePath);
        TEConfigurationDataMgr tEConfigurationDataMgr = TEConfigurationDataMgr.getInstance();
        StringBuffer strBuf = new StringBuffer();
        String boardString = this.res.getString("board");
        int boardType = -1;
        int slotID = -1;
        strBuf.append(boardString);
        slotID = Integer.parseInt(rowparams.getParam("slotID").getValue());
        boardType = TEConfigurationDataMgr.getInstance().getBoardType(this.neid, slotID);
        strBuf.append(TENEListMgr.getInstance().getNE(this.neid).getNEName()).append("-").append(slotID).append("-").append(tEConfigurationDataMgr.getBoardTypeName(this.neid, boardType));
        return strBuf.toString();
    }
}

