/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.sdh.fault;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEAlarmDataMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.alarm.TEAlarmInverse;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Fault;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import org.slf4j.Logger;

public class TEQueryPortInverseBean
extends TENEExplorerBean {
    private ArrayList filterErrorCodeList = new ArrayList();
    private static final int errorCode = 38153;
    private static Logger log = TELogFactory.getNormalLogger();
    private TEResourceUtil res = null;
    private int slotID = 0;
    private int boardType = 0;
    private static final String INVERSESTATE_FORBID = "0";
    private boolean isBranchBoard = false;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        Param slotidParam = Datainterface.getParam((Param[])inputData.getBussinessParams().getRowParams(0).getParam(), (String)"slotID");
        this.slotID = Integer.parseInt(slotidParam.getValue());
        this.boardType = TEConfigurationDataMgr.getInstance().getBoardType(neid, this.slotID);
        if (TEConfigurationDataMgr.getInstance().isBranchBoard(neid, this.slotID)) {
            this.isBranchBoard = true;
        }
        try {
            this.neid = neid;
            this.subfunc = subFunc;
            this.inputData = inputData;
            this.outputData = new Datainterface();
            this.operationList = new ArrayList();
            Operation oper = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_ALM_GET_INVERSE_STATE");
            if (oper == null) {
                log.info("The operation NSCMD_CFG_DEL_PORT is not found!");
                return null;
            }
            Input input = oper.getInput();
            Part part = input.getPart("slotID");
            part.setValue(String.valueOf(this.slotID));
            part = input.getPart("opticalID");
            part.setValue(INVERSESTATE_FORBID);
            part = input.getPart("pathID");
            part.setValue(INVERSESTATE_FORBID);
            this.operationList.add(oper);
            int result = this.sendMessage(neid);
            if (result == 0) {
                ArrayList filterErrorCodeList = this.getFilterErrorCodeList();
                this.handleMessage(neid, this.operationList, subFunc, filterErrorCodeList);
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
            }
            if (this.isNeedOperationlog()) {
                this.writeLog(neid, subFunc, inputData, user, ipAddress, this.outputData);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
            return null;
        }
        return this.outputData;
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        ArrayList list = TEAlarmDataMgr.getInstance().getInverseList(this.boardType);
        ArrayList<Object> inverseList = new ArrayList<Object>();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            inverseList.add(((TEAlarmInverse)list.get(i)).clone());
        }
        Collections.sort(inverseList);
        Datainterface TempOutData = this.getOutPut(inverseList);
        RowParams tempRow = null;
        Param param = null;
        int opticalID = -1;
        int pathID = -1;
        String inverseStatus = "-1";
        int tempopticalId = -1;
        int temppathId = -1;
        Operation oper = (Operation)operationList.get(0);
        Output[] outPuts = oper.getOutput();
        Output outPut = null;
        Part part = null;
        block1: for (int i = outPuts.length - 1; i >= 0; --i) {
            outPut = outPuts[i];
            Fault fault = outPut.getFault()[0];
            if (!fault.getCode().equalsIgnoreCase(INVERSESTATE_FORBID)) continue;
            part = outPut.getPart("opticalID");
            opticalID = new Integer(part.getValue());
            part = outPut.getPart("pathID");
            pathID = new Integer(part.getValue());
            part = outPut.getPart("inverseStatus");
            inverseStatus = part.getValue();
            for (int j = TempOutData.getBussinessParams().getRowParamsCount() - 1; j >= 0; --j) {
                tempRow = TempOutData.getBussinessParams().getRowParams(j);
                param = Datainterface.getParam((Param[])tempRow.getParam(), (String)"opticalID");
                tempopticalId = Integer.parseInt(param.getValue());
                param = Datainterface.getParam((Param[])tempRow.getParam(), (String)"pathID");
                temppathId = Integer.parseInt(param.getValue());
                if (this.isBranchBoard) {
                    int temp = tempopticalId;
                    tempopticalId = temppathId;
                    temppathId = temp;
                }
                if (tempopticalId != opticalID || temppathId != pathID) continue;
                Datainterface.getParam((Param[])tempRow.getParam(), (String)"inverseStatus").setValue(inverseStatus);
                continue block1;
            }
        }
        this.outputData = TempOutData;
        TENE ne = TENEListMgr.getInstance().getNE(neid);
        if (ne.getLogStatus() == 0) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)37926));
        } else {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
        }
    }

    private Datainterface getOutPut(ArrayList list) {
        TEAlarmInverse tEAlarmInverse = null;
        Datainterface tempOutputData = new Datainterface();
        tempOutputData.setBussinessParams(new BussinessParams());
        RowParams rowParam = null;
        Param param = null;
        if (this.isBranchBoard) {
            ArrayList pathList = null;
            int len = list.size();
            for (int i = 0; i < len; ++i) {
                pathList = ((TEAlarmInverse)list.get(i)).getPathIDList();
                int size = pathList.size();
                for (int j = 0; j < size; ++j) {
                    rowParam = new RowParams();
                    param = new Param();
                    param.setName("opticalID");
                    param.setValue(String.valueOf(pathList.get(j)));
                    rowParam.addParam(param);
                    param = new Param();
                    param.setName("pathID");
                    param.setValue(String.valueOf(((TEAlarmInverse)list.get(i)).getPortID()));
                    rowParam.addParam(param);
                    param = new Param();
                    param.setName("inverseStatus");
                    param.setValue(INVERSESTATE_FORBID);
                    rowParam.addParam(param);
                    tempOutputData.getBussinessParams().addRowParams(rowParam);
                }
            }
            param = new Param();
            param.setName("isBranchBoard");
            param.setValue(this.isBranchBoard ? "1" : INVERSESTATE_FORBID);
            tempOutputData.getBussinessParams().getRowParams()[0].addParam(param);
            tempOutputData.setErrorMessage(new ErrorMessage());
            tempOutputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neid, (int)0));
            return tempOutputData;
        }
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            tEAlarmInverse = (TEAlarmInverse)list.get(i);
            rowParam = new RowParams();
            Param[] params = tEAlarmInverse.toRowParams();
            for (int j = 0; j < params.length; ++j) {
                rowParam.addParam(params[j]);
            }
            tempOutputData.getBussinessParams().addRowParams(rowParam);
        }
        tempOutputData.setErrorMessage(new ErrorMessage());
        tempOutputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neid, (int)0));
        return tempOutputData;
    }

    public ArrayList getFilterErrorCodeList() {
        this.filterErrorCodeList.add(new Integer(38153));
        return this.filterErrorCodeList;
    }

    public String getDetailStr(RowParams rowparams) {
        StringBuffer filePath = new StringBuffer();
        filePath.append("necommon").append(File.separator).append(TEPathManager.RESOURCE_PROFILE_PATH).append("fault").append(File.separator).append("stringsource_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        this.res = TEGetFilePath.getResource((int)this.neid, (StringBuffer)filePath);
        TEConfigurationDataMgr tEConfigurationDataMgr = TEConfigurationDataMgr.getInstance();
        StringBuffer strBuf = new StringBuffer();
        String boardString = this.res.getString("board");
        int boardType = -1;
        int slotID = -1;
        strBuf.append(boardString);
        slotID = Integer.parseInt(rowparams.getParam("slotID").getValue());
        boardType = TEConfigurationDataMgr.getInstance().getBoardType(this.neid, slotID);
        strBuf.append(slotID).append("-").append(tEConfigurationDataMgr.getBoardTypeName(this.neid, boardType));
        return strBuf.toString();
    }
}

