/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.sdh.fault;

import com.huawei.nglct.cbb.log.TECommonWriteLogBean;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.model.TEAlarmDataMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.alarm.TEBitErrorTh;
import com.huawei.nglct.nelist.model.alarm.TEPortBitErrorTh;
import com.huawei.nglct.nemgr.sdh.fault.TEBitErrThMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.device.ne.TEGetNEDomainVersion;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;

public class TEQueryBitErrorBean
extends TECommonWriteLogBean {
    private static final int TIME_OUT = 10;
    private int slotID = -1;
    private int boardType = -1;
    private ArrayList tEPortBitErrorThList = null;
    private TEBitErrThMgr tEBitErrThMgr = TEBitErrThMgr.getInstance();
    private static Logger log = TELogFactory.getNormalLogger();
    private TEResourceUtil res = null;
    private static final String NE_NOT_LOGIN = "37926";
    HashMap bitErrorMap = new HashMap();
    boolean isBreanchBoard = false;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.neid = neid;
            this.subfunc = subFunc;
            this.inputData = inputData;
            this.outputData = new Datainterface();
            RowParams[] rParams = inputData.getBussinessParams().getRowParams();
            this.boardType = Integer.parseInt(rParams[0].getParam("boardType").getValue());
            this.slotID = Integer.parseInt(rParams[0].getParam("slotID").getValue());
            this.operationList = this.queryBitError(neid);
            if (null == this.operationList) {
                if (this.isNeedOperationlog()) {
                    this.writeLog(neid, subFunc, inputData, user, ipAddress, this.outputData);
                }
                log.info("The operationlist is null!");
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)2));
                return this.outputData;
            }
            int result = TENECommMgr.getInstance().sendCommand((int)neid, (List)this.operationList, (int)10).retCode;
            if (result == 0) {
                this.handleMessage(result);
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
            }
            if (this.isNeedOperationlog()) {
                this.writeLog(neid, subFunc, inputData, user, ipAddress, this.outputData);
            }
        }
        catch (Exception e) {
            log.error("query bit error fail!", (Throwable)e);
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)2));
            return this.outputData;
        }
        if (!this.outputData.getErrorMessage().getErrorcode().equals("0")) {
            BussinessParams bussinessParams = this.outputData.getBussinessParams();
            if (bussinessParams == null) {
                return this.outputData;
            }
            if (bussinessParams.getRowParamsCount() == 0) {
                return this.outputData;
            }
            RowParams rowparams = bussinessParams.getRowParams(bussinessParams.getRowParamsCount() - 1);
            RowErrors rowErrors = rowparams.getRowErrors(0);
            if (rowErrors.getErrorMessage().getErrorcode().equals(NE_NOT_LOGIN)) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)Integer.parseInt(NE_NOT_LOGIN)));
                for (int i = rowparams.getRowErrorsCount() - 1; i >= 0; --i) {
                    rowparams.removeRowErrors(rowparams.getRowErrors(i));
                }
            }
        }
        return this.outputData;
    }

    public void handleMessage(int result) {
        TENE ne = TENEListMgr.getInstance().getNE(this.neid);
        if (ne.getLogStatus() == 0) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neid, (int)37926));
            return;
        }
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neid, (int)result));
        BussinessParams bParams = new BussinessParams();
        this.outputData.setBussinessParams(bParams);
        ArrayList<TEPortBitErrorTh> BitErrorThList = new ArrayList<TEPortBitErrorTh>();
        int size = this.operationList.size();
        for (int i = 0; i < size; ++i) {
            Operation oper = (Operation)this.operationList.get(i);
            if (!oper.getOutput()[0].getFault()[0].getCode().equalsIgnoreCase(String.valueOf(0))) continue;
            Part[] parts = oper.getOutput()[0].getPart();
            String PortID = "1";
            String PathID = "1";
            TEBitErrorTh bitError = new TEBitErrorTh();
            for (Part part : parts) {
                String name = part.getName();
                String value = part.getValue();
                if (name.equalsIgnoreCase("portID")) {
                    PortID = value;
                    continue;
                }
                if (name.equalsIgnoreCase("pathID")) {
                    PathID = value;
                    continue;
                }
                if (name.indexOf("biterr_type_") < 0) continue;
                int index = name.lastIndexOf("_");
                bitError.setThtype(Integer.valueOf(name.substring(index + 1)).intValue());
                bitError.setBitErrorvalue(value);
                String key = PortID + "-" + PathID;
                if (!this.bitErrorMap.containsKey(key)) continue;
                TEPortBitErrorTh tEPortBitErrorTh = (TEPortBitErrorTh)this.bitErrorMap.get(key);
                tEPortBitErrorTh.getBitErrorThList().add(bitError.clone());
            }
        }
        for (TEPortBitErrorTh tEPortBitErrorTh : this.bitErrorMap.values()) {
            BitErrorThList.add(tEPortBitErrorTh);
        }
        Collections.sort(BitErrorThList);
        int size2 = BitErrorThList.size();
        for (int i = 0; i < size2; ++i) {
            TEPortBitErrorTh tEPortBitErrorTh = (TEPortBitErrorTh)BitErrorThList.get(i);
            RowParams row = tEPortBitErrorTh.toRowParams(this.isBreanchBoard);
            this.handelOprObj(row, tEPortBitErrorTh);
            bParams.addRowParams(row);
        }
    }

    private void handelOprObj(RowParams row, TEPortBitErrorTh tEPortBitErrorTh) {
        TENE neObj = TENEListMgr.getInstance().getNE(this.neid);
        Param nenameParam = new Param("nename", neObj.getNEName());
        row.addParam(nenameParam);
        Param slotidParam = new Param("slotid", this.slotID + "");
        row.addParam(slotidParam);
        int boardtype = TEConfigurationDataMgr.getInstance().getBoardType(this.neid, this.slotID);
        Param boardname = new Param();
        boardname.setName("boardname");
        boardname.setValue(TEConfigurationDataMgr.getInstance().getBoardTypeName(this.neid, boardtype));
        row.addParam(boardname);
        Param portname = new Param();
        portname.setName("portname");
        if (TEConfigurationDataMgr.getInstance().isBranchBoard(this.neid, this.slotID) && tEPortBitErrorTh.getPathID() > 1) {
            portname.setValue(TEConfigurationDataMgr.getInstance().getPortNameForNARTN(this.neid, this.slotID, boardtype, tEPortBitErrorTh.getPathID()));
        } else {
            portname.setValue(TEConfigurationDataMgr.getInstance().getPortNameForNARTN(this.neid, this.slotID, boardtype, tEPortBitErrorTh.getPortID()));
        }
        row.addParam(portname);
        TENE teNE = TENEListUtils.getNEObj((int)this.neid);
        String domain = TEGetNEDomainVersion.getInstance().getDomain(teNE.getNEType());
        if (row.getParam("monObject") != null && (domain.equalsIgnoreCase("ngwdm") || domain.equalsIgnoreCase("wdm"))) {
            String monObject = neObj.getNEName();
            String subrackname = TEBoardUtil.getSubrackNameFromSlot((int)this.neid, (int)this.slotID);
            String boardName = TEConfigurationDataMgr.getInstance().getBoardTypeName(this.neid, boardtype);
            String portName = TEConfigurationDataMgr.getInstance().getPortName(this.neid, this.slotID, this.boardType, tEPortBitErrorTh.getPortID());
            if (!subrackname.isEmpty()) {
                monObject = monObject + "-" + subrackname;
            }
            monObject = monObject + "-" + TEBoardUtil.bigSlotToSmall((int)this.slotID) + "-" + boardName + "-" + portName;
            row.getParam("monObject").setValue(monObject);
        }
    }

    private ArrayList queryBitError(int neID) {
        this.operationList = new ArrayList();
        this.tEPortBitErrorThList = TEAlarmDataMgr.getInstance().getBITThList(this.boardType);
        Collections.sort(this.tEPortBitErrorThList);
        int len = this.tEPortBitErrorThList.size();
        for (int i = 0; i < len; ++i) {
            TEPortBitErrorTh tEPortBitErrorTh = (TEPortBitErrorTh)this.tEPortBitErrorThList.get(i);
            int portID = tEPortBitErrorTh.getPortID();
            int pathID = tEPortBitErrorTh.getPathID();
            TEPortBitErrorTh bitErrorTh = new TEPortBitErrorTh();
            bitErrorTh.setPortID(portID);
            bitErrorTh.setPathID(pathID);
            ArrayList bitErrorThList = tEPortBitErrorTh.getBitErrorThList();
            if (this.tEBitErrThMgr.isNABitError(bitErrorThList)) continue;
            this.bitErrorMap.put(bitErrorTh.makeBitErrorKey(), bitErrorTh);
            bitErrorThList = this.tEBitErrThMgr.delNABitErrorList(bitErrorThList);
            int length = bitErrorThList.size();
            for (int j = 0; j < length; j += 2) {
                TEBitErrorTh tEBitErrorTh = (TEBitErrorTh)bitErrorThList.get(j);
                int type = tEBitErrorTh.getThtype();
                int bitType = this.tEBitErrThMgr.getBitType(type);
                if (bitType == 5 || 4 == bitType) {
                    this.setBranchQxData(pathID, bitType);
                    continue;
                }
                if (6 == bitType) {
                    this.setIFAQxData(portID);
                    continue;
                }
                if ((bitType < 1 || bitType > 3) && bitType < 50) continue;
                this.setLineQxData(portID, bitType);
            }
        }
        return this.operationList;
    }

    private void setIFAQxData(int portID) {
        Operation oper = null;
        try {
            oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_GET_RADIO_BIP_TH");
            if (null == oper) {
                log.info("The operation NSCMD_CFG_GET_RADIO_BIP_TH is not found!");
                return;
            }
            Input input = oper.getInput();
            Part part = input.getPart("slotID");
            part.setValue(String.valueOf(this.slotID));
            part = input.getPart("portID");
            part.setValue(String.valueOf(portID));
            oper.getOutput(0).getPart("exceedValue").setName("biterr_type_19");
            oper.getOutput(0).getPart("badValue").setName("biterr_type_20");
        }
        catch (Exception e) {
            log.error("Parse Qx description file fail!", (Throwable)e);
            return;
        }
        this.operationList.add(oper);
    }

    private void setBranchQxData(int pathID, int bitType) {
        this.isBreanchBoard = true;
        Operation oper = null;
        try {
            oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_GET_BIP_TH");
            if (null == oper) {
                log.info("The operation NSCMD_CFG_GET_BIP_TH is not found!");
                return;
            }
            Input input = oper.getInput();
            Part part = input.getPart("slotID");
            part.setValue(Integer.valueOf(this.slotID).toString());
            part = input.getPart("pathID");
            part.setValue(Integer.valueOf(pathID).toString());
            part = input.getPart("bitType");
            part.setValue(Integer.valueOf(bitType).toString());
            oper.getOutput(0).getPart("exceedValue").setName(this.tEBitErrThMgr.getExceedType(bitType));
            oper.getOutput(0).getPart("badValue").setName(this.tEBitErrThMgr.getBadType(bitType));
        }
        catch (Exception e) {
            log.error("Parse Qx description file fail!", (Throwable)e);
            return;
        }
        this.operationList.add(oper);
    }

    private void setLineQxData(int portID, int bitType) {
        int bitTypeTmp = bitType;
        Operation oper = null;
        try {
            TENE neObj = TENEListMgr.getInstance().getNE(this.neid);
            if (neObj != null && neObj.getNEType() == 67) {
                oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_GET_B1B2B3_TH_WBID");
                if (null == oper) {
                    log.info("The operation NSCMD_CFG_GET_B1B2B3_TH_WBID is not found!");
                    return;
                }
            } else {
                if (bitType > 50) {
                    bitTypeTmp = bitType - 50;
                    oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_GET_B1B2B3_TH_EX2");
                } else {
                    oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_GET_B1B2B3_TH");
                }
                if (null == oper) {
                    log.info("The operation NSCMD_CFG_GET_B1B2B3_TH is not found!");
                    return;
                }
            }
            Input input = oper.getInput();
            Part part = input.getPart("slotID");
            part.setValue(Integer.valueOf(this.slotID).toString());
            part = input.getPart("portID");
            part.setValue(Integer.valueOf(portID).toString());
            part = input.getPart("bitType");
            part.setValue(Integer.valueOf(bitTypeTmp).toString());
            oper.getOutput(0).getPart("exceedValue").setName(this.tEBitErrThMgr.getExceedType(bitType));
            oper.getOutput(0).getPart("badValue").setName(this.tEBitErrThMgr.getBadType(bitType));
        }
        catch (Exception e) {
            log.error("Parse Qx description file fail!", (Throwable)e);
            return;
        }
        this.operationList.add(oper);
    }

    protected boolean isSingletonLog() {
        return true;
    }

    protected String getOperateName() {
        StringBuffer filePath = new StringBuffer();
        filePath.append("necommon").append(File.separator).append(TEPathManager.RESOURCE_PROFILE_PATH).append("fault").append(File.separator).append("stringsource_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        this.res = TEGetFilePath.getResource((int)this.neid, (StringBuffer)filePath);
        return this.res.getString("QueryBitError");
    }

    public String getDetailInfo(RowParams[] rParamsArr) {
        TEConfigurationDataMgr tEConfigurationDataMgr = TEConfigurationDataMgr.getInstance();
        StringBuffer strBuf = new StringBuffer();
        strBuf.append(this.res.getString("Query"));
        String boardString = this.res.getString("board");
        strBuf.append(boardString);
        strBuf.append(this.slotID).append("-").append(tEConfigurationDataMgr.getBoardTypeName(this.neid, this.boardType));
        strBuf.append(this.res.getString("QueryBitError"));
        return strBuf.toString();
    }
}

