/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.sdh.fault;

import com.huawei.nglct.cbb.log.TECommonWriteLogBean;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEAlarmDataMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.alarm.TEBitErrorTh;
import com.huawei.nglct.nelist.model.alarm.TEPortBitErrorTh;
import com.huawei.nglct.nemgr.sdh.fault.TEBitErrThMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

public class TEApplyBitErrorBean
extends TECommonWriteLogBean {
    private static final int TIME_OUT = 10;
    private TEBitErrThMgr tEBitErrThMgr = TEBitErrThMgr.getInstance();
    private static Logger log = TELogFactory.getNormalLogger();
    private int slotID = -1;
    private int boardType = -1;
    private TEResourceUtil res = null;
    private ArrayList alarmBITThList = null;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.neid = neid;
            this.subfunc = subFunc;
            this.inputData = inputData;
            RowParams[] rParams = inputData.getBussinessParams().getRowParams();
            this.boardType = Integer.parseInt(rParams[0].getParam("boardType").getValue());
            this.slotID = Integer.parseInt(rParams[0].getParam("slotID").getValue());
            this.operationList = this.applyBitError(neid, inputData);
            int result = TENECommMgr.getInstance().sendCommand((int)neid, (List)this.operationList, (int)10).retCode;
            this.outputData = new Datainterface();
            if (result == 0) {
                this.handleMessage(neid, this.operationList, subFunc);
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
            }
            if (this.isNeedOperationlog()) {
                this.writeLog(neid, subFunc, inputData, user, ipAddress, this.outputData);
            }
        }
        catch (Exception e) {
            log.error("Apply bit error fail!", (Throwable)e);
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)2));
            return this.outputData;
        }
        return this.outputData;
    }

    private ArrayList applyBitError(int neID, Datainterface inputData) {
        this.operationList = new ArrayList();
        RowParams[] rParams = inputData.getBussinessParams().getRowParams();
        this.boardType = Integer.parseInt(rParams[0].getParam("boardType").getValue());
        this.alarmBITThList = TEAlarmDataMgr.getInstance().getBITThList(this.boardType);
        int size = rParams.length;
        for (int i = 0; i < size; ++i) {
            int portID = Integer.parseInt(rParams[i].getParam("portID").getValue());
            int pathID = Integer.parseInt(rParams[i].getParam("pathID").getValue());
            int len = this.alarmBITThList.size();
            for (int j = 0; j < len; ++j) {
                TEPortBitErrorTh tEPortBitErrorTh = (TEPortBitErrorTh)this.alarmBITThList.get(j);
                if (portID != tEPortBitErrorTh.getPortID() || pathID != tEPortBitErrorTh.getPathID()) continue;
                ArrayList bitErrorThList = tEPortBitErrorTh.getBitErrorThList();
                int length = bitErrorThList.size();
                for (int k = 0; k < length; k += 2) {
                    TEBitErrorTh tEBitErrorTh = (TEBitErrorTh)bitErrorThList.get(k);
                    int type = tEBitErrorTh.getThtype();
                    int bitType = this.tEBitErrThMgr.getBitType(type);
                    Operation oper = null;
                    if (4 == bitType) {
                        String vc3b3Exc = rParams[i].getParam("biterr_type_7").getValue();
                        String vc3b3SD = rParams[i].getParam("biterr_type_8").getValue();
                        if (vc3b3Exc.equals("") || vc3b3SD.equals("")) continue;
                        oper = this.setBranchQxData(pathID, bitType, vc3b3Exc, vc3b3SD);
                        this.operationList.add(oper);
                        continue;
                    }
                    if (5 == bitType) {
                        String Bip2Exc = rParams[i].getParam("biterr_type_9").getValue();
                        String Bip2SD = rParams[i].getParam("biterr_type_10").getValue();
                        if (Bip2Exc.equals("") || Bip2SD.equals("")) continue;
                        oper = this.setBranchQxData(pathID, bitType, Bip2Exc, Bip2SD);
                        this.operationList.add(oper);
                        continue;
                    }
                    if (6 == bitType) {
                        String IFAExc = rParams[i].getParam("biterr_type_19").getValue();
                        String IFASd = rParams[i].getParam("biterr_type_20").getValue();
                        if (IFAExc.equals("") || IFASd.equals("")) continue;
                        oper = this.setIFAQxData(portID, IFAExc, IFASd);
                        this.operationList.add(oper);
                        continue;
                    }
                    String Exc = "";
                    String SD = "";
                    switch (bitType) {
                        case 1: 
                        case 51: {
                            Exc = rParams[i].getParam("biterr_type_" + bitType).getValue();
                            SD = rParams[i].getParam("biterr_type_" + (bitType + 1)).getValue();
                            break;
                        }
                        case 2: 
                        case 52: {
                            Exc = rParams[i].getParam("biterr_type_" + (bitType + 1)).getValue();
                            SD = rParams[i].getParam("biterr_type_" + (bitType + 2)).getValue();
                            break;
                        }
                        case 3: 
                        case 53: {
                            Exc = rParams[i].getParam("biterr_type_" + (bitType + 2)).getValue();
                            SD = rParams[i].getParam("biterr_type_" + (bitType + 3)).getValue();
                            break;
                        }
                        case 55: {
                            Exc = rParams[i].getParam("biterr_type_" + (bitType + 4)).getValue();
                            SD = rParams[i].getParam("biterr_type_" + (bitType + 5)).getValue();
                            break;
                        }
                    }
                    if (Exc.equals("") || SD.equals("")) continue;
                    oper = this.setLineQxData(portID, bitType, Exc, SD);
                    this.operationList.add(oper);
                }
            }
        }
        return this.operationList;
    }

    private Operation setIFAQxData(int portID, String IFAExc, String IFASd) {
        Operation oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_SET_RADIO_BIP_TH");
        if (null == oper) {
            log.info("The operation NSCMD_CFG_SET_RADIO_BIP_TH is not found!");
            return null;
        }
        Input input = oper.getInput();
        Part part = input.getPart("slotID");
        part.setValue(String.valueOf(this.slotID));
        part = input.getPart("portID");
        part.setValue(String.valueOf(portID));
        part = input.getPart("exceedValue");
        part.setValue(IFAExc);
        part = input.getPart("badValue");
        part.setValue(IFASd);
        return oper;
    }

    private Operation setBranchQxData(int PathID, int bitType, String Bip2Exc, String Bip2SD) {
        Operation oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_SET_BIP_TH");
        if (null == oper) {
            log.info("The operation NSCMD_CFG_SET_BIP_TH is not found!");
            return null;
        }
        Input input = oper.getInput();
        Part part = input.getPart("slotID");
        part.setValue(String.valueOf(this.slotID));
        part = input.getPart("pathID");
        part.setValue(String.valueOf(PathID));
        part = input.getPart("bitType");
        part.setValue(String.valueOf(bitType));
        part = input.getPart("exceedValue");
        part.setValue(Bip2Exc);
        part = input.getPart("badValue");
        part.setValue(Bip2SD);
        return oper;
    }

    private Operation setLineQxData(int portID, int bitType, String EXC, String SD) {
        Operation oper = null;
        TENE neObj = TENEListMgr.getInstance().getNE(this.neid);
        if (neObj != null && neObj.getNEType() == 67) {
            oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_SET_B1B2B3_TH_WBID");
            if (null == oper) {
                log.info("The operation NSCMD_CFG_SET_B1B2B3_TH_WBID is not found!");
                return null;
            }
        } else {
            if (bitType > 50) {
                bitType -= 50;
                oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_SET_B1B2B3_TH_EX2");
            } else {
                oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_SET_B1B2B3_TH");
            }
            if (null == oper) {
                log.info("The operation NSCMD_CFG_SET_B1B2B3_TH is not found!");
                return null;
            }
        }
        Input input = oper.getInput();
        Part part = input.getPart("slotID");
        part.setValue(String.valueOf(this.slotID));
        part = input.getPart("portID");
        part.setValue(String.valueOf(portID));
        part = input.getPart("bitType");
        part.setValue(String.valueOf(bitType));
        part = input.getPart("exceedValue");
        part.setValue(EXC);
        part = input.getPart("badValue");
        part.setValue(SD);
        return oper;
    }

    protected String getOperateName() {
        StringBuffer filePath = new StringBuffer();
        filePath.append("necommon").append(File.separator).append(TEPathManager.RESOURCE_PROFILE_PATH).append("fault").append(File.separator).append("stringsource_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        this.res = TEGetFilePath.getResource((int)this.neid, (StringBuffer)filePath);
        return this.res.getString("ApplyBitError");
    }

    protected String getOperObj() {
        TENE neObj = TENEListMgr.getInstance().getNE(this.neid);
        String operObj = String.valueOf(this.neid);
        if (null != neObj) {
            String boardName = TEConfigurationDataMgr.getInstance().getBoardTypeName(this.neid, this.boardType);
            operObj = neObj.getNEName() + "-" + this.slotID + "(" + boardName + ")";
        }
        return operObj;
    }

    protected boolean isSingletonLog() {
        return true;
    }

    public String getDetailInfo(RowParams[] rParamsArr) {
        TEConfigurationDataMgr tEConfigurationDataMgr = TEConfigurationDataMgr.getInstance();
        StringBuffer strBuf = new StringBuffer();
        String boardString = this.res.getString("board");
        int boardType = -1;
        int slotID = -1;
        strBuf.append(boardString);
        slotID = Integer.parseInt(rParamsArr[0].getParam("slotID").getValue());
        boardType = TEConfigurationDataMgr.getInstance().getBoardType(this.neid, slotID);
        strBuf.append(slotID).append("-").append(tEConfigurationDataMgr.getBoardTypeName(this.neid, boardType));
        strBuf.append(this.res.getString("ApplyBitError"));
        return strBuf.toString();
    }
}

