/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.sdh.clocktop_u2kv1r3c00;

import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEParseXMLFile;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Option;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import com.huawei.nglct.nemgr.sdh.clock_v1r3c00.TEQueryAcrClockBean;
import com.huawei.nglct.nemgr.sdh.clock_v2r8c01.TEUsableResource;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntHashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TEGetClockDomainPortsBean
extends TENEExplorerBean {
    TEConfigurationDataMgr cfgDataMgr = TEConfigurationDataMgr.getInstance();
    public static final String cfgFile = "nemgr" + File.separator + "sdh" + File.separator + "conf" + File.separator + "clock_top" + File.separator + "clock_domain_res.xml";
    private static Map<Integer, TIntHashSet> supportMap = new HashMap<Integer, TIntHashSet>();

    private void initSupportMap() {
        Bundle bundle = FrameworkUtil.getBundle(TEGetClockDomainPortsBean.class);
        Document doc = TEParseXMLFile.parseFile((Bundle)bundle, (String)cfgFile);
        NodeList nodeList = doc.getElementsByTagName("item");
        int len = nodeList.getLength();
        for (int i = 0; i < len; ++i) {
            Node node = nodeList.item(i);
            NamedNodeMap sub_nodes = node.getAttributes();
            String neTypeId = TEGetClockDomainPortsBean.getNodeAttrValue(sub_nodes, "ne_type_id");
            String[] cptypeArray = TEGetClockDomainPortsBean.getNodeAttrValue(sub_nodes, "support_cptype_list").split(",");
            TIntHashSet cpTypeHashSet = new TIntHashSet();
            int jLength = cptypeArray.length;
            for (int j = 0; j < jLength; ++j) {
                cpTypeHashSet.add(Integer.parseInt(cptypeArray[j]));
            }
            supportMap.put(Integer.valueOf(neTypeId), cpTypeHashSet);
        }
    }

    private static TIntHashSet getSupportCPList(int neid) {
        List supportList = TESpecialAttrMgr.getInstance().getSupportCPList(neid, "TE_FUNC_TOP_CLOCKDOMAIN", "SDH_ATTR_SUPPORT_CLOCKDOMAIN_SUPPORTBD");
        TENE neObj = TENEListMgr.getInstance().getNE(neid);
        TIntHashSet kcpTypeHashSet = supportMap.get(neObj.getNEType());
        if (kcpTypeHashSet == null) {
            kcpTypeHashSet = new TIntHashSet();
        }
        TIntHashSet result = (TIntHashSet)kcpTypeHashSet.clone();
        if (!supportList.isEmpty()) {
            int klen = supportList.size();
            for (int k = 0; k < klen; ++k) {
                result.add(((Integer)supportList.get(k)).intValue());
            }
        }
        return result;
    }

    private static String getNodeAttrValue(NamedNodeMap sub_nodes, String attrName) {
        if (null == sub_nodes) {
            return "";
        }
        String value = "";
        int len1 = sub_nodes.getLength();
        for (int j = 0; j < len1; ++j) {
            Node sub_node = sub_nodes.item(j);
            String name = sub_node.getNodeName();
            value = sub_node.getNodeValue();
            if (name.equals(attrName)) break;
        }
        return value;
    }

    public ArrayList getOperation(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData) {
        TIntArrayList slotes = TEQueryAcrClockBean.getAcrClockSlot(neid);
        Operation operation = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_CFG_GET_CESTOP_SRC");
        ArrayList<Object> operationList = new ArrayList<Object>();
        int m = slotes.size();
        for (int i = 0; i < m; ++i) {
            operation.getInput().setPartValue("slotid", String.valueOf(slotes.get(i)));
            operationList.add(operation.clone());
        }
        return operationList;
    }

    private List<String> getACRServiceBoardPort(ArrayList operationList) {
        ArrayList<String> list = new ArrayList<String>();
        Operation tmpOper = null;
        Output tmpOut = null;
        TEBoard board = null;
        int m = operationList.size();
        for (int i = 0; i < m; ++i) {
            tmpOper = (Operation)operationList.get(i);
            int n = tmpOper.getOutputCount();
            for (int j = 0; j < n; ++j) {
                tmpOut = tmpOper.getOutput(j);
                if (!tmpOut.getFault(0).getCode().equals(String.valueOf(0))) continue;
                String cesindex = tmpOut.getPartValue("cesindex");
                String slotid = tmpOut.getPartValue("slotid");
                String clockindex = tmpOut.getPartValue("clockindex");
                if (cesindex.equals("0") || null == (board = this.cfgDataMgr.getBoard(this.neid, Integer.parseInt(slotid)))) continue;
                list.add(clockindex + "-" + slotid + "-" + board.getBoardName());
            }
        }
        return list;
    }

    private List<TEUsableResource> getUsableResource() {
        if (supportMap.isEmpty()) {
            this.initSupportMap();
        }
        ArrayList<TEUsableResource> usableResourceList = new ArrayList<TEUsableResource>();
        TENE ne = TENEListMgr.getInstance().getNE(this.neid);
        Vector boardList = ne.getClonedBoardList();
        Collections.sort(boardList);
        if (boardList == null || boardList.isEmpty()) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neid, (int)0));
        }
        List portList = null;
        TIntHashSet supportCPList = TEGetClockDomainPortsBean.getSupportCPList(this.neid);
        int size = boardList.size();
        for (int i = 0; i < size; ++i) {
            TEUsableResource usableRes;
            TEBoard board = (TEBoard)boardList.get(i);
            int bdType = board.getBoardType();
            if (!supportCPList.contains(bdType)) continue;
            int slotID = board.getSlotID();
            String bdName = board.getBoardName();
            boolean isBDSupport = TESpecialAttrMgr.getInstance().isCPSupportByType(bdType, "TE_FUNC_TOP_CLOCKDOMAIN", "SDH_ATTR_SUPPORT_CLOCKDOMAIN_GETPORTFUNC");
            portList = bdType == 2439 || isBDSupport ? this.cfgDataMgr.getPortListFromPortType(this.neid, bdType, 1799) : this.cfgDataMgr.getBoardPortList(this.neid, bdType);
            Collections.sort(portList);
            ArrayList<String> portNameList = new ArrayList<String>();
            ArrayList<String> portidList = new ArrayList<String>();
            int size3 = portList.size();
            for (int l = 0; l < size3; ++l) {
                int portID = (Integer)portList.get(l);
                portidList.add(l, String.valueOf(portID));
                String portName = this.cfgDataMgr.getPortNameForPTN(this.neid, slotID, bdType, portID);
                portNameList.add(l, portName);
            }
            if (portidList.isEmpty() || usableResourceList.contains((Object)(usableRes = new TEUsableResource(slotID, bdName, 255, "", portidList, portNameList)))) continue;
            usableResourceList.add(usableRes);
        }
        return usableResourceList;
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        List<String> acrList = this.getACRServiceBoardPort(operationList);
        List<TEUsableResource> usableResourceList = this.getUsableResource();
        this.outputData = this.constructRtnData(acrList, usableResourceList);
    }

    public Datainterface constructRtnData(List<String> acrList, List<TEUsableResource> usableResourceList) {
        int i;
        BussinessParams bParams = new BussinessParams();
        Datainterface datainterface = new Datainterface();
        RowParams rParams = null;
        Param param = null;
        StringBuffer boardNameArray = new StringBuffer();
        int size = acrList.size();
        for (i = 0; i < size; ++i) {
            boardNameArray.append(acrList.get(i)).append(",");
        }
        rParams = new RowParams();
        param = new Param("boardNameArray", boardNameArray.toString());
        rParams.addParam(param);
        bParams.addRowParams(rParams);
        Collections.sort(usableResourceList, new Comparator<TEUsableResource>(){

            @Override
            public int compare(TEUsableResource t1, TEUsableResource t2) {
                return t1.getSlotID() - t2.getSlotID();
            }
        });
        size = usableResourceList.size();
        for (i = 0; i < size; ++i) {
            Option option;
            int j;
            TEUsableResource res = usableResourceList.get(i);
            rParams = new RowParams();
            param = null;
            param = new Param("slotid", String.valueOf(res.getSlotID()));
            rParams.addParam(param);
            param = new Param("subslotid", String.valueOf(res.getSubslotID()));
            rParams.addParam(param);
            param = new Param("boardType", String.valueOf(this.cfgDataMgr.getBoardType(this.neid, res.getSlotID())));
            rParams.addParam(param);
            param = new Param("boardName", res.getBoardName());
            rParams.addParam(param);
            param = new Param("portid", (String)res.getPortidList().get(0));
            int size1 = res.getPortidList().size();
            for (j = 1; j < size1; ++j) {
                option = new Option((String)res.getPortidList().get(j));
                param.addOption(option);
            }
            rParams.addParam(param);
            param = res.getPortNameList().size() > 0 ? new Param("portName", (String)res.getPortNameList().get(0)) : new Param("portName", "");
            size1 = res.getPortNameList().size();
            for (j = 1; j < size1; ++j) {
                option = new Option((String)res.getPortNameList().get(j));
                param.addOption(option);
            }
            rParams.addParam(param);
            bParams.addRowParams(rParams);
        }
        datainterface.setBussinessParams(bParams);
        datainterface.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neid, (int)0));
        return datainterface;
    }

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        Datainterface data = super.performBussinessProcess(neid, subFunc, inputData, memeryData, user, ipAddress);
        if (this.operationList.isEmpty()) {
            this.handleMessage(neid, this.operationList, subFunc);
            data = this.outputData;
        }
        return data;
    }
}

