/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.sdh.clocktop.script;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.script.TEScriptCmd;
import com.huawei.nglct.cbb.script.TEScriptHandler;
import com.huawei.nglct.cbb.script.TEScriptOperationMgr;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.sdh.clocktop.db.TEClockDomainDbMgr;
import com.huawei.nglct.po.embeddednemgrmo.mstp.TESTGDomainMOPO;
import com.huawei.nglct.util.errinfo.TEErrInfoReturn;
import java.util.List;
import org.slf4j.Logger;

public class TEClockDomainScriptHandler
implements TEScriptHandler {
    private static final Logger logger = TELogFactory.getNormalLogger();

    public int doExport(int neID, int item) {
        int result = 0;
        if (!TENEListMgr.getInstance().isAddedNE(neID)) {
            return result;
        }
        return this.writeExportDataToScript(neID, item);
    }

    private int writeExportDataToScript(int neID, int item) {
        TEErrInfoReturn errRet = new TEErrInfoReturn();
        List<TESTGDomainMOPO> stgDomainMOList = TEClockDomainDbMgr.getStgDomainMOFromDB(neID, errRet);
        if (0 != errRet.getResult()) {
            return 1092743443;
        }
        if (null == stgDomainMOList || stgDomainMOList.isEmpty()) {
            logger.info("stgDomainMOList is null! neID->" + neID);
            return 0;
        }
        for (TESTGDomainMOPO mo : stgDomainMOList) {
            TEScriptCmd cmd = this.constractScriptCmd(mo, item);
            if (null == cmd) continue;
            TEScriptOperationMgr.getInstance().writeCommand(neID, item, cmd);
        }
        return 0;
    }

    private TEScriptCmd constractScriptCmd(TESTGDomainMOPO mo, int item) {
        TEScriptCmd cmd = new TEScriptCmd();
        cmd.setCmdCode(item);
        int board = mo.getSlotID();
        int subbd = mo.getSubCardID();
        int port = mo.getPortID();
        int clockDomainSlotID = mo.getClockDomainSlotID();
        int clockDomain = mo.getClockDomainID();
        cmd.addPara("stgbd", clockDomainSlotID, false, false);
        cmd.addPara("board", board, false, false);
        cmd.addPara("subbd", subbd, false, false);
        cmd.addPara("port", port, false, false);
        cmd.addPara("stgdomainid", clockDomain, false, false);
        return cmd;
    }

    public int doImport(int neID, int item, List<TEScriptCmd> contents) {
        return 0;
    }
}

