/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.sdh.clocktop.db;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.explorer.beanplugin.TEBeanPluginLog;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.po.embeddednemgrmo.mstp.TESTGDomainMOPO;
import com.huawei.nglct.util.errinfo.TEErrInfo;
import com.huawei.nglct.util.errinfo.TEErrInfoReturn;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

public class TEClockDomainDbMgr {
    public static final String UNKNOWN = "UNKNOWN";
    private static final Logger logger = TELogFactory.getNormalLogger();

    private TEClockDomainDbMgr() {
    }

    public static List<TESTGDomainMOPO> getStgDomainMOFromDB(int neID, TEErrInfoReturn errRet) {
        String FUNC_NAME = "TEClockDomainDbMgr.getStgDomainMOFromDB";
        TEBeanPluginLog.logFuncBegin((String)"TEClockDomainDbMgr.getStgDomainMOFromDB");
        if (null == errRet) {
            errRet = new TEErrInfoReturn();
        }
        TEDaoOperationResult dbResult = null;
        ArrayList<TESTGDomainMOPO> moList = new ArrayList<TESTGDomainMOPO>();
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            if (null == ne) {
                TEClockDomainDbMgr.logNullNEError(neID);
                TEClockDomainDbMgr.setOperFail(neID, errRet, 1090596385);
                TEBeanPluginLog.logFuncEnd((String)"TEClockDomainDbMgr.getStgDomainMOFromDB");
                return moList;
            }
            dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.findAll((int[])new int[]{neID}, TESTGDomainMOPO.class) : TECommonDaoService.findAll_NonLock((int[])new int[]{neID}, TESTGDomainMOPO.class);
        }
        catch (Exception e) {
            TEClockDomainDbMgr.logExceptionOnGet(neID, e);
            TEClockDomainDbMgr.setOperFail(neID, errRet, 1092743443);
            TEBeanPluginLog.logFuncEnd((String)"TEClockDomainDbMgr.getStgDomainMOFromDB");
            return moList;
        }
        if (null == dbResult) {
            TEClockDomainDbMgr.logNullErrorOnGet(neID);
            TEClockDomainDbMgr.setOperFail(neID, errRet, 1092743443);
            TEBeanPluginLog.logFuncEnd((String)"TEClockDomainDbMgr.getStgDomainMOFromDB");
            return moList;
        }
        int retCode = dbResult.getResult();
        if (0 == retCode) {
            List data = dbResult.getData();
            if (null != data && !data.isEmpty()) {
                for (Object obj : data) {
                    moList.add((TESTGDomainMOPO)obj);
                }
            }
        } else {
            TEClockDomainDbMgr.logRetCodeErrorOnGet(neID, retCode);
            TEClockDomainDbMgr.setOperFail(neID, errRet, retCode);
        }
        TEBeanPluginLog.logFuncEnd((String)"TEClockDomainDbMgr.getStgDomainMOFromDB");
        return moList;
    }

    public static void updateStgDomainMOToDB(int neID, TESTGDomainMOPO tpidMO, TEErrInfoReturn errRet_rep1) {
        String FUNC_NAME_rep1 = "TEClockDomainDbMgr.updateStgDomainMOToDB";
        TEBeanPluginLog.logFuncBegin((String)"TEClockDomainDbMgr.updateStgDomainMOToDB");
        if (null == tpidMO) {
            return;
        }
        if (null == errRet_rep1) {
            errRet_rep1 = new TEErrInfoReturn();
        }
        TEDaoOperationResult dbResult_rep1 = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            dbResult_rep1 = ne.isDataCfgStausNeedLock() ? TECommonDaoService.update((int[])new int[]{neID}, (Object)tpidMO) : TECommonDaoService.update_NonLock((int[])new int[]{neID}, (Object)tpidMO);
        }
        catch (Exception e) {
            TEClockDomainDbMgr.logExceptionErrorOnUpdate(neID, e);
            TEClockDomainDbMgr.setOperFail(neID, errRet_rep1, 1092743443);
            TEBeanPluginLog.logFuncEnd((String)"TEClockDomainDbMgr.updateStgDomainMOToDB");
            return;
        }
        if (null == dbResult_rep1) {
            TEClockDomainDbMgr.logNullErrorOnUpdate(neID);
            TEClockDomainDbMgr.setOperFail(neID, errRet_rep1, 1092743443);
            TEBeanPluginLog.logFuncEnd((String)"TEClockDomainDbMgr.updateStgDomainMOToDB");
            return;
        }
        int retCode = dbResult_rep1.getResult();
        if (0 != retCode) {
            TEClockDomainDbMgr.logRetCodeErrorOnUpdate(neID, retCode);
            TEClockDomainDbMgr.setOperFail(neID, errRet_rep1, retCode);
        }
        TEBeanPluginLog.logFuncEnd((String)"TEClockDomainDbMgr.updateStgDomainMOToDB");
    }

    public static void createStgDomainMOToDB(int neID, TESTGDomainMOPO tpidMO, TEErrInfoReturn errRet_rep1) {
        String FUNC_NAME_rep1 = "TEClockDomainDbMgr.createStgDomainMOToDB";
        TEBeanPluginLog.logFuncBegin((String)"TEClockDomainDbMgr.createStgDomainMOToDB");
        if (null == tpidMO) {
            return;
        }
        if (null == errRet_rep1) {
            errRet_rep1 = new TEErrInfoReturn();
        }
        TEDaoOperationResult dbResult_rep1 = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            dbResult_rep1 = ne.isDataCfgStausNeedLock() ? TECommonDaoService.create((int[])new int[]{neID}, (Object)tpidMO) : TECommonDaoService.create_NonLock((int[])new int[]{neID}, (Object)tpidMO);
        }
        catch (Exception e) {
            TEClockDomainDbMgr.logExceptionErrorOnCreate(neID, e);
            TEClockDomainDbMgr.setOperFail(neID, errRet_rep1, 1092743443);
            TEBeanPluginLog.logFuncEnd((String)"TEClockDomainDbMgr.createStgDomainMOToDB");
            return;
        }
        if (null == dbResult_rep1) {
            TEClockDomainDbMgr.logNullErrorOnCreate(neID);
            TEClockDomainDbMgr.setOperFail(neID, errRet_rep1, 1092743443);
            TEBeanPluginLog.logFuncEnd((String)"TEClockDomainDbMgr.createStgDomainMOToDB");
            return;
        }
        int retCode = dbResult_rep1.getResult();
        if (0 != retCode) {
            TEClockDomainDbMgr.logRetCodeErrorOnCreate(neID, retCode);
            TEClockDomainDbMgr.setOperFail(neID, errRet_rep1, retCode);
        }
        TEBeanPluginLog.logFuncEnd((String)"TEClockDomainDbMgr.createStgDomainMOToDB");
    }

    public static void delClockDomainMOToDB(int neID, TESTGDomainMOPO stgDomainMO, TEErrInfoReturn errRetDomain) {
        String FUNC_NAME = "TEClockDomainDbMgr.delClockDomainMOToDB";
        TEBeanPluginLog.logFuncBegin((String)"TEClockDomainDbMgr.delClockDomainMOToDB");
        if (null == stgDomainMO) {
            return;
        }
        if (null == errRetDomain) {
            errRetDomain = new TEErrInfoReturn();
        }
        TEDaoOperationResult dbResult = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.delete((int[])new int[]{neID}, (Object)stgDomainMO) : TECommonDaoService.delete_NonLock((int[])new int[]{neID}, (Object)stgDomainMO);
        }
        catch (Exception ex) {
            TEClockDomainDbMgr.logExceptionErrorOnDel(neID, ex);
            TEClockDomainDbMgr.setOperFail(neID, errRetDomain, 1092743443);
            TEBeanPluginLog.logFuncEnd((String)"TEClockDomainDbMgr.delClockDomainMOToDB");
            return;
        }
        if (null == dbResult) {
            TEClockDomainDbMgr.logNullErrorOnDel(neID);
            TEClockDomainDbMgr.setOperFail(neID, errRetDomain, 1092743443);
            TEBeanPluginLog.logFuncEnd((String)"TEClockDomainDbMgr.delClockDomainMOToDB");
            return;
        }
        int retCode = dbResult.getResult();
        if (0 != retCode) {
            TEClockDomainDbMgr.logRetCodeErrorOnDel(neID, retCode);
            TEClockDomainDbMgr.setOperFail(neID, errRetDomain, retCode);
        }
        TEBeanPluginLog.logFuncEnd((String)"TEClockDomainDbMgr.delClockDomainMOToDB");
    }

    private static void setOperFail(int neID, TEErrInfoReturn rspErrRet, int retCode1) {
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        String neName = ne.getNEName();
        rspErrRet.setResult(1090605056);
        rspErrRet.addErrInfo(TEClockDomainDbMgr.constructErrInfoReturn(new int[]{neID}, new String[]{neName}, retCode1).getErrList());
    }

    public static TEErrInfoReturn constructErrInfoReturn(int neID, int errorCode1) {
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        String neName = UNKNOWN;
        if (null != ne) {
            neName = ne.getNEName();
        }
        return TEClockDomainDbMgr.constructErrInfoReturn(new int[]{neID}, new String[]{neName}, errorCode1);
    }

    public static TEErrInfoReturn constructErrInfoReturn(int[] objID, String[] objName1, int retCode) {
        TEErrInfoReturn errRet = new TEErrInfoReturn();
        errRet.setResult(2);
        TEErrInfo errInfo = new TEErrInfo();
        errInfo.setObjID(objID);
        errInfo.setObjName(TEClockDomainDbMgr.getObjName(objName1));
        errInfo.setErrorCode(retCode);
        errRet.addErrInfo(errInfo);
        return errRet;
    }

    public static String getObjName(String[] objName1) {
        StringBuffer objNameBuffer = new StringBuffer();
        int len = objName1.length;
        for (int i = 0; i < len; ++i) {
            if (0 != i) {
                objNameBuffer.append('-');
            }
            objNameBuffer.append(objName1[i]);
        }
        return objNameBuffer.toString();
    }

    private static void logNullNEError(int neID) {
        logger.error("ne is null! neID->" + neID);
    }

    private static void logRetCodeErrorOnGet(int neID, int retCode1) {
        String tipStr = String.format("get mo from db device fail! neID:%d, retCode:%d", neID, retCode1);
        logger.error(tipStr);
    }

    private static void logNullErrorOnGet(int neID) {
        logger.error("get mo from db fail! dbResult is null! neID->" + neID);
    }

    private static void logExceptionOnGet(int neID, Exception ex) {
        logger.error("get mo from db fail! neID->" + neID, (Throwable)ex);
    }

    private static void logRetCodeErrorOnUpdate(int neID, int retCode1) {
        String tipStr = String.format("update mo to db device fail! neID:%d, retCode:%d", neID, retCode1);
        logger.error(tipStr);
    }

    private static void logNullErrorOnUpdate(int neID) {
        logger.error("update mo to db device fail! dbResult is null! neID->" + neID);
    }

    private static void logExceptionErrorOnUpdate(int neID, Exception ex) {
        logger.error("update mo to db device fail! neID->" + neID, (Throwable)ex);
    }

    private static void logNullErrorOnCreate(int neID) {
        logger.error("create mo to db device fail! neID->" + neID);
    }

    private static void logExceptionErrorOnCreate(int neID, Exception ex) {
        logger.error("create mo to db device fail! neID->" + neID, (Throwable)ex);
    }

    private static void logRetCodeErrorOnCreate(int neID, int retCode1) {
        String tipStr = String.format("create mo to db device fail! neID:%d, retCode:%d", neID, retCode1);
        logger.error(tipStr);
    }

    private static void logNullErrorOnDel(int neID) {
        logger.error("delete mo to db device fail! neID->" + neID);
    }

    private static void logExceptionErrorOnDel(int neID, Exception ex) {
        logger.error("delete mo to db device fail! neID->" + neID, (Throwable)ex);
    }

    private static void logRetCodeErrorOnDel(int neID, int retCode1) {
        String tipStr = String.format("delete mo to db device fail! neID:%d, retCode:%d", neID, retCode1);
        logger.error(tipStr);
    }
}

