/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.sdh.clocktop.beanplugin;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.beanplugin.TEBeanPlugin;
import com.huawei.nglct.explorer.beanplugin.TEBeanPluginUtil;
import com.huawei.nglct.nemgr.sdh.clocktop.db.TEClockDomainDbMgr;
import com.huawei.nglct.po.embeddednemgrmo.mstp.TESTGDomainMOPO;
import com.huawei.nglct.util.errinfo.TEErrInfoReturn;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.List;
import org.slf4j.Logger;

public class TEQueryClockDomainBeanPlugin
extends TEBeanPlugin {
    private static final Logger logger = TELogFactory.getNormalLogger();

    public TEErrInfoReturn doAfterSendMessage(int neid, SubFunc subFunc, List<Operation> operationList) {
        TEErrInfoReturn errRet = new TEErrInfoReturn();
        String operName = null;
        for (Operation oper : operationList) {
            operName = oper.getName();
            if (!TEBeanPluginUtil.isOperSuccess((Operation)oper) || !"NSCMD_CFG_STGDOMAIN_GETINFO".equals(operName)) continue;
            TEErrInfoReturn tempErrRet = new TEErrInfoReturn();
            this.handleNSCMD_CFG_STGDOMAIN_GETINFO(neid, oper, tempErrRet);
            if (0 == tempErrRet.getResult()) continue;
            errRet.setResult(2);
            errRet.addErrInfo(tempErrRet.getErrList());
        }
        return errRet;
    }

    private void handleNSCMD_CFG_STGDOMAIN_GETINFO(int neID, Operation oper, TEErrInfoReturn errRet) {
        if (!TEBeanPluginUtil.isOperSuccess((Operation)oper)) {
            TEBeanPluginUtil.fillErrorToOperation((Operation)oper, (TEErrInfoReturn)errRet);
            return;
        }
        List<TESTGDomainMOPO> clockDomainMOList = TEClockDomainDbMgr.getStgDomainMOFromDB(neID, errRet);
        if (0 != errRet.getResult()) {
            return;
        }
        for (TESTGDomainMOPO mo : clockDomainMOList) {
            TEClockDomainDbMgr.delClockDomainMOToDB(neID, mo, errRet);
            if (0 == errRet.getResult()) continue;
            return;
        }
        for (Output output : oper.getOutput()) {
            int clockDomainSlotid = TEBeanPluginUtil.getOutputPartValueInt((Output)output, (String)"clockDomainSlotid", (int)-1);
            int clockDomain = TEBeanPluginUtil.getOutputPartValueInt((Output)output, (String)"clockDomain", (int)-1);
            int slotid = TEBeanPluginUtil.getOutputPartValueInt((Output)output, (String)"slotid", (int)-1);
            int subslotid = TEBeanPluginUtil.getOutputPartValueInt((Output)output, (String)"subslotid", (int)-1);
            int port = TEBeanPluginUtil.getOutputPartValueInt((Output)output, (String)"port", (int)-1);
            if (-1 == clockDomain) {
                logger.info("clockDomain is invalid! will not set to db!");
                return;
            }
            TESTGDomainMOPO clockDomainMO = new TESTGDomainMOPO();
            clockDomainMO.setClockDomainSlotID(clockDomainSlotid);
            clockDomainMO.setClockDomainID(clockDomain);
            clockDomainMO.setSlotID(slotid);
            clockDomainMO.setSubCardID(subslotid);
            clockDomainMO.setPortID(port);
            TEClockDomainDbMgr.createStgDomainMOToDB(neID, clockDomainMO, errRet);
            TEBeanPluginUtil.fillErrorToOperation((Operation)oper, (TEErrInfoReturn)errRet);
        }
    }
}

