/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.sdh.clocktop;

import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;

public class TEQueryClockDomain
extends TENEExplorerBean {
    private ArrayList processingBoardList = new ArrayList();
    private static final int BDTYPE_SSR1ML1 = 2125;
    private static final int BDTYPE_SS48CXP = 226;
    private static final List<Integer> NETYPE_SUPPURT_4LINECLOCKSOURCE = new ArrayList<Integer>();

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        int i;
        this.neid = neid;
        TENE ne = TENEListMgr.getInstance().getNE(neid);
        int neType = ne.getNEType();
        BussinessParams bussinessParams = inputData.getBussinessParams();
        RowParams rowParams = null;
        rowParams = new RowParams();
        rowParams.addParam("clockDomainSlotid", "65535");
        rowParams.addParam("clockDomain", "1");
        rowParams.addParam("isNoLog", "1");
        bussinessParams.addRowParams(rowParams);
        this.getProcessingBoard();
        boolean isNESupport = TESpecialAttrMgr.getInstance().isNESupport(neid, "TE_FUNC_TOP_CLOCKDOMAIN", "SDH_ATTR_SUPPORT_CLOCKDOMAIN_4LINESOURCE");
        int len = this.processingBoardList.size();
        for (i = 0; i < len; ++i) {
            rowParams = new RowParams();
            rowParams.addParam("clockDomainSlotid", (String)this.processingBoardList.get(i));
            rowParams.addParam("clockDomain", "2");
            rowParams.addParam("isNoLog", "1");
            bussinessParams.addRowParams(rowParams);
            rowParams = new RowParams();
            rowParams.addParam("clockDomainSlotid", (String)this.processingBoardList.get(i));
            rowParams.addParam("clockDomain", "3");
            rowParams.addParam("isNoLog", "1");
            bussinessParams.addRowParams(rowParams);
            if (!NETYPE_SUPPURT_4LINECLOCKSOURCE.contains(neType) && !isNESupport) continue;
            rowParams = new RowParams();
            rowParams.addParam("clockDomainSlotid", (String)this.processingBoardList.get(i));
            rowParams.addParam("clockDomain", "4");
            rowParams.addParam("isNoLog", "1");
            bussinessParams.addRowParams(rowParams);
            rowParams = new RowParams();
            rowParams.addParam("clockDomainSlotid", (String)this.processingBoardList.get(i));
            rowParams.addParam("clockDomain", "5");
            rowParams.addParam("isNoLog", "1");
            bussinessParams.addRowParams(rowParams);
        }
        if (!NETYPE_SUPPURT_4LINECLOCKSOURCE.contains(neType) && !isNESupport) {
            for (i = 6; i < 10; ++i) {
                rowParams = new RowParams();
                rowParams.addParam("clockDomainSlotid", "65535");
                rowParams.addParam("clockDomain", i + "");
                rowParams.addParam("isNoLog", "1");
                bussinessParams.addRowParams(rowParams);
            }
        }
        return super.performBussinessProcess(neid, subFunc, inputData, memeryData, user, ipAddress);
    }

    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        super.writeLog(neid, subfunc, this.getWriteLogInputData(inputData), user, ipAddress, outputData);
    }

    private Datainterface getWriteLogInputData(Datainterface inputData) {
        Datainterface newData = new Datainterface();
        BussinessParams newBussinessParams = new BussinessParams();
        newData.setBussinessParams(newBussinessParams);
        if (null == inputData || null == inputData.getBussinessParams()) {
            return inputData;
        }
        ArrayList rowparamsList = inputData.getBussinessParams().getRowParamList();
        int paramSize = rowparamsList.size();
        if (0 == paramSize || 1 == paramSize) {
            return inputData;
        }
        newBussinessParams.addRowParams((RowParams)((RowParams)rowparamsList.get(0)).clone());
        return newData;
    }

    private void getProcessingBoard() {
        TENE ne = TENEListMgr.getInstance().getNE(this.neid);
        Vector boardList = ne.getClonedBoardList();
        Collections.sort(boardList);
        int size = boardList.size();
        for (int i = 0; i < size; ++i) {
            TEBoard board = (TEBoard)boardList.get(i);
            String slotidStr = board.getSlotID() + "";
            if (this.processingBoardList.contains(slotidStr)) continue;
            this.processingBoardList.add(slotidStr);
        }
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        TENE ne = TENEListMgr.getInstance().getNE(neid);
        int neType = ne.getNEType();
        this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList, (ArrayList)filterErrorCodeList);
        TEConfigurationDataMgr cfgDataMgr = TEConfigurationDataMgr.getInstance();
        if (!this.outputData.getErrorMessage().getErrorcode().equals(1090605056)) {
            for (RowParams rowParam : this.outputData.getBussinessParams().getRowParams()) {
                Param lowpathParam;
                Param highpathParam;
                if (rowParam.getParamCount() == 0) continue;
                int clockDomainSlotid = Integer.parseInt(rowParam.getParam("clockDomainSlotid").getValue());
                rowParam.addParam("hideClockDomainSlotid", rowParam.getParam("clockDomainSlotid").getValue());
                int slotId = Integer.parseInt(rowParam.getParam("slotid").getValue());
                int port = Integer.parseInt(rowParam.getParam("port").getValue());
                TEBoard board = cfgDataMgr.getBoard(neid, slotId);
                int boardType = -1;
                if (board != null) {
                    boardType = board.getBoardType();
                }
                String portName = cfgDataMgr.getPortNameForPTN(neid, slotId, boardType, port);
                if (boardType == 226 && neType == 37) {
                    portName = cfgDataMgr.getPortNameForSDH(neid, slotId, boardType, port - 10);
                }
                if (boardType == 2125 && neType == 36) {
                    portName = cfgDataMgr.getPortNameForSDH(neid, slotId, boardType, port);
                }
                if (null != (highpathParam = rowParam.getParam("highpath")) && !"".equals(highpathParam.getValue()) && Integer.valueOf(highpathParam.getValue()) != -1) {
                    portName = portName + "-VC4:" + rowParam.getParam("highpath").getValue();
                }
                if (null != (lowpathParam = rowParam.getParam("lowpath")) && !"".equals(lowpathParam.getValue()) && Integer.valueOf(lowpathParam.getValue()) != -1) {
                    portName = portName + "-VC12:" + rowParam.getParam("lowpath").getValue();
                }
                rowParam.getParam("portname").setValue(portName);
                if (clockDomainSlotid != 255 && clockDomainSlotid != 65535) {
                    String boardName = cfgDataMgr.getBoardTypeName(neid, cfgDataMgr.getBoardType(neid, clockDomainSlotid));
                    rowParam.addParam("clockDomainSlotidName", boardName);
                    continue;
                }
                rowParam.getParam("clockDomainSlotid").setValue("/");
                rowParam.addParam("clockDomainSlotidName", "");
            }
        }
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        if (this.subfunc != null && this.subfunc.getFilterErrCodeList() != null && !this.subfunc.getFilterErrCodeList().isEmpty()) {
            list.addAll(this.subfunc.getFilterErrCodeList());
        }
        list.add(43324);
        return list;
    }

    static {
        NETYPE_SUPPURT_4LINECLOCKSOURCE.add(76);
        NETYPE_SUPPURT_4LINECLOCKSOURCE.add(77);
        NETYPE_SUPPURT_4LINECLOCKSOURCE.add(114);
        NETYPE_SUPPURT_4LINECLOCKSOURCE.add(83);
        NETYPE_SUPPURT_4LINECLOCKSOURCE.add(95);
        NETYPE_SUPPURT_4LINECLOCKSOURCE.add(29);
        NETYPE_SUPPURT_4LINECLOCKSOURCE.add(36);
        NETYPE_SUPPURT_4LINECLOCKSOURCE.add(41);
        NETYPE_SUPPURT_4LINECLOCKSOURCE.add(37);
        NETYPE_SUPPURT_4LINECLOCKSOURCE.add(82);
        NETYPE_SUPPURT_4LINECLOCKSOURCE.add(81);
        NETYPE_SUPPURT_4LINECLOCKSOURCE.add(62);
        NETYPE_SUPPURT_4LINECLOCKSOURCE.add(67);
    }
}

