/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.sdh.clockptp.script;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.script.TEScriptCmd;
import com.huawei.nglct.cbb.script.TEScriptHandler;
import com.huawei.nglct.cbb.script.TEScriptOperationMgr;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.sdh.clockptp.db.TEPTPExtClockDbMgr;
import com.huawei.nglct.po.embeddednemgrmo.mstp.TEExtClockPortMOPO;
import com.huawei.nglct.util.errinfo.TEErrInfoReturn;
import java.util.List;
import org.slf4j.Logger;

public class TEPTPExtClockScriptHandler
implements TEScriptHandler {
    private static final Logger logger = TELogFactory.getNormalLogger();

    public int doExport(int neID, int item) {
        int result = 0;
        if (!TENEListMgr.getInstance().isAddedNE(neID)) {
            return result;
        }
        return this.writeExportDataToScript(neID, item);
    }

    private int writeExportDataToScript(int neID, int item) {
        TEErrInfoReturn errRet = new TEErrInfoReturn();
        List<TEExtClockPortMOPO> extClockPortMOList = TEPTPExtClockDbMgr.getExtClockPortMOFromDB(neID, errRet);
        if (0 != errRet.getResult()) {
            return 1092743443;
        }
        if (null == extClockPortMOList || extClockPortMOList.isEmpty()) {
            logger.info("vplsInfoMO is null! neID->" + neID);
            return 0;
        }
        for (TEExtClockPortMOPO mo : extClockPortMOList) {
            TEScriptCmd cmd = this.constractScriptCmd(mo, item);
            if (null == cmd) continue;
            TEScriptOperationMgr.getInstance().writeCommand(neID, item, cmd);
        }
        return 0;
    }

    private TEScriptCmd constractScriptCmd(TEExtClockPortMOPO mo, int item) {
        TEScriptCmd cmd = new TEScriptCmd();
        cmd.setCmdCode(item);
        int board = mo.getSlotID();
        int subbd = mo.getSubCardID();
        int port = mo.getPortID();
        int extinfmode = mo.getExtInfMode();
        int inoutputmode = mo.getInOutputMode();
        int ifprotocolmode = mo.getIfptlMode();
        int ifvoltage = mo.getIfvoltage();
        int r_cablemode = mo.getRCableMode();
        long r_cabledistance = mo.getRCableDistance();
        int s_cablemode = mo.getSCableMode();
        long s_cabledistance = mo.getSCableDistance();
        cmd.addPara("board", board, false, false);
        cmd.addPara("subbd", subbd, false, false);
        cmd.addPara("port", port, false, false);
        cmd.addPara("extinfmode", extinfmode, false, false);
        cmd.addPara("inoutputmode", inoutputmode, false, false);
        cmd.addPara("ifprotocolmode", ifprotocolmode, false, false);
        cmd.addPara("ifvoltage", ifvoltage, false, false);
        cmd.addPara("r_cablemode", r_cablemode, false, false);
        cmd.addPara("r_cabledistance", (int)r_cabledistance, false, false);
        cmd.addPara("s_cablemode", s_cablemode, false, false);
        cmd.addPara("s_cabledistance", (int)s_cabledistance, false, false);
        return cmd;
    }

    public int doImport(int neID, int item, List<TEScriptCmd> contents) {
        return 0;
    }
}

