/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.sdh.clockptp.db;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.explorer.beanplugin.TEBeanPluginLog;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.po.embeddednemgrmo.mstp.TEExtClockPortMOPO;
import com.huawei.nglct.util.errinfo.TEErrInfo;
import com.huawei.nglct.util.errinfo.TEErrInfoReturn;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

public class TEPTPExtClockDbMgr {
    public static final String UNKNOWN = "UNKNOWN";
    private static final Logger logger = TELogFactory.getNormalLogger();

    private TEPTPExtClockDbMgr() {
    }

    public static List<TEExtClockPortMOPO> getExtClockPortMOFromDB(int neID, TEErrInfoReturn errRet) {
        String FUNC_NAME = "TEPTPExtClockDbMgr.getExtClockPortMOFromDB";
        TEBeanPluginLog.logFuncBegin((String)"TEPTPExtClockDbMgr.getExtClockPortMOFromDB");
        if (null == errRet) {
            errRet = new TEErrInfoReturn();
        }
        TEDaoOperationResult dbResult = null;
        ArrayList<TEExtClockPortMOPO> moList = new ArrayList<TEExtClockPortMOPO>();
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            if (null == ne) {
                TEPTPExtClockDbMgr.logNullNEError(neID);
                TEPTPExtClockDbMgr.setOperFail(neID, errRet, 1090596385);
                TEBeanPluginLog.logFuncEnd((String)"TEPTPExtClockDbMgr.getExtClockPortMOFromDB");
                return moList;
            }
            dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.findAll((int[])new int[]{neID}, TEExtClockPortMOPO.class) : TECommonDaoService.findAll_NonLock((int[])new int[]{neID}, TEExtClockPortMOPO.class);
        }
        catch (Exception e) {
            TEPTPExtClockDbMgr.logExceptionOnGet(neID, e);
            TEPTPExtClockDbMgr.setOperFail(neID, errRet, 1092743443);
            TEBeanPluginLog.logFuncEnd((String)"TEPTPExtClockDbMgr.getExtClockPortMOFromDB");
            return moList;
        }
        if (null == dbResult) {
            TEPTPExtClockDbMgr.logNullErrorOnGet(neID);
            TEPTPExtClockDbMgr.setOperFail(neID, errRet, 1092743443);
            TEBeanPluginLog.logFuncEnd((String)"TEPTPExtClockDbMgr.getExtClockPortMOFromDB");
            return moList;
        }
        int retCode = dbResult.getResult();
        if (0 == retCode) {
            List data = dbResult.getData();
            if (null != data && !data.isEmpty()) {
                for (Object obj : data) {
                    moList.add((TEExtClockPortMOPO)obj);
                }
            }
        } else {
            TEPTPExtClockDbMgr.logRetCodeErrorOnGet(neID, retCode);
            TEPTPExtClockDbMgr.setOperFail(neID, errRet, retCode);
        }
        TEBeanPluginLog.logFuncEnd((String)"TEPTPExtClockDbMgr.getExtClockPortMOFromDB");
        return moList;
    }

    public static void updateExtClockPortMOToDB(int neID, TEExtClockPortMOPO extClockPortMO, TEErrInfoReturn errRet) {
        String FUNC_NAME = "TEPTPExtClockDbMgr.updateExtClockPortMOToDB";
        TEBeanPluginLog.logFuncBegin((String)"TEPTPExtClockDbMgr.updateExtClockPortMOToDB");
        if (null == extClockPortMO) {
            return;
        }
        if (null == errRet) {
            errRet = new TEErrInfoReturn();
        }
        TEDaoOperationResult dbResult = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.update((int[])new int[]{neID}, (Object)extClockPortMO) : TECommonDaoService.update_NonLock((int[])new int[]{neID}, (Object)extClockPortMO);
        }
        catch (Exception e) {
            TEPTPExtClockDbMgr.logExceptionErrorOnUpdate(neID, e);
            TEPTPExtClockDbMgr.setOperFail(neID, errRet, 1092743443);
            TEBeanPluginLog.logFuncEnd((String)"TEPTPExtClockDbMgr.updateExtClockPortMOToDB");
            return;
        }
        if (null == dbResult) {
            TEPTPExtClockDbMgr.logNullErrorOnUpdate(neID);
            TEPTPExtClockDbMgr.setOperFail(neID, errRet, 1092743443);
            TEBeanPluginLog.logFuncEnd((String)"TEPTPExtClockDbMgr.updateExtClockPortMOToDB");
            return;
        }
        int retCode = dbResult.getResult();
        if (0 != retCode) {
            TEPTPExtClockDbMgr.logRetCodeErrorOnUpdate(neID, retCode);
            TEPTPExtClockDbMgr.setOperFail(neID, errRet, retCode);
        }
        TEBeanPluginLog.logFuncEnd((String)"TEPTPExtClockDbMgr.updateExtClockPortMOToDB");
    }

    public static void createExtClockPortMOToDB(int neID, TEExtClockPortMOPO extClockPortMO, TEErrInfoReturn errRet) {
        String FUNC_NAME = "TEPTPExtClockDbMgr.createExtClockPortMOToDB";
        TEBeanPluginLog.logFuncBegin((String)"TEPTPExtClockDbMgr.createExtClockPortMOToDB");
        if (null == extClockPortMO) {
            return;
        }
        if (null == errRet) {
            errRet = new TEErrInfoReturn();
        }
        TEDaoOperationResult dbResult = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.create((int[])new int[]{neID}, (Object)extClockPortMO) : TECommonDaoService.create_NonLock((int[])new int[]{neID}, (Object)extClockPortMO);
        }
        catch (Exception e) {
            TEPTPExtClockDbMgr.logExceptionErrorOnCreate(neID, e);
            TEPTPExtClockDbMgr.setOperFail(neID, errRet, 1092743443);
            TEBeanPluginLog.logFuncEnd((String)"TEPTPExtClockDbMgr.createExtClockPortMOToDB");
            return;
        }
        if (null == dbResult) {
            TEPTPExtClockDbMgr.logNullErrorOnCreate(neID);
            TEPTPExtClockDbMgr.setOperFail(neID, errRet, 1092743443);
            TEBeanPluginLog.logFuncEnd((String)"TEPTPExtClockDbMgr.createExtClockPortMOToDB");
            return;
        }
        int retCode = dbResult.getResult();
        if (0 != retCode) {
            TEPTPExtClockDbMgr.logRetCodeErrorOnCreate(neID, retCode);
            TEPTPExtClockDbMgr.setOperFail(neID, errRet, retCode);
        }
        TEBeanPluginLog.logFuncEnd((String)"TEPTPExtClockDbMgr.createExtClockPortMOToDB");
    }

    public static void delExtClockPortMOToDB(int neID, TEExtClockPortMOPO extClockPortMO, TEErrInfoReturn errRet) {
        String FUNC_NAME = "TEPTPExtClockDbMgr.delExtClockPortMOToDB";
        TEBeanPluginLog.logFuncBegin((String)"TEPTPExtClockDbMgr.delExtClockPortMOToDB");
        if (null == extClockPortMO) {
            return;
        }
        if (null == errRet) {
            errRet = new TEErrInfoReturn();
        }
        TEDaoOperationResult dbResult = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.delete((int[])new int[]{neID}, (Object)extClockPortMO) : TECommonDaoService.delete_NonLock((int[])new int[]{neID}, (Object)extClockPortMO);
        }
        catch (Exception e) {
            TEPTPExtClockDbMgr.logExceptionErrorOnDel(neID, e);
            TEPTPExtClockDbMgr.setOperFail(neID, errRet, 1092743443);
            TEBeanPluginLog.logFuncEnd((String)"TEPTPExtClockDbMgr.delExtClockPortMOToDB");
            return;
        }
        if (null == dbResult) {
            TEPTPExtClockDbMgr.logNullErrorOnDel(neID);
            TEPTPExtClockDbMgr.setOperFail(neID, errRet, 1092743443);
            TEBeanPluginLog.logFuncEnd((String)"TEPTPExtClockDbMgr.delExtClockPortMOToDB");
            return;
        }
        int retCode = dbResult.getResult();
        if (0 != retCode) {
            TEPTPExtClockDbMgr.logRetCodeErrorOnDel(neID, retCode);
            TEPTPExtClockDbMgr.setOperFail(neID, errRet, retCode);
        }
        TEBeanPluginLog.logFuncEnd((String)"TEPTPExtClockDbMgr.delExtClockPortMOToDB");
    }

    private static void setOperFail(int neID, TEErrInfoReturn rspErrRet, int retCode) {
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        String neName = ne.getNEName();
        rspErrRet.setResult(1090605056);
        rspErrRet.addErrInfo(TEPTPExtClockDbMgr.constructErrInfoReturn(new int[]{neID}, new String[]{neName}, retCode).getErrList());
    }

    public static TEErrInfoReturn constructErrInfoReturn(int neID, int errorCode) {
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        String neName = UNKNOWN;
        if (null != ne) {
            neName = ne.getNEName();
        }
        return TEPTPExtClockDbMgr.constructErrInfoReturn(new int[]{neID}, new String[]{neName}, errorCode);
    }

    public static TEErrInfoReturn constructErrInfoReturn(int[] objID, String[] objName, int retCode) {
        TEErrInfoReturn errRet = new TEErrInfoReturn();
        errRet.setResult(2);
        TEErrInfo errInfo = new TEErrInfo();
        errInfo.setObjID(objID);
        errInfo.setObjName(TEPTPExtClockDbMgr.getObjName(objName));
        errInfo.setErrorCode(retCode);
        errRet.addErrInfo(errInfo);
        return errRet;
    }

    public static String getObjName(String[] objName) {
        StringBuffer objNameBuffer = new StringBuffer();
        int len = objName.length;
        for (int i = 0; i < len; ++i) {
            if (0 != i) {
                objNameBuffer.append('-');
            }
            objNameBuffer.append(objName[i]);
        }
        return objNameBuffer.toString();
    }

    private static void logNullNEError(int neID) {
        logger.error("ne is null! neID->" + neID);
    }

    private static void logRetCodeErrorOnGet(int neID, int retCode) {
        String tipStr = String.format("get mo from db device fail! neID:%d, retCode:%d", neID, retCode);
        logger.error(tipStr);
    }

    private static void logNullErrorOnGet(int neID) {
        logger.error("get mo from db fail! dbResult is null! neID->" + neID);
    }

    private static void logExceptionOnGet(int neID, Exception e) {
        logger.error("get mo from db fail! neID->" + neID, (Throwable)e);
    }

    private static void logRetCodeErrorOnUpdate(int neID, int retCode) {
        String tipStr = String.format("update mo to db device fail! neID:%d, retCode:%d", neID, retCode);
        logger.error(tipStr);
    }

    private static void logNullErrorOnUpdate(int neID) {
        logger.error("update mo to db device fail! dbResult is null! neID->" + neID);
    }

    private static void logExceptionErrorOnUpdate(int neID, Exception e) {
        logger.error("update mo to db device fail! neID->" + neID, (Throwable)e);
    }

    private static void logNullErrorOnCreate(int neID) {
        logger.error("create mo to db device fail! neID->" + neID);
    }

    private static void logExceptionErrorOnCreate(int neID, Exception e) {
        logger.error("create mo to db device fail! neID->" + neID, (Throwable)e);
    }

    private static void logRetCodeErrorOnCreate(int neID, int retCode) {
        String tipStr = String.format("create mo to db device fail! neID:%d, retCode:%d", neID, retCode);
        logger.error(tipStr);
    }

    private static void logNullErrorOnDel(int neID) {
        logger.error("delete mo to db device fail! neID->" + neID);
    }

    private static void logExceptionErrorOnDel(int neID, Exception e) {
        logger.error("delete mo to db device fail! neID->" + neID, (Throwable)e);
    }

    private static void logRetCodeErrorOnDel(int neID, int retCode) {
        String tipStr = String.format("delete mo to db device fail! neID:%d, retCode:%d", neID, retCode);
        logger.error(tipStr);
    }
}

