/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.sdh.clockptp.beanplugin;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.beanplugin.TEBeanPlugin;
import com.huawei.nglct.explorer.beanplugin.TEBeanPluginUtil;
import com.huawei.nglct.nemgr.sdh.clockptp.db.TEPTPExtClockDbMgr;
import com.huawei.nglct.po.embeddednemgrmo.mstp.TEExtClockPortMOPO;
import com.huawei.nglct.util.errinfo.TEErrInfoReturn;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.List;
import org.slf4j.Logger;

public class TESetTransDistanceBeanPlugin
extends TEBeanPlugin {
    private static final Logger logger = TELogFactory.getNormalLogger();

    public TEErrInfoReturn doAfterSendMessage(int neid, SubFunc subFunc, List<Operation> operationList) {
        TEErrInfoReturn errRet = new TEErrInfoReturn();
        String operName = null;
        for (Operation oper : operationList) {
            if (!TEBeanPluginUtil.isOperSuccess((Operation)oper) || !"NSCMD_CFG_SET_PTP_CABLELENGTH".equals(operName = oper.getName())) continue;
            TEErrInfoReturn tempErrRet = new TEErrInfoReturn();
            this.handleNSCMD_CFG_SET_PTP_CABLELENGTH(neid, oper, tempErrRet);
        }
        return errRet;
    }

    private void handleNSCMD_CFG_SET_PTP_CABLELENGTH(int neID, Operation oper, TEErrInfoReturn errRet) {
        if (!TEBeanPluginUtil.isOperSuccess((Operation)oper)) {
            TEBeanPluginUtil.fillErrorToOperation((Operation)oper, (TEErrInfoReturn)errRet);
            return;
        }
        Output[] outputArr = oper.getOutput();
        int len = outputArr.length;
        for (int i = 0; i < len; ++i) {
            int slotid = TEBeanPluginUtil.getInputPartValueInt((Operation)oper, (String)"slotid", (int)-1);
            int subslotid = TEBeanPluginUtil.getInputPartValueInt((Operation)oper, (String)"subslotid", (int)-1);
            int port = TEBeanPluginUtil.getInputPartValueInt((Operation)oper, (String)"port", (int)-1);
            int trandirection = TEBeanPluginUtil.getInputPartValueInt((Operation)oper, (String)"trandirection", (int)-1);
            int tranmode = TEBeanPluginUtil.getInputPartValueInt((Operation)oper, (String)"tranmode", (int)-1);
            int tranvalue = TEBeanPluginUtil.getInputPartValueInt((Operation)oper, (String)"tranvalue", (int)-1);
            if (-1 == slotid || -1 == port) {
                logger.info("slotid or port is invalid! will not set to db!");
                return;
            }
            List<TEExtClockPortMOPO> extClockPortMOList = TEPTPExtClockDbMgr.getExtClockPortMOFromDB(neID, errRet);
            if (0 != errRet.getResult()) {
                return;
            }
            TEExtClockPortMOPO clockPortMO = null;
            for (TEExtClockPortMOPO tempMO : extClockPortMOList) {
                if (tempMO.getSlotID() != slotid || tempMO.getSubCardID() != subslotid || tempMO.getPortID() != port) continue;
                clockPortMO = tempMO;
                break;
            }
            if (null == clockPortMO) {
                clockPortMO = new TEExtClockPortMOPO();
                clockPortMO.setSlotID(slotid);
                clockPortMO.setSubCardID(subslotid);
                clockPortMO.setPortID(port);
                if (0 == trandirection) {
                    clockPortMO.setRCableMode(tranmode);
                    clockPortMO.setRCableDistance((long)tranvalue);
                } else {
                    clockPortMO.setSCableMode(tranmode);
                    clockPortMO.setSCableDistance((long)tranvalue);
                }
                TEPTPExtClockDbMgr.createExtClockPortMOToDB(neID, clockPortMO, errRet);
            } else {
                if (0 == trandirection) {
                    clockPortMO.setRCableMode(tranmode);
                    clockPortMO.setRCableDistance((long)tranvalue);
                } else {
                    clockPortMO.setSCableMode(tranmode);
                    clockPortMO.setSCableDistance((long)tranvalue);
                }
                TEPTPExtClockDbMgr.updateExtClockPortMOToDB(neID, clockPortMO, errRet);
            }
            TEBeanPluginUtil.fillErrorToOperation((Operation)oper, (TEErrInfoReturn)errRet);
        }
    }
}

