/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.sdh.clockptp;

import com.huawei.nglct.cbb.log.TECommonWriteLogBean;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.device.ne.TEGetNEDomainVersion;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.io.File;
import java.util.ArrayList;

public class TESetClockPriorityBean
extends TECommonWriteLogBean {
    private static final String LANGUAGE = TESysManagerBean.getInstance().getlanguage();
    private static final String CLOCKPTP_RES = "sdh" + File.separator + "res" + File.separator + "clock_ptp" + File.separator + "clockptp_" + LANGUAGE + ".ini";
    private static final int INVALID_VALUE = 255;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.subfunc = subFunc;
        this.inputData = inputData;
        this.operationList = new ArrayList();
        this.outputData = new Datainterface();
        BussinessParams businessparams = inputData.getBussinessParams();
        this.getSetClockPriOper(businessparams);
        if (null == this.operationList || this.operationList.size() == 0) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
            return this.outputData;
        }
        int result = this.sendMessage(neid);
        if (result == 0) {
            ArrayList filterErrorCodeList = this.getFilterErrorCodeList();
            this.handleMessage(neid, this.operationList, subFunc, filterErrorCodeList);
        } else {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
        }
        if (this.isNeedOperationlog()) {
            this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
        }
        return this.outputData;
    }

    private boolean isNGWDMDomain(int neid) {
        TENE ne = TENEListMgr.getInstance().getNE(neid);
        String domain = TEGetNEDomainVersion.getInstance().getDomain(ne.getNEType());
        return domain.equalsIgnoreCase("ngwdm") || domain.equalsIgnoreCase("wdm");
    }

    private void getSetClockPriOper(BussinessParams bussinessparams) {
        RowParams rowparams = null;
        Operation oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_SET_PTPPL");
        Input input = oper.getInput();
        input.clearPart();
        boolean isngwdmDevice = this.isNGWDMDomain(this.neid);
        rowparams = bussinessparams.getRowParams(0);
        Part part = new Part();
        part.setLength(2);
        part.setName("srcount");
        part.setType("int");
        part.setValue(rowparams.getParam("srcount").getValue());
        input.addPart(part);
        int len = bussinessparams.getRowParamsCount();
        for (int i = 1; i < len; ++i) {
            rowparams = bussinessparams.getRowParams(i);
            part = new Part();
            part.setLength(2);
            part.setName("slotid");
            part.setType("int");
            if (isngwdmDevice) {
                part.setSubrackConvertFlag(true);
            }
            part.setValue(rowparams.getParam("slotid").getValue());
            input.addPart(part);
            part = new Part();
            part.setLength(1);
            part.setName("subslotid");
            part.setType("byte");
            part.setValue(rowparams.getParam("subslotid").getValue());
            input.addPart(part);
            part = new Part();
            part.setLength(2);
            part.setName("port");
            part.setType("int");
            part.setValue(rowparams.getParam("port").getValue());
            input.addPart(part);
            part = new Part();
            part.setLength(4);
            part.setName("srcidhigh");
            part.setType("prototype");
            part.setValue(rowparams.getParam("srcidhigh").getValue());
            input.addPart(part);
            part = new Part();
            part.setLength(4);
            part.setName("srcidlow");
            part.setType("prototype");
            part.setValue(rowparams.getParam("srcidlow").getValue());
            input.addPart(part);
            part = new Part();
            part.setLength(2);
            part.setName("interfaceid");
            part.setType("prototype");
            part.setValue(rowparams.getParam("interfaceid").getValue());
            input.addPart(part);
        }
        this.operationList.add(oper);
    }

    protected boolean isSingletonLog() {
        return true;
    }

    public String getDetailInfo(RowParams[] rParamsArr) {
        TEResourceUtil resourceUtil = TEGetFilePath.getResource((int)this.neid, (String)CLOCKPTP_RES);
        StringBuffer operDesc = new StringBuffer();
        RowParams rowparams = null;
        TEConfigurationDataMgr configurDataMgr = TEConfigurationDataMgr.getInstance();
        rowparams = rParamsArr[0];
        int srcount = Integer.parseInt(rowparams.getParam("srcount").getValue());
        if (0 == srcount) {
            operDesc.append(resourceUtil.getString("clearallsource"));
        }
        int len = rParamsArr.length;
        for (int i = 1; i < len; ++i) {
            rowparams = rParamsArr[i];
            int slotid = Integer.parseInt(rowparams.getParam("slotid").getValue());
            int boardType = configurDataMgr.getBoardType(this.neid, slotid);
            String boardName = configurDataMgr.getBoardTypeName(this.neid, boardType);
            int subslotid = Integer.parseInt(rowparams.getParam("subslotid").getValue());
            if (255 != subslotid) {
                int subboardType = configurDataMgr.getSubboardType(this.neid, slotid, subslotid);
                String subboardName = configurDataMgr.getBoardTypeName(this.neid, subboardType);
                String port = rowparams.getParam("port").getValue();
                String portName = configurDataMgr.getPortName(this.neid, slotid, boardType, Integer.parseInt(port));
                operDesc.append(slotid).append("-").append(boardName).append("-").append(subslotid).append("-").append(subboardName).append("-").append(portName).append(" ");
            } else {
                String port = rowparams.getParam("port").getValue();
                String portName = configurDataMgr.getPortName(this.neid, slotid, boardType, Integer.parseInt(port));
                if (this.isNGWDMDomain(this.neid)) {
                    operDesc.append(TEBoardUtil.getSubrackNameFromSlot((int)this.neid, (int)slotid)).append("-").append(TEBoardUtil.getSlotIDFromSlot((int)this.neid, (int)slotid)).append("-").append(boardName).append("-").append(portName).append(" ");
                } else {
                    operDesc.append(slotid).append("-").append(boardName).append("-").append(portName).append(" ");
                }
            }
            if (rowparams.getParam("operdes") != null) {
                operDesc.append(rowparams.getParam("operdes").getValue());
                continue;
            }
            String strSidHigh = rowparams.getParam("srcidhigh").getValue();
            String strSidLow = rowparams.getParam("srcidlow").getValue();
            String strIfID = rowparams.getParam("interfaceid").getValue();
            if (strSidHigh.length() > 6 && this.isHwDev(strSidHigh.substring(0, 6))) {
                String neip = Integer.parseInt(strSidLow.substring(0, 2), 16) + "." + Integer.parseInt(strSidLow.substring(2, 4), 16) + "." + Integer.parseInt(strSidLow.substring(4, 6), 16) + "." + Integer.parseInt(strSidLow.substring(6, 8), 16);
                operDesc.append(resourceUtil.getString("companyCode")).append(":").append(strSidHigh.substring(0, 6)).append(" ").append(resourceUtil.getString("addCode")).append(":").append(strSidHigh.substring(6, 8)).append(" ").append(resourceUtil.getString("NEID")).append(":").append(neip).append(" ").append(resourceUtil.getString("interfaceID")).append(":").append(Integer.parseInt(strIfID, 16)).append(" ");
                continue;
            }
            operDesc.append(resourceUtil.getString("hexInput")).append(":").append(strSidHigh).append(strSidLow).append(strIfID).append(" ");
        }
        return operDesc.toString();
    }

    public boolean isHwDev(String src) {
        String[] strHwDevCode = new String[]{"001882", "001E10", "00E0FC"};
        for (int i = 0; i < strHwDevCode.length; ++i) {
            if (!strHwDevCode[i].equals(src)) continue;
            return true;
        }
        return false;
    }
}

