/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.sdh.clockptp;

import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.neinterface.neadapter.TECommuNEMgr;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.sdh.clock.TEClockUtility;
import com.huawei.nglct.nemgr.sdh.clock_v2r8c01.TEUsableResource;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.definitions.Fault;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Vector;

public class TEQueryPortStatusBean
extends TENEExplorerBean {
    protected static final String v1r2 = "02.10";
    protected TEConfigurationDataMgr cfgDataMgr = TEConfigurationDataMgr.getInstance();
    protected static final String INVALID_SUBSLOTID = "255";
    protected ArrayList usableResourceList = new ArrayList();
    protected static final String ENABLE = "1";
    protected static final String TC = "3";
    protected static final String TCOC = "4";
    protected static final String ISNOT_FORMNE = "1";
    protected String workMode = "";
    protected String isFromNE = "";
    protected static final String NEVER_ISSUPACRENABLE = "5.64.01.50";

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.subfunc = subFunc;
        this.inputData = inputData;
        this.outputData = new Datainterface();
        RowParams rowparam = inputData.getBussinessParams().getRowParams(0);
        this.workMode = rowparam.getParam("workmode").getValue();
        this.isFromNE = rowparam.getParam("isFromNE").getValue();
        this.operationList = new ArrayList();
        if (0 != this.getEtherPort()) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
            return this.outputData;
        }
        if (this.isFromNE.equals("1")) {
            this.constructResult();
            return this.outputData;
        }
        if (this.workMode.equals(TC) || this.workMode.equals(TCOC)) {
            this.constructOperationListTC(subFunc);
        } else {
            this.constructOperationList(subFunc);
        }
        if (null == this.operationList || this.operationList.size() == 0) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
            return this.outputData;
        }
        int result = this.sendMessage(neid, subFunc);
        if (result == 0) {
            this.handleMessage(neid, this.operationList, subFunc);
        } else {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
        }
        if (this.isNeedOperationlog()) {
            this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
        }
        return this.outputData;
    }

    protected int getEtherPort() {
        TENE ne = TENEListMgr.getInstance().getNE(this.neid);
        Vector boardList = ne.getBoardList();
        Collections.sort(boardList);
        if (boardList == null || boardList.isEmpty()) {
            return 2;
        }
        int size = boardList.size();
        for (int i = 0; i < size; ++i) {
            TEUsableResource usableRes;
            TEBoard board = (TEBoard)boardList.get(i);
            int bdType = board.getBoardType();
            if (!TEClockUtility.isPTPBoard(bdType)) continue;
            int slotID = board.getSlotID();
            int subBoardId = 255;
            String subdName = "";
            String bdName = board.getBoardName();
            ArrayList portList = null;
            portList = this.cfgDataMgr.getBoardPortList(this.neid, bdType, slotID);
            ArrayList<String> portidList = new ArrayList<String>();
            ArrayList<String> portNameList = new ArrayList<String>();
            int size3 = portList.size();
            for (int l = 0; l < size3; ++l) {
                int portID = (Integer)portList.get(l);
                if ((bdType == 1410 || bdType == 1411 || bdType == 1607 || bdType == 1608 || bdType == 1609) && portID <= 16) continue;
                portidList.add(portID + "");
                String portName = this.cfgDataMgr.getPortNameForPTN(this.neid, slotID, bdType, portID);
                portNameList.add(portName);
            }
            if (portidList.isEmpty() || this.usableResourceList.contains((Object)(usableRes = new TEUsableResource(slotID, bdName, subBoardId, subdName, portidList, portNameList)))) continue;
            this.usableResourceList.add(usableRes);
        }
        return 0;
    }

    protected void constructOperationList(SubFunc subFunc) {
        ArrayList<Operation> queryPortEnableList = new ArrayList<Operation>();
        int size = this.usableResourceList.size();
        for (int i = 0; i < size; ++i) {
            TEUsableResource res = (TEUsableResource)((Object)this.usableResourceList.get(i));
            int slotid = res.getSlotID();
            int subslotid = res.getSubslotID();
            ArrayList portidList = res.getPortidList();
            int size1 = portidList.size();
            for (int j = 0; j < size1; ++j) {
                String portid = (String)portidList.get(j);
                Operation operation = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_GET_PTPENABLE");
                Input input = operation.getInput();
                input.setPartValue("slotid", slotid + "");
                input.setPartValue("subslotid", subslotid + "");
                input.setPartValue("port", portid);
                queryPortEnableList.add(operation);
            }
        }
        if (null == queryPortEnableList || queryPortEnableList.isEmpty()) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
            return;
        }
        OperationResult result = TECommuNEMgr.getInstance().sendCommand(this.neid, queryPortEnableList, this.getTimeOut(), subFunc);
        if (result.retCode == 0) {
            int size2 = queryPortEnableList.size();
            for (int i = 0; i < size2; ++i) {
                Output output = ((Operation)queryPortEnableList.get(i)).getOutput()[0];
                Fault[] faultArr = output.getFault();
                boolean isSuccess = true;
                for (Fault fault : faultArr) {
                    String code = fault.getCode();
                    if (Integer.parseInt(code) == 0) continue;
                    isSuccess = false;
                    break;
                }
                if (!isSuccess || !"1".equals(output.getPartValue("ptpenable"))) continue;
                String slotid = output.getPartValue("slotid");
                String subslotid = output.getPartValue("subslotid");
                String port = output.getPartValue("port");
                this.convertOperationList(this.neid, slotid, subslotid, port);
            }
        }
    }

    protected void convertOperationList(int neid, String slotid, String subslotid, String port) {
        Operation operation = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_CFG_GET_PTPPORTVLAN");
        Input input = operation.getInput();
        input.setPartValue("slotid", slotid);
        input.setPartValue("subslotid", subslotid);
        input.setPartValue("port", port);
        this.operationList.add(operation);
        operation = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_CFG_GET_PTPMSGFORMAT");
        input = operation.getInput();
        input.setPartValue("slotid", slotid);
        input.setPartValue("subslotid", subslotid);
        input.setPartValue("port", port);
        this.operationList.add(operation);
        operation = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_CFG_GET_PTPPORTSTATE");
        input = operation.getInput();
        input.setPartValue("slotid", slotid);
        input.setPartValue("subslotid", subslotid);
        input.setPartValue("port", port);
        this.operationList.add(operation);
        operation = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_CFG_GET_PTPPORTREALSTATE");
        input = operation.getInput();
        input.setPartValue("slotid", slotid);
        input.setPartValue("subslotid", subslotid);
        input.setPartValue("port", port);
        this.operationList.add(operation);
        operation = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_CFG_GET_GETBKSID");
        input = operation.getInput();
        input.setPartValue("slotid", slotid);
        input.setPartValue("subslotid", subslotid);
        input.setPartValue("port", port);
        this.operationList.add(operation);
        TENE ne = TENEListMgr.getInstance().getNE(neid);
        String never = ne.getHostVersion();
        if (NEVER_ISSUPACRENABLE.compareTo(never) <= 0) {
            operation = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_CFG_GET_PTPACRENABLE");
            input = operation.getInput();
            input.setPartValue("slotid", slotid);
            input.setPartValue("subslotid", subslotid);
            input.setPartValue("port", port);
            this.operationList.add(operation);
        }
    }

    protected void constructOperationListTC(SubFunc subFunc) {
        String ver = TENEListMgr.getInstance().getNE(this.neid).getShowNEVersion();
        ver = ver.split("\\.")[2] + "." + ver.split("\\.")[3];
        int neType = TENEListMgr.getInstance().getNE(this.neid).getNEType();
        int bdType = -1;
        int size = this.usableResourceList.size();
        for (int i = 0; i < size; ++i) {
            TEUsableResource res = (TEUsableResource)((Object)this.usableResourceList.get(i));
            int slotid = res.getSlotID();
            int subslotid = res.getSubslotID();
            bdType = TENEListMgr.getInstance().getNE(this.neid).getBoard(slotid).getBoardType();
            if (!(neType != 76 && neType != 77 && neType != 114 || v1r2.compareTo(ver) <= 0 || bdType != 1404 && bdType != 2080 && bdType != 2079)) continue;
            ArrayList portidList = res.getPortidList();
            int size1 = portidList.size();
            for (int j = 0; j < size1; ++j) {
                String portid = (String)portidList.get(j);
                Operation operation = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_GET_PTPMSGFORMAT");
                Input input = operation.getInput();
                input.setPartValue("slotid", slotid + "");
                input.setPartValue("subslotid", subslotid + "");
                input.setPartValue("port", portid);
                this.operationList.add(operation);
            }
        }
    }

    protected void constructResult() {
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
        BussinessParams bussinessParam = new BussinessParams();
        this.outputData.setBussinessParams(bussinessParam);
        String ver = TENEListMgr.getInstance().getNE(this.neid).getShowNEVersion();
        ver = ver.split("\\.")[2] + "." + ver.split("\\.")[3];
        int neType = TENEListMgr.getInstance().getNE(this.neid).getNEType();
        int bdType = -1;
        int size = this.usableResourceList.size();
        for (int i = 0; i < size; ++i) {
            TEUsableResource res = (TEUsableResource)((Object)this.usableResourceList.get(i));
            int slotid = res.getSlotID();
            int subslotid = res.getSubslotID();
            bdType = TENEListMgr.getInstance().getNE(this.neid).getBoard(slotid).getBoardType();
            if (!(neType != 76 && neType != 77 && neType != 114 || v1r2.compareTo(ver) <= 0 || bdType != 1404 && bdType != 2080 && bdType != 2079)) continue;
            ArrayList portidList = res.getPortidList();
            int size1 = portidList.size();
            for (int j = 0; j < size1; ++j) {
                String portid = (String)portidList.get(j);
                RowParams rowparam = new RowParams();
                Param param = null;
                param = new Param("slotid", slotid + "");
                rowparam.addParam(param);
                int boardType = this.cfgDataMgr.getBoard(this.neid, slotid).getBoardType();
                String boardName = this.cfgDataMgr.getBoardTypeName(this.neid, boardType);
                param = new Param("boardname", boardName);
                rowparam.addParam(param);
                param = new Param("subslotid", subslotid + "");
                rowparam.addParam(param);
                param = new Param("port", portid);
                rowparam.addParam(param);
                String portName = this.cfgDataMgr.getPortNameForPTN(this.neid, slotid, boardType, Integer.parseInt(portid));
                param = new Param("portname", portName);
                rowparam.addParam(param);
                param = new Param("msgformat", "1");
                rowparam.addParam(param);
                bussinessParam.addRowParams(rowparam);
            }
        }
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        super.handleMessage(neid, operationList, subfunc);
        RowParams[] rParams = this.outputData.getBussinessParams().getRowParams();
        for (int i = 0; i < rParams.length; ++i) {
            if (rParams[i].getParamCount() == 0) continue;
            int slotId = Integer.parseInt(rParams[i].getParam("slotid").getValue());
            int port = Integer.parseInt(rParams[i].getParam("port").getValue());
            int boardType = this.cfgDataMgr.getBoard(neid, slotId).getBoardType();
            String portName = this.cfgDataMgr.getPortNameForPTN(neid, slotId, boardType, port);
            rParams[i].getParam("portname").setValue(portName);
        }
    }
}

