/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.sdh.clockptp;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.uflight.qxprotocol.definitions.Definitions;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;

public class TEQueryOuterBaseAttrBean
extends TENEExplorerBean {
    private static int IS_OUTERCLOCK = 43236;
    private int OUTER_PARA_1 = 1;
    private int OUTER_PARA_2 = 2;
    private static final List<Integer> DUBLE_OUTTIME_BOARDS = new ArrayList<Integer>();

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList, (ArrayList)filterErrorCodeList);
        int errorCode = Integer.parseInt(this.outputData.getErrorMessage().getErrorcode());
        if (0 == errorCode || 1 == errorCode) {
            if (this.outputData.getBussinessParams().getRowParamsCount() > 0) {
                RowParams rowdata = this.outputData.getBussinessParams().getRowParams(0);
                TENE ne = TENEListMgr.getInstance().getNE(neid);
                Param neNameParam = rowdata.getParam("neName");
                if (null != neNameParam) {
                    ne.setNEName(neNameParam.getValue().trim());
                    neNameParam.setValue(ne.getNEName());
                }
            }
            boolean hasErrorCode = false;
            RowParams[] rowArray = this.outputData.getBussinessParams().getRowParams();
            int rowArrayLen = rowArray.length;
            for (int i = 0; i < rowArrayLen; ++i) {
                RowErrors[] rowErrorsArray = rowArray[i].getRowErrors();
                for (int rowErrorsLen = rowErrorsArray.length - 1; rowErrorsLen >= 0; --rowErrorsLen) {
                    RowErrors rowErrors = rowErrorsArray[rowErrorsLen];
                    if (IS_OUTERCLOCK != Integer.parseInt(rowErrors.getErrorMessage().getErrorcode())) continue;
                    rowArray[i].removeRowErrors(rowErrors);
                }
                if (0 == rowArray[i].getRowErrorsCount()) continue;
                hasErrorCode = true;
            }
            if (!hasErrorCode) {
                this.outputData.getErrorMessage().setErrorcode(Integer.toString(0));
            }
        }
    }

    public ArrayList getOperation(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData) {
        ArrayList<Object> templist = new ArrayList<Object>();
        int portSize = -1;
        try {
            Definitions definitions = TECreateObjectFactory.parseQxDesFile((int)neid);
            Operation oper1 = definitions.getOperation("NSCMD_CFG_GET_PTPEXTINTERFACEMODE");
            Input input1 = oper1.getInput();
            Operation oper2 = definitions.getOperation("NSCMD_CFG_GET_PTPEXTTIMEINTERFACEPARA");
            Input input2 = oper2.getInput();
            TENE ne = TENEListMgr.getInstance().getNE(neid);
            Vector boardList = ne.getBoardList();
            Collections.sort(boardList);
            int size = boardList.size();
            for (int i = 0; i < size; ++i) {
                TEBoard board = (TEBoard)boardList.get(i);
                int slotID = board.getSlotID();
                int deviceType = ne.getNEType();
                switch (deviceType) {
                    case 114: {
                        this.OUTER_PARA_1 = 7;
                        break;
                    }
                    case 77: {
                        this.OUTER_PARA_1 = 7;
                        this.OUTER_PARA_2 = 8;
                        break;
                    }
                    case 83: {
                        this.OUTER_PARA_1 = 15;
                        this.OUTER_PARA_2 = 20;
                        break;
                    }
                    case 62: {
                        this.OUTER_PARA_1 = 13;
                        this.OUTER_PARA_2 = 13;
                        break;
                    }
                    case 67: 
                    case 81: {
                        this.OUTER_PARA_1 = 85;
                        this.OUTER_PARA_2 = 86;
                        break;
                    }
                    default: {
                        this.OUTER_PARA_1 = 1;
                        this.OUTER_PARA_2 = 2;
                    }
                }
                if (this.OUTER_PARA_1 != slotID && this.OUTER_PARA_2 != slotID) continue;
                portSize = TEConfigurationDataMgr.getInstance().getLogicPortList(neid, slotID).size();
                input1.setPartValue("slotid", slotID + "");
                input1.setPartValue("subslotid", "255");
                input1.setPartValue("port", portSize + 1 + "");
                templist.add(oper1.clone());
                input1 = oper1.getInput();
                input1.setPartValue("slotid", slotID + "");
                input1.setPartValue("subslotid", "255");
                input1.setPartValue("port", portSize + 2 + "");
                if (ne.getNEType() != 76 || DUBLE_OUTTIME_BOARDS.contains(board.getBoardType())) {
                    templist.add(oper1.clone());
                }
                input2.setPartValue("slotid", slotID + "");
                input2.setPartValue("subslotid", "255");
                input2.setPartValue("port", portSize + 1 + "");
                templist.add(oper2.clone());
                input2.setPartValue("slotid", slotID + "");
                input2.setPartValue("subslotid", "255");
                input2.setPartValue("port", portSize + 2 + "");
                if (ne.getNEType() == 76 && !DUBLE_OUTTIME_BOARDS.contains(board.getBoardType())) continue;
                templist.add(oper2.clone());
            }
            return templist;
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("getOperation fail!", (Throwable)e);
            return null;
        }
    }

    static {
        DUBLE_OUTTIME_BOARDS.add(2270);
        DUBLE_OUTTIME_BOARDS.add(1259);
        DUBLE_OUTTIME_BOARDS.add(2453);
        DUBLE_OUTTIME_BOARDS.add(2252);
    }
}

