/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.sdh.clockptp;

import com.huawei.nglct.common.TENEMgrInterface;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Option;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.circuitpack.TEPortProperty;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import com.huawei.nglct.nemgr.sdh.clock.TEClockUtility;
import com.huawei.nglct.nemgr.sdh.clock_v2r8c01.TEUsableResource;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class TEGetPTPPortsBean
implements TENEMgrInterface {
    private Datainterface datainterface = new Datainterface();
    private BussinessParams bParams = new BussinessParams();
    private int neID = -1;
    private ArrayList usableResourceList = new ArrayList();
    private TEConfigurationDataMgr cfgDataMgr = TEConfigurationDataMgr.getInstance();

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neID = neid;
        TENE ne = TENEListMgr.getInstance().getNE(this.neID);
        Vector boardList = ne.getClonedBoardList();
        Collections.sort(boardList);
        if (boardList == null || boardList.size() == 0) {
            this.datainterface.setBussinessParams(this.bParams);
            this.datainterface.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neID, (int)0));
            return this.datainterface;
        }
        int size = boardList.size();
        for (int i = 0; i < size; ++i) {
            TEUsableResource usableRes;
            TEBoard board = (TEBoard)boardList.get(i);
            int bdType = board.getBoardType();
            if (!TEClockUtility.isPTPBoard(bdType)) continue;
            int slotID = board.getSlotID();
            String bdName = board.getBoardName();
            int subBoardId = 0;
            List portList = null;
            String subdName = "";
            portList = this.getPortList(neid, slotID, bdType);
            ArrayList<String> portidList = new ArrayList<String>();
            ArrayList<String> portNameList = new ArrayList<String>();
            int size3 = portList.size();
            for (int l = 0; l < size3; ++l) {
                int portID = (Integer)portList.get(l);
                if (portidList.contains(portID + "")) continue;
                portidList.add(portID + "");
                String portName = this.cfgDataMgr.getPortNameForPTN(this.neID, slotID, bdType, portID);
                portNameList.add(portName);
            }
            if (portidList.size() <= 0 || this.usableResourceList.contains((Object)(usableRes = new TEUsableResource(slotID, bdName, subBoardId, subdName, portidList, portNameList)))) continue;
            this.usableResourceList.add(usableRes);
        }
        return this.constructRtnData();
    }

    public Datainterface constructRtnData() {
        RowParams rParams = null;
        Param param = null;
        int size = this.usableResourceList.size();
        for (int i = 0; i < size; ++i) {
            Option option;
            int j;
            TEUsableResource res = (TEUsableResource)((Object)this.usableResourceList.get(i));
            rParams = new RowParams();
            param = null;
            param = new Param("slotid", String.valueOf(res.getSlotID()));
            rParams.addParam(param);
            param = new Param("boardName", res.getBoardName());
            rParams.addParam(param);
            param = new Param("subslotid", String.valueOf(res.getSubslotID()));
            rParams.addParam(param);
            param = new Param("subBoardName", res.getSubboardName());
            rParams.addParam(param);
            param = new Param("portid", (String)res.getPortidList().get(0));
            int size1 = res.getPortidList().size();
            for (j = 1; j < size1; ++j) {
                option = new Option((String)res.getPortidList().get(j));
                param.addOption(option);
            }
            rParams.addParam(param);
            param = res.getPortNameList().size() > 0 ? new Param("portName", (String)res.getPortNameList().get(0)) : new Param("portName", "");
            size1 = res.getPortNameList().size();
            for (j = 1; j < size1; ++j) {
                option = new Option((String)res.getPortNameList().get(j));
                param.addOption(option);
            }
            rParams.addParam(param);
            this.bParams.addRowParams(rParams);
        }
        this.datainterface.setBussinessParams(this.bParams);
        this.datainterface.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neID, (int)0));
        return this.datainterface;
    }

    private List getPortList(int neid, int slotid, int boardType) {
        List ports = this.cfgDataMgr.getPortPropertyList(boardType);
        ArrayList dynPortList = this.cfgDataMgr.getDynPropertyList(neid, boardType);
        TENE neobj = this.cfgDataMgr.getNE(neid);
        ArrayList<Integer> uninstallPortList = new ArrayList<Integer>(0);
        if (!dynPortList.isEmpty()) {
            TEClockUtility.getUninstalledLogiPortForRTN(neid, slotid, dynPortList);
            Iterator it = dynPortList.iterator();
            while (it.hasNext()) {
                uninstallPortList.add(((TEPortProperty)it.next()).getPortNo());
            }
            dynPortList.clear();
        }
        ArrayList<Integer> res = new ArrayList<Integer>();
        Iterator iter = ports.iterator();
        while (iter.hasNext()) {
            List unSupportPorts;
            int tmpPort = ((TEPortProperty)iter.next()).getPortNo();
            if (uninstallPortList.contains(tmpPort) || 2471 == boardType && (tmpPort == 2 || tmpPort == 3 || tmpPort == 4 || tmpPort == 6) && neobj.getNEType() == 95 || (unSupportPorts = TESpecialAttrMgr.getInstance().getCPAttrListValueByType(boardType, "TE_FUNC_CFG_PTPCLOCK_SYN_ATTRIBUTE", "PORTSOFBOARD_NOTSUPPORT_PTPCLOCKSYNATTR")).contains(String.valueOf(tmpPort))) continue;
            res.add(tmpPort);
        }
        uninstallPortList.clear();
        Collections.sort(res);
        return res;
    }

    public boolean isNeedOperationlog() {
        return false;
    }
}

