/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.sdh.clock_v2r8c01;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEPort;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import com.huawei.nglct.nemgr.sdh.clock.TEClockUtility;
import com.huawei.nglct.nemgr.sdh.clock.jni.TEGetOtherFiberEndAdapter;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class TEQuerySSMCtrlBean
extends TENEExplorerBean {
    public Datainterface otheroutputData = null;

    private void handleInputData(TEBoard board) {
        String[] ver;
        int slotid = board.getSlotID();
        ArrayList<TEPort> portIDList = new ArrayList<TEPort>();
        int boardType = board.getBoardType();
        List tempPorts = TESpecialAttrMgr.getInstance().getCPAttrListValueByType(boardType, "TE_FUNC_CFG_STG_SUBNET", "PORTSOFBOARD_SUPPORT_CLOCKPRISOURCE");
        if (boardType == 2084 || boardType == 2099) {
            return;
        }
        if (1624 == boardType) {
            portIDList.add(new TEPort(this.neid, slotid, boardType, Integer.valueOf(1).intValue()));
        } else if (2102 == boardType) {
            List portList = TEConfigurationDataMgr.getInstance().getPortListFromPortType(this.neid, boardType, 1025);
            int m = portList.size();
            for (int i = 0; i < m; ++i) {
                int portId = (Integer)portList.get(i);
                if (portId == 9) continue;
                portIDList.add(new TEPort(this.neid, slotid, boardType, portId));
            }
        } else if (2439 == boardType) {
            TEConfigurationDataMgr cfgDataMgr = TEConfigurationDataMgr.getInstance();
            portIDList.addAll(cfgDataMgr.getPortList(this.neid, slotid, 1025));
            portIDList.addAll(cfgDataMgr.getPortList(this.neid, slotid, 1799));
        } else if (TEConfigurationDataMgr.getInstance().isDynPortBoardType(this.neid, boardType)) {
            ArrayList logicPorts = TEConfigurationDataMgr.getInstance().getLogicPortList(this.neid, slotid);
            int size = logicPorts.size();
            for (int j = 0; j < size; ++j) {
                int port = (Integer)logicPorts.get(j);
                TEPort tempTEPort = new TEPort(this.neid, slotid, boardType, port);
                portIDList.add(tempTEPort);
                if (tempPorts.isEmpty() || tempPorts.contains(String.valueOf(port))) continue;
                portIDList.remove(tempTEPort);
            }
        } else if (!tempPorts.isEmpty()) {
            for (String tempPort : tempPorts) {
                portIDList.add(new TEPort(this.neid, slotid, boardType, Integer.valueOf(tempPort).intValue()));
            }
        } else {
            portIDList.addAll(TEClockUtility.getPortIDList(this.neid, slotid));
        }
        int subslotid = 255;
        int clockid = (slotid << 24) + (subslotid << 16);
        TEPort port = null;
        RowParams rtnRowParams = null;
        int m = portIDList.size();
        for (int i = 0; i < m; ++i) {
            port = (TEPort)portIDList.get(i);
            rtnRowParams = new RowParams();
            rtnRowParams.addParam("clockid", clockid + port.getPortNo() + "");
            rtnRowParams.addParam("ssmoutstate", "0");
            this.otheroutputData.getBussinessParams().addRowParams(rtnRowParams);
        }
        TENE ne = TENEListMgr.getInstance().getNE(this.neid);
        int netype = ne.getNEType();
        if (netype == 92 && (Integer.parseInt((ver = ne.getShowNEVersion().split("\\."))[2]) > 1 || Integer.parseInt(ver[2]) == 1 && Integer.parseInt(ver[3]) >= 20)) {
            ArrayList<Operation> operList = new ArrayList<Operation>();
            Operation oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_RTN_CFG_GET_RADIO_1J1PG");
            operList.add(oper);
            OperationResult result = TENECommMgr.getInstance().sendCommand(this.neid, operList, 10);
            if (result.retCode == 0 && oper.getOutput(0).getFault(0).getCode().equals("0")) {
                rtnRowParams = new RowParams();
                rtnRowParams.addParam("clockid", clockid + 4 + "");
                rtnRowParams.addParam("ssmoutstate", "0");
                this.otheroutputData.getBussinessParams().addRowParams(rtnRowParams);
            }
        }
    }

    public void addDefault() {
        TENE ne = TENEListMgr.getInstance().getNE(this.neid);
        Vector boardList = null;
        boardList = ne.getBoardList();
        int len = boardList.size();
        for (int i = 0; i < len; ++i) {
            TEBoard board = (TEBoard)boardList.get(i);
            this.handleInputData(board);
        }
        int netype = ne.getNEType();
        if (netype != 89 && netype != 90 && netype != 92 && netype != 115 && !TESpecialAttrMgr.getInstance().isNENotSupport(this.neid, "TE_FUNC_CFG_STG_SUBNET", "CLOCKPRI_NOTSUPPORT_FIRSTCLOCKSOURCE")) {
            RowParams rtnRowParams = new RowParams();
            rtnRowParams.addParam("clockid", "15728641");
            rtnRowParams.addParam("ssmoutstate", "0");
            this.otheroutputData.getBussinessParams().addRowParams(rtnRowParams);
        }
        if (netype != 89 && netype != 90 && netype != 92 && netype != 115 && !TESpecialAttrMgr.getInstance().isNENotSupport(this.neid, "TE_FUNC_CFG_PTPCLOCK_EXTERN_TIME", "CLOCKPRI_SUPPORT_SECONDCLOCKSOURCE")) {
            RowParams rtnRowParams = new RowParams();
            rtnRowParams.addParam("clockid", "15728642");
            rtnRowParams.addParam("ssmoutstate", "0");
            this.otheroutputData.getBussinessParams().addRowParams(rtnRowParams);
        }
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList);
        Operation operation = (Operation)operationList.get(0);
        Output output = operation.getOutput(0);
        int faultCode = Integer.valueOf(output.getFault(0).getCode());
        if (faultCode == 0 || faultCode == 38662) {
            this.otheroutputData = new Datainterface();
            this.otheroutputData.setBussinessParams(new BussinessParams());
            this.addDefault();
            RowParams[] rowdatas = this.otheroutputData.getBussinessParams().getRowParams();
            int[] clockidArr = new int[rowdatas.length];
            int len = rowdatas.length;
            for (int i = 0; i < len; ++i) {
                int clockid;
                Param para = rowdatas[i].getParam("clockid");
                clockidArr[i] = clockid = Integer.valueOf(para.getValue()).intValue();
                rowdatas[i].addParam("clockname", TEClockUtility.getClockSourceNameExForPTN(neid, clockid));
                rowdatas[i].getParam("ssmoutstate").setValue(this.getSSMOutCtrlState(clockid));
            }
            this.otheroutputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
            this.outputData = this.otheroutputData;
            try {
                new TEGetOtherFiberEndAdapter(1).appendOtherFiberEndParam(neid, clockidArr, this.outputData);
            }
            catch (Exception e) {
                TELogFactory.getNormalLogger().error("", (Throwable)e);
            }
        }
    }

    private String getSSMOutCtrlState(int clockid) {
        int state = 0;
        Param param = null;
        RowParams rowParams2 = null;
        for (RowParams rowParams2 : this.outputData.getBussinessParams().getRowParams()) {
            param = rowParams2.getParam("clockid");
            if (param == null || Integer.valueOf(param.getValue()) != clockid) continue;
            state = Integer.valueOf(rowParams2.getParam("ssmoutstate").getValue()) ^ 1;
            break;
        }
        return String.valueOf(state);
    }
}

