/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.sdh.clock_v2r8c01;

import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgDataMgr;
import com.huawei.nglct.nemgr.sdh.clock.TEClockUtility;
import com.huawei.nglct.util.device.port.TEPortUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class TEQueryClockSwitchConBean
extends TENEExplorerBean {
    private static final int IF_WORK_MODE_7 = 7;
    private static final int QUERY_RESULT_NULL = 38662;
    private static final int UNSUPPORT_BOARD = 38664;
    public static final int NSCMD_CFG_GET_ALM2CLKSW = 35690;
    public static final int NSCMD_CFG_SET_ALM2CLKSW = 35689;
    public static final int NSCMD_CFG_GET_ALM2CLKSW_EX2 = 33990;
    public static final int NSCMD_CFG_SET_ALM2CLKSW_EX2 = 33989;
    private Datainterface newinput = null;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.subfunc = subFunc;
        this.newinput = new Datainterface();
        BussinessParams businessParam = new BussinessParams();
        this.newinput.setBussinessParams(businessParam);
        this.outputData = new Datainterface();
        this.outputData.setBussinessParams(new BussinessParams());
        TEConfigurationDataMgr cfgDataMgr = TEConfigurationDataMgr.getInstance();
        TENE ne = TENEListMgr.getInstance().getNE(neid);
        Vector boardList = ne.getClonedBoardList();
        int len = boardList.size();
        for (int i = 0; i < len; ++i) {
            TEBoard board = (TEBoard)boardList.get(i);
            int type = board.getBoardType();
            if (cfgDataMgr.isIFboard(type)) {
                this.handleIFBoard(board);
                continue;
            }
            if (!cfgDataMgr.isSDHLineBoard(neid, board.getSlotID())) continue;
            this.handleInputData(board);
        }
        if (this.newinput.getBussinessParams().getRowParamsCount() <= 0) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
            return this.outputData;
        }
        this.operationList = this.getOperation(neid, subFunc, this.newinput, memeryData);
        this.operationList = TEQueryClockSwitchConBean.changeQXCmdForBoard("GET", this.operationList, neid);
        int result = this.sendMessage(neid);
        if (result == 0) {
            this.handleMessage(neid, this.operationList, subFunc);
        } else {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
        }
        if (this.isNeedOperationlog()) {
            this.writeLog(neid, subFunc, inputData, user, ipAddress, this.outputData);
        }
        return this.outputData;
    }

    public static ArrayList changeQXCmdForBoard(String operType, ArrayList operList, int neID) {
        ArrayList<Operation> newOperList = new ArrayList<Operation>();
        Iterator it = operList.iterator();
        HashMap<Integer, List> cesPortMaps = new HashMap<Integer, List>();
        while (it.hasNext()) {
            Operation oper = (Operation)it.next();
            if (oper.getCmdid() != 35690 && oper.getCmdid() != 35689) continue;
            String slotNO = oper.getInput().getPart("slotno").getValue();
            int boardType = TEConfigurationDataMgr.getInstance().getBoard(neID, Integer.parseInt(slotNO)).getBoardType();
            int slotID = Integer.parseInt(slotNO);
            if (!TEGenCfgDataMgr.isBoardSupportAttr((int)neID, (int)boardType, (String)"NSCMD_CFG_GET_ALM2CLKSW_EX2")) continue;
            List cesPorts = null;
            if (TESpecialAttrMgr.getInstance().isCPSupport(neID, slotID, "TE_FUNC_CES_CLK", "TE_ATTR_RTN_SUPPORT_E1_CES_CLOCK")) {
                if (!cesPortMaps.containsKey(slotID)) {
                    List portList = (List)TEConfigurationDataMgr.getInstance().getLogicPortList(neID, slotID).clone();
                    cesPortMaps.put(slotID, TEPortUtil.getCESModePortList((int)neID, (int)slotID, (List)portList));
                }
                cesPorts = (List)cesPortMaps.get(slotID);
            }
            String partNo = oper.getInput().getPartValue("partno");
            if (operType.equalsIgnoreCase("GET")) {
                newOperList.addAll(TEQueryClockSwitchConBean.getQueryOperaionList(neID, slotID, Integer.parseInt(partNo), oper, cesPorts));
            } else {
                newOperList.addAll(TEQueryClockSwitchConBean.getSetOperationList(neID, slotID, Integer.parseInt(partNo), oper, cesPorts));
            }
            it.remove();
        }
        if (!newOperList.isEmpty()) {
            operList.addAll(newOperList);
        }
        return operList;
    }

    private static List<Operation> getSetOperationList(int neID, int slotid, int portid, Operation oper, List<Integer> cesPorts) {
        ArrayList<Integer> portList = new ArrayList<Integer>();
        portList.add(portid);
        ArrayList<Operation> operList = new ArrayList<Operation>();
        Operation newOper = null;
        ArrayList<Integer> cesPortList = new ArrayList<Integer>();
        Operation operCes = TECreateObjectFactory.getOperation((int)neID, (String)"NSCMD_CFG_SET_ALM2CLKSW_EX2");
        if (cesPorts == null || cesPorts.isEmpty()) {
            cesPortList.addAll(portList);
        } else {
            if (cesPorts.contains(portid)) {
                cesPortList.add(portid);
            }
            operList.addAll(TEQueryClockSwitchConBean.refreshOperationList(neID, slotid, oper, cesPorts));
        }
        int len = cesPortList.size();
        for (int i = 0; i < len; ++i) {
            newOper = (Operation)operCes.clone();
            newOper.getInput().setPartValue("slotno", String.valueOf(slotid));
            newOper.getInput().setPartValue("subboardno", "255");
            newOper.getInput().setPartValue("partno", String.valueOf(cesPortList.get(i)));
            newOper.getInput().setPartValue("alarmid", oper.getInput().getPartValue("alarmid"));
            newOper.getInput().setPartValue("isswitch", oper.getInput().getPartValue("isswitch"));
            operList.add(newOper);
        }
        return operList;
    }

    private static List<Operation> refreshOperationList(int neID, int slotid, Operation oper, List<Integer> cesPorts) {
        ArrayList modelPortList = TEConfigurationDataMgr.getInstance().getLogicPortList(neID, slotid);
        ArrayList<Operation> operList = new ArrayList<Operation>();
        Operation newOper = null;
        int len = modelPortList.size();
        for (int i = 0; i < len; ++i) {
            if (cesPorts.contains(modelPortList.get(i))) continue;
            newOper = (Operation)oper.clone();
            newOper.getInput().setPartValue("slotno", String.valueOf(slotid));
            newOper.getInput().setPartValue("subboardno", "255");
            newOper.getInput().setPartValue("partno", String.valueOf(modelPortList.get(i)));
            operList.add(newOper);
        }
        return operList;
    }

    private static List<Operation> getQueryOperaionList(int neID, int slotid, int portid, Operation oper, List<Integer> cesPorts) {
        ArrayList portList = new ArrayList();
        if (portid > 0) {
            portList.add(portid);
        } else {
            portList = TEConfigurationDataMgr.getInstance().getLogicPortList(neID, slotid);
        }
        Operation newOper = null;
        Operation operCes = TECreateObjectFactory.getOperation((int)neID, (String)"NSCMD_CFG_GET_ALM2CLKSW_EX2");
        ArrayList<Operation> operList = new ArrayList<Operation>();
        ArrayList<Integer> cesPortList = new ArrayList<Integer>();
        if (cesPorts == null || cesPorts.isEmpty()) {
            cesPortList.addAll(portList);
        } else {
            cesPortList.addAll(cesPorts);
            operList.addAll(TEQueryClockSwitchConBean.refreshOperationList(neID, slotid, oper, cesPorts));
        }
        int len = cesPortList.size();
        for (int i = 0; i < len; ++i) {
            newOper = (Operation)operCes.clone();
            newOper.getInput().setPartValue("slotno", String.valueOf(slotid));
            newOper.getInput().setPartValue("subboardno", "255");
            newOper.getInput().setPartValue("partno", String.valueOf(cesPortList.get(i)));
            newOper.getInput().setPartValue("alarmid", oper.getInput().getPartValue("alarmid"));
            operList.add(newOper);
        }
        return operList;
    }

    private void handleInputData(TEBoard board) {
        int subboardid = 255;
        int boardtype = board.getBoardType();
        String defaultportno = "0";
        if (1624 == boardtype) {
            defaultportno = "1";
        }
        RowParams rtnRowParams = new RowParams();
        rtnRowParams.addParam("slotno", board.getSlotID() + "");
        rtnRowParams.addParam("subboardno", subboardid + "");
        rtnRowParams.addParam("partno", defaultportno);
        rtnRowParams.addParam("alarmid", "33");
        this.newinput.getBussinessParams().addRowParams(rtnRowParams);
        rtnRowParams = new RowParams();
        rtnRowParams.addParam("slotno", board.getSlotID() + "");
        rtnRowParams.addParam("subboardno", subboardid + "");
        rtnRowParams.addParam("partno", defaultportno);
        rtnRowParams.addParam("alarmid", "35");
        this.newinput.getBussinessParams().addRowParams(rtnRowParams);
    }

    private void handleIFBoard(TEBoard board) {
        ArrayList<Object> operationList = new ArrayList<Object>();
        Operation operation = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_GET_RADIO_IFMODE");
        Input input = operation.getInput();
        input.getPart("slotid").setValue(String.valueOf(board.getSlotID()));
        input.getPart("port").setValue("1");
        operationList.add(operation.clone());
        int errCode = this.sendMessage(this.neid, operationList);
        if (errCode != 0) {
            return;
        }
        int workMode = 0;
        int m = operationList.size();
        for (int i = 0; i < m; ++i) {
            operation = (Operation)operationList.get(i);
            for (Output output : operation.getOutput()) {
                errCode = Integer.valueOf(output.getFault()[0].getCode());
                if (0 != errCode || 7 != (workMode = Integer.valueOf(output.getPartValue("W32PORT_ATTR_RADIOWORKMODE")).intValue())) continue;
                this.handleInputData(board);
            }
        }
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        int retcode = this.handleAISPara(neid, operationList);
        if (retcode == 1090646019) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
            return;
        }
        if (retcode != 0) {
            return;
        }
        retcode = this.addB2EXCPara(operationList);
        if (retcode == 1090646019) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
            return;
        }
        if (retcode != 0) {
            return;
        }
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
    }

    private int addB2EXCPara(ArrayList operationList) {
        int len = operationList.size();
        for (int i = 0; i < len; ++i) {
            Operation operation = (Operation)operationList.get(i);
            Output[] outputArr = operation.getOutput();
            if (outputArr.length == 0) {
                return 1090646019;
            }
            for (int j = 0; j < outputArr.length; ++j) {
                Output output = outputArr[j];
                int retCode = new Integer(output.getFault()[0].getCode());
                if (this.getFilterErrorCodeList().contains(retCode)) continue;
                if (retCode != 0) {
                    this.setErrorDate(retCode);
                    return retCode;
                }
                String value = output.getPartValue("alarmid");
                int alarmid = new Integer(value);
                if (alarmid == 33) continue;
                value = output.getPartValue("slotno");
                int slotno = new Integer(value);
                value = output.getPartValue("partno");
                int partno = new Integer(value);
                value = output.getPartValue("subboardno");
                int subboardno = new Integer(value);
                RowParams rtnRowParams = this.getRowParams(slotno, partno, subboardno);
                value = output.getPartValue("isswitch");
                if (rtnRowParams == null) continue;
                rtnRowParams.addParam("b2eswitch", value);
            }
        }
        return 0;
    }

    private RowParams getRowParams(int slotno, int partno, int subboardno) {
        RowParams[] rowparams = this.outputData.getBussinessParams().getRowParams();
        int len = rowparams.length;
        for (int i = 0; i < len; ++i) {
            Param parm = rowparams[i].getParam("slotno");
            int otherslot = new Integer(parm.getValue());
            parm = rowparams[i].getParam("partno");
            int otherpart = new Integer(parm.getValue());
            parm = rowparams[i].getParam("subboardno");
            int othsubboardno = new Integer(parm.getValue());
            if (slotno != otherslot || partno != otherpart || subboardno != othsubboardno) continue;
            return rowparams[i];
        }
        return null;
    }

    private int handleAISPara(int neid, ArrayList operationList) {
        String nename = TENEListMgr.getInstance().getNE(neid).getNEName().trim();
        int len = operationList.size();
        for (int i = 0; i < len; ++i) {
            Operation operation = (Operation)operationList.get(i);
            Output[] outputArr = operation.getOutput();
            if (outputArr.length == 0) {
                return 1090646019;
            }
            for (int j = 0; j < outputArr.length; ++j) {
                Output output = outputArr[j];
                int retCode = new Integer(output.getFault()[0].getCode());
                if (this.getFilterErrorCodeList().contains(retCode)) continue;
                if (retCode != 0) {
                    this.setErrorDate(retCode);
                    return retCode;
                }
                RowParams rtnRowParams = new RowParams();
                String value = output.getPartValue("alarmid");
                int alarmid = new Integer(value);
                if (alarmid == 35) continue;
                rtnRowParams.addParam("nename", nename);
                value = output.getPartValue("slotno");
                int slotno = new Integer(value);
                rtnRowParams.addParam("slotno", value);
                value = output.getPartValue("partno");
                int partno = new Integer(value);
                rtnRowParams.addParam("partno", value);
                value = output.getPartValue("subboardno");
                int subboardno = new Integer(value);
                rtnRowParams.addParam("subboardno", value);
                rtnRowParams.addParam("clockname", this.getClockName(slotno, partno, subboardno));
                value = output.getPartValue("isswitch");
                rtnRowParams.addParam("aisswitch", value);
                rtnRowParams.addParam("b1switch", "-");
                rtnRowParams.addParam("rlosswitch", "1");
                rtnRowParams.addParam("cvswitch", "-");
                rtnRowParams.addParam("cvlimit", "-");
                this.outputData.getBussinessParams().addRowParams(rtnRowParams);
            }
        }
        return 0;
    }

    private String getClockName(int slotno, int partno, int subboardno) {
        int clockid = (slotno << 24) + (subboardno << 16) + partno;
        return TEClockUtility.getClockSourceNameExForPTN(this.neid, clockid);
    }

    private void setErrorDate(int retCode) {
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neid, (int)retCode));
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(38662);
        list.add(38664);
        list.add(40004);
        list.add(41681);
        return list;
    }
}

