/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.sdh.clock_v2r8c01;

import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import com.huawei.nglct.nemgr.sdh.clock.TEClockUtility;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.ArrayList;

public class TEQueryClockQuality
extends TENEExplorerBean {
    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        int result;
        this.neid = neid;
        this.subfunc = subFunc;
        this.outputData = new Datainterface();
        RowParams rowpara = inputData.getBussinessParams().getRowParams(0);
        Param paraa = rowpara.getParam("clockslotno");
        String slotno = paraa.getValue();
        RowParams rowparam = new RowParams();
        Param para = new Param();
        para.setName("clockslotno");
        para.setValue(slotno + "");
        para.setModifyFlag(false);
        rowparam.addParam(para);
        rowparam.addParam("clockid", "0");
        inputData.getBussinessParams().addRowParams(rowparam);
        this.operationList = this.getOperation(neid, subFunc, inputData, memeryData);
        Operation oper = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_CFG_GET_ALL_2MS1_EX2");
        Input input = oper.getInput();
        for (Part part : input.getPart()) {
            if (part.getName().equals("clockslotno")) {
                part.setValue(slotno);
            }
            if (!part.getName().equals("clocktype")) continue;
            part.setValue("1");
        }
        TENE ne = TENEListMgr.getInstance().getNE(neid);
        if (ne.getNEType() != 92 && ne.getNEType() != 95 && ne.getNEType() != 115 || TESpecialAttrMgr.getInstance().isNESupport(neid, "TE_FUNC_CFG_STG_SUBNET", "CLOCKPRI_SUPPORT_FIRST2M")) {
            this.operationList.add(oper.clone());
        }
        oper = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_CFG_GET_ALL_2MS1_EX2");
        input = oper.getInput();
        for (Part part : input.getPart()) {
            if (part.getName().equals("clockslotno")) {
                part.setValue(slotno);
            }
            if (!part.getName().equals("clocktype")) continue;
            part.setValue("2");
        }
        if (this.isSupport2MS1()) {
            this.operationList.add(oper.clone());
        }
        if ((result = this.sendMessage(neid)) == 0) {
            this.handleMessage(neid, this.operationList, subFunc);
        } else {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
        }
        if (this.isNeedOperationlog()) {
            this.writeLog(neid, subFunc, inputData, user, ipAddress, this.outputData);
        }
        return this.outputData;
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        Operation operation;
        Output output;
        int faultCode;
        this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList);
        TENE neObj = TENEListMgr.getInstance().getNE(neid);
        int devicetype = neObj.getNEType();
        if (devicetype == 89 || devicetype == 90) {
            this.fillterOutputData();
        }
        if ((faultCode = Integer.parseInt((output = (operation = (Operation)operationList.get(0)).getOutput(0)).getFault(0).getCode())) == 0 && this.outputData.getBussinessParams().getRowParamsCount() > 0) {
            this.handleData(this.outputData);
        }
    }

    private void fillterOutputData() {
        RowParams[] tmpRows = this.outputData.getBussinessParams().getRowParams();
        this.outputData.getBussinessParams().clearRowParams();
        for (int i = 0; i < tmpRows.length; ++i) {
            String clockname;
            RowParams rowpara = tmpRows[i];
            Param tmppara = rowpara.getParam("clockid");
            int clockid = -1;
            if (tmppara != null && tmppara.getValue() != null && !tmppara.getValue().isEmpty()) {
                clockid = Integer.parseInt(tmppara.getValue());
            }
            if (clockid != -1 && (clockname = TEClockUtility.getClockSourceNameExForPTN(this.neid, clockid)).indexOf("External") != -1) continue;
            this.outputData.getBussinessParams().addRowParams(rowpara);
        }
    }

    private void handleData(Datainterface outputData) {
        RowParams[] rowdatas = outputData.getBussinessParams().getRowParams();
        for (int i = rowdatas.length - 1; i >= 0; --i) {
            Param para = rowdatas[i].getParam("clockid");
            if (null == para) continue;
            int clockid = Integer.parseInt(para.getValue());
            rowdatas[i].addParam("clockname", TEClockUtility.getClockSourceNameExForPTN(this.neid, clockid));
            para = rowdatas[i].getParam("configquality");
            int t = 0;
            if (para.getValue().equals("")) {
                para.setValue("0");
            } else {
                int configquality = Integer.parseInt(para.getValue());
                t = configquality;
                if (t != 0 && t != 2 && t != 4 && t != 8 && t != 11 && t != 15 && t != 255) {
                    para.setValue("0");
                }
            }
            para = rowdatas[i].getParam("clockquality");
            if ("".equals(para.getValue())) {
                para.setValue("16");
                continue;
            }
            t = Integer.parseInt(para.getValue());
            para.setValue(String.valueOf(t &= 0xF));
            if (t == 0 || t == 2 || t == 4 || t == 8 || t == 11 || t == 15) continue;
            para.setValue("16");
        }
    }

    private boolean isSupport2MS1() {
        if (TESpecialAttrMgr.getInstance().isNESupport(this.neid, "TE_FUNC_CFG_STG_SUBNET", "CLOCKPRI_SUPPORT_SECOND2M")) {
            return true;
        }
        TENE ne = TENEListMgr.getInstance().getNE(this.neid);
        String hostVersion = ne.getHostVersion();
        String[] neVersions = hostVersion.split("\\.");
        if (ne.getNEType() == 92 || ne.getNEType() == 95 || ne.getNEType() == 115) {
            return false;
        }
        return ne.getNEType() != 76 && ne.getNEType() != 77 && ne.getNEType() != 114 && ne.getNEType() != 83 || neVersions[2].compareTo("03") <= 0 && (!neVersions[2].equals("03") || Integer.parseInt(neVersions[3]) < 40);
    }
}

