/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.sdh.clock_v2r8c01;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nemgr.sdh.clock.TEClockUtility;
import com.huawei.nglct.nemgr.sdh.clock.jni.TEGetOtherFiberEndAdapter;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.ArrayList;

public class TEQueryClockPriority
extends TENEExplorerBean {
    private int[] clockid;

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        int retCode = this.handleclockidlist(operationList);
        if (retCode != 0) {
            this.setErrorDate(retCode);
            return;
        }
        retCode = this.handleclockmode(operationList);
        if (retCode != 0) {
            this.setErrorDate(retCode);
            return;
        }
        this.handles1byte(operationList, 1);
        this.handles1byte(operationList, 2);
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
        try {
            new TEGetOtherFiberEndAdapter(1).appendOtherFiberEndParam(neid, this.clockid, this.outputData);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("", (Throwable)e);
        }
    }

    private int handles1byte(ArrayList operationList, int id) {
        Operation operation_rtn = (Operation)operationList.get(id + 1);
        Output[] outputArr_rtn = operation_rtn.getOutput();
        int retCode = 0;
        for (Output output_rtn : outputArr_rtn) {
            retCode = new Integer(output_rtn.getFault()[0].getCode());
            if (retCode != 0) {
                return retCode;
            }
            String value = output_rtn.getPartValue("s1byte");
            int s1byte = new Integer(value);
            value = output_rtn.getPartValue("extclockid");
            int extclockid = new Integer(value);
            this.joinS1Byte(s1byte, extclockid);
        }
        return retCode;
    }

    private void joinS1Byte(int s1byte, int extid) {
        RowParams[] rowpara_rtn = this.outputData.getBussinessParams().getRowParams();
        int len = rowpara_rtn.length;
        for (int i = 0; i < len; ++i) {
            Param param = rowpara_rtn[i].getParam("clockid");
            int clockid = new Integer(param.getValue());
            if (clockid != extid) continue;
            rowpara_rtn[i].getParam("s1byte").setValue(s1byte + "");
        }
    }

    private void setErrorDate(int retCode) {
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neid, (int)retCode));
    }

    private int handleclockmode(ArrayList operationList) {
        Operation operation_rtn = (Operation)operationList.get(1);
        Output[] outputArr_rtn = operation_rtn.getOutput();
        int retCode = 0;
        for (Output output : outputArr_rtn) {
            retCode = new Integer(output.getFault()[0].getCode());
            if (retCode != 0) {
                return retCode;
            }
            String value_rtn = output.getPartValue("extclockmode1");
            int mode = new Integer(value_rtn);
            this.joinClockMode(mode, 0xF00001);
            value_rtn = output.getPartValue("extclockmode2");
            mode = new Integer(value_rtn);
            this.joinClockMode(mode, 0xF00002);
        }
        return retCode;
    }

    private void joinClockMode(int clockmode, int extid) {
        RowParams[] rowpara = this.outputData.getBussinessParams().getRowParams();
        int len = rowpara.length;
        for (int i = 0; i < len; ++i) {
            Param param = rowpara[i].getParam("clockid");
            int clockid = new Integer(param.getValue());
            if (clockid != extid) continue;
            rowpara[i].getParam("outclockmode").setValue(clockmode + "");
        }
    }

    private int handleclockidlist(ArrayList operationList) {
        Operation operation = (Operation)operationList.get(0);
        Output[] outputArr = operation.getOutput();
        String[] clockidstr = null;
        int clocknum = 0;
        int retCode = 0;
        for (Output output : outputArr) {
            retCode = new Integer(output.getFault()[0].getCode());
            if (retCode != 0) {
                return retCode;
            }
            for (Part part : output.getPart()) {
                String name = part.getName();
                String value = part.getValue();
                if (name.equalsIgnoreCase("clocknum") && value != null) {
                    clocknum = new Integer(value);
                    continue;
                }
                if (!name.equalsIgnoreCase("clockdata") || value == null) continue;
                clockidstr = new String[clocknum];
                int index = 0;
                for (int i = 0; i < clocknum; ++i) {
                    int clockidlength = 8;
                    clockidstr[i] = value.substring(index, index + clockidlength);
                    index += clockidlength;
                }
            }
        }
        if (clockidstr == null) {
            clockidstr = new String[]{};
        }
        this.handleClockiddata(clockidstr);
        this.clockid = this.getClockID(clockidstr);
        return retCode;
    }

    private int[] getClockID(String[] clockidstr) {
        if (null == clockidstr) {
            return null;
        }
        int[] clockid = new int[clockidstr.length];
        int len = clockidstr.length;
        for (int i = 0; i < len; ++i) {
            clockid[i] = Integer.parseInt(clockidstr[i], 16);
        }
        return clockid;
    }

    private void handleClockiddata(String[] clockidstr) {
        BussinessParams businessParam = new BussinessParams();
        for (int i = 0; i < clockidstr.length; ++i) {
            RowParams rtnRowParams = new RowParams();
            int clockid = Integer.parseInt(clockidstr[i], 16);
            rtnRowParams.addParam("clockid", clockid + "");
            rtnRowParams.addParam("clockname", TEClockUtility.getClockSourceNameExForPTN(this.neid, clockid));
            rtnRowParams.addParam("outclockmode", "0");
            rtnRowParams.addParam("s1byte", "0");
            rtnRowParams.addParam("branchboard", "-");
            rtnRowParams.addParam("number", String.valueOf(i + 1));
            businessParam.addRowParams(rtnRowParams);
        }
        this.outputData.setBussinessParams(businessParam);
    }
}

