/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.sdh.clock_v2r8c01;

import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.sdh.clock.TEClockUtility;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TEQueryClockNetBean
extends TENEExplorerBean {
    protected Datainterface otheroutputData = null;

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        this.otheroutputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList, (ArrayList)filterErrorCodeList);
        Operation operation = (Operation)operationList.get(0);
        Output output = operation.getOutput(0);
        int faultCode = Integer.parseInt(output.getFault(0).getCode());
        if (faultCode == 38662 || faultCode == 0) {
            this.handleData(this.otheroutputData);
            return;
        }
        this.outputData = this.otheroutputData;
    }

    protected int handleclockidlist(List<Operation> operationList) {
        ArrayList<Integer> clockIdLst = new ArrayList<Integer>();
        int clocknum = 0;
        int retCode = 0;
        for (int operlen = 0; operlen < operationList.size(); ++operlen) {
            Operation operation = operationList.get(operlen);
            for (Output output : operation.getOutput()) {
                retCode = Integer.parseInt(output.getFault()[0].getCode());
                if (retCode != 0) {
                    return retCode;
                }
                for (Part part : output.getPart()) {
                    String name = part.getName();
                    String value = part.getValue();
                    if (name.equalsIgnoreCase("clocknum") && value != null) {
                        clocknum = Integer.parseInt(value);
                        continue;
                    }
                    if (!name.equalsIgnoreCase("clockdata") || value == null) continue;
                    int index = 0;
                    for (int i = 0; i < clocknum; ++i) {
                        int tmpclockid = Integer.parseInt(value.substring(index, index + 8), 16);
                        if (!clockIdLst.contains(tmpclockid)) {
                            clockIdLst.add(tmpclockid);
                        }
                        index += 8;
                    }
                }
            }
        }
        this.handleClockiddata(clockIdLst);
        return 0;
    }

    protected void handleClockiddata(ArrayList clockid) {
        int tmpClockId = 0;
        this.outputData = new Datainterface();
        BussinessParams businessParam = new BussinessParams();
        TENE neObj = TENEListMgr.getInstance().getNE(this.neid);
        int devicetype = neObj.getNEType();
        Iterator iter = clockid.iterator();
        while (iter.hasNext()) {
            RowParams rtnRowParams_rtn = new RowParams();
            tmpClockId = (Integer)iter.next();
            String tmpClockName = TEClockUtility.getClockSourceNameExForPTN(this.neid, tmpClockId);
            if ((devicetype == 89 || devicetype == 90) && tmpClockName.indexOf("External") != -1) continue;
            rtnRowParams_rtn.addParam("clockid", tmpClockId + "");
            rtnRowParams_rtn.addParam("clockname", tmpClockName);
            int clocknetid = this.getClockNetNo(tmpClockId);
            rtnRowParams_rtn.addParam("clocknetid", clocknetid + "");
            businessParam.addRowParams(rtnRowParams_rtn);
        }
        int clocknetno = 0;
        if (this.otheroutputData.getBussinessParams().getRowParamsCount() > 0) {
            RowParams rowpara_rtn = this.otheroutputData.getBussinessParams().getRowParams(0);
            Param p = rowpara_rtn.getParam("clocknetno");
            clocknetno = Integer.parseInt(p.getValue());
        }
        int len = businessParam.getRowParamsCount();
        for (int i = 0; i < len; ++i) {
            RowParams rowpara_rtn = businessParam.getRowParams(i);
            rowpara_rtn.addParam("clocknetno", clocknetno + "");
        }
        this.outputData.setBussinessParams(businessParam);
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neid, (int)0));
    }

    protected int getClockNetNo(int clockid) {
        if (this.otheroutputData.getBussinessParams().getRowParamsCount() <= 0) {
            return 0;
        }
        RowParams[] rowparam_rtn = this.otheroutputData.getBussinessParams().getRowParams();
        int len = rowparam_rtn.length;
        for (int j = 0; j < len; ++j) {
            Param para = rowparam_rtn[j].getParam("clockid");
            int clockidvalue = Integer.parseInt(para.getValue());
            if (clockidvalue != clockid) continue;
            Param p = rowparam_rtn[j].getParam("clocknetid");
            return Integer.parseInt(p.getValue());
        }
        return 0;
    }

    protected void handleData(Datainterface otheroutputData) {
        Param clockpara = this.inputData.getBussinessParams().getRowParams(0).getParam("clockslotno");
        ArrayList<Operation> operationList = new ArrayList<Operation>();
        Operation oper_rtn = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_GET_SYN_CLASS");
        Input input = oper_rtn.getInput();
        for (Part part : input.getPart()) {
            if (!part.getName().equals("clockslotno")) continue;
            part.setValue(clockpara.getValue());
        }
        operationList.add((Operation)oper_rtn.clone());
        oper_rtn = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_GET_2MPLL_CLASS_EX");
        input = oper_rtn.getInput();
        for (Part part : input.getPart()) {
            if (part.getName().equals("clockslotno")) {
                part.setValue(clockpara.getValue());
            }
            if (!part.getName().equals("clock2mindex")) continue;
            part.setValue("1");
        }
        operationList.add((Operation)oper_rtn.clone());
        oper_rtn = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_GET_2MPLL_CLASS_EX");
        input = oper_rtn.getInput();
        for (Part part : input.getPart()) {
            if (part.getName().equals("clockslotno")) {
                part.setValue(clockpara.getValue());
            }
            if (!part.getName().equals("clock2mindex")) continue;
            part.setValue("2");
        }
        if (this.isSupportSec2MPLL()) {
            operationList.add((Operation)oper_rtn.clone());
        }
        OperationResult result = TENECommMgr.getInstance().sendCommand(this.neid, operationList, 10);
        if (result.retCode != 0) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neid, (int)result.retCode));
            return;
        }
        int retCode = this.handleclockidlist(operationList);
        if (retCode != 0) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neid, (int)retCode));
            return;
        }
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(38662);
        return list;
    }

    protected boolean isSupportSec2MPLL() {
        TENE ne = TENEListMgr.getInstance().getNE(this.neid);
        String hostVersion = ne.getHostVersion();
        String[] neVersions = hostVersion.split("\\.");
        return ne.getNEType() != 76 && ne.getNEType() != 77 && ne.getNEType() != 114 && ne.getNEType() != 83 || neVersions[2].compareTo("03") <= 0 && (!neVersions[2].equals("03") || Integer.parseInt(neVersions[3]) < 40);
    }
}

